/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.RenameTableModel;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class ConfirmRenameMeasurePanel
extends ActionConfirmPanel {
    private GenericTable renameMeasuresTable;
    private DefaultTableModel renameTableModel;
    private List<AVBaseMeasure> measures;
    private List<String> origMeasureNames;
    private AnalyticView analyticView;
    private DBObjectProvider prov;
    private final int NAME_COLUMN = 0;
    private final int CAPTION_COLUMN = 1;
    private final int DESCRIPTION_COLUMN = 2;

    public ConfirmRenameMeasurePanel(DBObjectProvider dBObjectProvider, AnalyticView analyticView, List<AVBaseMeasure> list) {
        this.prov = dBObjectProvider;
        this.analyticView = analyticView;
        this.measures = list;
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.renameTableModel = this.getTableModel();
        this.renameMeasuresTable = new GenericTable((TableModel)this.renameTableModel);
        this.renameTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    ConfirmRenameMeasurePanel.this.objectDataChanged();
                }
            }
        });
        this.origMeasureNames = new ArrayList<String>();
        for (AVBaseMeasure aVBaseMeasure : this.measures) {
            String string = aVBaseMeasure.getName();
            this.origMeasureNames.add(string);
        }
        this.setupTableColumns();
        this.populateTable();
    }

    protected GenericTable getRenameTableModel() {
        return this.renameMeasuresTable;
    }

    protected List<AVBaseMeasure> getMeasures() {
        return this.measures;
    }

    protected DBObjectProvider getProvider() {
        return this.prov;
    }

    protected DefaultTableModel getTableModel() {
        return new RenameTableModel(this.measures, this.prov);
    }

    protected void populateTable() {
        for (AVBaseMeasure aVBaseMeasure : this.measures) {
            Object[] objectArray = new Object[]{String.format("%s.%s", aVBaseMeasure.getAV().getName(), aVBaseMeasure.getName()), aVBaseMeasure.getCaption(), aVBaseMeasure.getDescription()};
            this.renameTableModel.addRow(objectArray);
        }
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.renameMeasuresTable);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(this.getComponentTitle()));
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        JLabel jLabel = new JLabel();
        jLabel.setText(HCSArb.format(this.getNotificationMssg(), new Object[0]));
        int n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        int n2 = ++n;
        ++n;
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, n2, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 5, 5), 0, 0));
    }

    protected String getComponentTitle() {
        return HCSArb.getString("RENAME_MEASURES_TITLE");
    }

    protected String getNotificationMssg() {
        return "RENAME_MEASURES_NOTIFICATION";
    }

    private void setupTableColumns() {
        MyCellEditor myCellEditor = new MyCellEditor();
        this.renameMeasuresTable.setAutoResizeMode(0);
        this.renameMeasuresTable.setColumnSelectorAvailable(false);
        TableColumnModel tableColumnModel = this.renameMeasuresTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellEditor(myCellEditor);
        tableColumn.setPreferredWidth(220);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(220);
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setPreferredWidth(220);
        this.setExtraPropertyColumns();
    }

    protected void setExtraPropertyColumns() {
    }

    @Override
    public void commitPanel() {
        TableCellEditor tableCellEditor = this.renameMeasuresTable.getCellEditor();
        if (this.renameMeasuresTable.isEditing()) {
            tableCellEditor.stopCellEditing();
        }
    }

    class MyCellEditor
    extends ActionConfirmPanel.MyBaseCellEditor {
        @Override
        public boolean stopCellEditing() {
            int n = this.getNameColumnIndex();
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n2 = tableColumn.getModelIndex();
            if (n2 == n) {
                boolean bl = true;
                String string = null;
                String string2 = ConfirmRenameMeasurePanel.this.prov.getExternalName(ConfirmRenameMeasurePanel.this.origMeasureNames.get(this.row));
                String string3 = UIStringUtils.normalizeName(this.cellTextField.getText(), ConfirmRenameMeasurePanel.this.prov);
                try {
                    ConfirmRenameMeasurePanel.this.prov.validateName("MEASURE2", string3);
                }
                catch (InvalidNameException invalidNameException) {
                    string = invalidNameException.getMessage();
                    bl = false;
                }
                if (bl) {
                    String string4 = ConfirmRenameMeasurePanel.this.prov.getInternalName(string3);
                    AVBaseMeasure aVBaseMeasure = ConfirmRenameMeasurePanel.this.analyticView.findBaseMeasure(string4);
                    if (aVBaseMeasure != null && !string4.equals(ConfirmRenameMeasurePanel.this.prov.getInternalName(string2))) {
                        string = HCSArb.format("AV_MEASURE_ERROR_DUPLICATE_NAME", string4);
                        bl = false;
                    } else {
                        this.cellTextField.setText(string3);
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)HCSArb.get("AV_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string2);
                    return bl;
                }
            }
            return super.stopCellEditing();
        }
    }
}

