/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSCompileDDLGenerator;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.UpdateProcessorPropertiesFilter;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.refactoring.DBObjectTransaction;

public class HCSDDLPanel
extends DDLPanel
implements ActionListener {
    private HCSCompileDDLGenerator compileStatementsGenerator = new HCSCompileDDLGenerator();
    private final String CREATE = "Create";
    private boolean isCreateOptionChangedByUser;
    protected static final Logger LOG = Logger.getLogger(HCSDDLPanel.class.getName());

    public void onEntry(TraversableContext traversableContext) {
        this.isCreateOptionChangedByUser = false;
        super.onEntry(traversableContext);
        this.printDiff();
    }

    protected void printDiff() throws UnsupportedDDLException {
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        HCSDDLPanel.printDiff(dBEditorConfig, this.useProviderTransactionForDiff());
    }

    protected String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.getSQL());
        DBEditorConfig dBEditorConfig = this.getEditorConfig();
        if (dBEditorConfig.isEdit() && stringBuffer.length() > 0 && !this.isCreateOptionChangedByUser) {
            SystemObject systemObject = dBEditorConfig.getOriginalObject();
            String string = systemObject.getName();
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBEditorConfig.getProvider();
            String string2 = dBEditorConfig.getSchema().getName();
            List<AbstractSchemaObjectWithDesc> list = this.getDependencies(string2, oracleDatabaseImpl, string);
            if (!list.isEmpty()) {
                List<String> list2 = this.compileStatementsGenerator.generateCompileStatements(list);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.join((CharSequence)";\n\n", list2));
                stringBuilder.append(";");
                stringBuffer.append("\n");
                stringBuffer.append((CharSequence)stringBuilder);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.isCreateOptionChangedByUser = string.equals("Create");
        super.actionPerformed(actionEvent);
    }

    protected List<AbstractSchemaObjectWithDesc> getDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        return Collections.EMPTY_LIST;
    }

    public static Collection<String> getSQLStatements(DBEditorConfig dBEditorConfig) throws UnsupportedDDLException {
        DBObjectTransaction dBObjectTransaction;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        boolean bl = dBEditorConfig.isReplaceAllowed();
        DDLOptions dDLOptions = new DDLOptions(bl, false);
        DDLGenerator dDLGenerator = HCSDDLPanel.getDDLGenerator((DBEditorConfig)dBEditorConfig);
        if (dDLGenerator == null) {
            DBLog.getLogger().log(Level.WARNING, "No DDL generator found. DDL panel will not function.");
            return null;
        }
        SystemObject systemObject2 = dBEditorConfig.getOriginalObject();
        if (systemObject2 == null) {
            dDLOptions.setReplace(false);
        }
        Difference difference = null;
        boolean bl2 = false;
        if (bl2) {
            dBObjectTransaction = new DBObjectTransaction(dBObjectProvider);
            dBObjectTransaction.includeUpdate(systemObject2, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject));
            dBObjectTransaction.setReplace(true);
            dBObjectTransaction.setCascade(true);
            try {
                Difference difference2 = dBObjectTransaction.getTransactionDifference();
                difference = difference2.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (difference == null) {
            difference = dBObjectProvider.getDiffEngine().difference((Object)systemObject2, (Object)systemObject);
            difference = difference.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
        }
        dBObjectTransaction = dDLGenerator.getUpdateDDL(dDLOptions, difference);
        return dBObjectTransaction.getStatements();
    }

    public static void printDiff(DBEditorConfig dBEditorConfig, boolean bl) throws UnsupportedDDLException {
        Collection collection;
        DBObjectTransaction dBObjectTransaction;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        DDLDatabase dDLDatabase = null;
        if (dBObjectProvider instanceof DDLDatabase) {
            dDLDatabase = (DDLDatabase)dBObjectProvider;
        }
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        SystemObject systemObject2 = dBEditorConfig.getOriginalObject();
        boolean bl2 = dBEditorConfig.isReplaceAllowed();
        DDLOptions dDLOptions = new DDLOptions(bl2, false);
        DDLGenerator dDLGenerator = HCSDDLPanel.getDDLGenerator((DBEditorConfig)dBEditorConfig);
        if (dDLGenerator == null) {
            DBLog.getLogger().log(Level.WARNING, "No DDL generator found. DDL panel will not function.");
            return;
        }
        SystemObject systemObject3 = systemObject2;
        Difference difference = null;
        if (bl) {
            dBObjectTransaction = new DBObjectTransaction(dBObjectProvider);
            dBObjectTransaction.includeUpdate(systemObject3, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject));
            dBObjectTransaction.setReplace(true);
            dBObjectTransaction.setCascade(true);
            try {
                collection = dBObjectTransaction.getTransactionDifference();
                difference = collection.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
                difference.print(System.out);
            }
            catch (DBException dBException) {
                LOG.log(Level.WARNING, dBException.getMessage(), dBException);
            }
        }
        if (difference == null) {
            difference = dBObjectProvider.getDiffEngine().difference((Object)systemObject3, (Object)systemObject);
            difference.print(System.out);
        }
        dBObjectTransaction = dDLGenerator.getUpdateDDL(dDLOptions, difference);
        collection = dBObjectTransaction.getStatements();
        System.out.println(collection);
    }

    public static void print(Difference difference) {
        StringBuilder stringBuilder = new StringBuilder("\n");
        HCSDDLPanel.toString(difference, stringBuilder, "");
        System.out.println(stringBuilder.toString());
    }

    public static void toString(Difference difference, StringBuilder stringBuilder, String object) {
        String string = HCSDDLPanel.toString(difference);
        stringBuilder.append((String)object).append(string).append("\n");
        object = (String)object + "  ";
        for (Difference difference2 : difference.getChildren()) {
            HCSDDLPanel.toString(difference2, stringBuilder, (String)object);
        }
    }

    public static String toString(Difference difference) {
        StringBuilder stringBuilder = new StringBuilder();
        if (difference.getPropertyName() != null) {
            boolean bl = difference.isSame();
            String string = difference.getPropertyName();
            stringBuilder.append(bl ? "SAME " : "XXXX ").append("  ");
            stringBuilder.append(string);
            if (difference.isLeaf()) {
                stringBuilder.append("  ").append("(").append(String.valueOf(difference.getOriginalObject())).append(" : ").append(String.valueOf(difference.getUpdatedObject())).append(")");
            }
            int n = difference.getIndexOfOriginalObject();
            int n2 = difference.getIndexOfUpdatedObject();
            if (n >= 0 || n2 >= 0) {
                stringBuilder.append("  ").append(n + " " + n2);
            }
        }
        return stringBuilder.toString();
    }
}

