/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.hcs.HCSImagesArb;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.panels.LevelMatchFilter;
import oracle.hcs.util.CompletionProviderWithFilter;
import oracle.hcs.util.ListSeparatorsRenderer;

public class CompletionLevelMatchProvider
implements CompletionProviderWithFilter<DimensionLevel> {
    private List<DimensionLevel> levels = new ArrayList<DimensionLevel>();
    private boolean filter = true;
    private final ListCellRenderer renderer;
    private LevelMatchFilter levelMatchFilter;

    public CompletionLevelMatchProvider(JList jList, Collection<DimensionLevel> collection) {
        this(jList);
        this.levels.addAll(collection);
    }

    public CompletionLevelMatchProvider(JComponent jComponent, Collection<DimensionLevel> collection) {
        this((JList)jComponent);
        this.levels.addAll(collection);
    }

    public CompletionLevelMatchProvider(JList jList) {
        this.renderer = new ListSeparatorsRenderer(jList.getCellRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList jList, Object object, int n) {
                Object object2 = null;
                if (n + 1 < jList.getModel().getSize()) {
                    object2 = jList.getModel().getElementAt(n + 1);
                }
                if (object2 != null) {
                    IdentifierElement identifierElement = new IdentifierElement(object2.toString());
                    IdentifierElement identifierElement2 = new IdentifierElement(object.toString());
                    if (identifierElement.getCount() == 2 && identifierElement2.getCount() == 2) {
                        boolean bl = identifierElement.getFirst().equals(identifierElement2.getFirst());
                        return !bl;
                    }
                }
                return false;
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (component instanceof JLabel && object instanceof ColumnIdentifier) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(HCSImagesArb.getIcon("LEVEL_ICON"));
                }
                return component;
            }
        };
    }

    public void setStrings(Collection<DimensionLevel> collection) {
        this.filter = true;
        this.levels.clear();
        this.levels.addAll(collection);
    }

    @Override
    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public void setLevelMatchFilter(LevelMatchFilter levelMatchFilter) {
        this.levelMatchFilter = levelMatchFilter;
    }

    public DimensionLevel[] getInsightData(Document document, int n) {
        ArrayList<DimensionLevel> arrayList = new ArrayList<DimensionLevel>();
        try {
            String string = document.getText(0, n).toLowerCase();
            if (string.trim().length() == 0) {
                this.filter = false;
            }
            for (DimensionLevel dimensionLevel : this.levels) {
                String string2 = dimensionLevel.getExternalName();
                if (this.filter) {
                    int n2 = string2.toLowerCase().indexOf(string.toLowerCase());
                    if (n2 < 0) continue;
                    if (this.levelMatchFilter != null) {
                        if (this.levelMatchFilter.filter(dimensionLevel)) continue;
                        arrayList.add(dimensionLevel);
                        continue;
                    }
                    arrayList.add(dimensionLevel);
                    continue;
                }
                if (this.levelMatchFilter == null || this.levelMatchFilter.filter(dimensionLevel)) continue;
                arrayList.add(dimensionLevel);
            }
            if (arrayList.size() == 1) {
                DimensionLevel dimensionLevel = (DimensionLevel)arrayList.get(0);
                if (this.levelMatchFilter != null && !this.levelMatchFilter.filter(dimensionLevel) && ((DimensionLevel)arrayList.get(0)).getExternalName().equalsIgnoreCase(string)) {
                    arrayList.clear();
                    arrayList.addAll(this.levels);
                }
            }
            if (arrayList.size() == 0) {
                arrayList.addAll(this.levels);
            }
            this.filter = true;
        }
        catch (BadLocationException badLocationException) {
            return new DimensionLevel[0];
        }
        return arrayList.toArray(new DimensionLevel[arrayList.size()]);
    }

    public void completeInsight(Document document, int n, DimensionLevel dimensionLevel) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, dimensionLevel.getExternalName(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

