/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.hcs.HCSArb;
import oracle.hcs.quickav.QuickAVTableAnalyzer;
import oracle.hcs.quickav.model.QuickAVChecklistTask;
import oracle.hcs.quickav.model.QuickAVChecklistTaskNode;
import oracle.hcs.quickav.model.QuickAVChecklistTaskRenderer;
import oracle.hcs.quickav.model.QuickAVChecklistTaskTableModel;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class QuickAVChecklistTaskDialog
extends JDialog {
    private QuickAVChecklistTaskTableModel treeModel;
    private JFastTreeTable treeTable;
    private JButton okBtn;
    private String factTable;
    private JProgressBar progressBar;

    public QuickAVChecklistTaskDialog(JDialog jDialog, String string) {
        super(jDialog, HCSArb.format("QUICK_AV_OVERVIEW_TITLE", string), true);
        this.factTable = string;
        QuickAVChecklistTaskNode quickAVChecklistTaskNode = this.setupTree();
        this.treeModel = new QuickAVChecklistTaskTableModel(quickAVChecklistTaskNode);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.treeModel);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        JTree jTree = this.treeTable.getTree();
        QuickAVChecklistTaskRenderer quickAVChecklistTaskRenderer = new QuickAVChecklistTaskRenderer();
        quickAVChecklistTaskRenderer.setTreeTable((JTable)this.treeTable);
        jTree.setCellRenderer((TreeCellRenderer)((Object)quickAVChecklistTaskRenderer));
        jTree.setRowHeight(this.treeTable.getRowHeight());
        jTree.setShowsRootHandles(true);
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(600, 400));
        this.setLocationRelativeTo(jDialog);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane((Component)this.treeTable), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.okBtn = new JButton(HCSArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QuickAVChecklistTaskDialog.this.setVisible(false);
                QuickAVChecklistTaskDialog.this.dispose();
            }
        });
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.okBtn, DialogButtonBar.CONSTRAINT_APPLY);
        this.add((Component)this.progressBar, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.okBtn.setEnabled(false);
    }

    public void start(QuickAVTableAnalyzer quickAVTableAnalyzer) {
        quickAVTableAnalyzer.execute();
        this.setVisible(true);
    }

    public void addCompletionStatus(int n) {
        QuickAVChecklistTaskNode quickAVChecklistTaskNode = (QuickAVChecklistTaskNode)this.treeModel.getRoot();
        QuickAVChecklistTaskNode quickAVChecklistTaskNode2 = quickAVChecklistTaskNode.findNodeByTaskId(n);
        if (quickAVChecklistTaskNode2 != null) {
            QuickAVChecklistTask quickAVChecklistTask = quickAVChecklistTaskNode2.getTask();
            switch (n) {
                case 1: {
                    quickAVChecklistTask.setTask(HCSArb.format("QUICK_AV_SRC_ANALYSIS_TASK_DONE", this.factTable));
                    break;
                }
                case 2: {
                    quickAVChecklistTask.setTask(HCSArb.getString("QUICK_AV_CLASSIFY_TASK_DONE"));
                    break;
                }
                case 3: {
                    quickAVChecklistTask.setTask(HCSArb.getString("QUICK_AV_IDENTIFY_DIMENSIONS_TASK_DONE"));
                    break;
                }
                case 4: {
                    quickAVChecklistTask.setTask(HCSArb.getString("QUICK_AV_IDENTIFY_MEASURES_TASK_DONE"));
                }
            }
            quickAVChecklistTask.setCompleted(true);
            this.expandAndUpdateTree(quickAVChecklistTaskNode);
        }
    }

    public void addDimOrMeasureFound(int n, String string) {
        QuickAVChecklistTaskNode quickAVChecklistTaskNode = (QuickAVChecklistTaskNode)this.treeModel.getRoot();
        QuickAVChecklistTaskNode quickAVChecklistTaskNode2 = quickAVChecklistTaskNode.findNodeByTaskId(n);
        if (quickAVChecklistTaskNode2 != null) {
            QuickAVChecklistTask quickAVChecklistTask = new QuickAVChecklistTask(n, n + 10, string);
            quickAVChecklistTask.setCompleted(true);
            QuickAVChecklistTaskNode quickAVChecklistTaskNode3 = new QuickAVChecklistTaskNode(quickAVChecklistTask);
            quickAVChecklistTaskNode2.addQuickAVNode(quickAVChecklistTaskNode3);
            this.expandAndUpdateTree(quickAVChecklistTaskNode);
        }
    }

    public void enableOKBtn() {
        this.okBtn.setEnabled(true);
        this.progressBar.setVisible(false);
        this.setDefaultCloseOperation(2);
    }

    public void showCheckListCompleteMsg() {
        JOptionPane.showMessageDialog(this, HCSArb.getString("QUICK_AV_CHECKLIST_COMPLETE"), this.getTitle(), 1);
    }

    private void expandAndUpdateTree(QuickAVChecklistTaskNode quickAVChecklistTaskNode) {
        this.treeModel.updateTree(quickAVChecklistTaskNode);
        JTree jTree = this.treeTable.getTree();
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    private QuickAVChecklistTaskNode setupTree() {
        QuickAVChecklistTask quickAVChecklistTask = new QuickAVChecklistTask(0, 0, HCSArb.getString("QUICK_AV_ANALYSIS_TASKS"));
        QuickAVChecklistTask quickAVChecklistTask2 = new QuickAVChecklistTask(0, 1, HCSArb.format("QUICK_AV_SRC_ANALYSIS_TASK", this.factTable));
        QuickAVChecklistTask quickAVChecklistTask3 = new QuickAVChecklistTask(0, 2, HCSArb.getString("QUICK_AV_CLASSIFY_TASK"));
        QuickAVChecklistTask quickAVChecklistTask4 = new QuickAVChecklistTask(0, 3, HCSArb.getString("QUICK_AV_IDENTIFY_DIMENSIONS_TASK"));
        QuickAVChecklistTask quickAVChecklistTask5 = new QuickAVChecklistTask(0, 4, HCSArb.getString("QUICK_AV_IDENTIFY_MEASURES_TASK"));
        QuickAVChecklistTaskNode quickAVChecklistTaskNode = new QuickAVChecklistTaskNode(quickAVChecklistTask);
        quickAVChecklistTaskNode.addQuickAVNode(new QuickAVChecklistTaskNode(quickAVChecklistTask2));
        quickAVChecklistTaskNode.addQuickAVNode(new QuickAVChecklistTaskNode(quickAVChecklistTask3));
        quickAVChecklistTaskNode.addQuickAVNode(new QuickAVChecklistTaskNode(quickAVChecklistTask4));
        quickAVChecklistTaskNode.addQuickAVNode(new QuickAVChecklistTaskNode(quickAVChecklistTask5));
        return quickAVChecklistTaskNode;
    }
}

