/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templatedialog;

import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSpecTimeoutConnectionCache;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.templates.syntaxparser.SyntaxParserStateListener;
import oracle.hcs.templates.templatedialog.TemplateHelper;
import oracle.hcs.templates.templatedialog.TemplateHelperFactory;
import oracle.hcs.templates.templatelist.BaseTemplate;
import oracle.hcs.templates.templatelist.Template;
import oracle.hcs.templates.templatelist.TemplateExpression;
import oracle.hcs.templates.templatelist.TemplateGroup;
import oracle.hcs.templates.templateview.TemplateContext;
import oracle.hcs.templates.templateview.TemplateHelperImpl;
import oracle.hcs.templates.templateview.TemplateHyperContext;
import oracle.hcs.templates.templateview.TemplateHyperContextImpl;
import oracle.hcs.templates.templateview.TemplateMetadata;
import oracle.hcs.util.FetchIcon;
import oracle.hcs.util.Resources;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class TemplateHelperFactoryImpl
implements TemplateHelperFactory {
    private TemplateContext context;
    private Resources resources;
    private TemplateHyperContext hyperContext;
    private Logger LOG = Logger.getLogger(TemplateHelperFactoryImpl.class.getName());
    private HCSSchema schema;
    private OracleDatabaseImpl provider;
    private Properties props;
    private FetchIcon fi;
    private SyntaxParser parser;
    private boolean initialized;
    private String connectionName;
    private String schemaName;
    private String objectType = "CUBE";
    private SyntaxParserStateListener parserStateListener = new SyntaxParserStateListener(){

        @Override
        public void stateChanged(boolean bl) {
            if (bl) {
                TemplateHelperFactoryImpl.this.reinitialize();
            }
        }
    };

    public TemplateHelperFactoryImpl(Properties properties, Resources resources, FetchIcon fetchIcon, OracleDatabaseImpl oracleDatabaseImpl) {
        this(properties, null, null, resources, fetchIcon);
        this.provider = oracleDatabaseImpl;
    }

    public TemplateHelperFactoryImpl(Properties properties, HCSSchema hCSSchema, SyntaxParser syntaxParser, Resources resources, FetchIcon fetchIcon) {
        this.resources = resources;
        this.schema = hCSSchema;
        this.setParser(syntaxParser);
        this.props = properties;
        this.fi = fetchIcon;
    }

    public TemplateHelperFactoryImpl(Properties properties, String string, String string2, SyntaxParser syntaxParser, Resources resources, FetchIcon fetchIcon, OracleDatabaseImpl oracleDatabaseImpl) {
        this(properties, null, syntaxParser, resources, fetchIcon);
        this.provider = oracleDatabaseImpl;
        this.connectionName = string;
        this.schemaName = string2;
    }

    @Override
    public TemplateHelper getInstance(Object ... objectArray) {
        if (!this.initialized) {
            this.initialize();
        }
        TemplateGroup templateGroup = null;
        TemplateExpression templateExpression = null;
        for (Object object : objectArray) {
            if (object instanceof TemplateGroup) {
                templateGroup = (TemplateGroup)object;
            }
            if (!(object instanceof Template)) continue;
            templateExpression = (Template)object;
        }
        if (templateExpression == null && templateGroup != null && !templateGroup.isContainer()) {
            return new TemplateHelperImpl(templateGroup, this.context, this.hyperContext, this.parser);
        }
        if (templateExpression != null && templateExpression.getExpression() != null && ((BaseTemplate)templateExpression).getUi() != null) {
            return new TemplateHelperImpl((Template)templateExpression, templateGroup, this.context, this.hyperContext, this.parser);
        }
        return null;
    }

    @Override
    public TemplateHelper getInstance(String string, Object ... objectArray) {
        this.objectType = string;
        this.initialized = false;
        return this.getInstance(objectArray);
    }

    public void initialize() {
        this.initialized = true;
        Connection connection = null;
        try {
            Object object;
            if (this.connectionName != null) {
                object = HCSSpecTimeoutConnectionCache.getInstance("Get_Instance");
                if (((HCSSpecTimeoutConnectionCache)object).isActive() && ((HCSSpecTimeoutConnectionCache)object).getConnection(this.connectionName) != null) {
                    connection = ((HCSSpecTimeoutConnectionCache)object).getConnection(this.connectionName);
                }
                this.schema = HCSMetadataCache.getUpdatedSchema(this.connectionName, this.schemaName);
                if (connection == null) {
                    connection = Connections.getInstance().getConnection(this.connectionName);
                    ((HCSSpecTimeoutConnectionCache)object).setConnection(connection, this.connectionName);
                }
            }
            if (connection == null) {
                connection = this.provider.getConnection();
            }
            this.hyperContext = new TemplateHyperContextImpl(connection, this.resources, TemplateHyperContext.ResizeMode.TEMPLATE);
            if (this.schema == null) {
                this.context = new TemplateContext();
            } else {
                object = this.schema.findAV(this.props.getProperty("CUBE"));
                if (this.objectType.equalsIgnoreCase("CUBE")) {
                    this.context = new TemplateContext(new TemplateMetadata(this.schema, (AnalyticView)object), (DBObjectProvider)this.provider);
                } else if (this.objectType.equalsIgnoreCase("DIMENSION")) {
                    AttributeDimension attributeDimension = this.schema.findDimension(this.props.getProperty("DIMENSION"));
                    this.context = new TemplateContext(new TemplateMetadata(this.schema, attributeDimension), (DBObjectProvider)this.provider);
                    this.context.setAV((AnalyticView)object);
                }
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public void reinitialize() {
        if (this.initialized) {
            try {
                if (this.connectionName != null) {
                    this.schema = HCSMetadataCache.getSchema(this.connectionName, this.schemaName);
                }
                AnalyticView analyticView = this.schema.findAV(this.props.getProperty("CUBE"));
                this.context.reinitialize(new TemplateMetadata(this.schema, analyticView));
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        } else {
            this.initialize();
        }
    }

    public void setSchema(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
    }

    public HCSSchema getSchema() {
        return this.schema;
    }

    public void setProperty(String string, String string2) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(string, string2);
    }

    public void setProvider(OracleDatabaseImpl oracleDatabaseImpl) {
        this.provider = oracleDatabaseImpl;
    }

    public void setParser(SyntaxParser syntaxParser) {
        this.parser = syntaxParser;
        if (syntaxParser != null) {
            syntaxParser.addSyntaxParserStateListener(this.parserStateListener);
        }
    }

    public SyntaxParser getParser() {
        return this.parser;
    }
}

