/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.Bidi;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.TextPlacementInfo;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLabeler;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.TextStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class StyleText
implements Style,
StyleLabeler {
    static final long serialVersionUID = 6356666330058786798L;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static FontRenderContext frc = new FontRenderContext(null, true, false);
    transient AffineTransform at = new AffineTransform();
    transient Properties fontProperties;
    TextStyleModel bean;
    double visualWidthOfA = 0.0;
    transient BasicStroke floatingStroke = null;
    private TruetypeFont ttFont = null;

    public StyleText() {
        this.bean = new TextStyleModel();
    }

    public StyleText(StyleModel model) {
        this.setModel(model);
    }

    public StyleText(Font font, Color c, float fw) {
        this(font, c);
        this.bean.setHaloWidth(fw);
    }

    public StyleText(String svg) throws StyleException {
        this.bean = new TextStyleModel();
        if (!this.parseTextStyle(svg)) {
            throw new StyleException("Invalid text style definition.");
        }
    }

    public StyleText(Font font, Color c) {
        this.bean = new TextStyleModel();
        this.bean.setFont(font);
        this.bean.setColor(c);
        Rectangle2D r2d = this.getVisualBounds("A", null);
        if (r2d != null) {
            this.visualWidthOfA = r2d.getWidth();
        }
    }

    public boolean updateVisualWidthOfA(TextStyleModifiers tsmods) {
        Rectangle2D r2d = this.getVisualBounds("A", tsmods);
        if (r2d != null) {
            this.visualWidthOfA = r2d.getWidth();
            return true;
        }
        return false;
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof TextStyleModel)) {
            throw new IllegalArgumentException("Not a TextStyleModel instance.");
        }
        this.bean = (TextStyleModel)model;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public Font getFont() {
        return this.bean.getFont();
    }

    public Color getColor() {
        return this.bean.getColor();
    }

    public void setFontProperties(Properties p) {
        this.fontProperties = p;
        this.bean.setFont(this.createFont(p));
    }

    public Properties getFontProperties() {
        return this.fontProperties;
    }

    public Object clone() {
        try {
            StyleText sty = (StyleText)super.clone();
            sty.setModel((StyleModel)this.bean.clone());
            return sty;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public double getCoarseVisualLength(String s) {
        if (!this.bean.getFontSizes().isPixelUnit()) {
            return 0.0;
        }
        return this.visualWidthOfA > 0.0 ? (double)s.length() * this.visualWidthOfA : 0.0;
    }

    public Rectangle2D getVisualBounds(String s, StyleModifiers stymods) {
        if (this.bean.getFont() == null || frc == null) {
            System.err.println("no font specified.");
            return null;
        }
        if (s == null) {
            return null;
        }
        Shape shp = StyleText.getStringOutline(s, this.bean, stymods);
        return shp == null ? null : shp.getBounds();
    }

    public static Shape getStringOutline(String s, TextStyleModel ts, StyleModifiers stymods) {
        if (stymods != null && stymods instanceof TextStyleModifiers && ((TextStyleModifiers)stymods).getFontSize() < 1) {
            return null;
        }
        if (!(ts.isAutoTextWrap() || ts.isHonorNewline() && StyleText.hasLF(s))) {
            return StyleText.getSimpleStringOutline(s, ts, stymods);
        }
        return StyleText.getStringOutline2(s, ts, stymods);
    }

    protected static Shape getStringOutline2(String s, TextStyleModel ts, StyleModifiers stymods) {
        String[] lines = StyleText.breakAtLF(s, ts);
        GeneralPath a = new GeneralPath();
        float[] vspace = new float[1];
        float y = 0.0f;
        for (int i = 0; i < lines.length; ++i) {
            Shape shp = StyleText.getWrappedOutline(lines[i], ts, vspace, stymods);
            if (shp == null) continue;
            if (i > 0) {
                shp = AffineTransform.getTranslateInstance(0.0, y).createTransformedShape(shp);
            }
            a.append(shp, false);
            y += vspace[0];
        }
        return a;
    }

    protected static Shape getWrappedOutline(String s, TextStyleModel ts, float[] vspace, StyleModifiers stymods) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Font f = ts.getFont();
        if (ts.getFont() != null && stymods != null && stymods instanceof TextStyleModifiers) {
            f = ts.deriveFont(((TextStyleModifiers)stymods).getFontSize());
        }
        AttributedString attribString = new AttributedString(s);
        attribString.addAttribute(TextAttribute.FONT, f, 0, s.length());
        float wrappingWidth = ts.isAutoTextWrap() ? (float)ts.getWrappingWidth() : 25000.0f;
        AttributedCharacterIterator attribCharIterator = attribString.getIterator();
        LineBreakMeasurer lbm = new LineBreakMeasurer(attribCharIterator, frc);
        GeneralPath a = new GeneralPath();
        int pos = 0;
        boolean x = false;
        int y = 0;
        while ((pos = lbm.getPosition()) < s.length()) {
            double xtrans;
            Rectangle2D r;
            TextLayout layout = lbm.nextLayout(wrappingWidth);
            Shape shp = layout.getOutline(AffineTransform.getTranslateInstance((double)x, y));
            Object txtAlign = ts.getLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN);
            if (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER == txtAlign) {
                r = shp.getBounds2D();
                xtrans = (double)(wrappingWidth / 2.0f) - r.getCenterX();
                shp = AffineTransform.getTranslateInstance(xtrans, 0.0).createTransformedShape(shp);
            } else if (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT == txtAlign) {
                r = shp.getBounds2D();
                xtrans = (double)wrappingWidth - r.getMaxX();
                shp = AffineTransform.getTranslateInstance(xtrans, 0.0).createTransformedShape(shp);
            }
            a.append(shp, false);
            y = (int)((float)y + layout.getAscent());
            if ((double)ts.getMultilineSpacing() <= 0.0) {
                y = (int)((float)y + (layout.getDescent() + layout.getLeading()));
                continue;
            }
            y = (int)((float)y + (layout.getDescent() + ts.getMultilineSpacing()));
        }
        vspace[0] = y;
        return a;
    }

    protected static boolean hasLF(String s) {
        if (s == null) {
            return false;
        }
        char[] ca = s.toCharArray();
        if (ca == null) {
            return false;
        }
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != '\n') continue;
            return true;
        }
        return false;
    }

    protected static String[] breakAtLF(String s, TextStyleModel ts) {
        if (!ts.isHonorNewline()) {
            return new String[]{s};
        }
        char[] ca = s.toCharArray();
        int count = 0;
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != '\n') continue;
            ++count;
        }
        String[] rs = new String[count + 1];
        int last = 0;
        int k = 0;
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != '\n') continue;
            rs[k++] = s.substring(last, i);
            last = i + 1;
        }
        rs[k] = s.substring(last);
        return rs;
    }

    protected static Shape getSimpleStringOutline(String s, TextStyleModel ts, StyleModifiers stymods) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Shape shp = null;
        Font font = ts.getFont();
        if (ts.getFont() != null && stymods != null && stymods instanceof TextStyleModifiers) {
            font = ts.deriveFont(((TextStyleModifiers)stymods).getFontSize());
        }
        try {
            char[] chars = s.toCharArray();
            if (!Bidi.requiresBidi(chars, 0, chars.length)) {
                GlyphVector glyphV = null;
                glyphV = font == null ? TextStyleModel.getDefaultFont().createGlyphVector(frc, s) : font.createGlyphVector(frc, s);
                if (ts.getLetterSpacing() > 0.0f) {
                    glyphV = StyleText.applySpacing(glyphV, ts.getLetterSpacing());
                }
                shp = glyphV.getOutline();
            } else {
                TextLayout tl = new TextLayout(s, font == null ? TextStyleModel.getDefaultFont() : font, frc);
                shp = tl.getOutline(null);
            }
            return shp;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public static Shape getLayout(Graphics2D g, String s, float x, float y, Object anchorHint, double rotation, int gap, TextStyleModel m, StyleModifiers stymods) {
        Shape shp = null;
        if (anchorHint != LabelingHints.VALUE_OPOINT_HALIGN_START && anchorHint != LabelingHints.VALUE_OPOINT_HALIGN_CENTER && anchorHint != LabelingHints.VALUE_OPOINT_HALIGN_END) {
            anchorHint = LabelingHints.VALUE_OPOINT_HALIGN_START;
        }
        if ((shp = StyleText.getStringOutline(s, m, stymods)) == null) {
            return null;
        }
        Rectangle2D r = shp.getBounds2D();
        double width = r.getWidth();
        double xtrans = (double)x - r.getCenterX();
        double ytrans = (double)y - r.getCenterY();
        AffineTransform at = new AffineTransform();
        if (rotation != 0.0) {
            at.setToRotation(rotation, x, y);
        }
        if (anchorHint == LabelingHints.VALUE_OPOINT_HALIGN_START) {
            at.translate(xtrans + width / 2.0 + (double)gap, ytrans);
        } else if (anchorHint == LabelingHints.VALUE_OPOINT_HALIGN_CENTER) {
            at.translate(xtrans, ytrans + (double)gap);
        } else {
            at.translate(xtrans - width / 2.0 - (double)gap, ytrans);
        }
        return at.createTransformedShape(shp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _drawString(Graphics2D g, float x, float y, String s, StyleModifiers stymods) {
        Shape shp = StyleText.getStringOutline(s, this.bean, stymods);
        if (shp == null) {
            return;
        }
        g.translate(x, y);
        Stroke olds = g.getStroke();
        Object oldaa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldfm = g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        try {
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle2D r = shp.getBounds2D();
            this.fillTextBackground(g, r, null, stymods);
            if (this.bean.haloEnabled()) {
                this.applyHalo(g, shp, stymods);
            }
            g.setPaint(this.bean.getColor());
            g.fill(shp);
            this.drawTextDecoration(g, shp.getBounds2D(), null, stymods);
        }
        finally {
            g.translate(-x, -y);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldfm);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldaa);
        }
    }

    public void applyHalo(Graphics2D g, Shape shp, StyleModifiers stymods) {
        if (stymods != null && stymods instanceof TextStyleModifiers && ((TextStyleModifiers)stymods).getHaloWidth() < 1.5f) {
            return;
        }
        Stroke strk = this.initFloatingStroke(stymods);
        Stroke olds = g.getStroke();
        g.setStroke(strk);
        g.setPaint(this.bean.getHaloColor());
        g.draw(shp);
        g.setStroke(olds);
    }

    private boolean parseTextStyle(String svg) {
        Rectangle2D r2d;
        Node pathtxtNd;
        String textDecoration;
        String rootStyle;
        String mlspacing;
        String spacing;
        String hn;
        String autoWrapS;
        String fwc;
        XMLDOMParser parser = new XMLDOMParser();
        if (!parser.parse(svg)) {
            return false;
        }
        String t = parser.getAttribute("g", "class");
        if (t == null || !t.toUpperCase().equals("TEXT")) {
            return false;
        }
        String fws = parser.getAttribute("g", "float-width");
        if (fws != null && fws.length() > 0) {
            SizeDefinition hsize = SizeDefinition.parse(fws);
            if (hsize != null) {
                this.bean.setHaloWidth((float)hsize.getValue());
                this.bean.setHaloWidthUnit(hsize.getUnit());
            } else {
                this.bean.setHaloWidth(-1.0f);
                this.bean.setHaloWidthUnit(null);
            }
        }
        if ((fwc = parser.getAttribute("g", "float-color")) != null && fwc.length() > 0) {
            try {
                this.bean.setHaloColor(StyleUtils.getColor("float-color", "float-color:" + fwc));
                String fco = parser.getAttribute("g", "float-color-opacity");
                if (fco != null && fco.trim().length() > 0) {
                    int opacity = Integer.parseInt(fco.trim());
                    Color hcolor = this.bean.getHaloColor();
                    if (hcolor != null) {
                        this.bean.setHaloColor(new Color(hcolor.getRed(), hcolor.getGreen(), hcolor.getBlue(), opacity));
                    }
                }
            }
            catch (Exception e) {
                log.warning("error parsing float-color attr.");
            }
        }
        this.bean.setSticky(false);
        String stickyS = parser.getAttribute("g", "sticky");
        if (stickyS != null && stickyS.length() > 0) {
            this.bean.setSticky("true".equalsIgnoreCase(stickyS));
        }
        this.bean.setEmbeddedTTFont(null);
        String embttf = parser.getAttribute("g", "embedded-ttf");
        if (embttf != null && embttf.length() > 0) {
            if (!"true".equalsIgnoreCase(embttf)) {
                embttf = "false";
            }
        } else {
            embttf = "false";
        }
        if ((autoWrapS = parser.getAttribute("g", "auto-wrap")) != null && autoWrapS.length() > 0) {
            this.bean.setAutoTextWrap("true".equalsIgnoreCase(autoWrapS));
            String ww = parser.getAttribute("g", "wrapping-width");
            if (ww != null && ww.length() > 0) {
                this.bean.setWrappingWidth((int)Double.parseDouble(ww));
            }
        }
        if ((hn = parser.getAttribute("g", "honor-newline")) != null && hn.length() > 0) {
            this.bean.setHonorNewline("true".equalsIgnoreCase(hn));
        }
        if ((spacing = parser.getAttribute("g", "letter-spacing")) != null && spacing.length() > 0) {
            try {
                this.bean.setLetterSpacing(Float.parseFloat(spacing));
            }
            catch (Exception e) {
                log.warning("invalid letter-spacing value.");
            }
        }
        if ((mlspacing = parser.getAttribute("g", "multiline-spacing")) != null && mlspacing.length() > 0) {
            try {
                this.bean.setMultilineSpacing(Float.parseFloat(mlspacing));
            }
            catch (Exception e) {
                log.warning("invalid multiline-spacing value.");
            }
        }
        if ((rootStyle = parser.getAttribute("g", "style")) == null) {
            return false;
        }
        String fontFamily = StyleUtils.getNamedString(rootStyle, "font-family");
        String fontSize = StyleUtils.getNamedString(rootStyle, "font-size");
        String minFontSize = StyleUtils.getNamedString(rootStyle, "min-font-size");
        String fontWeight = StyleUtils.getNamedString(rootStyle, "font-weight");
        String fontStyle = StyleUtils.getNamedString(rootStyle, "font-style");
        String fontFill = StyleUtils.getNamedString(rootStyle, "fill");
        String fontBackground = StyleUtils.getNamedString(rootStyle, "background");
        String ta = StyleUtils.getNamedString(rootStyle, "text-align");
        if (ta != null && ta.length() > 0) {
            if ("left".equalsIgnoreCase(ta)) {
                this.bean.setLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_LEFT);
            } else if ("right".equalsIgnoreCase(ta)) {
                this.bean.setLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT);
            } else {
                this.bean.setLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER);
            }
        }
        if ((textDecoration = StyleUtils.getNamedString(rootStyle, "text-decoration")) != null && textDecoration.length() > 0) {
            this.bean.setTextDecoration(textDecoration);
        }
        this.fontProperties = new Properties();
        this.fontProperties.put("font-family", fontFamily != null ? fontFamily : "");
        this.fontProperties.put("font-size", fontSize != null ? fontSize : "");
        this.fontProperties.put("font-weight", fontWeight != null ? fontWeight : "");
        this.fontProperties.put("font-style", fontStyle != null ? fontStyle : "");
        this.fontProperties.put("font-fill", fontFill != null ? fontFill : "");
        if (fontFill != null) {
            this.bean.setColor(StyleUtils.getColor("fill", rootStyle));
        }
        if (fontBackground != null) {
            this.bean.setBackground(StyleUtils.getColor("background", rootStyle));
        }
        int jfStyle = 0;
        if (fontStyle != null && fontStyle.toUpperCase().equals("ITALIC")) {
            jfStyle = 2;
        }
        if (fontWeight != null && fontWeight.toUpperCase().equals("BOLD")) {
            jfStyle = jfStyle == 2 ? (jfStyle |= 1) : 1;
        }
        int jfSize = 12;
        if (fontSize != null) {
            SizeDefinition fsize = SizeDefinition.parse(fontSize);
            if (fsize != null) {
                jfSize = (int)fsize.getValue();
                this.bean.setFontSize((float)fsize.getValue(), fsize.getUnit());
            } else {
                this.bean.setFontSize(12.0f, null);
            }
            if (minFontSize != null) {
                SizeDefinition minfsize = SizeDefinition.parse(minFontSize);
                if (minfsize != null) {
                    int minjfSize = (int)minfsize.getValue();
                    this.bean.setMinFontSize(minjfSize);
                } else {
                    this.bean.setMinFontSize(-1.0f);
                }
            }
        }
        if ("false".equalsIgnoreCase(embttf)) {
            this.bean.setFont(new Font(fontFamily, jfStyle, jfSize));
        } else {
            StyleText styleText = this;
            this.bean.setFont(new Font(styleText.bean.getDefaultFont().getFamily(), jfStyle, jfSize));
            this.bean.setEmbeddedTTFont(fontFamily);
        }
        Node opointNd = parser.getElementNode("opoint");
        if (opointNd != null) {
            String halign = XMLDOMParser.getAttribute(opointNd, "halign");
            String valign = XMLDOMParser.getAttribute(opointNd, "valign");
            if (halign == null || halign.length() == 0) {
                halign = "center";
            }
            if (valign == null || valign.length() == 0) {
                valign = "middle";
            }
            halign = halign.toLowerCase();
            valign = valign.toLowerCase();
            Object h = null;
            Object v = null;
            h = "center".equals(halign) ? LabelingHints.VALUE_OPOINT_HALIGN_CENTER : ("start".equals(halign) ? LabelingHints.VALUE_OPOINT_HALIGN_START : ("end".equals(halign) ? LabelingHints.VALUE_OPOINT_HALIGN_END : LabelingHints.VALUE_OPOINT_HALIGN_CENTER));
            v = "middle".equals(valign) ? LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE : ("top".equals(valign) ? LabelingHints.VALUE_OPOINT_VALIGN_TOP : ("bottom".equals(valign) ? LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM : ("baseline".equals(valign) ? LabelingHints.VALUE_OPOINT_VALIGN_BASELINE : LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE)));
            this.bean.setLabelingHint(LabelingHints.KEY_OPOINT_HALIGN, h);
            this.bean.setLabelingHint(LabelingHints.KEY_OPOINT_VALIGN, v);
            String applyspt = XMLDOMParser.getAttribute(opointNd, "apply-to-simple-points");
            if (applyspt != null && applyspt.equalsIgnoreCase("true")) {
                this.bean.setApplyOPointsHintsToSimplePoints(true);
            } else {
                this.bean.setApplyOPointsHintsToSimplePoints(false);
            }
        }
        if ((pathtxtNd = parser.getElementNode("text-along-path")) != null) {
            String valign = XMLDOMParser.getAttribute(pathtxtNd, "valign");
            if (valign == null || valign.length() == 0) {
                valign = "middle";
            }
            valign = valign.toLowerCase();
            Object v = null;
            v = "middle".equals(valign) ? LabelingHints.VALUE_LINE_VALIGN_MIDDLE : ("top".equals(valign) ? LabelingHints.VALUE_LINE_VALIGN_TOP : ("bottom".equals(valign) ? LabelingHints.VALUE_LINE_VALIGN_BOTTOM : ("baseline".equals(valign) ? LabelingHints.VALUE_LINE_VALIGN_BASELINE : LabelingHints.VALUE_LINE_VALIGN_MIDDLE)));
            this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, v);
            String halign = XMLDOMParser.getAttribute(pathtxtNd, "halign");
            if (halign == null || halign.length() == 0) {
                halign = "center";
            }
            halign = halign.toLowerCase();
            Object h = null;
            h = "start".equals(halign) ? LabelingHints.VALUE_LINE_HALIGN_START : ("end".equals(halign) ? LabelingHints.VALUE_LINE_HALIGN_END : LabelingHints.VALUE_LINE_HALIGN_CENTER);
            this.bean.setLabelingHint(LabelingHints.KEY_LINE_HALIGN, h);
            String spf = XMLDOMParser.getAttribute(pathtxtNd, "smart-path-following");
            if (spf != null && "true".equalsIgnoreCase(spf)) {
                this.bean.setSmartPathFollowing(true);
            } else {
                this.bean.setSmartPathFollowing(false);
            }
            String stf = XMLDOMParser.getAttribute(pathtxtNd, "straight-line-labeling");
            if (stf != null && "true".equalsIgnoreCase(stf)) {
                this.bean.setStraightLineLabeling(true);
            } else {
                this.bean.setStraightLineLabeling(false);
            }
        }
        if (this.bean.getFontSizes().isPixelUnit() && (r2d = this.getVisualBounds("A", null)) != null) {
            this.visualWidthOfA = r2d.getWidth();
        }
        return true;
    }

    private Font createFont(Properties p) {
        String fontFamily = p.getProperty("font-family");
        String fontSize = p.getProperty("font-size");
        String fontWeight = p.getProperty("font-weight");
        String fontStyle = p.getProperty("font-style");
        String fontFill = p.getProperty("font-fill");
        if (fontFill != null && fontFill.length() > 0) {
            this.bean.setColor(StyleUtils.getColor("fill", fontFill));
        }
        int jfStyle = 0;
        if (fontStyle != null && fontStyle.toUpperCase().equals("ITALIC")) {
            jfStyle = 2;
        }
        if (fontWeight != null && fontWeight.toUpperCase().equals("BOLD")) {
            jfStyle = jfStyle == 2 ? (jfStyle |= 1) : 1;
        }
        int jfSize = 12;
        if (fontSize != null && fontSize.length() > 0) {
            SizeDefinition fsize = SizeDefinition.parse(fontSize);
            if (fsize != null) {
                jfSize = (int)fsize.getValue();
                this.bean.setFontSize((float)fsize.getValue(), fsize.getUnit());
            } else {
                this.bean.setFontSize(12.0f, null);
            }
        }
        Font font = new Font(fontFamily, jfStyle, jfSize);
        return font;
    }

    private Stroke initFloatingStroke(StyleModifiers stymods) {
        if (stymods != null) {
            return this.createFloatingStroke(stymods);
        }
        if (this.floatingStroke == null) {
            this.floatingStroke = (BasicStroke)this.createFloatingStroke(null);
            return this.floatingStroke;
        }
        return this.floatingStroke;
    }

    public Stroke createFloatingStroke(StyleModifiers stymods) {
        float hwidth = this.bean.getHaloWidth();
        if (stymods != null && stymods instanceof TextStyleModifiers) {
            hwidth = ((TextStyleModifiers)stymods).getHaloWidth();
        }
        return new BasicStroke(hwidth, 0, 2);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        if (this.bean.getEmbeddedTTFont() != null) {
            if (this.ttFont == null || !this.bean.getEmbeddedTTFont().equalsIgnoreCase(this.ttFont.getName())) {
                this.ttFont = sc.getFont(this.bean.getEmbeddedTTFont());
                if (this.ttFont != null && this.ttFont.getFont() != null) {
                    this.bean.setFont(this.ttFont.getFont().deriveFont(this.bean.getFont().getStyle(), this.bean.getFontSizeValue()));
                } else {
                    StyleText styleText = this;
                    this.bean.setFont(styleText.bean.getDefaultFont());
                    this.ttFont = null;
                }
            }
        } else {
            this.ttFont = null;
        }
        return true;
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        this.ttFont = null;
        return this.resolveStyles(sc, dynaStyles);
    }

    @Override
    public void drawString(Graphics2D g, float x, float y, double rotation, String s, StyleModifiers stymods) throws StyleNotApplicableException {
        if (rotation == 0.0) {
            g.setFont(this.bean.getFont());
            Rectangle2D r = this.getVisualBounds(s, stymods);
            this._drawString(g, x, y, s, stymods);
        } else {
            Shape shp = StyleText.getStringOutline(s, this.bean, stymods);
            Shape shp2 = null;
            Shape shp3 = null;
            if (shp == null) {
                return;
            }
            Rectangle2D r = shp.getBounds2D();
            this.at.setToRotation(rotation);
            this.fillTextBackground(g, r, this.at, stymods);
            shp2 = this.at.createTransformedShape(shp);
            r = shp2.getBounds2D();
            this.at.setToTranslation(x, y);
            shp3 = this.at.createTransformedShape(shp2);
            r = shp3.getBounds2D();
            if (this.bean.haloEnabled()) {
                this.applyHalo(g, shp3, stymods);
            }
            if (this.bean.getColor() != null) {
                g.setColor(this.bean.getColor());
            }
            g.fill(shp3);
            this.drawTextDecoration(g, r, this.at, stymods);
        }
    }

    @Override
    public void apply(Graphics2D g, float x, float y, String s, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(g, x, y, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, s, stymods);
    }

    @Override
    public void apply(Graphics2D g, Rectangle2D rect, String s, StyleModifiers stymods) throws StyleNotApplicableException {
        Shape shp = StyleText.getStringOutline(s, this.bean, stymods);
        if (shp == null) {
            return;
        }
        Shape shp2 = null;
        Object shp3 = null;
        Rectangle2D r = shp.getBounds2D();
        this.at.setToTranslation(rect.getCenterX() - r.getCenterX(), rect.getCenterY() - r.getCenterY());
        this.fillTextBackground(g, r, this.at, stymods);
        shp2 = this.at.createTransformedShape(shp);
        if (this.bean.haloEnabled()) {
            this.applyHalo(g, shp2, stymods);
        }
        if (this.bean.getColor() != null) {
            g.setColor(this.bean.getColor());
        }
        g.fill(shp2);
        this.drawTextDecoration(g, r, this.at, stymods);
    }

    @Override
    public void apply(Graphics2D g, float x, float y, Object anchorHint, double angle, int gap, String s, StyleModifiers stymods) throws StyleNotApplicableException {
        Shape shp2 = StyleText.getLayout(g, s, x, y, anchorHint, angle, gap, this.bean, stymods);
        if (shp2 == null) {
            return;
        }
        this.drawOutline(g, shp2, stymods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOutline(Graphics2D g, Shape shp2, StyleModifiers stymods) {
        Object oldaa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldfm = g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        try {
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bean.haloEnabled()) {
                this.applyHalo(g, shp2, stymods);
            }
            if (this.bean.getColor() != null) {
                g.setColor(this.bean.getColor());
            }
            g.fill(shp2);
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldfm);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldaa);
        }
    }

    private void drawTextDecoration(Graphics2D g, Rectangle2D r, AffineTransform aft, StyleModifiers stymods) {
        if (g == null || r == null) {
            return;
        }
        String textDecor = this.bean.getTextDecoration();
        if (textDecor.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_NONE)) {
            return;
        }
        double shpx = r.getBounds().x;
        double shpy = r.getBounds().y;
        double shpw = r.getBounds().width;
        double shph = r.getBounds().height;
        if (this.bean.haloEnabled()) {
            float hwidth = this.bean.getHaloWidth();
            if (stymods != null && stymods instanceof TextStyleModifiers) {
                hwidth = ((TextStyleModifiers)stymods).getHaloWidth();
            }
            shpx -= (double)hwidth / 2.0;
            shpy -= (double)hwidth / 2.0;
            shpw += (double)hwidth;
            shph += (double)hwidth;
        }
        Line2D.Double ld = new Line2D.Double();
        if (textDecor.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_UNDERLINE)) {
            ld.setLine(shpx, shpy + shph, shpx + shpw, shpy + shph);
        } else if (textDecor.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_LINETHROUGH)) {
            ld.setLine(shpx, shpy + (double)((int)(0.5 * shph)), shpx + shpw, shpy + (double)((int)(0.5 * shph)));
        } else if (textDecor.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_OVERLINE)) {
            ld.setLine(shpx, shpy, shpx + shpw, shpy);
        } else {
            return;
        }
        Shape lds = ld;
        if (aft != null) {
            lds = aft.createTransformedShape(ld);
        }
        g.draw(lds);
    }

    private void fillTextBackground(Graphics2D g, Rectangle2D r, AffineTransform aft, StyleModifiers stymods) {
        Rectangle2D.Double backRect;
        if (g == null || r == null) {
            return;
        }
        Color backColor = this.bean.getBackground();
        if (backColor == null) {
            return;
        }
        double shpx = r.getBounds().x;
        double shpy = r.getBounds().y;
        double shpw = r.getBounds().width;
        double shph = r.getBounds().height;
        if (this.bean.haloEnabled()) {
            float hwidth = this.bean.getHaloWidth();
            if (stymods != null && stymods instanceof TextStyleModifiers) {
                hwidth = ((TextStyleModifiers)stymods).getHaloWidth();
            }
            shpx -= (double)hwidth / 2.0;
            shpy -= (double)hwidth / 2.0;
            shpw += (double)hwidth;
            shph += (double)hwidth;
        }
        Shape lds = backRect = new Rectangle2D.Double(shpx, shpy, shpw, shph);
        if (aft != null) {
            lds = aft.createTransformedShape(backRect);
        }
        g.setPaint(backColor);
        g.fill(lds);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(g, rect, "123 Main St", stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        this.apply(null, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    public void apply(Graphics2D g, TextPlacementInfo tpi, VisContext vc, StyleModifiers stymods) {
        Shape shp = tpi.getTextShape();
        Rectangle2D r = tpi.getTextShapeMBR();
        AffineTransform at = new AffineTransform();
        double rotation = tpi.getRotation();
        if (rotation != 0.0) {
            at.setToRotation(rotation, tpi.getRotationAnchorX(), tpi.getRotationAnchorY());
        }
        float xtrans = (float)((double)tpi.getTextCenterX() - r.getCenterX());
        float ytrans = (float)((double)tpi.getTextCenterY() - r.getCenterY());
        if (xtrans != 0.0f || ytrans != 0.0f) {
            at.translate(xtrans, ytrans);
        }
        this.fillTextBackground(g, r, at, stymods);
        shp = at.createTransformedShape(shp);
        this.drawOutline(g, shp, stymods);
        this.drawTextDecoration(g, r, at, stymods);
        if (vc != null) {
            vc.getCRArray().insert(shp.getBounds2D());
        }
    }

    protected static GlyphVector applySpacing(GlyphVector gv, float spacing) {
        if (spacing <= 5.0f) {
            return gv;
        }
        int n = gv.getNumGlyphs();
        double w1 = gv.getLogicalBounds().getWidth() / (double)n;
        double inc = w1 * (double)spacing / 100.0;
        double accum = 0.0;
        for (int i = 0; i < n; ++i) {
            Point2D pt = gv.getGlyphPosition(i);
            Point2D.Double pt2 = new Point2D.Double(pt.getX() + accum, pt.getY());
            gv.setGlyphPosition(i, pt2);
            accum += inc;
        }
        return gv;
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }

    @Override
    public StyleModifiers convertToPixelSize(VisContext vc) {
        if (this.bean.getFontSizes().isPixelUnit() && this.bean.getHaloSize().isPixelUnit()) {
            return null;
        }
        TextStyleModifiers textmods = new TextStyleModifiers();
        if (vc == null || Util.isFullExtent(vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMinX(), vc.getQueryWindow().getMaxX(), vc.getQueryWindow().getMaxY()) || vc.getQueryWindow().getWidth() == 0.0 && vc.getQueryWindow().getHeight() == 0.0) {
            SizeDefinition hsize;
            SizeDefinition2D fsize = this.bean.getFontSizes();
            if (fsize.isPixelUnit()) {
                textmods.setFontSize((int)fsize.getWidth());
                textmods.setMinFontSize((int)fsize.getHeight());
            }
            if ((hsize = this.bean.getHaloSize()).isPixelUnit()) {
                textmods.setHaloWidth((int)hsize.getValue());
            }
        } else {
            double pixelY;
            Rectangle2D devW = vc.getDeviceWindow();
            Rectangle2D queW = vc.getQueryWindow();
            double pixelX = queW.getWidth() / devW.getWidth();
            pixelX = pixelY = queW.getHeight() / devW.getHeight();
            double v = this.getPixelValue(new SizeDefinition(this.bean.getFontSizeValue(), this.bean.getFontSizes().getUnit()), pixelY, vc);
            if (v > 0.0) {
                textmods.setFontSize((int)v);
            }
            if (this.bean.getMinFontSize() != -1.0f) {
                v = this.getPixelValue(new SizeDefinition(this.bean.getMinFontSize(), this.bean.getFontSizes().getUnit()), pixelY, vc);
                if (v > 0.0) {
                    textmods.setMinFontSize((int)v);
                }
            } else {
                textmods.setMinFontSize(-1);
            }
            if ((v = this.getPixelValue(this.bean.getHaloSize(), pixelX, vc)) > 0.0) {
                textmods.setHaloWidth((int)v);
            }
        }
        return textmods;
    }

    private double getPixelValue(SizeDefinition value, double pixelSize, VisContext vc) {
        Double convFactor = null;
        if (value.getUnit() != null) {
            convFactor = SRS.getDistanceConversionFactor(value.getUnit());
        }
        if (value.isPixelUnit()) {
            return value.getValue();
        }
        if (convFactor != null) {
            double cv = value.getValue() * convFactor;
            if (vc.getSrs() != null && vc.getSrs().isGeodetic()) {
                double dgw = SphereCG.convertRadius(0.0, 0.0, cv);
                return dgw / pixelSize + 0.5;
            }
            return cv / pixelSize + 0.5;
        }
        return 0.0;
    }
}

