/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.VariableMarkerStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VariableMarkerStyle
extends BucketStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    StyleMarker baseMarker = null;

    public VariableMarkerStyle() {
        this.bean = new VariableMarkerStyleModel();
    }

    public VariableMarkerStyle(StyleModel model) {
        this.setModel(model);
    }

    public VariableMarkerStyle(Document doc) throws StyleException {
        this.bean = new VariableMarkerStyleModel();
        try {
            Node elem = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
            Node elemVMS = XMLDOMParser.getSubElement(elem, "VariableMarkerStyle");
            elem = XMLDOMParser.getSubElement(elemVMS, "Buckets");
            BucketStyle.fetchBuckets(elem, this.bean.getBucketSeries());
            ((VariableMarkerStyleModel)this.bean).setBaseMarkerName(XMLDOMParser.getAttribute(elemVMS, "basemarker"));
            String startSize = XMLDOMParser.getAttribute(elemVMS, "startsize");
            String incSize = XMLDOMParser.getAttribute(elemVMS, "increment");
            SizeDefinition2D sizes = SizeDefinition2D.parse(startSize, incSize);
            if (sizes == null) {
                throw new StyleException("Invalid sizes in VariableMarker style definition.");
            }
            ((VariableMarkerStyleModel)this.bean).setSizes(sizes);
        }
        catch (Exception e) {
            throw new StyleException("Invalid VariableMarker style definition.");
        }
    }

    public VariableMarkerStyle(BucketSeries bkts, StyleMarker baseMarker, int startSize, int increment) {
        this.bean = new VariableMarkerStyleModel(bkts);
        this.baseMarker = baseMarker;
        ((VariableMarkerStyleModel)this.bean).setStartSize(startSize);
        ((VariableMarkerStyleModel)this.bean).setIncrement(increment);
        this.reset();
    }

    @Override
    public Object clone() {
        VariableMarkerStyle sty = (VariableMarkerStyle)super.clone();
        sty.setModel((StyleModel)this.bean.clone());
        return sty;
    }

    @Override
    public StyleModel getModel() {
        return this.bean;
    }

    @Override
    public void setModel(StyleModel model) {
        if (!(model instanceof VariableMarkerStyleModel)) {
            throw new IllegalArgumentException("Not a VariableMarkerStyleModel instance.");
        }
        this.bean = (VariableMarkerStyleModel)model;
    }

    public String getBaseMarkerName() {
        return ((VariableMarkerStyleModel)this.bean).getBaseMarkerName();
    }

    public void setBaseMarkerName(String marker) {
        ((VariableMarkerStyleModel)this.bean).setBaseMarkerName(marker);
    }

    public StyleMarker getBaseMakerStyle() {
        return this.baseMarker;
    }

    public void setBaseMarkerStyle(StyleMarker marker) {
        this.baseMarker = marker;
    }

    @Override
    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void reset() {
        double size = ((VariableMarkerStyleModel)this.bean).getDoubleStartSize();
        BucketSeries buckets = this.bean.getBucketSeries();
        for (int i = 0; i < buckets.size(); ++i) {
            Bucket sb = buckets.getBucket(i);
            if (sb.getRenderStyle() != null || sb.getRenderStyleName() != null) {
                log.finest("using user specified style.");
                continue;
            }
            StyleMarker sm = (StyleMarker)this.baseMarker.clone();
            sm.setDesiredWidth(size);
            sm.setDesiredHeight(size);
            sm.setDesiredUnit(((VariableMarkerStyleModel)this.bean).getSizesUnit());
            sb.setRenderStyle(sm);
            size += ((VariableMarkerStyleModel)this.bean).getDoubleIncrement();
        }
    }

    @Override
    public boolean refreshResolvedStyles(StyleCache sc, Hashtable dynaStyles) {
        this.baseMarker = null;
        super.refreshResolvedStyles(sc, dynaStyles);
        return true;
    }

    @Override
    public boolean resolveStyles(StyleCache sc, Hashtable dynaStyles) {
        String baseMarkerName;
        String defaultStyleName = this.bean.getBucketSeries().getDefaultRenderStyleName();
        Style defaultStyle = (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        if (defaultStyleName != null && defaultStyle == null) {
            defaultStyle = Util.getStyle(defaultStyleName, sc, dynaStyles);
            this.bean.getBucketSeries().setDefaultRenderStyle(defaultStyle);
        }
        if (defaultStyle != null && !(defaultStyle instanceof AdvancedStyle)) {
            defaultStyle.resolveStyles(sc, dynaStyles);
        }
        if ((baseMarkerName = ((VariableMarkerStyleModel)this.bean).getBaseMarkerName()) == null || this.baseMarker != null) {
            return true;
        }
        this.baseMarker = (StyleMarker)Util.getStyle(baseMarkerName, sc, dynaStyles);
        if (this.baseMarker != null) {
            this.reset();
            return true;
        }
        return false;
    }

    @Override
    public int getMaxLegendWidth(Graphics2D g, int fontSize) {
        return super.getMaxLegendWidth(g, fontSize);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, float x, float y, StyleModifiers stymods) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply VariableMarkerStyle to a point without attribute.");
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Rectangle2D rect, StyleModifiers stymods) throws StyleNotApplicableException {
        double w = rect.getWidth();
        double h = rect.getHeight();
        BucketSeries buckets = this.bean.getBucketSeries();
        int nBuckets = buckets.size();
        try {
            int widest = ((StyleMarker)buckets.getBucket(nBuckets - 1).getRenderStyle()).getDesiredWidth();
            int narrowest = ((StyleMarker)buckets.getBucket(0).getRenderStyle()).getDesiredWidth();
            if (stymods != null && stymods instanceof AdvancedStyleModifiers) {
                StyleModifiers smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.getBaseMarkerName().toUpperCase() + "_" + (nBuckets - 1));
                if (smods != null && smods instanceof MarkerStyleModifiers) {
                    widest = ((MarkerStyleModifiers)smods).getWidth();
                }
                if ((smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.getBaseMarkerName().toUpperCase() + "_0")) != null && smods instanceof MarkerStyleModifiers) {
                    narrowest = ((MarkerStyleModifiers)smods).getWidth();
                }
            }
            widest = Math.max(widest, narrowest);
            double sx = rect.getMinX();
            double sy = rect.getMinY() + 2.0;
            Rectangle2D.Float sr = new Rectangle2D.Float();
            for (int i = 0; i < nBuckets; ++i) {
                StyleModifiers smods = null;
                Bucket bucket = buckets.getBucket(i);
                StyleMarker sty = (StyleMarker)bucket.getRenderStyle();
                int styleW = sty.getDesiredWidth();
                int styleH = sty.getDesiredHeight();
                if (stymods != null && stymods instanceof AdvancedStyleModifiers && (smods = ((AdvancedStyleModifiers)stymods).getStyleModifiers(this.getBaseMarkerName().toUpperCase() + "_" + i)) != null && smods instanceof MarkerStyleModifiers) {
                    styleW = ((MarkerStyleModifiers)smods).getWidth();
                    styleH = ((MarkerStyleModifiers)smods).getHeight();
                }
                double x = sx + (double)(widest - styleW) / 2.0;
                ((Rectangle2D)sr).setRect(x, sy, w, styleH);
                this.drawBucketWithLabel(g, bucket, sr, (float)((double)styleW / w), 0.0f, smods);
                sy += (double)(styleH + 2);
            }
        }
        catch (Exception e) {
            g.drawString(" * bad style *", 10, 10);
        }
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, StyleModifiers stymods) throws StyleNotApplicableException {
        if (!(shp instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("VariableMarkerStyle not applicable without an attr value.");
        }
        this.apply(null, g, (Rectangle2D)shp, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, StyleModifiers stymods) throws StyleNotApplicableException {
        super.apply(vc, g, shp, gtype, label, labelPoint, cr, values, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, StyleModifiers stymods) throws StyleNotApplicableException {
        super.apply(vc, g, shp, gtype, label, labelPoint, cr, values, styleColumns, stymods);
    }

    @Override
    public void apply(VisContext vc, Graphics2D g, Shape shp, int gtype, String label, Point2D labelPoint, ConflictResolver cr, Field[] values, String[] styleColumns, Style subStyle, String[] substyleColumns, String changeProperty, StyleModifiers stymods) throws StyleNotApplicableException {
        super.apply(vc, g, shp, gtype, label, labelPoint, cr, values, styleColumns, subStyle, substyleColumns, changeProperty, stymods);
    }

    @Override
    public Object getPropertyValue(String propertyType) {
        return null;
    }
}

