/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JavaDBStyleStore;
import oracle.sdovis.MapTable;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.TileLayerTable;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Base64InputStream;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;

public class MMImport {
    static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String delim = "|";
    static String ESC = "&#124;";
    static String DS_NAME = "MMImport_temp_ds";
    static String outputReport = null;

    public static void main(String[] args) throws Exception {
        log.setLevel(Level.FINEST);
        if (args.length != 6 && args.length != 7) {
            System.out.println("Usage: java MMImport <metadata> <host> <sid> <port> <user> <password>\n       or\n       java MMImport <metadata> <host> <sid> <port> <user> <password> <overwrite>\n\n       <metadata>: metadata file name\n       <host>: host name\n       <sid>: database SID name\n       <port>: listener port number\n       <user>: user name\n       <password>: password\n       <overwrite>: replace existing metadata (true or false)");
            System.exit(1);
        }
        System.out.println("connecting to " + args[1] + "...");
        DSManager.registerOracleJdbcDS(DS_NAME, args[1], args[3], args[2], args[4], args[5], "thin", 3);
        System.out.println("connected.");
        MMImport.importAll(args);
        DSManager.remove(DS_NAME);
    }

    public static void importAll(String[] args) throws IOException {
        byte[] content = Util.readFile(args[0]);
        String s = new String(content);
        int idx = s.indexOf("--------STYLES BEGIN--------");
        int idx2 = s.indexOf("--------STYLES END--------");
        String styles = idx >= 0 && idx2 > 0 ? s.substring(idx + 28, idx2) : null;
        idx = s.indexOf("--------THEMES BEGIN--------");
        idx2 = s.indexOf("--------THEMES END--------");
        String themes = idx >= 0 && idx2 > 0 ? s.substring(idx + 28, idx2) : null;
        idx = s.indexOf("--------MAPS BEGIN--------");
        idx2 = s.indexOf("--------MAPS END--------");
        String maps = idx >= 0 && idx2 > 0 ? s.substring(idx + 26, idx2) : null;
        idx = s.indexOf("--------TILELAYERS BEGIN--------");
        idx2 = s.indexOf("--------TILELAYERS END--------");
        String tilelayers = idx >= 0 && idx2 > 0 ? s.substring(idx + 32, idx2) : null;
        boolean overwrite = false;
        if (args.length == 7 && args[6].equalsIgnoreCase("true")) {
            overwrite = true;
        }
        if (styles != null) {
            MMImport.importStyles(styles, overwrite);
        }
        if (themes != null) {
            MMImport.importThemes(themes, overwrite);
        }
        if (maps != null) {
            MMImport.importMaps(maps, overwrite);
        }
        if (tilelayers != null) {
            MMImport.importTileLayers(tilelayers, overwrite);
        }
        log.info("import of map metadata done. ");
    }

    public static boolean importMetadata(String dataSource, String fileName, boolean styles, boolean themes, boolean basemaps, boolean tilelayers, boolean overwrite) throws IOException {
        String tilelayer;
        if (dataSource == null || fileName == null) {
            return false;
        }
        if (DSManager.get(dataSource) == null) {
            return false;
        }
        DS_NAME = dataSource;
        byte[] content = Util.readFile(fileName);
        String s = new String(content);
        int idx = s.indexOf("--------STYLES BEGIN--------");
        int idx2 = s.indexOf("--------STYLES END--------");
        String style = styles && idx >= 0 && idx2 > 0 ? s.substring(idx + 28, idx2) : null;
        idx = s.indexOf("--------THEMES BEGIN--------");
        idx2 = s.indexOf("--------THEMES END--------");
        String theme = themes && idx >= 0 && idx2 > 0 ? s.substring(idx + 28, idx2) : null;
        idx = s.indexOf("--------MAPS BEGIN--------");
        idx2 = s.indexOf("--------MAPS END--------");
        String map = basemaps && idx >= 0 && idx2 > 0 ? s.substring(idx + 26, idx2) : null;
        idx = s.indexOf("--------TILELAYERS BEGIN--------");
        idx2 = s.indexOf("--------TILELAYERS END--------");
        String string = tilelayer = tilelayers && idx >= 0 && idx2 > 0 ? s.substring(idx + 32, idx2) : null;
        if (style != null) {
            MMImport.importStyles(style, overwrite);
        }
        if (theme != null) {
            MMImport.importThemes(theme, overwrite);
        }
        if (map != null) {
            MMImport.importMaps(map, overwrite);
        }
        if (tilelayer != null) {
            MMImport.importTileLayers(tilelayer, overwrite);
        }
        log.info("import of map metadata done. ");
        return true;
    }

    public static void importStyles(String str, boolean overwrite) throws IOException {
        log.info("importing styles...");
        if (outputReport != null) {
            outputReport = outputReport + "\n\nImporting styles...";
        }
        String dbType = DSManager.getDataSourceType(DS_NAME);
        DBTable st = null;
        st = dbType == null || dbType.equalsIgnoreCase("ORACLE") ? new StyleTable(DS_NAME, "USER_SDO_STYLES") : new JavaDBStyleStore(DS_NAME);
        ArrayList<String> existingStyles = null;
        existingStyles = MMImport.getMetadataNames("USER_SDO_STYLES");
        int n = 0;
        int count = 0;
        StringTokenizer stk = new StringTokenizer(str, delim);
        while (stk.hasMoreTokens()) {
            try {
                block19: {
                    String name = stk.nextToken().trim();
                    String type = stk.nextToken().trim();
                    String description = MMImport.descape(stk.nextToken().trim());
                    if (description.equals("null")) {
                        description = null;
                    }
                    String definition = MMImport.descape(stk.nextToken().trim());
                    String imageb64 = stk.nextToken().trim();
                    if (type == null || type.equalsIgnoreCase("null")) {
                        log.info("Null type for style " + name + ". Style ignored");
                        if (outputReport == null) continue;
                        outputReport = outputReport + "\nNull type for style " + name + ". Style ignored";
                        continue;
                    }
                    byte[] imageData = null;
                    if (!imageb64.equals("null")) {
                        byte[] big;
                        byte[] img64 = imageb64.getBytes();
                        Base64InputStream in = new Base64InputStream(new ByteArrayInputStream(img64));
                        int size = in.read(big = new byte[img64.length]);
                        if (size <= 0) continue;
                        imageData = new byte[size];
                        System.arraycopy(big, 0, imageData, 0, size);
                    }
                    log.finest("Importing style " + name + " of type " + type + " ...");
                    if (st instanceof StyleTable) {
                        ((StyleTable)st).setName(name);
                        ((StyleTable)st).setType(type);
                        ((StyleTable)st).setDescription(description);
                        ((StyleTable)st).setDefinition(new StringBuffer(definition));
                        ((StyleTable)st).setImage(imageData);
                    } else {
                        ((JavaDBStyleStore)st).setName(name);
                        ((JavaDBStyleStore)st).setType(type);
                        ((JavaDBStyleStore)st).setDescription(description);
                        ((JavaDBStyleStore)st).setDefinition(new StringBuffer(definition));
                        ((JavaDBStyleStore)st).setImage(imageData);
                    }
                    try {
                        if (overwrite && existingStyles != null && existingStyles.contains(name)) {
                            st.delete();
                            if (st instanceof StyleTable) {
                                ((StyleTable)st).setName(name);
                                ((StyleTable)st).setType(type);
                                ((StyleTable)st).setDescription(description);
                                ((StyleTable)st).setDefinition(new StringBuffer(definition));
                                ((StyleTable)st).setImage(imageData);
                            } else {
                                ((JavaDBStyleStore)st).setName(name);
                                ((JavaDBStyleStore)st).setType(type);
                                ((JavaDBStyleStore)st).setDescription(description);
                                ((JavaDBStyleStore)st).setDefinition(new StringBuffer(definition));
                                ((JavaDBStyleStore)st).setImage(imageData);
                            }
                        } else if (!overwrite && existingStyles != null && existingStyles.contains(name)) {
                            log.finest("Style " + name + " already exists. Ignored.");
                            if (outputReport != null) {
                                outputReport = outputReport + "\nStyle " + name + " already exists. Ignored.";
                            }
                            ++count;
                            continue;
                        }
                        st.insert();
                        ++n;
                        log.finest("Style " + name + ": success.");
                        if (outputReport != null) {
                            outputReport = outputReport + "\nStyle " + name + ": success.";
                        }
                    }
                    catch (SQLException ex) {
                        log.finest("Style " + name + ": failed - " + ex.getMessage());
                        if (outputReport == null) break block19;
                        outputReport = outputReport + "\nStyle " + name + ": failed - " + ex.getMessage();
                    }
                }
                ++count;
            }
            catch (NoSuchElementException ex) {
                // empty catch block
                break;
            }
        }
        log.info("# Styles processed: " + count);
        log.info("# Styles imported: " + n);
        if (outputReport != null) {
            outputReport = outputReport + "\n# Styles processed: " + count;
            outputReport = outputReport + "\n# Styles imported: " + n;
        }
    }

    public static void importThemes(String str, boolean overwrite) {
        log.info("importing themes...");
        if (outputReport != null) {
            outputReport = outputReport + "\n\nImporting themes...";
        }
        int n = 0;
        int count = 0;
        StringTokenizer stk = new StringTokenizer(str, delim);
        ThemeTable tt = new ThemeTable(DS_NAME, "user_sdo_themes");
        ArrayList<String> existingThemes = null;
        existingThemes = MMImport.getMetadataNames("user_sdo_themes");
        while (stk.hasMoreTokens()) {
            try {
                block13: {
                    String name = stk.nextToken().trim();
                    String description = MMImport.descape(stk.nextToken().trim());
                    if (description.equals("null")) {
                        description = null;
                    }
                    String baseTable = stk.nextToken().trim();
                    String geomColumn = stk.nextToken().trim();
                    String srules = MMImport.descape(stk.nextToken().trim());
                    tt.setName(name);
                    tt.setDescription(description);
                    tt.setBaseTable(baseTable);
                    tt.setSpatialColumn(geomColumn);
                    tt.setStylingRules(srules);
                    log.finest("Importing theme: " + name + " ...");
                    try {
                        if (overwrite && existingThemes != null && existingThemes.contains(name)) {
                            tt.delete();
                            tt.setName(name);
                            tt.setDescription(description);
                            tt.setBaseTable(baseTable);
                            tt.setSpatialColumn(geomColumn);
                            tt.setStylingRules(srules);
                        } else if (!overwrite && existingThemes != null && existingThemes.contains(name)) {
                            log.finest("Theme " + name + " already exists. Ignored.");
                            if (outputReport != null) {
                                outputReport = outputReport + "\nTheme " + name + " already exists. Ignored.";
                            }
                            ++count;
                            continue;
                        }
                        tt.insert();
                        ++n;
                        log.finest("Theme " + name + ": success.");
                        if (outputReport != null) {
                            outputReport = outputReport + "\nTheme " + name + ": success.";
                        }
                    }
                    catch (SQLException ex) {
                        log.finest("Theme " + name + ": failed - " + ex.getMessage());
                        if (outputReport == null) break block13;
                        outputReport = outputReport + "\nTheme " + name + ": failed - " + ex.getMessage();
                    }
                }
                ++count;
            }
            catch (NoSuchElementException ex) {
                // empty catch block
                break;
            }
        }
        log.info("# Themes processed: " + count);
        log.info("# of Themes imported: " + n);
        if (outputReport != null) {
            outputReport = outputReport + "\n# Themes processed: " + count;
            outputReport = outputReport + "\n# Themes imported: " + n;
        }
    }

    public static void importMaps(String str, boolean overwrite) {
        log.info("importing base maps...");
        if (outputReport != null) {
            outputReport = outputReport + "\n\nImporting base maps...";
        }
        int n = 0;
        int count = 0;
        MapTable mt = new MapTable(DS_NAME, "user_sdo_maps");
        ArrayList<String> existingMaps = null;
        existingMaps = MMImport.getMetadataNames("user_sdo_maps");
        StringTokenizer stk = new StringTokenizer(str, delim);
        while (stk.hasMoreTokens()) {
            try {
                block13: {
                    String name = stk.nextToken().trim();
                    String description = stk.nextToken().trim();
                    if (description.equals("null")) {
                        description = null;
                    }
                    String def = stk.nextToken().trim();
                    log.finest("Importing base map: " + name + " ...");
                    mt.setName(name);
                    mt.setDescription(description);
                    mt.setMapDefinition(def);
                    try {
                        if (overwrite && existingMaps != null && existingMaps.contains(name)) {
                            mt.delete();
                            mt.setName(name);
                            mt.setDescription(description);
                            mt.setMapDefinition(def);
                        } else if (!overwrite && existingMaps != null && existingMaps.contains(name)) {
                            log.finest("Base map " + name + " already exists. Ignored.");
                            if (outputReport != null) {
                                outputReport = outputReport + "\nBase map " + name + " already exists. Ignored.";
                            }
                            ++count;
                            continue;
                        }
                        mt.insert();
                        ++n;
                        log.finest("Base map " + name + ": success.");
                        if (outputReport != null) {
                            outputReport = outputReport + "\nBase map " + name + ": success.";
                        }
                    }
                    catch (SQLException ex) {
                        log.finest("Base map " + name + ": failed - " + ex.getMessage());
                        if (outputReport == null) break block13;
                        outputReport = outputReport + "\nBase map " + name + ": failed - " + ex.getMessage();
                    }
                }
                ++count;
            }
            catch (NoSuchElementException ex) {
                // empty catch block
                break;
            }
        }
        log.info("# Base maps processed: " + count);
        log.info("# of Base maps imported: " + n);
        if (outputReport != null) {
            outputReport = outputReport + "\n# Base maps processed: " + count;
            outputReport = outputReport + "\n# Base maps imported: " + n;
        }
    }

    public static void importTileLayers(String str, boolean overwrite) throws IOException {
        log.info("importing tile layers...");
        if (outputReport != null) {
            outputReport = outputReport + "\n\nImporting tile layers...";
        }
        TileLayerTable st = new TileLayerTable(DS_NAME, "USER_SDO_CACHED_MAPS");
        ArrayList<String> existingTlayers = null;
        existingTlayers = MMImport.getMetadataNames("USER_SDO_CACHED_MAPS");
        int n = 0;
        int count = 0;
        StringTokenizer stk = new StringTokenizer(str, delim);
        while (stk.hasMoreTokens()) {
            try {
                block15: {
                    String tilesTable;
                    String name = stk.nextToken().trim();
                    String description = MMImport.descape(stk.nextToken().trim());
                    if (description.equals("null")) {
                        description = null;
                    }
                    if ((tilesTable = stk.nextToken().trim()).equals("null")) {
                        tilesTable = null;
                    }
                    String isOnline = stk.nextToken().trim();
                    String isInternal = stk.nextToken().trim();
                    String definition = MMImport.descape(stk.nextToken().trim());
                    String baseMap = stk.nextToken().trim();
                    String imageb64 = stk.nextToken().trim();
                    byte[] mapAdapter = null;
                    if (!imageb64.equals("null")) {
                        byte[] big;
                        byte[] img64 = imageb64.getBytes();
                        Base64InputStream in = new Base64InputStream(new ByteArrayInputStream(img64));
                        int size = in.read(big = new byte[img64.length]);
                        if (size <= 0) continue;
                        mapAdapter = new byte[size];
                        System.arraycopy(big, 0, mapAdapter, 0, size);
                    }
                    log.finest("Importing tile layer " + name + " ...");
                    st.setName(name);
                    st.setDescription(description);
                    st.setTilesTable(tilesTable);
                    st.setIsOnline(isOnline);
                    st.setIsInternal(isInternal);
                    st.setDefinition(new StringBuffer(definition));
                    st.setBaseMap(baseMap);
                    st.setMapAdapter(mapAdapter);
                    try {
                        if (overwrite && existingTlayers != null && existingTlayers.contains(name)) {
                            st.delete();
                            st.setName(name);
                            st.setDescription(description);
                            st.setTilesTable(tilesTable);
                            st.setIsOnline(isOnline);
                            st.setIsInternal(isInternal);
                            st.setDefinition(new StringBuffer(definition));
                            st.setBaseMap(baseMap);
                            st.setMapAdapter(mapAdapter);
                        } else if (!overwrite && existingTlayers != null && existingTlayers.contains(name)) {
                            log.finest("Tile layer " + name + " already exists. Ignored.");
                            if (outputReport != null) {
                                outputReport = outputReport + "\nTile layer " + name + " already exists. Ignored.";
                            }
                            ++count;
                            continue;
                        }
                        st.insert();
                        ++n;
                        log.finest("Tile layer " + name + ": success.");
                        if (outputReport != null) {
                            outputReport = outputReport + "\nTile layer " + name + ": success.";
                        }
                    }
                    catch (SQLException ex) {
                        log.finest("Tile layer " + name + ": failed - " + ex.getMessage());
                        if (outputReport == null) break block15;
                        outputReport = outputReport + "\nTile layer" + name + ": failed - " + ex.getMessage();
                    }
                }
                ++count;
            }
            catch (NoSuchElementException ex) {
                // empty catch block
                break;
            }
        }
        log.info("# Tile layers processed: " + count);
        log.info("# Tile layers imported: " + n);
        if (outputReport != null) {
            outputReport = outputReport + "\n# Tile layers processed: " + count;
            outputReport = outputReport + "\n# Tile layers imported: " + n;
        }
    }

    private static String descape(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("&#124;", "\\|");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getMetadataNames(String metadataTable) {
        if (metadataTable == null) {
            return null;
        }
        ArrayList<String> metaNames = new ArrayList<String>();
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        String querystr = null;
        try {
            AbstractDBDataSource adb = (AbstractDBDataSource)DSManager.get(DS_NAME);
            conn = adb.getConnection();
            querystr = "select name from " + metadataTable + " order by name";
            st = conn.prepareStatement(querystr);
            rs = st.executeQuery();
            while (rs.next()) {
                metaNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            metaNames = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception re) {}
            }
        }
        if (metaNames == null || metaNames.size() == 0) {
            return null;
        }
        return metaNames;
    }

    public static void setOutputReport(boolean report) {
        outputReport = report ? "" : null;
    }

    public static void resetOutputReport() {
        if (outputReport != null) {
            outputReport = "";
        }
    }

    public static String getOutputReport() {
        return outputReport;
    }
}

