/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.xml;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomParseProblem;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.model.message.XmlModelMessageLog;
import oracle.bali.xml.validator.ValidationException;
import oracle.ide.Context;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.status.Severity;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionResource;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.xml.XmlModelAdapter;
import oracle.jdevimpl.audit.util.Strings;
import oracle.jdevimpl.audit.xml.XmlAuditHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlErrorAnalyzer
extends Analyzer {
    @ExtensionResource(value="oracle.ide.xml.wellformedness-error")
    private Rule WELLFORMEDNESS_ERROR;
    @ExtensionResource(value="oracle.ide.xml.wellformedness-warning")
    private Rule WELLFORMEDNESS_WARNING;
    @ExtensionResource(value="oracle.ide.xml.validation-error")
    private Rule VALIDATION_ERROR;
    @ExtensionResource(value="oracle.ide.xml.validation-incomplete")
    private Rule VALIDATION_INCOMPLETE;
    @ExtensionResource(value="oracle.ide.xml.validation-warning")
    private Rule VALIDATION_WARNING;
    @ExtensionResource(value="oracle.ide.xml.validation-advisory")
    private Rule VALIDATION_ADVISORY;
    @ExtensionResource(value="oracle.ide.xml.other-error")
    private Rule OTHER_ERROR;
    @ExtensionResource(value="oracle.ide.xml.other-warning")
    private Rule OTHER_WARNING;
    @ExtensionResource(value="oracle.ide.xml.other-suggestion")
    private Rule OTHER_ADVISORY;
    @ExtensionResource(value="oracle.ide.xml.attribute-missing-error")
    private Rule ATTRIBUTE_MISSING_ERROR;
    @ExtensionResource(value="oracle.ide.xml.attribute-missing-warning")
    private Rule ATTRIBUTE_MISSING_WARNING;
    @ExtensionResource(value="oracle.ide.xml.attribute-missing-incomplete")
    private Rule ATTRIBUTE_MISSING_INCOMPLETE;
    @ExtensionResource(value="oracle.ide.xml.attribute-duplicated")
    private Rule ATTRIBUTE_DUPLICATED;
    @ExtensionResource(value="oracle.ide.xml.attribute-value-missing")
    private Rule ATTRIBUTE_VALUE_MISSING;
    @ExtensionResource(value="oracle.ide.xml.mismatched-end-tag")
    private Rule MISMATCHED_END_TAG;
    private static final Log LOG = new Log(new String[]{"errors", "status-xml"});

    public boolean isApplicationContentSupported() {
        return true;
    }

    public void enter(AuditContext context, Document document) {
        XmlModelAdapter modelAdapter = (XmlModelAdapter)context.getModel();
        int maxOffset = modelAdapter.getTextBuffer().getLength();
        XmlModel model = modelAdapter.getXmlModel();
        try {
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            XmlModelMessageLog log = model.getXmlModelInternalMessageLog();
            LOG.trace("processing {0} messages from message log", log.size());
            for (XmlModelMessage message : log) {
                try {
                    Map parameters;
                    String localName;
                    Object name;
                    Rule rule;
                    String type = message.getMessageType();
                    Object cause = message.getCause();
                    if (type == "XML-ATTRIBUTE-MISSING") {
                        rule = message.getSeverity() == Severity.ERROR ? this.ATTRIBUTE_MISSING_ERROR : this.ATTRIBUTE_MISSING_INCOMPLETE;
                        name = cause instanceof ValidationException ? (QualifiedName)((ValidationException)cause).getRelatedObject() : null;
                    } else if (type == "XML-WARNING-ATTRIBUTE-MISSING") {
                        XmlKey baseKey = model.getNodeXmlKey(message.getRelatedNode());
                        if (cause instanceof ValidationException) {
                            name = (QualifiedName)((ValidationException)cause).getRelatedObject();
                            XmlKey key = DerivedXmlKey.createAttributeKey((GrammarResolver)model.getContext().getGrammarResolver(), (XmlKey)baseKey, (QualifiedName)name);
                            if (!resolver.isWarnIfNotSpecified(key)) {
                                continue;
                            }
                        } else {
                            name = null;
                        }
                        rule = this.ATTRIBUTE_MISSING_WARNING;
                    } else {
                        if (type.equals("XML-20124") && this.processAttributes(context, message) || type.equals("XML-20122") && this.processAttributes(context, message) || type.equals("XML-20125") && this.processAttributes(context, message)) continue;
                        if (MessageCategory.PARSING.equals(message.getCategory())) {
                            rule = message.isError() ? (type.equals("end-tag-mismatch") ? this.MISMATCHED_END_TAG : this.WELLFORMEDNESS_ERROR) : (message.isAtLeastWarning() ? this.WELLFORMEDNESS_WARNING : this.OTHER_ADVISORY);
                            name = null;
                        } else if (MessageCategory.GRAMMAR_VALIDITY.equals(message.getCategory())) {
                            Object object;
                            rule = message.getSeverity() == Severity.INCOMPLETE ? this.VALIDATION_INCOMPLETE : (message.isError() ? this.VALIDATION_ERROR : (message.isAtLeastWarning() ? this.VALIDATION_WARNING : this.VALIDATION_ADVISORY));
                            name = cause instanceof ValidationException ? ((object = ((ValidationException)cause).getRelatedObject()) instanceof QualifiedName ? (QualifiedName)object : null) : null;
                        } else {
                            rule = message.isError() ? this.OTHER_ERROR : (message.isAtLeastWarning() ? this.OTHER_WARNING : this.OTHER_ADVISORY);
                            name = null;
                        }
                    }
                    int start = Math.min(message.getTextStartOffset(), maxOffset);
                    int length = Math.min(message.getTextEndOffset(), maxOffset) - start;
                    Location location = context.getModel().getLocation(start, length);
                    Node node = message.getRelatedNode();
                    if (name == null && node != null && (localName = node.getLocalName()) != null) {
                        name = QualifiedName.getQualifiedName((String)node.getNamespaceURI(), (String)localName);
                    }
                    LOG.trace("processing message {0} as {1} at {2} ({3})", (Object)message, (Object)rule, (Object)node, (Object)location);
                    IssueReport report = node != null ? context.report(rule, (Object)node) : context.report(rule, location);
                    report.addParameter("longMessage", (Object)message.getLongDescription());
                    report.addParameter("shortMessage", (Object)message.getShortDescription());
                    report.addParameter("subissue", (Object)type);
                    if (name != null) {
                        report.addParameter("name", name);
                    }
                    if ((parameters = cause instanceof DomParseProblem ? ((DomParseProblem)cause).getParameters() : (cause instanceof ValidationException ? ((ValidationException)cause).getParameters() : null)) == null) continue;
                    for (Map.Entry entry : parameters.entrySet()) {
                        String key = (String)entry.getKey();
                        if ("name".equals(key) && name != null) continue;
                        report.addParameter(key, entry.getValue());
                    }
                }
                catch (Exception e) {
                    int start = message.getTextStartOffset();
                    int length = message.getTextEndOffset() - start;
                    Location location = context.getModel().getLocation(start, length);
                    AuditLogger.error((Throwable)e, (String)"exception processing XML issue {0}{1}{2}", (Object[])new Object[]{message, Strings.LINE_SEPARATOR, location.getModel().contextDescription(location)});
                }
            }
        }
        catch (ExpiredTextBufferException e) {
            this.cancel();
            throw e;
        }
        catch (CancellationException e) {
            this.cancel();
            throw e;
        }
        catch (OutOfMemoryError e) {
            this.cancel();
            throw e;
        }
        catch (Throwable e) {
            AuditLogger.log((Throwable)e, (String)"XML", null, (String)"XML", (Object[])new Object[]{model, null});
            IssueReport report = context.report(this.OTHER_ERROR);
            report.addParameter("longMessage", (Object)("INTERNAL: XML document parsing or validation failed: " + e));
        }
    }

    private boolean processAttributes(AuditContext context, XmlModelMessage message) {
        int reportCount = 0;
        XmlModelAdapter model = (XmlModelAdapter)context.getModel();
        XMLSourceNode node = (XMLSourceNode)model.getNode();
        Context ideContext = context.getIdeContext();
        DocumentScannerFactory scannerFactory = node.getDocumentScannerFactory(ideContext, null);
        Map<QualifiedName, MultiMap<String, AttributeLocator>> names = XmlAuditHelper.getAttributeDeclarations(scannerFactory, model.getTextBuffer(), message.getOffset());
        for (Map.Entry<QualifiedName, MultiMap<String, AttributeLocator>> namesEntry : names.entrySet()) {
            QualifiedName name = namesEntry.getKey();
            MultiMap<String, AttributeLocator> values = namesEntry.getValue();
            Collection nullLocators = values.get(null);
            if (values.valuesSize() > 1) {
                String[] valuesArray = values.keySet().toArray(new String[0]);
                if (nullLocators != null) {
                    for (int i = 0; i < valuesArray.length; ++i) {
                        if (valuesArray[i] != null) continue;
                        valuesArray[i] = "";
                        break;
                    }
                }
                for (Map.Entry valuesEntry : values.entrySet()) {
                    String value = (String)valuesEntry.getKey();
                    if (value == null) {
                        value = "";
                    }
                    Collection locators = (Collection)valuesEntry.getValue();
                    for (AttributeLocator locator : locators) {
                        int offset = locator.getStartOffset();
                        Location location = model.getLocation(offset, locator.getEndOffset() - offset);
                        IssueReport report = context.report(this.ATTRIBUTE_DUPLICATED, location);
                        report.addParameter("name", (Object)name);
                        report.addParameter("value", (Object)value);
                        report.addParameter("values", (Object)valuesArray);
                        ++reportCount;
                    }
                }
                continue;
            }
            if (nullLocators == null) continue;
            for (AttributeLocator locator : nullLocators) {
                int offset = locator.getStartOffset();
                Location location = model.getLocation(offset, locator.getEndOffset() - offset);
                IssueReport report = context.report(this.ATTRIBUTE_VALUE_MISSING, location);
                report.addParameter("name", (Object)name);
                ++reportCount;
            }
        }
        return reportCount > 0;
    }
}

