/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.timing;

import javax.inject.Inject;
import oracle.dbtools.common.timing.Lifetime;
import oracle.dbtools.common.timing.LifetimeImpl;
import oracle.dbtools.common.timing.Lifetimes;
import oracle.dbtools.common.timing.TimingClock;
import oracle.dbtools.common.util.TimeDuration;
import oracle.dbtools.plugin.api.conf.Configuration;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class LifetimesProvider
implements Lifetimes {
    private final TimingClock clock;
    private final Configuration conf;

    @Inject
    LifetimesProvider(TimingClock clock, Configuration conf) {
        this.clock = clock;
        this.conf = conf;
    }

    @Override
    public Lifetime lifetime(String propName, TimeDuration defaultDuration) {
        TimeDuration duration = this.duration(propName, defaultDuration);
        return this.lifetime(duration);
    }

    @Override
    public Lifetime lifetime(TimeDuration duration) {
        return new LifetimeImpl(this.clock, duration);
    }

    private TimeDuration duration(String propName, TimeDuration defaultDuration) {
        String text = this.conf.get(propName);
        if (text == null) {
            return defaultDuration;
        }
        return TimeDuration.parse(text);
    }
}

