/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import jakarta.json.JsonException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.json.common.DocumentCodec;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.IndexSpecification;
import oracle.json.parser.JsonPath;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.util.ByteArray;
import oracle.json.util.JsonByteArray;
import oracle.soda.OracleCollection;
import oracle.soda.OracleCollectionAdmin;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.OracleOperationBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentFragmentImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.OracleOperationBuilderImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonParser;

public abstract class OracleCollectionImpl
implements OracleCollection {
    protected static final Logger log = Logger.getLogger(OracleCollectionImpl.class.getName());
    static ArrayList<OracleDocument> EMPTY_LIST = new ArrayList();
    static byte[] EMPTY_DATA = new byte[0];
    private static final int ORA_SQL_DATAGUIDE_NOT_EXISTS = 40582;
    protected final String collectionName;
    protected final OracleConnection conn;
    protected final OracleDatabaseImpl db;
    protected final MetricsCollector metrics;
    protected final CollectionDescriptor options;
    private OracleCollectionAdministrationImpl admin;
    private static final int ORA_SQL_OBJECT_EXISTS = 955;
    private static final int ORA_SQL_OBJECT_NOT_EXISTS = 942;
    private static final int ORA_SQL_INDEX_NOT_EXISTS = 1418;
    protected StringBuilder sb = new StringBuilder(1000);
    protected boolean internalDriver = false;
    public boolean oracleDriver = false;
    public boolean useCallableReturns = false;
    private SODAUtils.SQLSyntaxLevel sqlSyntaxLevel = SODAUtils.SQLSyntaxLevel.SQL_SYNTAX_UNKNOWN;
    boolean avoidTxnManagement = false;
    private DocumentCodec osonCodec = null;
    private String[] dockeySteps = null;
    private static final String GET_INDEX_INFO = "begin\n  DBMS_SODA_ADMIN.LIST_INDEXES(?, NULL, ?);\nend;\n";

    OracleCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        this(oracleDatabaseImpl, string, CollectionDescriptor.createDefault(string));
    }

    OracleCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        this.db = oracleDatabaseImpl;
        this.collectionName = string;
        this.options = collectionDescriptor;
        this.metrics = oracleDatabaseImpl.getMetrics();
        this.conn = oracleDatabaseImpl.getConnection();
        this.setAvoid();
    }

    void checkJDBCVersion() throws OracleException {
        boolean bl = this.options.hasBinaryFormat();
        boolean bl2 = this.options.hasJsonType();
        if (bl || bl2) {
            try {
                DatabaseMetaData databaseMetaData = this.conn.getMetaData();
                int n = databaseMetaData.getDriverMajorVersion();
                int n2 = databaseMetaData.getDriverMinorVersion();
                if (bl && (n < 19 || n == 19 && n2 < 7)) {
                    throw SODAUtils.makeException(SODAMessage.EX_JDBC_JAR_HAS_NO_OSON_SUPPORT, new Object[0]);
                }
                if (bl2 && n < 21) {
                    throw SODAUtils.makeException(SODAMessage.EX_JDBC_JAR_HAS_NO_JSON_TYPE_SUPPORT, new Object[0]);
                }
            }
            catch (SQLException sQLException) {
                throw new OracleException(sQLException);
            }
        }
    }

    public void setAvoid() {
        if (System.getProperty("oracle.jserver.version") != null) {
            this.internalDriver = true;
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Avoid returning clauses for internal connections");
            }
        }
        if (this.db.hasOracleConnection()) {
            this.oracleDriver = true;
        } else {
            this.useCallableReturns = true;
        }
    }

    void setAvoidTxnManagement(boolean bl) {
        this.avoidTxnManagement = bl;
    }

    private String getName() {
        return this.collectionName;
    }

    protected boolean isReadOnly() {
        return !this.options.writable;
    }

    public boolean usesObjectIdKeys() {
        return this.options.keyAssignmentMethod == 6;
    }

    private boolean isHeterogeneous() {
        return this.options.doctypeColumnName != null && this.options.contentDataType == 4;
    }

    public boolean isDualityViewBased() {
        return this.options.isDualityView();
    }

    private String getDBObjectName() {
        return this.options.dbObjectName;
    }

    private String getDBObjectSchemaName() {
        return this.options.dbSchema;
    }

    public boolean hasClientAssignedKeys() {
        return this.options.keyAssignmentMethod == 1;
    }

    protected boolean hasDocumentFieldKey() {
        return this.options.keyAssignmentMethod == 6;
    }

    protected boolean hasExtrinsicServerKey() {
        return !this.hasDocumentFieldKey() && !this.hasClientAssignedKeys();
    }

    public boolean isBinary() {
        return this.options.contentDataType == 4 || this.options.contentDataType == 2;
    }

    public boolean payloadBasedVersioning() {
        return this.options.versioningMethod == 5 || this.options.versioningMethod == 4 || this.options.versioningMethod == 0;
    }

    boolean matches(CollectionDescriptor collectionDescriptor) {
        return this.options.matches(collectionDescriptor);
    }

    private void drop() throws OracleException {
        this.db.dropCollection(this.collectionName);
    }

    private void drop(boolean bl, boolean bl2) throws OracleException {
        this.db.dropCollection(this.collectionName, bl, bl2);
    }

    void writeCheck(String string) throws OracleException {
        if (this.isReadOnly()) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning("Write to " + this.options.uriName + " not allowed");
            }
            throw SODAUtils.makeException(SODAMessage.EX_READ_ONLY, this.options.uriName, string);
        }
    }

    protected String computeVersion(byte[] byArray) throws OracleException {
        if (byArray == null) {
            byArray = EMPTY_DATA;
        }
        String string = null;
        this.metrics.startTiming();
        switch (this.options.versioningMethod) {
            case 5: {
                try {
                    byte[] byArray2 = this.db.hasher.MD5(byArray);
                    if (byArray2 == null) {
                        OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_MD5_NOT_SUPPORTED, new Object[0]);
                        if (OracleLog.isLoggingEnabled()) {
                            log.warning(oracleException.getMessage());
                        }
                        throw oracleException;
                    }
                    string = ByteArray.rawToHex(byArray2);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_MD5_NOT_SUPPORTED, noSuchAlgorithmException, new Object[0]);
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(oracleException.getMessage());
                    }
                    throw oracleException;
                }
            }
            case 4: {
                try {
                    byte[] byArray3 = this.db.hasher.SHA256(byArray);
                    if (byArray3 == null) {
                        OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_SHA256_NOT_SUPPORTED, new Object[0]);
                        if (OracleLog.isLoggingEnabled()) {
                            log.warning(oracleException.getMessage());
                        }
                        throw oracleException;
                    }
                    string = ByteArray.rawToHex(byArray3);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_SHA256_NOT_SUPPORTED, noSuchAlgorithmException, new Object[0]);
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(oracleException.getMessage());
                    }
                    throw oracleException;
                }
            }
        }
        this.metrics.recordChecksum();
        return string;
    }

    protected String uidToDecimal(String string) {
        byte[] byArray = ByteArray.hexToRaw(string);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = new BigDecimal(256L);
        for (int i = 0; i < byArray.length; ++i) {
            bigDecimal = bigDecimal.multiply(bigDecimal2).add(new BigDecimal(byArray[i] & 0xFF));
        }
        return bigDecimal.toPlainString();
    }

    private boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if ("0123456789".indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    private String zeroStrip(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        for (n = 0; n < n2 && string.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return string;
        }
        if (n == n2) {
            return "0";
        }
        return string.substring(n);
    }

    protected String canonicalKey(String string) throws OracleException {
        if (this.options.keyDataType == 3) {
            if (!this.isInteger(string = this.zeroStrip(string))) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyDataType());
            }
        } else if (this.options.keyAssignmentMethod == 3 || this.options.keyAssignmentMethod == 2) {
            int n;
            int n2 = string.length();
            if (n2 < (n = 32)) {
                String string2 = "00000000000000000000000000000000";
                string = string2.substring(0, n - n2) + string;
            } else if (n2 > n) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyAssignmentMethod());
            }
            if (!ByteArray.isHex(string)) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyAssignmentMethod());
            }
        } else if (this.options.keyDataType == 4) {
            if (!ByteArray.isHex(string)) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyDataType());
            }
        } else if (!(this.options.keyAssignmentMethod != 4 && this.options.keyAssignmentMethod != 5 || this.isInteger(string = this.zeroStrip(string)))) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, "INTEGER");
        }
        return string;
    }

    DocumentCodec getCodec() {
        if (this.osonCodec == null) {
            this.osonCodec = this.db.getCodecFactory().getCodec();
        }
        return this.osonCodec;
    }

    protected byte[] convertToBinary(byte[] byArray) throws OracleException {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length != 0) {
            DocumentCodec documentCodec = this.getCodec();
            try {
                documentCodec.loadUnicode(byArray);
                byArray2 = documentCodec.getImage();
            }
            catch (RuntimeException runtimeException) {
                throw SODAUtils.makeException(SODAMessage.EX_TO_BINARY_CONVERSION_ERROR, runtimeException, new Object[0]);
            }
        }
        return byArray2;
    }

    private BigDecimal readJsonStringAsNumber(String string) throws OracleException {
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw SODAUtils.makeException(SODAMessage.EX_STRING_NOT_A_NUMBER, string);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractKey(byte[] var1_1) throws OracleException {
        var2_2 = null;
        var3_3 = new OracleJsonFactory();
        var4_4 = new ByteArrayInputStream(var1_1);
        var5_5 = var3_3.createJsonTextParser((InputStream)var4_4);
        var6_6 = 0;
        var7_7 = false;
        while (true) {
            if (!var5_5.hasNext()) {
                var5_5.close();
                return var2_2;
            }
            var8_8 = var5_5.next();
            if (!var7_7) {
                if (var8_8 != OracleJsonParser.Event.START_OBJECT) {
                    throw SODAUtils.makeException(SODAMessage.EX_EJSON_MUST_BE_AN_OBJECT, new Object[0]);
                }
                var7_7 = true;
            }
            if (var8_8 == OracleJsonParser.Event.START_OBJECT || var8_8 == OracleJsonParser.Event.START_ARRAY) {
                ++var6_6;
            } else if (var8_8 == OracleJsonParser.Event.END_OBJECT || var8_8 == OracleJsonParser.Event.END_ARRAY) {
                --var6_6;
            }
            if (var8_8 == OracleJsonParser.Event.KEY_NAME && var5_5.getString().equals("_id")) {
                var8_8 = var5_5.next();
                if (var8_8 == OracleJsonParser.Event.START_OBJECT) {
                    var8_8 = var5_5.next();
                    if (var8_8 != OracleJsonParser.Event.KEY_NAME) {
                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_FOR_ID, new Object[0]);
                    }
                    var10_10 = var9_9 = var5_5.getString();
                    var11_12 = -1;
                    switch (var10_10.hashCode()) {
                        case 764843556: {
                            if (!var10_10.equals("$numberDecimal")) break;
                            var11_12 = 0;
                            break;
                        }
                        case -658150263: {
                            if (!var10_10.equals("$numberLong")) break;
                            var11_12 = 1;
                            break;
                        }
                        case -1129612222: {
                            if (!var10_10.equals("$numberInt")) break;
                            var11_12 = 2;
                            break;
                        }
                        case -1351036258: {
                            if (!var10_10.equals("$numberDouble")) break;
                            var11_12 = 3;
                            break;
                        }
                        case 1066548719: {
                            if (!var10_10.equals("$numberFloat")) break;
                            var11_12 = 4;
                            break;
                        }
                        case 1182502: {
                            if (!var10_10.equals("$oid")) break;
                            var11_12 = 5;
                            break;
                        }
                    }
                    block15 : switch (var11_12) {
                        case 0: {
                            var8_8 = var5_5.next();
                            switch (1.$SwitchMap$oracle$sql$json$OracleJsonParser$Event[var8_8.ordinal()]) {
                                case 1: {
                                    try {
                                        var12_13 = var3_3.createDecimal(this.readJsonStringAsNumber(var5_5.getString()));
                                        var2_2 = DocumentCodec.bigDecimalToKey(var12_13.bigDecimalValue());
                                        break block15;
                                    }
                                    catch (Exception var12_14) {
                                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDecimal"});
                                    }
                                }
                                case 2: 
                                case 3: 
                                case 4: {
                                    var2_2 = DocumentCodec.bigDecimalToKey(var3_3.createDecimal(var5_5.getBigDecimal()).bigDecimalValue());
                                    break block15;
                                }
                            }
                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDecimal"});
                        }
                        case 1: {
                            var8_8 = var5_5.next();
                            if (var8_8 == OracleJsonParser.Event.VALUE_DECIMAL && var5_5.isIntegralNumber()) {
                                var12_15 = var5_5.getBigInteger();
                                try {
                                    var2_2 = DocumentCodec.bigDecimalToKey(var3_3.createDecimal(var12_15.longValueExact()).bigDecimalValue());
                                    break;
                                }
                                catch (Exception var13_26) {
                                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberLong"});
                                }
                            }
                            if (var8_8 != OracleJsonParser.Event.VALUE_STRING) {
                                throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberLong"});
                            }
                            try {
                                var12_16 = this.readJsonStringAsNumber(var5_5.getString());
                                var2_2 = DocumentCodec.bigDecimalToKey(var3_3.createDecimal(var12_16.longValueExact()).bigDecimalValue());
                                break;
                            }
                            catch (Exception var12_17) {
                                throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberLong"});
                            }
                        }
                        case 2: {
                            var8_8 = var5_5.next();
                            if (var8_8 == OracleJsonParser.Event.VALUE_DECIMAL && var5_5.isIntegralNumber()) {
                                var12_18 = var5_5.getBigInteger();
                                try {
                                    var2_2 = DocumentCodec.bigDecimalToKey(var3_3.createDecimal(var12_18.intValueExact()).bigDecimalValue());
                                    break;
                                }
                                catch (Exception var13_27) {
                                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberInt"});
                                }
                            }
                            if (var8_8 != OracleJsonParser.Event.VALUE_STRING) {
                                throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberInt"});
                            }
                            try {
                                var12_19 = this.readJsonStringAsNumber(var5_5.getString());
                                var2_2 = DocumentCodec.bigDecimalToKey(var3_3.createDecimal(var12_19.intValueExact()).bigDecimalValue());
                                break;
                            }
                            catch (Exception var12_20) {
                                throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberInt"});
                            }
                        }
                        case 3: {
                            var8_8 = var5_5.next();
                            switch (1.$SwitchMap$oracle$sql$json$OracleJsonParser$Event[var8_8.ordinal()]) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    var12_21 = var3_3.createDouble(var5_5.getDouble()).doubleValue();
                                    if (!Double.isInfinite(var12_21) && !Double.isNaN(var12_21)) {
                                        var14_28 = BigDecimal.valueOf(var12_21);
                                        if (var14_28.stripTrailingZeros().scale() > 0) {
                                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDouble"});
                                        }
                                        var2_2 = var14_28.toBigInteger().toString();
                                        break block15;
                                    }
                                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDouble"});
                                }
                                case 1: {
                                    try {
                                        var12_22 = var3_3.createDouble(Double.parseDouble(var5_5.getString())).doubleValue();
                                    }
                                    catch (Exception var14_29) {
                                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDouble"});
                                    }
                                    if (!Double.isInfinite(var12_22) && !Double.isNaN(var12_22)) {
                                        var14_30 = BigDecimal.valueOf(var12_22);
                                        if (var14_30.stripTrailingZeros().scale() > 0) {
                                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDouble"});
                                        }
                                        var2_2 = var14_30.toBigInteger().toString();
                                        break block15;
                                    }
                                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDouble"});
                                }
                            }
                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberDouble"});
                        }
                        case 4: {
                            var8_8 = var5_5.next();
                            switch (1.$SwitchMap$oracle$sql$json$OracleJsonParser$Event[var8_8.ordinal()]) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    var14_31 = var3_3.createFloat(var5_5.getFloat()).floatValue();
                                    if (!Float.isInfinite(var14_31) && !Float.isNaN(var14_31)) {
                                        var15_33 = BigDecimal.valueOf(var14_31);
                                        if (var15_33.stripTrailingZeros().scale() > 0) {
                                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberFloat"});
                                        }
                                        var2_2 = var15_33.toBigInteger().toString();
                                        break block15;
                                    }
                                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberFloat"});
                                }
                                case 1: {
                                    try {
                                        var14_32 = var3_3.createFloat(Float.parseFloat(var5_5.getString())).floatValue();
                                        if (!Float.isInfinite(var14_32) && !Float.isNaN(var14_32)) {
                                            var15_33 = BigDecimal.valueOf(var14_32);
                                            if (var15_33.stripTrailingZeros().scale() > 0) break block15;
                                            ** break;
                                        }
                                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberFloat"});
lbl149:
                                        // 1 sources

                                        var2_2 = var15_33.toBigInteger().toString();
                                        break block15;
                                    }
                                    catch (Exception var15_34) {
                                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberFloat"});
                                    }
                                }
                                default: {
                                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$numberFloat"});
                                }
                            }
                        }
                        case 5: {
                            var8_8 = var5_5.next();
                            if (var8_8 != OracleJsonParser.Event.VALUE_STRING) {
                                throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$oid"});
                            }
                            var15_33 = var5_5.getString();
                            if (ByteArray.isHex((String)var15_33) && var15_33.length() == 24) {
                                var16_35 = new OracleJsonBinaryImpl(ByteArray.hexToRaw((String)var15_33), true);
                                var2_2 = var16_35.getString();
                                break;
                            }
                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_VALUE, new Object[]{"$oid"});
                        }
                        default: {
                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_KEY, new Object[]{var5_5.getString()});
                        }
                    }
                    if (var5_5.hasNext() && (var8_8 = var5_5.next()) != OracleJsonParser.Event.END_OBJECT) {
                        if (var8_8 == OracleJsonParser.Event.KEY_NAME) {
                            throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_KEY, new Object[]{var5_5.getString()});
                        }
                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_FOR_ID, new Object[0]);
                    }
                } else {
                    if (var8_8 != OracleJsonParser.Event.VALUE_STRING && var8_8 != OracleJsonParser.Event.VALUE_DOUBLE && var8_8 != OracleJsonParser.Event.VALUE_FLOAT && var8_8 != OracleJsonParser.Event.VALUE_DECIMAL && var8_8 != OracleJsonParser.Event.VALUE_BINARY) {
                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_FOR_ID, new Object[0]);
                    }
                    var9_9 = var5_5.getValue();
                    switch (1.$SwitchMap$oracle$sql$json$OracleJsonValue$OracleJsonType[var9_9.getOracleJsonType().ordinal()]) {
                        case 1: {
                            var2_2 = var9_9.asJsonString().getString();
                            break;
                        }
                        case 2: {
                            var10_11 = var9_9.asJsonDouble().doubleValue();
                            if (Double.isInfinite(var10_11) || Double.isNaN(var10_11) || (var12_23 = BigDecimal.valueOf(var10_11)).stripTrailingZeros().scale() > 0) break;
                            var2_2 = var12_23.toBigInteger().toString();
                            break;
                        }
                        case 3: {
                            var12_24 = var9_9.asJsonFloat().floatValue();
                            if (Float.isInfinite(var12_24) || Float.isNaN(var12_24) || (var13_25 = BigDecimal.valueOf(var12_24)).stripTrailingZeros().scale() > 0) break;
                            var2_2 = var13_25.toBigInteger().toString();
                            break;
                        }
                        case 4: {
                            return DocumentCodec.bigDecimalToKey(var9_9.asJsonDecimal().bigDecimalValue());
                        }
                        case 5: {
                            var13_25 = var9_9.asJsonBinary();
                            if (!var13_25.isId()) break;
                            var2_2 = var13_25.getString();
                            break;
                        }
                    }
                    if (var2_2 == null) {
                        throw SODAUtils.makeException(SODAMessage.EX_INVALID_EJSON_FOR_ID, new Object[0]);
                    }
                }
            }
            if (var6_6 != 0) continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getDocumentKey(OracleDocument oracleDocument, boolean bl, boolean bl2) throws OracleException {
        Object object;
        byte[] byArray = null;
        if (oracleDocument == null) {
            return null;
        }
        String string = oracleDocument.getKey();
        if (this.hasExtrinsicServerKey()) {
            return string;
        }
        if (this.options.keyAssignmentMethod == 1) {
            return string;
        }
        if (this.options.keyAssignmentMethod != 6 || this.options.keyAssignmentMethod == 6 && bl2) {
            string = null;
        }
        if (OracleDocumentImpl.isBinary(oracleDocument) && bl2) {
            throw SODAUtils.makeException(SODAMessage.EX_EJSON_CANNOT_BE_USED_WITH_BINARY_DOC, new Object[0]);
        }
        if (this.options.keyAssignmentMethod == 6 && bl2) {
            if (!OracleDatabaseImpl.isOracleJsonAvailable()) {
                throw SODAUtils.makeException(SODAMessage.EX_JDBC_196_REQUIRED, new Object[0]);
            }
            string = this.extractKey(oracleDocument.getContentAsByteArray());
        }
        if (string != null) {
            try {
                string = this.canonicalKey(string);
            }
            catch (OracleException oracleException) {
                string = null;
            }
        }
        if (this.options.keyAssignmentMethod == 6 && string != null) {
            return string;
        }
        if (this.dockeySteps == null) {
            if (this.options.keyColumnPath == null) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_PATH, "<null>");
            }
            try {
                object = new PathParser(this.options.keyColumnPath);
                this.dockeySteps = ((PathParser)object).splitSteps(false);
            }
            catch (QueryException queryException) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_PATH, this.options.keyColumnPath);
            }
        }
        object = this.getCodec();
        ((DocumentCodec)object).setKeyPath(this.dockeySteps);
        if (string == null) {
            if (this.options.keyAssignmentMethod == 6 && !bl2) {
                if (OracleDocumentImpl.isBinary(oracleDocument)) {
                    OracleDocumentImpl oracleDocumentImpl = (OracleDocumentImpl)oracleDocument;
                    byte[] byArray2 = oracleDocumentImpl.getBinaryContentAsByteArray();
                    try {
                        ((DocumentCodec)object).loadImage(byArray2);
                        ((DocumentCodec)object).setValidation(false);
                        string = ((DocumentCodec)object).getKey(true);
                    }
                    catch (JsonException jsonException) {
                        throw SODAUtils.makeException(SODAMessage.EX_PATH_EXTRACT_FAILED, jsonException, this.options.keyColumnPath);
                    }
                }
                byArray = oracleDocument.getContentAsByteArray();
                try {
                    ((DocumentCodec)object).loadUnicode(byArray);
                    ((DocumentCodec)object).setValidation(false);
                    string = ((DocumentCodec)object).getKey(true);
                }
                catch (JsonException jsonException) {
                    throw SODAUtils.makeException(SODAMessage.EX_PATH_EXTRACT_FAILED, jsonException, this.options.keyColumnPath);
                }
            }
            if (string != null) {
                return this.canonicalKey(string);
            }
        }
        if (bl && string == null && this.options.keyAssignmentMethod == 6) {
            string = this.db.nextObjectId();
        }
        if (string == null || this.options.keyAssignmentMethod != 6) return string;
        boolean bl3 = true;
        boolean bl4 = true;
        if (OracleDocumentImpl.isBinary(oracleDocument)) {
            OracleDocumentImpl oracleDocumentImpl = (OracleDocumentImpl)oracleDocument;
            byte[] byArray3 = oracleDocumentImpl.getBinaryContentAsByteArray();
            try {
                ((DocumentCodec)object).loadImage(byArray3);
                ((DocumentCodec)object).setNewKey(string, bl3, bl4);
                ((DocumentCodec)object).setRemoveKey(true);
                byte[] byArray4 = ((DocumentCodec)object).getImage();
                if (byArray4 == null) return string;
                oracleDocumentImpl.setContent(byArray4);
                return string;
            }
            catch (JsonException jsonException) {
                throw SODAUtils.makeException(SODAMessage.EX_PATH_INSERT_FAILED, jsonException, this.options.keyColumnPath);
            }
        }
        if (byArray == null) {
            byArray = oracleDocument.getContentAsByteArray();
        }
        try {
            ((DocumentCodec)object).loadUnicode(byArray);
            ((DocumentCodec)object).setNewKey(string, bl3, bl4);
            ((DocumentCodec)object).setRemoveKey(true);
            OracleDocumentImpl oracleDocumentImpl = (OracleDocumentImpl)oracleDocument;
            if ((this.options.hasBinaryFormat() || this.options.hasJsonType()) && !bl2) {
                byte[] byArray5 = ((DocumentCodec)object).getImage();
                if (byArray5 == null) return string;
                oracleDocumentImpl.setContent(byArray5);
                oracleDocumentImpl.setBinary();
                return string;
            } else {
                String string2;
                if (bl2) {
                    ((DocumentCodec)object).generateEJSONId(true);
                }
                if ((string2 = ((DocumentCodec)object).getString()) == null) return string;
                oracleDocumentImpl.setContent(string2);
            }
            return string;
        }
        catch (JsonException jsonException) {
            throw SODAUtils.makeException(SODAMessage.EX_PATH_INSERT_FAILED, jsonException, this.options.keyColumnPath);
        }
    }

    static String stringFromBytes(byte[] byArray, boolean bl) throws OracleException {
        if (byArray == null) {
            return "";
        }
        if (byArray.length == 0) {
            return "";
        }
        Charset charset = JsonByteArray.getJsonCharset(byArray);
        if (!bl) {
            return new String(byArray, charset);
        }
        try {
            return ByteArray.bytesToString(byArray, charset);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new OracleException(characterCodingException);
        }
    }

    static String stringFromBytes(byte[] byArray) throws OracleException {
        return OracleCollectionImpl.stringFromBytes(byArray, false);
    }

    @Override
    public OracleDocument findOne(String string) throws OracleException {
        return this.find().key(string).getOne();
    }

    public abstract OracleDocumentFragmentImpl findFragment(String var1, long var2, int var4) throws OracleException;

    @Override
    public OracleOperationBuilder find() {
        return new OracleOperationBuilderImpl(this, (Connection)this.conn);
    }

    private void truncate() throws OracleException {
        this.writeCheck("truncate");
        if (this.options.dbObjectType != 0) {
            throw SODAUtils.makeException(SODAMessage.EX_TRUNCATE_NOT_SUPP, this.options.uriName);
        }
        this.sb.setLength(0);
        this.sb.append("truncate table \"");
        this.sb.append(this.options.dbObjectName);
        this.sb.append("\"");
        String string = this.sb.toString();
        PreparedStatement preparedStatement = null;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Truncated collection " + this.collectionName);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    public String toString() {
        return this.options.toString();
    }

    @Override
    public OracleCollectionAdmin admin() {
        if (this.admin == null) {
            this.admin = new OracleCollectionAdministrationImpl();
        }
        return this.admin;
    }

    public CollectionDescriptor getOptions() {
        return this.options;
    }

    MetricsCollector getMetrics() {
        return this.metrics;
    }

    OracleDatabaseImpl getDatabase() {
        return this.db;
    }

    void appendTable(StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        if (this.options.dbSchema != null) {
            stringBuilder.append(this.options.dbSchema);
            stringBuilder.append("\".\"");
        }
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    public String getInputFormatClause() {
        if (this.options.hasBinaryFormat()) {
            return "format oson";
        }
        if (this.options.contentDataType == 4 || this.options.contentDataType == 2) {
            return "format json";
        }
        return null;
    }

    private String buildSpatialIndexDDL(String string, JsonQueryPath jsonQueryPath, boolean bl, boolean bl2) {
        this.sb.setLength(0);
        this.sb.append("create index ");
        this.appendSanitizedName(this.sb, string);
        this.sb.append(" on ");
        this.appendTable(this.sb);
        this.sb.append(" (JSON_VALUE(\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\", '");
        jsonQueryPath.toSingletonString(this.sb);
        this.sb.append("' returning SDO_GEOMETRY");
        if (!bl2) {
            if (bl) {
                this.sb.append(" ERROR ON ERROR))");
            } else {
                this.sb.append(" ERROR ON ERROR NULL ON EMPTY))");
            }
        } else {
            this.sb.append("))");
        }
        this.sb.append(" indextype is MDSYS.SPATIAL_INDEX");
        this.sb.append(" parallel 8");
        return this.sb.toString();
    }

    private String buildCTXIndexDDL(String string, String string2, boolean bl) throws OracleException {
        if (!bl) {
            this.sb.setLength(0);
            this.sb.append("create index ");
            this.appendSanitizedName(this.sb, string);
            this.sb.append(" on ");
            this.appendTable(this.sb);
            this.sb.append(" (\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\") ");
            this.sb.append("indextype is CTXSYS.CONTEXT");
            this.sb.append(" parameters('section group CTXSYS.JSON_SECTION_GROUP sync (on commit)");
            this.sb.append("')");
        } else {
            String string3 = null;
            try {
                string3 = IndexSpecification.get121Lexer(string2);
            }
            catch (QueryException queryException) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_CREATE, queryException, new Object[0]);
            }
            this.sb.setLength(0);
            this.sb.append("create index ");
            this.appendSanitizedName(this.sb, string);
            this.sb.append(" on ");
            this.appendTable(this.sb);
            this.sb.append(" (\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\") ");
            this.sb.append("indextype is CTXSYS.CONTEXT");
            this.sb.append(" parameters('");
            this.sb.append("section group CTXSYS.JSON_SECTION_GROUP");
            if (string3 != null) {
                this.sb.append(" lexer ");
                this.sb.append(string3);
            }
            this.sb.append(" stoplist CTXSYS.EMPTY_STOPLIST");
            this.sb.append(" sync (on commit)");
            this.sb.append(" memory 100M");
            this.sb.append("')");
            this.sb.append(" parallel 8");
        }
        return this.sb.toString();
    }

    private String buildDGIndexDDL(String string, String string2, String string3, String string4) throws OracleException {
        this.sb.setLength(0);
        if (string3 == null) {
            string3 = "text_value";
        }
        if (string4 == null) {
            string4 = "on";
        }
        String string5 = null;
        try {
            if (string2 != null) {
                string5 = IndexSpecification.getLexer(string2);
            }
        }
        catch (QueryException queryException) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_CREATE, queryException, new Object[0]);
        }
        this.sb.append("create search index ");
        this.appendSanitizedName(this.sb, string);
        this.sb.append(" on ");
        this.appendTable(this.sb);
        this.sb.append(" (\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\") ");
        this.sb.append("for json");
        this.sb.append(" parameters('");
        this.sb.append("sync (on commit)");
        this.sb.append(" search_on ");
        this.sb.append(string3.toLowerCase());
        this.sb.append(" dataguide ");
        this.sb.append(string4.toLowerCase());
        if (string5 != null) {
            this.sb.append(" language ");
            this.sb.append(string5);
        }
        this.sb.append("')");
        return this.sb.toString();
    }

    private String dropIndexDDL(String string, boolean bl) {
        this.sb.setLength(0);
        this.sb.append("drop index ");
        this.appendSanitizedName(this.sb, string);
        if (bl) {
            this.sb.append(" force");
        }
        return this.sb.toString();
    }

    private String buildIndexDDL(String string, boolean bl, boolean bl2, boolean bl3, JsonPath[] jsonPathArray, boolean bl4) throws OracleException {
        this.sb.setLength(0);
        this.sb.append("create ");
        if (bl) {
            this.sb.append("unique ");
        }
        this.sb.append("index ");
        this.appendSanitizedName(this.sb, string);
        this.sb.append(" on ");
        this.appendTable(this.sb);
        this.sb.append(" (");
        boolean bl5 = true;
        int n = 0;
        int n2 = 0;
        for (JsonPath jsonPath : jsonPathArray) {
            String string2 = null;
            int n3 = 0;
            int n4 = 0;
            String string3 = null;
            if (jsonPath instanceof IndexColumn) {
                string2 = ((IndexColumn)jsonPath).getSqlTypeName();
                n3 = ((IndexColumn)jsonPath).getSqlType();
                n4 = ((IndexColumn)jsonPath).getMaxLength();
                string3 = ((IndexColumn)jsonPath).getOrder();
            }
            String[] stringArray = jsonPath.getSteps();
            if (bl5) {
                bl5 = false;
            } else {
                this.sb.append(", ");
            }
            boolean bl6 = false;
            if (string2 != null) {
                bl6 = true;
            }
            this.sb.append("JSON_VALUE(\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\"");
            String string4 = this.getInputFormatClause();
            if (string4 != null) {
                this.sb.append(" ").append(string4);
            }
            this.sb.append(",'");
            JsonQueryPath jsonQueryPath = new JsonQueryPath(stringArray);
            jsonQueryPath.toSingletonString(this.sb);
            if (jsonQueryPath.hasArraySteps()) {
                throw SODAUtils.makeException(SODAMessage.EX_ARRAY_STEPS_IN_PATH, new Object[0]);
            }
            this.sb.append("'");
            if (bl6) {
                this.sb.append(" returning ");
                this.sb.append(string2);
                if (n3 == 1) {
                    if (n + 1 > 16) {
                        throw SODAUtils.makeException(SODAMessage.EX_TOO_MANY_COLUMNS, Integer.toString(n));
                    }
                    if (n4 > 0) {
                        this.sb.append("(");
                        this.sb.append(n4);
                        this.sb.append(")");
                        n2 += n4;
                    } else {
                        this.sb.append("(\uffff)");
                        ++n;
                    }
                }
            }
            if (!bl3) {
                if (bl2) {
                    this.sb.append(" ERROR ON ERROR");
                } else {
                    this.sb.append(" ERROR ON ERROR NULL ON EMPTY");
                }
            }
            this.sb.append(") ");
            if (string3 == null) continue;
            this.sb.append(string3);
        }
        if (bl4) {
            this.sb.append(",1)");
        } else {
            this.sb.append(")");
        }
        Object object = this.sb.toString();
        if (n > 0) {
            int n5 = 0;
            if (n2 < 2000) {
                n5 = (2000 - n2) / n;
            }
            if (n5 < 255) {
                n5 = 255;
            }
            if ((n2 += n5 * n2) > 4000 && OracleLog.isLoggingEnabled()) {
                log.warning("Total size of index " + string + " is " + n2);
            }
            object = ((String)object).replaceAll("\uffff", Integer.toString(n5));
        }
        return object;
    }

    private void checkAllowedTextIndexContentAndKeyTypes() throws OracleException {
        if (this.options.contentDataType == 3 || this.options.contentDataType == 6) {
            throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_INDEX_CREATE, this.options.getContentDataType());
        }
        if (this.options.contentLobEncrypt != 0) {
            throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_ENCRYPTED_INDEX_CREATE, new Object[0]);
        }
        if (this.options.keyDataType == 2) {
            throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_INDEX_CREATE2, new Object[0]);
        }
    }

    private void appendSanitizedName(StringBuilder stringBuilder, String string) {
        stringBuilder.append("\"");
        stringBuilder.append(CollectionDescriptor.stringToIdentifier(string));
        stringBuilder.append("\"");
    }

    private void createIndex(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, JsonPath[] jsonPathArray, JsonQueryPath jsonQueryPath, String string2, String string3, String string4, boolean bl5) throws OracleException {
        PreparedStatement preparedStatement = null;
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexName");
        }
        String string5 = null;
        if (jsonQueryPath != null) {
            if (this.isHeterogeneous()) {
                throw SODAUtils.makeException(SODAMessage.EX_NO_SPATIAL_INDEX_ON_HETERO_COLLECTIONS, new Object[0]);
            }
            if (jsonQueryPath.hasArraySteps()) {
                throw SODAUtils.makeException(SODAMessage.EX_ARRAY_STEPS_IN_PATH, new Object[0]);
            }
            string5 = this.buildSpatialIndexDDL(string, jsonQueryPath, bl2, bl3);
        } else if (jsonPathArray == null || jsonPathArray.length == 0) {
            this.checkAllowedTextIndexContentAndKeyTypes();
            if (this.isHeterogeneous()) {
                throw SODAUtils.makeException(SODAMessage.EX_NO_TEXT_INDEX_ON_HETERO_COLLECTIONS, new Object[0]);
            }
            this.sqlSyntaxLevel = SODAUtils.getSQLSyntaxLevel((Connection)this.conn, this.sqlSyntaxLevel);
            if (SODAUtils.sqlSyntaxBelow_12_2(this.sqlSyntaxLevel)) {
                if (string3 != null) {
                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_PARAM_121_INDEX, "search_on");
                }
                if (string4 != null) {
                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_PARAM_121_INDEX, "dataguide");
                }
                if (string2 != null && !bl5) {
                    throw SODAUtils.makeException(SODAMessage.EX_INVALID_PARAM_121_INDEX, "language");
                }
            }
            if (bl5 && !SODAUtils.sqlSyntaxBelow_12_2(this.sqlSyntaxLevel)) {
                throw SODAUtils.makeException(SODAMessage.EX_TEXT_INDEX_WITH_LANG_NOT_SUPPORTED, new Object[0]);
            }
            string5 = bl5 || SODAUtils.sqlSyntaxBelow_12_2(this.sqlSyntaxLevel) ? this.buildCTXIndexDDL(string, string2, bl5) : this.buildDGIndexDDL(string, string2, string3, string4);
        } else {
            if (this.isHeterogeneous()) {
                throw SODAUtils.makeException(SODAMessage.EX_NO_FUNC_INDEX_ON_HETERO_COLLECTIONS, new Object[0]);
            }
            this.sqlSyntaxLevel = SODAUtils.getSQLSyntaxLevel((Connection)this.conn, this.sqlSyntaxLevel);
            if (SODAUtils.sqlSyntaxBelow_12_2(this.sqlSyntaxLevel) && !bl2 && !bl3) {
                throw SODAUtils.makeException(SODAMessage.EX_NULL_ON_EMPTY_NOT_SUPPORTED, new Object[0]);
            }
            string5 = this.buildIndexDDL(string, bl, bl2, bl3, jsonPathArray, bl4);
        }
        try {
            this.metrics.startTiming();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Index DDL: " + string5);
            }
            preparedStatement = this.conn.prepareStatement(string5);
            preparedStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Created index " + string);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString() + "\n" + string5);
                }
                if (sQLException.getErrorCode() == 955) {
                    throw SODAUtils.makeException(SODAMessage.EX_INDEX_ALREADY_EXISTS, string);
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string5);
            }
            catch (Throwable throwable) {
                for (String string6 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string6);
                }
                throw throwable;
            }
        }
        for (String string7 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(String string, boolean bl) throws OracleException {
        PreparedStatement preparedStatement = null;
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexName");
        }
        String string2 = this.dropIndexDDL(string, bl);
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            preparedStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Dropped index " + string);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                int n = sQLException.getErrorCode();
                if (n == 942 || n == 1418) {
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(sQLException.toString());
                    }
                } else {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString() + "\n" + string2);
                    }
                    throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
                }
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
            for (String string4 : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        for (String string5 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
    }

    public void dropIndex(OracleDocument oracleDocument) throws OracleException {
        String string = null;
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexSpecification");
        }
        IndexSpecification indexSpecification = new IndexSpecification(this.db.getJsonFactoryProvider(), ((OracleDocumentImpl)oracleDocument).getContentAsStream());
        try {
            string = indexSpecification.parse();
        }
        catch (QueryException queryException) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning(queryException.toString());
            }
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_DROP, queryException, new Object[0]);
        }
        this.dropIndex(string, indexSpecification.force());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleDocument getDataGuide() throws OracleException {
        OracleDocumentImpl oracleDocumentImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select DBMS_JSON.GET_INDEX_DATAGUIDE(?,?,?,?) from SYS.DUAL";
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            Object object = this.options.dbObjectName;
            if (!((String)object).matches("^[_#$A-Z][_#$A-Z\\d]*$")) {
                object = "\"" + (String)object + "\"";
            }
            preparedStatement.setString(1, (String)object);
            object = this.options.contentColumnName;
            if (!((String)object).matches("^[_#$A-Z][_#$A-Z\\d]*$")) {
                object = "\"" + (String)object + "\"";
            }
            preparedStatement.setString(2, (String)object);
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 0);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Clob object2 = resultSet.getClob(1);
                String string2 = object2.getSubString(1L, (int)object2.length());
                oracleDocumentImpl = new OracleDocumentImpl(string2);
                object2.free();
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                int n = sQLException.getErrorCode();
                if (n != 40582) {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
                }
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
            for (String string4 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        for (String string4 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return oracleDocumentImpl;
    }

    public List<OracleDocument> listIndexes() throws OracleException {
        CallableStatement callableStatement = null;
        String string = GET_INDEX_INFO;
        ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
        try {
            String[] object;
            this.metrics.startTiming();
            callableStatement = this.conn.prepareCall(string);
            callableStatement.setNString(1, this.options.uriName);
            callableStatement.registerOutParameter(2, 2003, "XDB.DBMS_SODA_ADMIN.VCNTAB");
            callableStatement.execute();
            Array array = callableStatement.getArray(2);
            for (String string2 : object = (String[])array.getArray()) {
                arrayList.add(new OracleDocumentImpl(string2));
            }
            callableStatement.close();
            callableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(callableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
        }
        for (String string4 : SODAUtils.closeCursor(callableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return arrayList;
    }

    private class OracleCollectionAdministrationImpl
    implements OracleCollectionAdmin {
        private OracleCollectionAdministrationImpl() {
        }

        @Override
        public String getName() {
            return OracleCollectionImpl.this.getName();
        }

        @Override
        public void drop() throws OracleException {
            OracleCollectionImpl.this.drop();
        }

        @Override
        public void drop(boolean bl, boolean bl2) throws OracleException {
            OracleCollectionImpl.this.drop(bl, bl2);
        }

        @Override
        public void truncate() throws OracleException {
            OracleCollectionImpl.this.truncate();
        }

        @Override
        public boolean isHeterogeneous() {
            return OracleCollectionImpl.this.isHeterogeneous();
        }

        @Override
        public String getDBObjectName() {
            return OracleCollectionImpl.this.getDBObjectName();
        }

        @Override
        public String getDBObjectSchemaName() {
            return OracleCollectionImpl.this.getDBObjectSchemaName();
        }

        @Override
        public boolean isReadOnly() {
            return OracleCollectionImpl.this.isReadOnly();
        }

        public boolean usesObjectIdKeys() {
            return OracleCollectionImpl.this.usesObjectIdKeys();
        }

        @Override
        public OracleDocument getMetadata() {
            OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl(OracleCollectionImpl.this.options.getDescription());
            return oracleDocumentImpl;
        }

        @Override
        public OracleDocument getDataGuide() throws OracleException {
            OracleDocument oracleDocument = OracleCollectionImpl.this.getDataGuide();
            return oracleDocument;
        }

        @Override
        public void createJsonSearchIndex(String string) throws OracleException {
            OracleCollectionImpl.this.createIndex(string, false, false, false, false, null, null, null, null, null, false);
        }

        @Override
        public void createIndex(OracleDocument oracleDocument) throws OracleException {
            String string = null;
            if (oracleDocument == null) {
                throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexSpecification");
            }
            IndexSpecification indexSpecification = new IndexSpecification(OracleCollectionImpl.this.db.getJsonFactoryProvider(), ((OracleDocumentImpl)oracleDocument).getContentAsStream());
            try {
                string = indexSpecification.parse();
            }
            catch (QueryException queryException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.warning(queryException.toString());
                }
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_CREATE, queryException, new Object[0]);
            }
            OracleCollectionImpl.this.createIndex(string, indexSpecification.isUnique(), indexSpecification.isScalarRequired(), indexSpecification.isLax(), indexSpecification.indexNulls(), indexSpecification.getColumns(), indexSpecification.getSpatialPath(), indexSpecification.getLanguage(), indexSpecification.getSearchOn(), indexSpecification.getDataGuide(), indexSpecification.is121TextIndexWithLang());
        }

        @Override
        public void dropIndex(String string) throws OracleException {
            OracleCollectionImpl.this.dropIndex(string, false);
        }

        @Override
        public void dropIndex(String string, boolean bl) throws OracleException {
            OracleCollectionImpl.this.dropIndex(string, bl);
        }
    }
}

