/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.checks.gg_enabled_replication;
import com.oracle.premigration.dbinspector.checks.gg_force_logging;
import com.oracle.premigration.dbinspector.checks.gg_not_unique;
import com.oracle.premigration.dbinspector.checks.gg_objects_not_supported;
import com.oracle.premigration.dbinspector.checks.gg_supplemental_log_data_min;
import com.oracle.premigration.dbinspector.checks.gg_tables_not_supported_adb;
import com.oracle.premigration.dbinspector.checks.gg_tables_not_supported_default;
import com.oracle.premigration.dbinspector.checks.gg_user_objects_in_ggadmin_schemas;
import com.oracle.premigration.dbinspector.checks.has_absent_default_tablespace;
import com.oracle.premigration.dbinspector.checks.has_absent_temp_tablespace;
import com.oracle.premigration.dbinspector.checks.has_active_data_guard_dedicated;
import com.oracle.premigration.dbinspector.checks.has_active_data_guard_serverless;
import com.oracle.premigration.dbinspector.checks.has_basic_file_lobs;
import com.oracle.premigration.dbinspector.checks.has_clustered_tables;
import com.oracle.premigration.dbinspector.checks.has_columns_of_rowid_type;
import com.oracle.premigration.dbinspector.checks.has_columns_with_media_data_types_adb;
import com.oracle.premigration.dbinspector.checks.has_columns_with_media_data_types_default;
import com.oracle.premigration.dbinspector.checks.has_columns_with_spatial_data_types;
import com.oracle.premigration.dbinspector.checks.has_common_objects;
import com.oracle.premigration.dbinspector.checks.has_compression_disabled_for_objects;
import com.oracle.premigration.dbinspector.checks.has_data_in_other_tablespaces_dedicated;
import com.oracle.premigration.dbinspector.checks.has_data_in_other_tablespaces_serverless;
import com.oracle.premigration.dbinspector.checks.has_db_link_synonyms;
import com.oracle.premigration.dbinspector.checks.has_db_links;
import com.oracle.premigration.dbinspector.checks.has_dbms_credentials;
import com.oracle.premigration.dbinspector.checks.has_default_tablespace_not_data;
import com.oracle.premigration.dbinspector.checks.has_directories;
import com.oracle.premigration.dbinspector.checks.has_enabled_scheduler_jobs;
import com.oracle.premigration.dbinspector.checks.has_external_tables_dedicated;
import com.oracle.premigration.dbinspector.checks.has_external_tables_default;
import com.oracle.premigration.dbinspector.checks.has_external_tables_serverless;
import com.oracle.premigration.dbinspector.checks.has_fmw_registry_in_system;
import com.oracle.premigration.dbinspector.checks.has_ilm_ado_policies;
import com.oracle.premigration.dbinspector.checks.has_incompatible_jobs;
import com.oracle.premigration.dbinspector.checks.has_index_organized_tables;
import com.oracle.premigration.dbinspector.checks.has_java_objects;
import com.oracle.premigration.dbinspector.checks.has_java_source;
import com.oracle.premigration.dbinspector.checks.has_libraries;
import com.oracle.premigration.dbinspector.checks.has_logging_off_for_partitions;
import com.oracle.premigration.dbinspector.checks.has_logging_off_for_subpartitions;
import com.oracle.premigration.dbinspector.checks.has_logging_off_for_tables;
import com.oracle.premigration.dbinspector.checks.has_low_streams_pool_size;
import com.oracle.premigration.dbinspector.checks.has_mining_model_issues;
import com.oracle.premigration.dbinspector.checks.has_noexport_object_grants;
import com.oracle.premigration.dbinspector.checks.has_parallel_indexes_enabled;
import com.oracle.premigration.dbinspector.checks.has_profile_not_default;
import com.oracle.premigration.dbinspector.checks.has_refs_to_restricted_packages_dedicated;
import com.oracle.premigration.dbinspector.checks.has_refs_to_restricted_packages_serverless;
import com.oracle.premigration.dbinspector.checks.has_refs_to_user_objects_in_sys;
import com.oracle.premigration.dbinspector.checks.has_role_privileges;
import com.oracle.premigration.dbinspector.checks.has_sqlt_objects_adb;
import com.oracle.premigration.dbinspector.checks.has_sqlt_objects_default;
import com.oracle.premigration.dbinspector.checks.has_sys_privileges;
import com.oracle.premigration.dbinspector.checks.has_tables_that_fail_with_dblink;
import com.oracle.premigration.dbinspector.checks.has_tables_with_long_raw_datatype;
import com.oracle.premigration.dbinspector.checks.has_tables_with_xmltype_column;
import com.oracle.premigration.dbinspector.checks.has_trusted_server_entries;
import com.oracle.premigration.dbinspector.checks.has_user_defined_objects_in_sys;
import com.oracle.premigration.dbinspector.checks.has_users_with_10g_password_version;
import com.oracle.premigration.dbinspector.checks.has_xmlschema_objects;
import com.oracle.premigration.dbinspector.checks.has_xmltype_tables;
import com.oracle.premigration.dbinspector.checks.lcm_super_admin_user_exists;
import com.oracle.premigration.dbinspector.checks.modified_db_parameters_dedicated;
import com.oracle.premigration.dbinspector.checks.modified_db_parameters_serverless;
import com.oracle.premigration.dbinspector.checks.nls_character_set_conversion;
import com.oracle.premigration.dbinspector.checks.nls_national_character_set;
import com.oracle.premigration.dbinspector.checks.nls_nchar_ora_910;
import com.oracle.premigration.dbinspector.checks.options_in_use_not_available_dedicated;
import com.oracle.premigration.dbinspector.checks.options_in_use_not_available_serverless;
import com.oracle.premigration.dbinspector.checks.timezone_table_compatibility_higher;
import com.oracle.premigration.dbinspector.checks.xdb_resource_view_has_entries;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CheckList {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CheckList.class.getName());

    private CheckList() {
    }

    public static List<Check> createChecksList() {
        ArrayList<Check> checkList = new ArrayList<Check>();
        checkList.add(new has_directories());
        checkList.add(new has_user_defined_objects_in_sys());
        checkList.add(new timezone_table_compatibility_higher());
        checkList.add(new lcm_super_admin_user_exists());
        checkList.add(new gg_user_objects_in_ggadmin_schemas());
        checkList.add(new options_in_use_not_available_dedicated());
        checkList.add(new options_in_use_not_available_serverless());
        checkList.add(new has_active_data_guard_serverless());
        checkList.add(new has_active_data_guard_dedicated());
        checkList.add(new modified_db_parameters_dedicated());
        checkList.add(new modified_db_parameters_serverless());
        checkList.add(new xdb_resource_view_has_entries());
        checkList.add(new has_fmw_registry_in_system());
        checkList.add(new gg_enabled_replication());
        checkList.add(new gg_supplemental_log_data_min());
        checkList.add(new gg_force_logging());
        checkList.add(new has_users_with_10g_password_version());
        checkList.add(new nls_national_character_set());
        checkList.add(new has_trusted_server_entries());
        checkList.add(new has_low_streams_pool_size());
        checkList.add(new has_java_objects());
        checkList.add(new has_java_source());
        checkList.add(new has_columns_with_media_data_types_adb());
        checkList.add(new has_columns_with_media_data_types_default());
        checkList.add(new has_external_tables_dedicated());
        checkList.add(new has_external_tables_serverless());
        checkList.add(new has_external_tables_default());
        checkList.add(new has_db_links());
        checkList.add(new has_tables_with_xmltype_column());
        checkList.add(new has_xmltype_tables());
        checkList.add(new has_tables_with_long_raw_datatype());
        checkList.add(new has_tables_that_fail_with_dblink());
        checkList.add(new has_index_organized_tables());
        checkList.add(new has_xmlschema_objects());
        checkList.add(new has_logging_off_for_tables());
        checkList.add(new has_logging_off_for_partitions());
        checkList.add(new has_logging_off_for_subpartitions());
        checkList.add(new has_basic_file_lobs());
        checkList.add(new has_ilm_ado_policies());
        checkList.add(new has_clustered_tables());
        checkList.add(new has_db_link_synonyms());
        checkList.add(new has_compression_disabled_for_objects());
        checkList.add(new has_parallel_indexes_enabled());
        checkList.add(new has_data_in_other_tablespaces_dedicated());
        checkList.add(new has_data_in_other_tablespaces_serverless());
        checkList.add(new has_columns_of_rowid_type());
        checkList.add(new has_default_tablespace_not_data());
        checkList.add(new has_profile_not_default());
        checkList.add(new has_refs_to_user_objects_in_sys());
        checkList.add(new has_role_privileges());
        checkList.add(new has_sys_privileges());
        checkList.add(new gg_not_unique());
        checkList.add(new gg_objects_not_supported());
        checkList.add(new gg_tables_not_supported_adb());
        checkList.add(new gg_tables_not_supported_default());
        checkList.add(new nls_character_set_conversion());
        checkList.add(new nls_nchar_ora_910());
        checkList.add(new has_libraries());
        checkList.add(new has_absent_default_tablespace());
        checkList.add(new has_refs_to_restricted_packages_dedicated());
        checkList.add(new has_refs_to_restricted_packages_serverless());
        checkList.add(new has_dbms_credentials());
        checkList.add(new has_absent_temp_tablespace());
        checkList.add(new has_incompatible_jobs());
        checkList.add(new has_common_objects());
        checkList.add(new has_columns_with_spatial_data_types());
        checkList.add(new has_sqlt_objects_adb());
        checkList.add(new has_sqlt_objects_default());
        checkList.add(new has_enabled_scheduler_jobs());
        checkList.add(new has_noexport_object_grants());
        checkList.add(new has_mining_model_issues());
        return checkList;
    }

    public static List<Check> filterChecksByTargetCloud(List<Check> checkList, TargetCloud targetCloud) {
        if (targetCloud.equals(TargetCloud.ALL)) {
            return checkList;
        }
        ArrayList<Check> filteredList = new ArrayList<Check>();
        for (Check c : checkList) {
            if (c.getTargetCloud().contains(targetCloud)) {
                filteredList.add(c);
                continue;
            }
            log.info("Check " + c.getName() + " will not be run because it does not apply to the specified target cloud type: " + targetCloud.name());
        }
        return filteredList;
    }

    public static List<Check> filterChecksByMigrationMethod(List<Check> checkList, List<MigrationMethod> migrationMethods) {
        if (migrationMethods.contains(MigrationMethod.ALL)) {
            return checkList;
        }
        ArrayList<Check> filteredList = new ArrayList<Check>();
        for (Check c : checkList) {
            if (!Collections.disjoint(c.getMigrationMethods(), migrationMethods)) {
                filteredList.add(c);
                continue;
            }
            log.info("Check " + c.getName() + " will not be run because it does not apply to any of the specified migration methods: " + Utilities.join(",", migrationMethods));
        }
        return filteredList;
    }

    public static List<Check> filterChecksByScope(List<Check> checkList, CommandLineArgs cla) {
        List<String> schemas = cla.getSchemas();
        boolean isFull = cla.isForceFull() || schemas == null || schemas.isEmpty();
        MessageFormat mf = new MessageFormat("Check {0} will not be run because it is {1} scoped and the command line args indicate a {2} migration");
        ArrayList<Check> filteredList = new ArrayList<Check>();
        for (Check c : checkList) {
            if (isFull && c.getScope() != Check.Scope.SCHEMA_ONLY) {
                filteredList.add(c);
                continue;
            }
            if (!isFull && c.getScope() != Check.Scope.INSTANCE) {
                filteredList.add(c);
                continue;
            }
            String filterMsg = mf.format(new Object[]{c.getName(), c.getScope(), isFull ? "FULL" : "SCHEMA"});
            log.info(filterMsg);
        }
        return filteredList;
    }

    public static List<Check> filterChecksByLockdownProfile(List<Check> checkList, LockdownProfile lockdownProfile) {
        ArrayList<Check> filteredList = new ArrayList<Check>();
        for (Check c : checkList) {
            if (c.getLockdownProfiles().contains((Object)lockdownProfile)) {
                filteredList.add(c);
                continue;
            }
            log.info("Check " + c.getName() + " will not be run because it does not apply to the specified lockdown profile type: " + lockdownProfile.name());
        }
        return filteredList;
    }
}

