/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.has_absent_tablespaces;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.Collections;

public class has_absent_default_tablespace
extends has_absent_tablespaces {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_absent_default_tablespace.class.getName());

    public has_absent_default_tablespace() {
        this.tablespaceColumnNames = Collections.singletonList("DEFAULT_TABLESPACE");
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (exeCtx.isFullMode()) {
            this.defaultList = exeCtx.getTablespacesNames();
        } else if (exeCtx.getParsedArgs().getTargetCloud() != TargetCloud.DEFAULT) {
            this.defaultList = Collections.singletonList("DATA");
        } else {
            try {
                String defPermTablespace = SqlUtils.getSingleString("SELECT PROPERTY_VALUE FROM SYS.DATABASE_PROPERTIES WHERE PROPERTY_NAME = 'DEFAULT_PERMANENT_TABLESPACE'", exeCtx);
                this.defaultList = Collections.singletonList(defPermTablespace);
            }
            catch (SQLException e) {
                log.warning("Unexpected exception fetching DEFAULT_PERMANENT_TABLESPACE; defaulting to 'USERS'", e);
                this.defaultList = Collections.singletonList("USERS");
            }
        }
        super.prepare(exeCtx);
    }
}

