/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_tables_with_long_raw_datatype
extends FilterableCheck {
    public has_tables_with_long_raw_datatype() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().add(TargetCloud.ADWS);
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String longRawColumnSQL = "SELECT OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE FROM SYS.DBA_TAB_COLS C" + whereClause + " AND DATA_TYPE IN ('LONG','LONG RAW') AND (EXISTS  (SELECT NULL FROM SYS.DBA_TABLES D  WHERE   D.OWNER = C.OWNER  AND     D.TABLE_NAME = C.TABLE_NAME  AND     (COMPRESS_FOR LIKE 'QUERY%' OR COMPRESS_FOR LIKE 'ARCHIVE%' OR COMPRESSION = 'DISABLED'))  OR     EXISTS (SELECT NULL FROM SYS.DBA_TAB_PARTITIONS          WHERE   TABLE_OWNER = C.OWNER          AND     TABLE_NAME = C.TABLE_NAME          AND     (COMPRESS_FOR LIKE 'QUERY%' OR COMPRESS_FOR LIKE 'ARCHIVE%' OR COMPRESSION = 'DISABLED'))  OR     EXISTS (SELECT NULL FROM SYS.DBA_TAB_SUBPARTITIONS          WHERE   TABLE_OWNER = C.OWNER          AND     TABLE_NAME = C.TABLE_NAME          AND     (COMPRESS_FOR LIKE 'QUERY%' OR COMPRESS_FOR LIKE 'ARCHIVE%' OR COMPRESSION = 'DISABLED'))) ORDER BY 1,2,3";
        this.setSqlQuery(longRawColumnSQL);
    }
}

