/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AnalysisPropHelper {
    private final String migrationTablespaceMapping;
    private final List<String> defaultList;
    private final List<String> columnNames;
    private final List<String> targetPropTablespacesList = new ArrayList<String>();
    private final List<String> migrationMethodPropTablespacesNotMappedList = new ArrayList<String>();

    public AnalysisPropHelper(ExecutionContext exeCtx, List<String> defaultList, List<String> columnNames) {
        String migrationMethodPropTablespacesNotMapped;
        this.defaultList = defaultList;
        this.columnNames = columnNames;
        this.migrationTablespaceMapping = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACE_MAPPING.getKey());
        String targetPropTablespaces = exeCtx.getAnalysisProperty(TargetInstanceProp.TABLESPACES.getKey());
        if (targetPropTablespaces != null && !targetPropTablespaces.trim().isEmpty()) {
            this.targetPropTablespacesList.addAll(Arrays.asList(targetPropTablespaces.trim().split(",")));
        }
        if ((migrationMethodPropTablespacesNotMapped = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey())) != null && !migrationMethodPropTablespacesNotMapped.trim().isEmpty()) {
            this.migrationMethodPropTablespacesNotMappedList.addAll(Arrays.asList(migrationMethodPropTablespacesNotMapped.trim().split(",")));
        }
    }

    public String getTablespaceAndClause() {
        boolean hasListOfTargetTablespaces = true;
        boolean hasListOfUnmappedTablespaces = true;
        if (this.targetPropTablespacesList.isEmpty()) {
            hasListOfTargetTablespaces = false;
        }
        if (this.migrationMethodPropTablespacesNotMappedList.isEmpty()) {
            hasListOfUnmappedTablespaces = false;
        }
        String andClause = hasListOfUnmappedTablespaces ? SqlUtils.createAndOfOrClauses(this.columnNames, true, this.migrationMethodPropTablespacesNotMappedList) : (hasListOfTargetTablespaces ? SqlUtils.createAndOfOrClauses(this.columnNames, false, this.targetPropTablespacesList) : SqlUtils.createAndOfOrClauses(this.columnNames, false, this.defaultList));
        return " " + andClause;
    }

    public boolean isMigrationMethodMappingAll() {
        return this.migrationTablespaceMapping != null && "ALL".equals(this.migrationTablespaceMapping.trim());
    }
}

