/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.net.URL;
import java.util.Map;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CloudConnectionType;
import oracle.dbtools.raptor.cloud.connection.Storage;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionType;
import oracle.dbtools.raptor.cloud.connection.rest.RestConnectionType;
import oracle.ide.Addin;

public class CloudPostMigrationAddin
implements Addin {
    private static URL sSourceURL;
    private static boolean sLegacyMigrate;

    static void setSourceURL(URL uRL) {
        sSourceURL = uRL;
    }

    static void setLegacyMigrate(boolean bl) {
        sLegacyMigrate = bl;
    }

    public void initialize() {
        Storage storage = null;
        if (sLegacyMigrate) {
            storage = Storage.getLegacyInstance();
        } else if (sSourceURL != null) {
            storage = Storage.getStorageFromFile(sSourceURL);
        }
        if (storage != null) {
            for (SessionType sessionType : this.getSupportedTypes()) {
                Map<String, SessionInfo> map = storage.getConnections(sessionType.getType());
                if (map.size() <= 0) continue;
                CConnections cConnections = CConnections.getInstance(sessionType);
                cConnections.migrateStandaloneConnections(map);
            }
            Storage.clearLegacyStorage();
        }
    }

    private SessionType[] getSupportedTypes() {
        return new SessionType[]{CloudConnectionType.getInstance(), RestConnectionType.getInstance(), ListenerConnectionType.getInstance()};
    }
}

