/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportNlsNumericPanel {
    private JCheckBox nlsNumericCheckBox;
    private ImportDataFormat dataFormat;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportNlsNumericPanel(ImportDataFormat importDataFormat) {
        this();
        this.dataFormat = importDataFormat;
    }

    public ImportNlsNumericPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.initNlsNumeric();
    }

    public JCheckBox getUseNlsNumeric() {
        return this.nlsNumericCheckBox;
    }

    void initNlsNumeric() {
        this.nlsNumericCheckBox = new JCheckBox();
        this.nlsNumericCheckBox.setSelected(true);
        this.nlsNumericCheckBox.setText(DataImportArb.getString("NLS_NUMERIC"));
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setOptions(dBConfig);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.setOptions(dBConfig);
    }

    private void setOptions(DBConfig dBConfig) {
        if (this.dataFormat != null) {
            this.nlsNumericCheckBox.setSelected(this.dataFormat.getUseNlsNumeric());
        } else {
            this.nlsNumericCheckBox.setSelected(dBConfig.getBoolean("IMPORT_USE_NLS_NUMERIC"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_USE_NLS_NUMERIC", this.nlsNumericCheckBox.isSelected());
    }
}

