/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.connections.impexp.Destination;
import oracle.dbtools.raptor.connections.impexp.DestinationBase;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.navigator.folders.FoldersConnectionPropertiesUpdater;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

class ImportDestination
extends DestinationBase {
    private final DatabaseConnections m_store;
    private final FoldersConnectionPropertiesUpdater propsUpdater;
    private Collection<String> m_existingConnections;

    ImportDestination(DatabaseConnections databaseConnections) {
        this.m_store = databaseConnections;
        this.propsUpdater = new FoldersConnectionPropertiesUpdater();
        this.propsUpdater.setConnectionStore(databaseConnections.getStoreName());
    }

    @Override
    public boolean connectionExistsInDestination(String string) {
        return this.getExistingConnections().contains(string);
    }

    private static boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null && object2 != null) {
            return object.equals(object2);
        }
        return false;
    }

    @Override
    public void commitChanges() throws TraversalException {
        try {
            Destination.DuplicateMode duplicateMode = this.getDuplicateMode();
            for (Map.Entry entry : this.m_conns.entrySet()) {
                String string = (String)entry.getKey();
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)((Map)entry.getValue()));
                boolean bl = this.connectionExistsInDestination(string);
                if (bl) {
                    if (duplicateMode == Destination.DuplicateMode.REPLACE) {
                        this.m_store.removeConnection(string);
                    } else {
                        string = this.getNewConnectionName(string);
                    }
                }
                this.m_store.addConnection(string, properties);
            }
        }
        catch (ConnectionException connectionException) {
            throw new TraversalException(connectionException.getLocalizedMessage());
        }
    }

    private String getNewConnectionName(String string) {
        String string2;
        int n = 1;
        while (this.connectionExistsInDestination(string2 = string + "_" + n++)) {
        }
        return string2;
    }

    private synchronized Collection<String> getExistingConnections() {
        if (this.m_existingConnections == null) {
            this.m_existingConnections = this.m_store.listConnections();
        }
        return this.m_existingConnections;
    }

    public String toString() {
        return ImpExpResources.get("TITLE_IMPORT_DIALOG");
    }
}

