/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.DefaultRaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandlerException;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Displayable;

public class OracleStoredProgramDnDHandler
implements RaptorCodeEditorDnDHandler {
    private static final Set<String> CHARACTER_TYPES = new HashSet<String>(Arrays.asList("CHAR", "NCHAR", "VARCHAR2", "NVARCHAR2"));
    private String _worksheetConnectionName;

    @Override
    public String handleDrop(List<Displayable> list) throws RaptorCodeEditorDnDHandlerException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Displayable displayable : list) {
                stringBuilder.append(this.buildStatementForPlSqlNode((PlSqlNode)displayable) + DefaultRaptorCodeEditorDnDHandler.NL);
            }
        }
        catch (Exception exception) {
            throw new RaptorCodeEditorDnDHandlerException(exception);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setWorksheetConnectionName(String string) {
        this._worksheetConnectionName = string;
    }

    private String buildStatementForPlSqlNode(PlSqlNode plSqlNode) throws SQLException, AbortException {
        return PlSqlRunnerPanel.generateAnonymousBlock(plSqlNode, this._worksheetConnectionName);
    }

    private String getLengthForParam(PlSqlNode plSqlNode, String string, String string2, String string3, String string4) {
        DBUtil dBUtil = null;
        String string5 = "SELECT DATA_LENGTH FROM SYS.ALL_ARGUMENTS WHERE OWNER = '" + string + "' AND OBJECT_NAME = '" + string3 + "'AND ARGUMENT_NAME = '" + string2 + "'";
        String string6 = null;
        try {
            dBUtil = DBUtil.getInstance((Connection)Connections.getInstance().getConnection(plSqlNode.getConnectionName()));
            string6 = dBUtil.executeReturnOneCol(string5, Collections.emptyList());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string6;
    }

    static boolean isCharType(String string) {
        return CHARACTER_TYPES.contains(string);
    }
}

