/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class RSTModelHook {
    private static Logger LOGGER = Logger.getLogger(RSTModelHook.class.getName());
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-rstmodel";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-rstmodel", "sqldev-rstmodel-hook");
    public static final String HOOKELEMENTNAME = "provider";
    public static final String DRIVERCLASS = "driverClass";
    private static Map<String, MetaClass<? extends ResultSetTableModel>> s_provClassNames = new HashMap<String, MetaClass<? extends ResultSetTableModel>>();
    private static HashStructureHookListener s_listener;

    private static final Listener createListener() {
        return new Listener(){};
    }

    private static synchronized void initListener() {
        if (s_listener == null) {
            HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
            s_listener = RSTModelHook.createListener();
            hashStructureHook.addHashStructureHookListener(s_listener);
        }
    }

    static ResultSetTableModel getRSTModel(String string) {
        RSTModelHook.initListener();
        ResultSetTableModel resultSetTableModel = null;
        MetaClass<? extends ResultSetTableModel> metaClass = s_provClassNames.get(string);
        if (metaClass != null) {
            try {
                resultSetTableModel = (ResultSetTableModel)metaClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
            }
        }
        return resultSetTableModel;
    }

    private static void registerRSTModelImpl(String string, MetaClass<? extends ResultSetTableModel> metaClass) {
        if (string == null || !ModelUtil.hasLength((String)string.trim())) {
            LOGGER.log(Level.SEVERE, RSTableMessages.getString("RSTModelHook.2"));
            return;
        }
        if (metaClass == null) {
            LOGGER.log(Level.SEVERE, RSTableMessages.getString("RSTModelHook.0"));
            return;
        }
        string = string.trim();
        s_provClassNames.put(string, metaClass);
    }

    protected static class Listener
    implements HashStructureHookListener {
        protected Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processModels(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processModels(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processModels(HashStructure hashStructure) {
            List list = hashStructure.getAsList(RSTModelHook.HOOKELEMENTNAME);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    String string = hashStructure2.getString(RSTModelHook.DRIVERCLASS);
                    MetaClass metaClass = LazyClassAdapter.getInstance((HashStructure)hashStructure2).getMetaClass("#text");
                    RSTModelHook.registerRSTModelImpl(string, (MetaClass<? extends ResultSetTableModel>)metaClass);
                }
            }
        }
    }
}

