/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.display.DrillObject;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnHighlightParameter;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.GridResultSet;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RSTableMessages;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridFilter;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.ResultSetGridCell;
import oracle.dbtools.raptor.controls.grid.ResultSetGridColumn;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.dbtools.raptor.utils.UniqueArrayList;
import oracle.dbtools.util.Closeables;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedSubstitutionProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.MigrationReportSubs;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ROWID;
import oracle.xdb.XMLType;

public abstract class ResultSetTableModel
extends AbstractRaptorGridModel
implements IResultSetTableModel {
    protected String _sql;
    protected String _connName;
    protected List<?> _bindList = null;
    protected Map<String, ?> _bindMap = null;
    protected ResultSet _rs;
    protected GridResultSet _grs = null;
    protected PreparedStatement _prepstmt;
    protected String _schemaName;
    protected String _tablename;
    protected static final String[] LINK_COLS = new String[]{"SDEV_LINK_OWNER", "SDEV_LINK_NAME", "SDEV_LINK_TYPE", "SDEV_LINK_LINE"};
    protected final List<String> _skipCols = new ArrayList<String>();
    protected final List<DrillObject> _drillUrls = new ArrayList<DrillObject>();
    protected LinkedList<Object> closeables = new LinkedList();
    protected ArrayList<ResultSetGridColumn> gridColumns;
    protected Query _queryObj;
    protected RSTMSql _rstmsql;
    protected float _fetchTime = 0.0f;
    protected boolean _autoApplyPersistedSort = true;

    protected void init(String string, String string2, List<?> list, Map<String, ?> map) {
        this._sql = RSTMSql.sanitizeSql(string);
        this._rstmsql = new RSTMSql(this._sql);
        this._connName = string2;
        this._bindList = list;
        this._bindMap = map;
        for (String string3 : LINK_COLS) {
            this._skipCols.add(string3);
        }
        this.setFetchSize(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
        DBConfig.getInstance().addStructureChangeListener(new SqlArrayFetchSizeListener());
    }

    protected int findTotalRows() {
        return this.findTotalRows(false);
    }

    protected void clearModelList() {
        super.clearModelList();
    }

    protected List<RaptorGridRowModel> getModelList() {
        return super.getModelList();
    }

    protected void setModelList(List<RaptorGridRowModel> list) {
        super.setModelList(list);
    }

    public void closeModel() {
        super.closeModel();
        CloseTask closeTask = new CloseTask((String)(this._taskWrapper != null ? this._taskWrapper.getTaskName() : RSTableMessages.getString("ResultSetTableModel.11")), IRaptorTaskRunMode.NO_GUI, false, false);
        if (null == this._taskWrapper) {
            try {
                closeTask.call();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        } else {
            RaptorTaskManager.getInstance().addTask(closeTask);
        }
    }

    protected void handleFetchNextSQLException(SQLException sQLException, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (iRaptorTaskProgressUpdater == null || !iRaptorTaskProgressUpdater.getDescriptor().isCancelled()) {
            this._rstmsql = new RSTMSql(this._sql);
            this.clearModelList();
            this.setAllRowsFetched(true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ResultSetTableModel.this.fireTableDataChanged();
                    ResultSetTableModel.this.getRowHeaderModel().fireTableDataChanged();
                }
            };
            SwingUtilities.invokeLater(runnable);
            throw new ExecutionException(sQLException);
        }
    }

    protected void fetchNext(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (this.allRowsFetched()) {
            return;
        }
        if (this.getConnectionName() == null) {
            this._connName = ConnectionSelectorUI.getConnection(ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), ConnectionArb.getString((String)"SQL_VIEWER_RECONNECT_ADVISORY"), null, false, false);
        }
        String string = this.getConnectionName();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string, false);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getLocalizedMessage(), dBException);
        }
        if (connection == null) {
            this._rstmsql = new RSTMSql(this._sql);
            this.clearModelList();
            this.setAllRowsFetched(true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ResultSetTableModel.this.fireTableDataChanged();
                    ResultSetTableModel.this.getRowHeaderModel().fireTableDataChanged();
                }
            };
            SwingUtilities.invokeLater(runnable);
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageFormat.format(RSTableMessages.getString("ResultSetTableModel.14"), Connections.getDisplayName(this.getConnectionName())));
            return;
        }
        boolean bl = false;
        if (!LockManager.checkLock((Connection)connection)) {
            bl = LockManager.lock((Connection)connection, (boolean)false);
        }
        if (this.getModelList() == null) {
            this.setModelList(new ArrayList<RaptorGridRowModel>());
        }
        try {
            Object object;
            if (iRaptorTaskProgressUpdater != null) {
                iRaptorTaskProgressUpdater.checkCanProceed();
            }
            if (this._rs == null) {
                if (iRaptorTaskProgressUpdater != null) {
                    String string2 = this.getModifiedSql();
                    String string3 = "(\\{:(\\w+)\\})\\.(\\{:(\\w+)\\})";
                    Pattern pattern = Pattern.compile(string3);
                    object = pattern.matcher(string2);
                    while (((Matcher)object).find()) {
                        int n2 = ((Matcher)object).groupCount();
                        for (int i = 1; i <= n2; ++i) {
                            String string4 = ((Matcher)object).group(i);
                            String string5 = "";
                            if (i < 2) continue;
                            string5 = ((Matcher)object).group(i - 1);
                            string5 = string5.replace("{", "\\{");
                            string5 = string5.replace("}", "\\}");
                            String string6 = (String)this.getBindMap().get(string4);
                            if (string6 == null) continue;
                            string2 = string2.replaceAll(string5, string6);
                        }
                    }
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage(RSTableMessages.getString("ResultSetTableModel.13") + string2);
                }
                this._rs = this.openResultSet();
            }
            int n3 = this.getModelList().size();
            for (int i = 0; i < n; ++i) {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                if (this._rs != null && this._rs.next()) {
                    if (this.isVerticalDisplay()) {
                        for (int j = 1; j <= this._rs.getMetaData().getColumnCount(); ++j) {
                            object = new ArrayList();
                            object.add(new ResultSetGridCell(this._rs.getMetaData().getColumnName(j), this.getConnectionName()));
                            this.cacheObjectInARow((List<ResultSetGridCell>)object, j, this._rs);
                            this.addRow((List)object, n3 + i);
                        }
                        continue;
                    }
                    this.addRow(this.fetchRowFromResultSet(), n3 + i);
                    if (iRaptorTaskProgressUpdater == null) continue;
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString("ResultSetTableModel.10"), i));
                    continue;
                }
                this.setAllRowsFetched(true);
                break;
            }
        }
        catch (SQLException sQLException) {
            this.handleFetchNextSQLException(sQLException, iRaptorTaskProgressUpdater);
        }
        catch (DBException dBException) {
            throw new ExecutionException(dBException);
        }
        finally {
            if (bl) {
                LockManager.unlock((Connection)connection);
            }
        }
        if (this.allRowsFetched() && iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(RSTableMessages.getString("ResultSetTableModel.6") + this.getLoadedRowCount());
        } else if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(MessageFormat.format(RSTableMessages.getString("ResultSetTableModel.10"), this.getLoadedRowCount()));
        }
        if (iRaptorTaskProgressUpdater != null) {
            this._fetchTime += Float.parseFloat("" + iRaptorTaskProgressUpdater.getDescriptor().getElapsedTime()) / 1000.0f;
        }
    }

    protected List<ResultSetGridCell> fetchRowFromResultSet() throws SQLException {
        if (this._rs == null) {
            return null;
        }
        ArrayList<ResultSetGridCell> arrayList = new ArrayList<ResultSetGridCell>();
        for (int i = 1; i <= this._rs.getMetaData().getColumnCount(); ++i) {
            this.cacheObjectInARow(arrayList, i, this._rs);
        }
        this.fillDrillUrls();
        return arrayList;
    }

    protected void cacheObjectInARow(List<ResultSetGridCell> list, int n, ResultSet resultSet) throws SQLException {
        Object object;
        Object object2 = null;
        try {
            object2 = resultSet instanceof OracleResultSet ? ((OracleResultSet)resultSet).getOracleObject(n) : resultSet.getObject(n);
        }
        catch (SQLException sQLException) {
            object2 = resultSet.getObject(n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, unsatisfiedLinkError.getStackTrace()[0].toString(), unsatisfiedLinkError);
        }
        if (object2 instanceof byte[]) {
            list.add(new ResultSetGridCell(this.rawToHex((byte[])object2), this._connName));
        } else if (object2 instanceof ROWID && resultSet.getMetaData().getColumnType(n) == 1111) {
            object = resultSet.getString(n);
            byte[] byArray = ((String)object).getBytes();
            list.add(new ResultSetGridCell(new ROWID(byArray), this._connName));
        } else if (object2 instanceof OracleResultSet) {
            object = new ArrayList();
            try {
                OracleResultSet oracleResultSet = (OracleResultSet)object2;
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = oracleResultSet.getMetaData().getColumnCount();
                for (int i = 1; i <= n2; ++i) {
                    arrayList.add(oracleResultSet.getMetaData().getColumnName(i));
                }
                object.add(arrayList);
                while (oracleResultSet.next()) {
                    ArrayList<ResultSetGridCell> arrayList2 = new ArrayList<ResultSetGridCell>();
                    for (int i = 1; i <= n2; ++i) {
                        this.cacheObjectInARow(arrayList2, i, (ResultSet)oracleResultSet);
                    }
                    object.add(arrayList2);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            list.add(new ResultSetGridCell(object, this._connName));
        } else {
            list.add(new ResultSetGridCell(object2, this._connName));
            if (object2 instanceof SQLXML || object2 instanceof XMLType) {
                this.closeables.add(object2);
            }
        }
    }

    protected void fillDrillUrls() {
        try {
            String string = this._rs.getString("SDEV_LINK_NAME");
            String string2 = this._rs.getString("SDEV_LINK_OWNER");
            String string3 = this._rs.getString("SDEV_LINK_TYPE");
            String string4 = null;
            try {
                string4 = this._rs.getString("SDEV_LINK_LINE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (string != null) {
                String string5 = string3;
                if (string3.endsWith(" BODY")) {
                    string5 = string5.substring(0, string3.indexOf(" BODY"));
                }
                URL uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this.getConnectionName(), null, string2, string5), string);
                if (string3.endsWith(" BODY")) {
                    uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getEnclosedTypeURL(uRL, string3), string);
                }
                this._drillUrls.add(new DrillObject(uRL, string4));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String rawToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = n2 >>> 4;
            stringBuffer.append(this.nibbletochar(n3));
            int n4 = n2 & 0xF;
            stringBuffer.append(this.nibbletochar(n4));
        }
        return stringBuffer.toString();
    }

    protected char nibbletochar(int n) {
        int n2 = 48;
        if (n < 10) {
            n2 = (char)(48 + n);
        } else if (n == 10) {
            n2 = 65;
        } else if (n == 11) {
            n2 = 66;
        } else if (n == 12) {
            n2 = 67;
        } else if (n == 13) {
            n2 = 68;
        } else if (n == 14) {
            n2 = 69;
        } else if (n == 15) {
            n2 = 70;
        }
        return (char)n2;
    }

    protected ResultSet openResultSet() throws SQLException, DBException {
        OutputStream outputStream;
        this._drillUrls.clear();
        this._fetchTime = 0.0f;
        String string = this._sql;
        ScriptRunnerContext scriptRunnerContext = null;
        SQLCommand sQLCommand = null;
        if (this.isScriptTable(string)) {
            scriptRunnerContext = new ScriptRunnerContext();
            outputStream = new OutputStream(){

                @Override
                public void write(int n) throws IOException {
                }
            };
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            scriptRunnerContext.setOutputStreamWrapper(bufferedOutputStream);
            scriptRunnerContext.consumerRuning(true);
            scriptRunnerContext.setMap(MigrationReportSubs.getMap());
            sQLCommand = new SQLCommand(SQLCommand.StmtType.G_C_SQL, SQLCommand.StmtSubType.G_S_BRIDGE, SQLCommand.StmtResultType.G_R_QUERY, true, Restricted.Level.R4);
            this.beforeScriptTable(string, scriptRunnerContext, sQLCommand);
        }
        this._prepstmt = this.prepareStatement();
        outputStream = null;
        try {
            outputStream = this._prepstmt != null ? this._prepstmt.executeQuery() : null;
        }
        catch (Exception exception) {
            MigrationReportSubs.getMap().clear();
            throw exception;
        }
        if (this.isScriptTable(string)) {
            this.afterListeners(scriptRunnerContext, sQLCommand);
        }
        return outputStream;
    }

    private void beforeScriptTable(String string, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) throws DBException {
        sQLCommand.setOrigSQL(string);
        sQLCommand.setSql(string);
        scriptRunnerContext.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
        Substitution substitution = new Substitution(scriptRunnerContext);
        try {
            substitution.replaceSubstitution((ISQLCommand)sQLCommand);
        }
        catch (Substitution.SubstitutionException substitutionException) {
            // empty catch block
        }
        this.beforeListeners(scriptRunnerContext, sQLCommand);
    }

    private void afterListeners(ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) throws DBException {
        CommandRegistry.fireEndListeners((Connection)this.getConnection(), (ScriptRunnerContext)scriptRunnerContext, (ISQLCommand)sQLCommand);
    }

    private void beforeListeners(ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) throws DBException {
        CommandRegistry.fireBeginListeners((Connection)this.getConnection(), (ScriptRunnerContext)scriptRunnerContext, (ISQLCommand)sQLCommand);
        CommandRegistry.fireListeners((Connection)this.getConnection(), (ScriptRunnerContext)scriptRunnerContext, (ISQLCommand)sQLCommand);
        this._rstmsql._originalSql = sQLCommand.getModifiedSQL();
        this._rstmsql._modifiedSql = null;
    }

    private boolean isScriptTable(String string) {
        return string.trim().startsWith("/*SQLDEV:SCRIPTTABLE*/");
    }

    protected abstract PreparedStatement prepareStatement() throws SQLException, DBException;

    public String getSortString() {
        StringBuilder stringBuilder = new StringBuilder();
        List<ResultSetGridColumn> list = this.getGridColumns();
        if (list != null) {
            ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
            for (ResultSetGridColumn resultSetGridColumn : list) {
                GridColumn gridColumn = resultSetGridColumn;
                if (gridColumn.getSortParameter() == null) continue;
                arrayList.add(gridColumn);
            }
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                ResultSetGridColumn resultSetGridColumn;
                resultSetGridColumn = (GridColumn)arrayList.get(i);
                stringBuilder.append(list.indexOf((Object)resultSetGridColumn) + 1 + " " + resultSetGridColumn.getSortParameter().getSortDir().toString());
                if (resultSetGridColumn.getSortParameter().getNullsOption() != GridColumnSortParameter.NullsOption.NONE) {
                    stringBuilder.append(" " + resultSetGridColumn.getSortParameter().getNullsOption());
                }
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString().length() != 0 ? stringBuilder.toString() : null;
    }

    public void setSkipCols(List<String> list) {
        this._skipCols.clear();
        for (String string : LINK_COLS) {
            this._skipCols.add(string);
        }
        if (list != null) {
            for (String string : list) {
                this._skipCols.add(string.toUpperCase());
            }
        }
    }

    public List<DrillObject> getDrillUrls() {
        return this._drillUrls;
    }

    @Override
    public String getConnectionName() {
        return this._connName;
    }

    public String getModelUniqueName() {
        return this.getConnectionName() + this._sql;
    }

    public int getColumnCount() {
        List<ResultSetGridColumn> list = this.getGridColumns();
        return list != null ? list.size() : 0;
    }

    protected Connection getConnection() throws DBException {
        return Connections.getInstance().getConnection(this._connName, false);
    }

    @Override
    public void setBindList(List<?> list) {
        this._bindList = list;
    }

    @Override
    public List<?> getBindList() {
        return this._bindList;
    }

    @Override
    public void setBindMap(Map<String, ?> map) {
        this._bindMap = map;
    }

    @Override
    public Map<String, ?> getBindMap() {
        return this._bindMap;
    }

    protected RaptorTask<List<RaptorGridRowModel>> createFetchTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, final int n) {
        return new DatabaseQueryTask<List<RaptorGridRowModel>>(string, iRaptorTaskRunMode, false, true){
            private boolean interrupt;

            public String getConnectionName() {
                return ResultSetTableModel.this.getConnectionName();
            }

            public String getQuery() {
                return ResultSetTableModel.this.getModifiedSql();
            }

            protected List<RaptorGridRowModel> doWork() throws TaskException {
                try {
                    this.checkCanProceed();
                    ResultSetTableModel.this.fetchNext(n, this.getRaptorTaskProgressUpdater());
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    throw new TaskException((Throwable)executionException);
                }
                return ResultSetTableModel.this.getModelList();
            }

            public boolean cancel() {
                if (ResultSetTableModel.this._prepstmt != null) {
                    try {
                        ResultSetTableModel.this._prepstmt.cancel();
                        try {
                            long l;
                            String string = this.getConnectionName();
                            if (string != null && (l = TNSPing.ping(string)) < 0L) {
                                this.interrupt = true;
                            }
                        }
                        catch (Throwable throwable) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                            return false;
                        }
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        return false;
                    }
                }
                return super.cancel();
            }

            protected boolean mayInterrupt() {
                return this.interrupt;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int findTotalRows(boolean bl) {
        String string = "0";
        StringBuilder stringBuilder = new StringBuilder("SELECT COUNT(1) FROM (\n");
        if (bl) {
            stringBuilder.append(this.getModifiedSql());
        } else {
            stringBuilder.append(this._sql);
        }
        stringBuilder.append("\n) sub1");
        if (Connections.getInstance().lock(this._connName, true)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((String)this._connName);
                string = this.getBindList() != null && this.getBindList().size() > 0 ? dBUtil.executeReturnOneCol(stringBuilder.toString(), this.getBindList()) : (this.getBindMap() != null && this.getBindMap().size() > 0 ? dBUtil.executeReturnOneCol(stringBuilder.toString(), this.getBindMap()) : dBUtil.executeReturnOneCol(stringBuilder.toString(), (Map)null));
            }
            finally {
                Connections.getInstance().unlock(this._connName);
            }
        }
        return Integer.parseInt(string);
    }

    public List<ResultSetGridColumn> getGridColumns() {
        if (this.gridColumns == null && this._rs != null) {
            this.gridColumns = new ArrayList();
            if (this.isVerticalDisplay()) {
                ResultSetGridColumn resultSetGridColumn = new ResultSetGridColumn(RSTableMessages.getString("ResultSetTableModel.2"), false, 12);
                resultSetGridColumn.setSortable(false);
                this.gridColumns.add(resultSetGridColumn);
                ResultSetGridColumn resultSetGridColumn2 = new ResultSetGridColumn(RSTableMessages.getString("ResultSetTableModel.3"), false, 12);
                resultSetGridColumn2.setSortable(false);
                this.gridColumns.add(resultSetGridColumn2);
            } else {
                try {
                    ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        String string = resultSetMetaData.getColumnName(i);
                        boolean bl = false;
                        if (this._skipCols.contains(string.toUpperCase())) {
                            bl = true;
                        }
                        ResultSetGridColumn resultSetGridColumn = new ResultSetGridColumn(string, bl, resultSetMetaData.getColumnType(i));
                        if (this._highlightCols.contains(string.toUpperCase())) {
                            resultSetGridColumn.setSkipped(true);
                            resultSetGridColumn.setHighlightParameter(new GridColumnHighlightParameter(string.toUpperCase(), Color.CYAN));
                        }
                        this.gridColumns.add(resultSetGridColumn);
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    this.publishStatusMessage(sQLException.getMessage(), sQLException);
                }
                UniqueArrayList.aliasWithDelim(this.gridColumns, (String)"_");
                for (int i = 0; i < this.gridColumns.size(); ++i) {
                    this.gridColumns.get(i).setSortable(this.isColumnSortable(i));
                }
                if (this._autoApplyPersistedSort) {
                    this.applySavedSort();
                }
            }
        }
        return this.gridColumns;
    }

    public void autoApplyPersistedSort(boolean bl) {
        this._autoApplyPersistedSort = bl;
    }

    protected void applySavedSort() {
        String string;
        RaptorGridPersistedSettings raptorGridPersistedSettings = RaptorGridPersistedSettings.loadPersistedSettings((String)this.getModelUniqueName());
        ArrayList arrayList = null;
        if (raptorGridPersistedSettings != null && (arrayList = raptorGridPersistedSettings.getSortClauses()) != null && arrayList.size() > 0 && (string = (String)arrayList.get(0)) != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.equals("")) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
                GridColumn gridColumn = null;
                GridColumnSortParameter gridColumnSortParameter = new GridColumnSortParameter(n, GridColumnSortParameter.SortDir.ASCENDING, GridColumnSortParameter.NullsOption.NONE);
                int n2 = 0;
                gridColumnSortParameter.setSortOrder(n);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    switch (++n2) {
                        case 1: {
                            int n3 = -1;
                            try {
                                n3 = Integer.parseInt(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n3 <= 0) break;
                            gridColumn = this.gridColumns.get(n3 - 1);
                            break;
                        }
                        case 2: {
                            if (string3.equals(GridColumnSortParameter.SortDir.ASCENDING.toString())) {
                                gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.ASCENDING);
                                break;
                            }
                            if (!string3.equals(GridColumnSortParameter.SortDir.DESCENDING.toString())) break;
                            gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.DESCENDING);
                            break;
                        }
                        case 3: {
                            if (!string3.equals("NULLS")) break;
                            string3 = stringTokenizer2.nextToken();
                            if (string3.equals("FIRST")) {
                                gridColumnSortParameter.setNullsOption(GridColumnSortParameter.NullsOption.FIRST);
                                break;
                            }
                            if (!string3.equals("LAST")) break;
                            gridColumnSortParameter.setNullsOption(GridColumnSortParameter.NullsOption.LAST);
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                if (gridColumn == null || !gridColumn.isSortable()) continue;
                gridColumn.setSortParameter(gridColumnSortParameter);
            }
        }
    }

    @Override
    public int getColumnSqlType(int n) {
        if (n < 0) {
            return 12;
        }
        if (this.getGridColumns() != null) {
            return this.getGridColumns().get(n).getSqlType();
        }
        return 12;
    }

    @Override
    public GridResultSet getResultSet() throws SQLException {
        throw new RuntimeException("this feature is not yet supported. contact rsaboo");
    }

    @Override
    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        return this._rs.getMetaData();
    }

    @Override
    public String getSql() {
        return this._sql;
    }

    @Override
    public int[] getColumnSqlTypes() {
        int[] nArray = new int[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            nArray[i] = this.getColumnSqlType(i);
        }
        return nArray;
    }

    @Override
    public Query getQuery() {
        return this._queryObj;
    }

    @Override
    public boolean isNewGrid() {
        return true;
    }

    public Column getQueryColumn(int n, int n2) {
        Column column = null;
        if (this._queryObj != null) {
            String string = this.getColumnName(n2);
            for (Column column2 : this._queryObj.getCols()) {
                if (!string.equals(column2.getName())) continue;
                column = column2;
            }
        }
        return column;
    }

    public final boolean isCellEditable(int n, int n2) {
        return true;
    }

    public boolean isCellEditorEditable(int n, int n2) {
        return false;
    }

    @Override
    public void addFilter(RaptorGridFilter raptorGridFilter) {
        if (this._rstmsql != null) {
            this._rstmsql.addFilter(raptorGridFilter);
        }
    }

    @Override
    public void removeFilter(RaptorGridFilter raptorGridFilter) {
        if (this._rstmsql != null) {
            this._rstmsql.removeFilter(raptorGridFilter);
        }
    }

    @Override
    public void removeFilter(int n) {
        if (this._rstmsql != null) {
            this._rstmsql.removeFilter(n);
        }
    }

    @Override
    public RaptorGridFilter getFilter(int n) {
        if (this._rstmsql != null) {
            return this._rstmsql.getFilter(n);
        }
        return null;
    }

    @Override
    public List<RaptorGridFilter> getAllFilters() {
        if (this._rstmsql != null) {
            return this._rstmsql.getAllFilters();
        }
        return null;
    }

    @Override
    public void removeAllFilters() {
        if (this._rstmsql != null) {
            this._rstmsql.removeAllFilters();
        }
    }

    public boolean isFilterApplied() {
        List<RaptorGridFilter> list = this.getAllFilters();
        if (list != null && list.size() > 0) {
            return true;
        }
        String string = this.getFilterClause();
        return string != null && !string.equals("");
    }

    public ResultSetGridColumn getGridColumnForCell(RaptorGridCell raptorGridCell) {
        List<RaptorGridRowModel> list = this.getModelList();
        for (int i = 0; i < this.getLoadedRowCount(); ++i) {
            RaptorGridRowModel raptorGridRowModel = list.get(i);
            for (int j = 0; j < this.getGridColumns().size(); ++j) {
                RaptorGridCell raptorGridCell2 = (RaptorGridCell)raptorGridRowModel.getRow().get(j);
                if (raptorGridCell != raptorGridCell2) continue;
                return this.getGridColumns().get(j);
            }
        }
        return null;
    }

    public float getFetchTime() {
        return this._fetchTime;
    }

    public void setQueryObject(Query query) {
        this._queryObj = query;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Column column : query.getCols()) {
            if (!column.isHidden()) continue;
            arrayList.add(column.getName());
        }
        if (arrayList.size() > 0) {
            this.setSkipCols(arrayList);
        }
    }

    protected synchronized void closeResultSet() throws SQLException {
        for (Object e : this.closeables) {
            try {
                Closeables.close(e);
            }
            catch (Throwable throwable) {}
        }
        this.closeables.clear();
        if (this._rs != null) {
            this._rs.close();
            this._rs = null;
        }
        if (this._prepstmt != null) {
            this._prepstmt.cancel();
            this._prepstmt.close();
            this._prepstmt = null;
        }
    }

    class CloseTask<Void>
    extends DatabaseQueryTask<Void>
    implements ConnectionDisconnectListener {
        public CloseTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
            super(string, iRaptorTaskRunMode, bl, bl2);
        }

        protected Void doWork() throws TaskException {
            try {
                Connections.getInstance().addConnectionDisconnectListener(this);
                Database database = Connections.getInstance().getDatabase(this.getConnectionName(), false);
                if (database != null && database.isConnectionAlive()) {
                    ResultSetTableModel.this.closeResultSet();
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public String getConnectionName() {
            return ResultSetTableModel.this.getConnectionName();
        }

        public String getQuery() {
            return RSTableMessages.getString("ResultSetTableModel.12");
        }

        @Override
        public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
            RaptorTaskManager.getInstance().cancelTask((RaptorTask)this);
        }

        protected void tearDown() {
            super.tearDown();
            Connections.getInstance().removeConnectionDisconnectListener(this);
        }

        @Override
        public void connectionDisconnected(ConnectionDetails connectionDetails) {
        }
    }

    private class SqlArrayFetchSizeListener
    extends StructureChangeListener {
        private SqlArrayFetchSizeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            String string = "";
            for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                string = changeInfo.getPropertyLocalName();
                if (!"ARRAYFETCHSIZE".equals(string)) continue;
                ResultSetTableModel.this.setFetchSize(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
            }
        }
    }
}

