/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.data.validators.LoadFieldValidator;
import oracle.javatools.icons.OracleIcons;

public class SourceColumnDefRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -3737233884717137960L;
    private Font _defaultFont;
    private Font _touchedFont;
    private ImportProperties _iProps;
    private LoadFile _loadFile;
    private LoadFieldValidator[] _validators;

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        LoadField loadField;
        Column column = (Column)object;
        String string = null == object ? null : column.getSourceColumnName();
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        if (this._defaultFont == null) {
            this._defaultFont = new Font(jLabel.getFont().getName(), 2, jLabel.getFont().getSize());
            this._touchedFont = new Font(jLabel.getFont().getName(), 1, jLabel.getFont().getSize());
        }
        if ((loadField = this._loadFile.getFieldByName(string)) != null) {
            if (loadField.isChecked()) {
                jLabel.setFont(this._touchedFont);
            } else {
                jLabel.setFont(this._defaultFont);
            }
            LoadFieldValidator loadFieldValidator = this._validators[column.getSourceColID()];
            ExitCode exitCode = loadFieldValidator.getHighestExitCode();
            if (exitCode.getSeverity() == ExitCode.EXIT_SEVERE.getSeverity() || exitCode.getSeverity() == ExitCode.EXIT_ERROR.getSeverity()) {
                jLabel.setIcon(OracleIcons.getIcon((String)"exception.png"));
            } else if (exitCode.getSeverity() != ExitCode.EXIT_SUCCESS.getSeverity()) {
                jLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                jLabel.setIcon(null);
            }
        }
        return jLabel;
    }

    public void setProperties(ImportProperties importProperties) {
        this._iProps = importProperties;
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._validators = (LoadFieldValidator[])this._iProps.get(ImportKeys.VALIDATORS);
    }
}

