/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.security.GrantedRoleObject;
import oracle.dbtools.raptor.dialogs.security.GrantedRolePanel;
import oracle.dbtools.raptor.dialogs.security.PrivilegeObject;
import oracle.dbtools.raptor.dialogs.security.PrivilegesPanel;
import oracle.dbtools.raptor.dialogs.security.SecurityArb;
import oracle.dbtools.raptor.dialogs.security.SqlPanel;
import oracle.dbtools.raptor.dialogs.security.SubjectObject;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public abstract class SubjectDialog {
    protected Connection connection;
    protected GrantedRolePanel grantedRolePanel;
    protected SqlPanel sqlPanel;
    protected PrivilegesPanel sysPrivPanel;
    protected Operation operation;
    private int _sqlPanelIndex;
    private JTabbedPane _tabbed;

    protected abstract void initialize(Operation var1, String var2);

    protected abstract SubjectObject getSubject();

    protected abstract JPanel[] getPanels();

    protected abstract String[] getTabNames();

    protected abstract String getTitle(Operation var1);

    protected abstract boolean subjectIsUser();

    public void showDialog(Operation operation, Connection connection, DBObject dBObject, ObjectActionController.ObjectActionPostProcess objectActionPostProcess) throws Exception {
        this.showDialog(operation, connection, dBObject.getObjectName(), objectActionPostProcess);
    }

    public void showDialog(Operation operation, Connection connection, String string, final ObjectActionController.ObjectActionPostProcess objectActionPostProcess) throws Exception {
        String[] stringArray;
        JPanel[] jPanelArray2;
        Object object;
        assert (objectActionPostProcess != null);
        this.operation = operation;
        this.connection = connection;
        this.initialize(operation, string);
        this.grantedRolePanel = new GrantedRolePanel(this.subjectIsUser());
        this.sqlPanel = new SqlPanel();
        this.sysPrivPanel = new PrivilegesPanel();
        GrantedRolePanel.RoleTableTableModel roleTableTableModel = this.grantedRolePanel.getTableModel();
        SubjectObject subjectObject = this.getSubject();
        Map<String, GrantedRoleObject> map = subjectObject.getRoles();
        for (String object22 : map.keySet()) {
            object = map.get(object22);
            roleTableTableModel.addRow(object22, ((GrantedRoleObject)object).isGranted(), ((GrantedRoleObject)object).isAdmin(), ((GrantedRoleObject)object).isDef());
        }
        PrivilegesPanel.PrivTableTableModel privTableTableModel = this.sysPrivPanel.getTableModel();
        Map<String, PrivilegeObject> map2 = subjectObject.getPrivs();
        for (JPanel[] jPanelArray2 : map2.keySet()) {
            stringArray = map2.get(jPanelArray2);
            privTableTableModel.addRow((String)jPanelArray2, stringArray.isGranted(), stringArray.isAdmin());
        }
        object = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SubjectDialog.this.updateSQL();
            }
        };
        this.sqlPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SubjectDialog.this.updateSQL();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        jPanelArray2 = this.getPanels();
        stringArray = this.getTabNames();
        for (int actionListener = 0; actionListener < jPanelArray2.length; ++actionListener) {
            JPanel jPanel = jPanelArray2[actionListener];
            if (!(jPanel instanceof SqlPanel)) continue;
            this._sqlPanelIndex = actionListener;
            break;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SubjectDialog.this.updateUI()) {
                    ScriptExecutor scriptExecutor = new ScriptExecutor(SubjectDialog.this.getSql(), SubjectDialog.this.connection);
                    ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                    scriptRunnerContext.setBaseConnection(SubjectDialog.this.connection);
                    scriptRunnerContext.setCurrentConnection(SubjectDialog.this.connection);
                    scriptRunnerContext.setSqlError(4);
                    scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                    scriptExecutor.setOut(bufferedOutputStream);
                    scriptExecutor.run();
                    if (Boolean.TRUE.equals(scriptRunnerContext.getProperty("sqldev.error"))) {
                        String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.message");
                        Logger.warn(SubjectDialog.this.getClass(), (String)string);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(SecurityArb.getString("SQL_FAILURE") + "\n- " + string), (String)SecurityArb.getString("ERROR_TITLE"), null);
                    } else {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)SecurityArb.getString("SQL_SUCCESS"), (String)SecurityArb.getString("SUCCESS_TITLE"), null);
                        SubjectDialog.this.onApply();
                        objectActionPostProcess.run();
                    }
                } else {
                    return;
                }
            }
        };
        this.showPanelAsTabbedDialog(jPanelArray2, stringArray, this.getTitle(operation), actionListener, (ChangeListener)object);
    }

    protected void onApply() {
        this.getSubject().setAlter(true);
        this.sqlPanel._sql.setText(this.getSubject().getSql());
    }

    private void showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, ChangeListener changeListener) {
        this._tabbed = new JTabbedPane();
        this._tabbed.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        for (int i = 0; i < jPanelArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            this._tabbed.addTab(stringArray[i], jPanelArray[i]);
        }
        HelpProvider helpProvider = new HelpProvider(){

            public void showHelp(Component component) throws HelpUnavailableException {
                HelpSystem.getHelpSystem().showHelp((JComponent)SubjectDialog.this._tabbed.getSelectedComponent());
            }
        };
        this._tabbed.putClientProperty("JEWT.HelpProvider", helpProvider);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._tabbed, null, (String)string, (int)28);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            this._tabbed.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(this._tabbed.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.runDialog();
    }

    private String getSql() {
        String string = null;
        string = this._tabbed.getSelectedIndex() == this._sqlPanelIndex ? this.sqlPanel._sql.getText() : this.getSubject().getSql();
        return string;
    }

    private void updateSQL() {
        this.sqlPanel._sql.setText("");
        if (this.updateUI()) {
            this.sqlPanel._sql.setText(this.getSubject().getSql());
            JScrollPane jScrollPane = (JScrollPane)this.sqlPanel._sql.getParent().getParent();
            JViewport jViewport = jScrollPane.getViewport();
            jScrollPane.setViewport(null);
            jScrollPane.setViewport(jViewport);
        }
    }

    protected boolean updateUI() {
        SubjectObject subjectObject = this.getSubject();
        for (GrantedRoleObject object : this.grantedRolePanel.getTableModel().getData()) {
            subjectObject.updateRole(object);
        }
        for (PrivilegeObject privilegeObject : this.sysPrivPanel.getTableModel().getData()) {
            subjectObject.updatePrivs(privilegeObject);
        }
        return true;
    }

    protected static class NameDocument
    extends PlainDocument {
        protected NameDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            super.insertString(n, string.replace("\"", ""), attributeSet);
        }
    }

    public static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

