/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.utils.Connections;

public class InsightCache {
    private static final Logger logger = Logger.getLogger(InsightCache.class.getName());
    private static Map<String, List<SuggestedItem>> database = new HashMap<String, List<SuggestedItem>>();

    public static List<SuggestedItem> getDatabase(String string) {
        return database.get(string);
    }

    public static List<SuggestedItem> queryItems(String string, String string2, String string3, String string4, List<String> list) {
        List<SuggestedItem> list2 = database.get(string);
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        if (list2 == null) {
            return linkedList;
        }
        int n = 1000;
        for (SuggestedItem suggestedItem : list2) {
            if (string3 != null && !suggestedItem.getName().toLowerCase().startsWith(string3.toLowerCase()) || string4 != null && !InsightCache.ownerMatches(string4, string2, suggestedItem, string3)) continue;
            boolean bl = false;
            for (String string5 : list) {
                if (!string5.equals(suggestedItem.getType())) continue;
                bl = true;
                break;
            }
            if (bl) {
                linkedList.add(suggestedItem);
            }
            if (n >= linkedList.size()) continue;
            break;
        }
        return linkedList;
    }

    public static boolean contains(String string, String string2, String string3, String string4, List<String> list) {
        List<SuggestedItem> list2 = database.get(string);
        if (list2 == null) {
            return false;
        }
        for (SuggestedItem suggestedItem : list2) {
            if (!suggestedItem.getName().equalsIgnoreCase(string3) || string4 != null && !InsightCache.ownerMatches(string4, string2, suggestedItem, "not null")) continue;
            boolean bl = false;
            for (String string5 : list) {
                if (!string5.equals(suggestedItem.getType())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private static boolean ownerMatches(String string, String string2, SuggestedItem suggestedItem, String string3) {
        String string4 = suggestedItem.getOwner();
        if (string3 != null && "".equals(string)) {
            if ("PUBLIC".equals(string4)) {
                return true;
            }
            if ("SYS".equals(string4)) {
                return true;
            }
        }
        if ("".equals(string4) && string2.equals(string)) {
            return true;
        }
        return string4.equalsIgnoreCase(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillIn(String string) {
        List<SuggestedItem> list = database.get(string);
        if (list != null) {
            return;
        }
        list = new LinkedList<SuggestedItem>();
        long l = System.currentTimeMillis();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            connection = ChameleonConnection.getConnection((String)string);
            bl = Connections.getInstance().tryLock(connection, 10000L);
            if (!bl) {
                return;
            }
            String string2 = connection.getMetaData().getUserName();
            String string3 = "SELECT object_type, owner, object_name \nFROM all_objects \nWHERE \tobject_type in ('TABLE','VIEW','SYNONYM',                     'PACKAGE','PROCEDURE','FUNCTION', 'SEQUENCE') \n                                   and object_name not like 'BIN$%'\n";
            statement = connection.prepareStatement(string3);
            statement.setFetchSize(1000000);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString("object_type");
                String string5 = resultSet.getString("object_name");
                String string6 = resultSet.getString("owner");
                list.add(new SuggestedItem(string4, string2.equals(string6) || "SYNONYM".equals(string4) && !"PUBLIC".equals(string6) ? "" : string6, string5 + ("SEQUENCE".equals(string4) ? ".nextval" : "")));
            }
            database.put(string, list);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (bl) {
                Connections.getInstance().unlock(connection);
            }
            long l2 = System.currentTimeMillis();
            if (RaptorExtensionConstants.isStandAlone() || string.startsWith("jdbc:oracle:thin")) {
                if (5000L < l2 - l) {
                    logger.severe("InsightCache.fillIn() time = " + (l2 - l) + "  ret.size()= " + list.size());
                } else {
                    logger.info("InsightCache.fillIn() time = " + (l2 - l) + "  ret.size()= " + list.size());
                }
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        Class.forName("oracle.jdbc.OracleDriver");
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@//localhost:1521/xe", "hr", "hr");
        String string = "SELECT object_type, owner, object_name \nFROM all_objects \nWHERE \tobject_type in ('VIEW','TABLE','SYNONYM','PACKAGE','PROCEDURE','FUNCTION') and object_name not like 'BIN$%'\n";
        string = "SELECT 'COLUMN' object_type, '' owner, table_name object_name, column_name, column_id, data_type \nFROM sys.all_tab_cols \nWHERE hidden_column = 'NO' ";
        long l = System.currentTimeMillis();
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setFetchSize(1000000);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 1;
        while (resultSet.next()) {
            String string2 = resultSet.getString("object_type");
            String object = resultSet.getString("object_name");
            String string3 = resultSet.getString("owner");
            if (++n % 1000 == 0) {
                System.out.print('.');
            }
            linkedList.add(new SuggestedItem(string2, string3, object));
        }
        System.out.println();
        System.out.println("time=" + (System.currentTimeMillis() - l));
        System.out.println("#objects=" + n);
        n = 0;
        l = System.currentTimeMillis();
        for (SuggestedItem suggestedItem : linkedList) {
            if (!"HR".equals(suggestedItem.getOwner())) continue;
            ++n;
        }
        System.out.println();
        System.out.println("time=" + (System.currentTimeMillis() - l));
        System.out.println("#objects=" + n);
    }
}

