/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.jdbc.AbstractJDBCFolderInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCDBFolder;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCDBItem;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCObjectInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCObjectType;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCProceduresFolderInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCSchema;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCSchemaInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCSchemas;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCSchemasInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.JDBCTableFolderInstance;
import oracle.dbtools.raptor.navigator.db.jdbc.MetadataSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchema;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemas;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class JDBCNavProvider
extends ObjectFactory {
    static final Logger LOGGER = Logger.getLogger(JDBCNavProvider.class.getName());
    private static DBSchemas s_schemasDesc = new JDBCSchemas();
    private static DBSchema s_schemaDesc = new JDBCSchema();
    private DBSchemasInstance m_schemas;
    private DBCatalogsInstance m_catalogs;
    private Database m_db;
    private List<JDBCObjectType> m_types;
    private Map<String, List<String>> m_catalogsAndSchemas;

    public JDBCNavProvider(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        super(connectionInfo, connectionType);
        this.initCatalogs();
        try {
            this.m_db = Connections.getInstance().getDatabase(connectionInfo.getConnectionName());
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    @Override
    public DBSchemaInstance createSchemaInstance(String string) {
        JDBCSchemaInstance jDBCSchemaInstance = new JDBCSchemaInstance(this);
        jDBCSchemaInstance.setProperty("SCHEMA", string);
        jDBCSchemaInstance.setProperty("ConnectionType", this.getConnectionType());
        return jDBCSchemaInstance;
    }

    @Override
    public DBCatalogInstance createCatalogInstance(String string) {
        return null;
    }

    @Override
    public DBChildInstance createChildInstance(String string, String string2) {
        return null;
    }

    @Override
    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        AbstractJDBCFolderInstance abstractJDBCFolderInstance = "PROCEDURE".equals(string) ? new JDBCProceduresFolderInstance(this, (JDBCDBFolder)databaseFolder) : new JDBCTableFolderInstance(this, (JDBCDBFolder)databaseFolder);
        abstractJDBCFolderInstance.setProperty("TYPE", string);
        return abstractJDBCFolderInstance;
    }

    @Override
    public DBObjectInstance createNodeInstance(String string) {
        JDBCObjectInstance jDBCObjectInstance = new JDBCObjectInstance(this, (JDBCDBItem)this.getObjectDescriptor(string));
        jDBCObjectInstance.setProperty("TYPE", string);
        return jDBCObjectInstance;
    }

    @Override
    public DBCatalogsInstance getCatalogsInstance() {
        if (this.m_catalogs == null) {
            this.m_catalogs.setProperty("ConnectionType", this.getConnectionType());
        }
        return this.m_catalogs;
    }

    @Override
    public DatabaseObject getObjectDescriptor(String string) {
        ObjectType objectType = this.getObjectType(string);
        return objectType != null ? objectType.getNode() : null;
    }

    @Override
    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        if (this.m_schemas == null) {
            this.m_schemas = new JDBCSchemasInstance(this, s_schemasDesc);
            this.m_schemas.setProperty("ConnectionType", this.getConnectionType());
        }
        return this.m_schemas;
    }

    @Override
    protected ObjectType[] listTypesImpl(String string) {
        return this.listTypes();
    }

    @Override
    public ObjectType[] listTypes() {
        if (this.m_types == null) {
            this.initTypes();
        }
        return this.m_types.toArray(new JDBCObjectType[0]);
    }

    @Override
    public ObjectType getObjectType(String string) {
        assert (string != null);
        if (this.m_types == null) {
            this.initTypes();
        }
        for (ObjectType objectType : this.m_types) {
            if (!ModelUtil.areEqual((Object)string, (Object)objectType.getType())) continue;
            return objectType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTypes() {
        this.m_types = new ArrayList<JDBCObjectType>();
        DatabaseMetaData databaseMetaData = null;
        ResultSet resultSet = null;
        try {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getTableTypes();
            String string = this.getConnectionType();
            Icon icon = RaptorImagesArb.getIcon("TABLE_FOLDER");
            Icon icon2 = OracleIcons.getIcon((String)"table.png");
            HashSet<Object> hashSet = new HashSet<Object>();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                hashSet.add(string2);
            }
            for (String string3 : hashSet) {
                this.m_types.add(new JDBCObjectType(string, string3, icon, icon2));
            }
            if (databaseMetaData.supportsStoredProcedures()) {
                this.m_types.add(new JDBCObjectType(string, "PROCEDURE", icon, icon2));
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isShowAllSchemasAtTopLevel() {
        return super.isShowAllSchemasAtTopLevel();
    }

    @Override
    public boolean isSupportsCatalog() {
        return super.isSupportsCatalog();
    }

    @Override
    public boolean isShowOtherSchemas() {
        return super.isShowOtherSchemas();
    }

    private DatabaseMetaData getMetaData() {
        DatabaseMetaData databaseMetaData = null;
        Connection connection = this.getConnection();
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        return databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCatalogs() {
        DatabaseMetaData databaseMetaData;
        if (this.m_catalogsAndSchemas == null && (databaseMetaData = this.getMetaData()) != null) {
            ResultSet resultSet = null;
            try {
                this.m_catalogsAndSchemas = new HashMap<String, List<String>>();
                resultSet = databaseMetaData.getCatalogs();
                while (resultSet.next()) {
                    this.m_catalogsAndSchemas.put(resultSet.getString(1), new ArrayList());
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    resultSet = null;
                }
            }
            try {
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    List<String> list = this.m_catalogsAndSchemas.get(string2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.m_catalogsAndSchemas.put(string2, list);
                    }
                    list.add(string);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    resultSet = null;
                }
            }
        }
    }

    public Database getDatabase() {
        return this.m_db;
    }

    DBSchemaInstance createSchemaInstance(Schema schema) {
        MetadataSchemaInstance metadataSchemaInstance = new MetadataSchemaInstance(this, s_schemaDesc, schema.getName());
        metadataSchemaInstance.setProperty("dbapi.schema", schema);
        Map map = schema.getProperties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                metadataSchemaInstance.setProperty((String)entry2.getKey(), entry2.getValue());
            }
        }
        return metadataSchemaInstance;
    }
}

