/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.db.ConnectionFolderOwner;
import oracle.dbtools.raptor.navigator.db.IConnectionNode;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.raptor.navigator.folders.FolderComparator;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.SynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public abstract class ConnectionFolderOwnerTreeNode
extends SynchronousNavigatorTreeNode {
    public static final String NAV_FOLDER_PROP = "NAV_FOLDER";
    private static final TreePath[] EMPTY_ARRAY = new TreePath[0];
    static final TreePath ROOT = new TreePath("");
    private ConnectionListener m_renameListener;

    public ConnectionFolderOwnerTreeNode() {
        this.setComparator(new FolderComparator());
    }

    private void savePrefs() {
        if (!Ide.isStarting()) {
            try {
                Preferences preferences = Preferences.getPreferences();
                preferences.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getLocalizedMessage());
            }
        }
    }

    protected static DatabasesFolder createFolder(String string) {
        DatabasesFolder databasesFolder = new DatabasesFolder(string);
        return databasesFolder;
    }

    TreePath getTreePath(DatabasesFolder databasesFolder) {
        NavigatorTreeNode navigatorTreeNode = this.getOwningNavigatorTree().findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
        return this.getTreePath(navigatorTreeNode);
    }

    public TreePath getTreePath(NavigatorTreeNode navigatorTreeNode) {
        TreePath treePath = null;
        if (navigatorTreeNode != this) {
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
            Element element = navigatorTreeNode.getElement();
            String string = element.getShortLabel();
            treePath = navigatorTreeNode2 == this ? new TreePath(string) : this.getTreePath(navigatorTreeNode2).pathByAddingChild(string);
        }
        return treePath;
    }

    private Map<TreePath, DatabasesFolder> processChildren(NavigatorTreeNode navigatorTreeNode, PathCreationFunction pathCreationFunction) {
        HashMap<TreePath, DatabasesFolder> hashMap = new HashMap<TreePath, DatabasesFolder>();
        Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = iterator.next();
            Element element = navigatorTreeNode2.getElement();
            if (!(element instanceof DatabasesFolder)) continue;
            TreePath treePath = pathCreationFunction.createPath(element.getShortLabel());
            hashMap.put(treePath, (DatabasesFolder)element);
            hashMap.putAll(this.processChildren(navigatorTreeNode2, string -> treePath.pathByAddingChild(string)));
        }
        return hashMap;
    }

    private Map<TreePath, DatabasesFolder> getFolders() {
        return this.processChildren(this, string -> new TreePath(string));
    }

    public TreePath[] getFolderNames() {
        return this.processChildren(this, string -> new TreePath(string)).keySet().toArray(EMPTY_ARRAY);
    }

    public String[] getSiblingNames(DatabasesFolder databasesFolder) {
        HashSet<String> hashSet = new HashSet<String>();
        NavigatorTreeNode navigatorTreeNode = this.getOwningNavigatorTree().findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
        if (navigatorTreeNode != null) {
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode2.getChildNodes();
            while (iterator.hasNext()) {
                Element element;
                NavigatorTreeNode navigatorTreeNode3 = iterator.next();
                if (navigatorTreeNode3 == navigatorTreeNode || !((element = navigatorTreeNode3.getElement()) instanceof DatabasesFolder)) continue;
                hashSet.add(element.getShortLabel());
            }
        }
        return hashSet.toArray(new String[0]);
    }

    private void updateCache(DatabasesFolder databasesFolder, TreePath treePath) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        Iterator iterator = databasesFolder.getChildren();
        while (iterator.hasNext()) {
            Serializable serializable;
            Object object;
            Object e = iterator.next();
            if (e instanceof IConnectionNode) {
                object = (IConnectionNode)e;
                serializable = object.getURL();
                databasesFolderCache.updateFolder(serializable.getProtocol(), object.getQualifiedConnectionName(), treePath);
                continue;
            }
            if (!(e instanceof DatabasesFolder)) continue;
            object = (DatabasesFolder)((Object)e);
            serializable = treePath.pathByAddingChild(((DatabasesFolder)((Object)object)).getName());
            this.updateCache((DatabasesFolder)((Object)object), (TreePath)serializable);
        }
    }

    private void renameFolder(TreePath treePath, TreePath treePath2) {
        DatabasesFolder databasesFolder = this.getFolders().get(treePath);
        if (databasesFolder != null) {
            databasesFolder.setName(treePath2.getLastPathComponent().toString());
            this.updateCache(databasesFolder, treePath2);
            UpdateMessage.fireObjectRenamed((Subject)databasesFolder);
        }
    }

    public boolean renameFolder(DatabasesFolder databasesFolder, String string) {
        if (databasesFolder != null) {
            TreePath treePath = this.getTreePath(databasesFolder);
            TreePath treePath2 = treePath.getParentPath();
            TreePath treePath3 = treePath2 == null ? new TreePath(string) : treePath2.pathByAddingChild(string);
            NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)this.getParent();
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
            while (iterator.hasNext()) {
                NavigatorTreeNode navigatorTreeNode2 = iterator.next();
                if (!(navigatorTreeNode2 instanceof ConnectionFolderOwnerTreeNode)) continue;
                ConnectionFolderOwnerTreeNode connectionFolderOwnerTreeNode = (ConnectionFolderOwnerTreeNode)navigatorTreeNode2;
                connectionFolderOwnerTreeNode.renameFolder(treePath, treePath3);
            }
            this.savePrefs();
            return true;
        }
        return false;
    }

    public void updateFolder(NavigatorTree navigatorTree, TreePath treePath, Element[] elementArray) {
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        if (treePath != null) {
            DatabasesFolder databasesFolder = this.findOrCreateFolder(navigatorTree, treePath);
            NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
            navigatorTree.expand(navigatorTreeNode, false);
            DatabasesFolder databasesFolder2 = this.getParent(elementArray[0]);
            if (databasesFolder2 == null) {
                for (Element element : elementArray) {
                    Object object;
                    if (element instanceof IConnectionNode) {
                        object = (IConnectionNode)element;
                        databasesFolder.add(element);
                        databasesFolderCache.addFolder(this.getConnectionType((IConnectionNode<?>)object), object.getQualifiedConnectionName(), treePath);
                        this.reparentNode(navigatorTree, navigatorTreeNode, element);
                        continue;
                    }
                    if (!(element instanceof DatabasesFolder)) continue;
                    object = (DatabasesFolder)element;
                    databasesFolder.add((Element)object);
                    TreePath treePath2 = treePath.pathByAddingChild(((DatabasesFolder)((Object)object)).getName());
                    this.updateCache((DatabasesFolder)((Object)object), treePath2);
                    this.reparentNode(navigatorTree, navigatorTreeNode, (Element)object);
                    TreePath treePath3 = new TreePath(((DatabasesFolder)((Object)object)).getName());
                    this.updateFolderInOtherRoots(treePath3, treePath2);
                }
            } else if (databasesFolder2 != databasesFolder) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (Element element : elementArray) {
                    Object object;
                    if (element instanceof IConnectionNode) {
                        if (databasesFolder2.remove(element)) {
                            arrayList.add(element);
                        }
                        databasesFolder.add(element);
                        object = (IConnectionNode)element;
                        databasesFolderCache.updateFolder(this.getConnectionType((IConnectionNode<?>)object), object.getQualifiedConnectionName(), treePath);
                        this.reparentNode(navigatorTree, navigatorTreeNode, element);
                        continue;
                    }
                    if (!(element instanceof DatabasesFolder)) continue;
                    if (databasesFolder2.remove(element)) {
                        arrayList.add(element);
                    }
                    databasesFolder.add(element);
                    object = (DatabasesFolder)element;
                    TreePath treePath4 = treePath.pathByAddingChild(((DatabasesFolder)((Object)object)).getName());
                    this.updateCache((DatabasesFolder)((Object)object), treePath4);
                    this.reparentNode(navigatorTree, navigatorTreeNode, (Element)object);
                    TreePath treePath5 = this.getTreePath(databasesFolder2);
                    TreePath treePath6 = treePath5.pathByAddingChild(((DatabasesFolder)((Object)object)).getName());
                    this.updateFolderInOtherRoots(treePath6, treePath4);
                }
            }
        } else {
            DatabasesFolder databasesFolder = this.getParent(elementArray[0]);
            if (databasesFolder != null) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (Element element : elementArray) {
                    Object object;
                    if (databasesFolder.remove(element)) {
                        arrayList.add(element);
                        if (element instanceof IConnectionNode) {
                            object = (IConnectionNode)element;
                            databasesFolderCache.removeFolder(this.getConnectionType((IConnectionNode<?>)object), object.getQualifiedConnectionName());
                        } else if (element instanceof DatabasesFolder) {
                            object = (DatabasesFolder)element;
                            TreePath treePath7 = new TreePath(((DatabasesFolder)((Object)object)).getName());
                            this.updateCache((DatabasesFolder)((Object)object), treePath7);
                            TreePath treePath8 = this.getTreePath(databasesFolder);
                            TreePath treePath9 = treePath8.pathByAddingChild(((DatabasesFolder)((Object)object)).getName());
                            this.updateFolderInOtherRoots(treePath9, treePath7);
                        }
                    }
                    if ((object = this.reparentNode(navigatorTree, this, element)) != null) continue;
                    navigatorTree.addChildToNode((NavigatorTreeNode)this, element);
                }
            }
        }
        this.savePrefs();
    }

    DatabasesFolder findOrCreateFolder(NavigatorTree navigatorTree, TreePath treePath) {
        return ConnectionFolderOwnerTreeNode.findOrCreateFolder(treePath, this.getFolders(), (databasesFolder, databasesFolder2) -> {
            NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
            navigatorTree.addChildToNode(navigatorTreeNode, (Element)databasesFolder2);
        }, databasesFolder -> navigatorTree.addChildToNode((NavigatorTreeNode)this, (Element)databasesFolder));
    }

    private NavigatorTreeNode reparentNode(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode, Element element) {
        NavigatorTreeNode navigatorTreeNode2 = navigatorTree.findTreeNode(element, (NavigatorTreeNode)this);
        if (navigatorTreeNode2 != null) {
            navigatorTree.reparentNode(navigatorTreeNode2, navigatorTreeNode);
        }
        return navigatorTreeNode2;
    }

    private DatabasesFolder getParent(Element element) {
        Iterator<NavigatorTreeNode> iterator = this.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode = iterator.next();
            Element element2 = navigatorTreeNode.getElement();
            if (!(element2 instanceof DatabasesFolder) || !((DatabasesFolder)element2).containsChild(element)) continue;
            return (DatabasesFolder)element2;
        }
        return null;
    }

    public void removeFolder(DatabasesFolder databasesFolder) {
        if (databasesFolder != null) {
            TreePath treePath = this.getTreePath(databasesFolder);
            this.removeFolderImpl(databasesFolder);
            NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)this.getParent();
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
            while (iterator.hasNext()) {
                NavigatorTreeNode navigatorTreeNode2 = iterator.next();
                if (navigatorTreeNode2 == this || !(navigatorTreeNode2 instanceof ConnectionFolderOwnerTreeNode)) continue;
                ((ConnectionFolderOwnerTreeNode)navigatorTreeNode2).removeFolderImpl(treePath);
            }
        }
    }

    private void removeFolderImpl(TreePath treePath) {
        this.removeFolderImpl(this.getFolders().get(treePath));
    }

    private void removeFolderImpl(DatabasesFolder databasesFolder) {
        if (databasesFolder != null) {
            NavigatorTree navigatorTree = this.getOwningNavigatorTree();
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
            NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
            if (navigatorTreeNode != null) {
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
                TreePath treePath = this.getTreePath(navigatorTreeNode2);
                ArrayList<Element> arrayList = new ArrayList<Element>();
                Iterator iterator = databasesFolder.getChildren();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    NavigatorTreeNode navigatorTreeNode3 = navigatorTree.findTreeNode(element, navigatorTreeNode);
                    if (navigatorTreeNode3 != null) {
                        navigatorTree.reparentNode(navigatorTreeNode3, navigatorTreeNode2);
                    } else {
                        arrayList.add(element);
                    }
                    if (!(element instanceof IConnectionNode)) continue;
                    IConnectionNode iConnectionNode = (IConnectionNode)element;
                    if (treePath == null) {
                        databasesFolderCache.removeFolder(this.getDatabaseType(iConnectionNode), iConnectionNode.getQualifiedConnectionName());
                        continue;
                    }
                    databasesFolderCache.updateFolder(this.getDatabaseType(iConnectionNode), iConnectionNode.getQualifiedConnectionName(), treePath);
                }
                if (arrayList.size() > 0) {
                    navigatorTree.addChildrenToNode(navigatorTreeNode2, arrayList);
                }
                navigatorTree.removeChildFromNode(navigatorTreeNode2, navigatorTreeNode);
            }
            this.savePrefs();
        }
    }

    private void handleConnectionRename(String string, String string2) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        databasesFolderCache.renameConnection("sqldev.nav", string, string2);
    }

    private void addConnectionToFolder(TreePath treePath, IConnectionNode<?> iConnectionNode) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        NavigatorTree navigatorTree = this.getOwningNavigatorTree();
        if (treePath != null) {
            DatabasesFolder databasesFolder = this.findOrCreateFolder(navigatorTree, treePath);
            NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
            navigatorTree.expand(navigatorTreeNode, false);
            DatabasesFolder databasesFolder2 = this.getParent(iConnectionNode);
            if (databasesFolder2 == null) {
                databasesFolder.add(iConnectionNode);
                databasesFolderCache.addFolder(this.getDatabaseType(iConnectionNode), iConnectionNode.getQualifiedConnectionName(), treePath);
                if (navigatorTreeNode != null) {
                    navigatorTree.refresh(navigatorTreeNode);
                }
            } else {
                System.out.println("shouldn't happen");
            }
        }
    }

    protected void initRenameListener() {
        this.m_renameListener = new ConnectionListener(){

            @Override
            public void connectionAdded(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionClosed(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionModified(ConnectionEvent connectionEvent) {
                ConnectionFolderOwnerTreeNode.this.handleConnectionRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
            }

            @Override
            public void connectionOpened(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionRemoved(ConnectionEvent connectionEvent) {
            }

            @Override
            public void connectionRenamed(ConnectionEvent connectionEvent) {
                ConnectionFolderOwnerTreeNode.this.handleConnectionRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
            }
        };
        Connections.getInstance().addConnectionListener(this.m_renameListener);
    }

    protected void clearRenameListener() {
        Connections.getInstance().removeConnectionListener(this.m_renameListener);
        this.m_renameListener = null;
    }

    @Override
    protected void handleChildrenRemoved(Collection<Element> collection) {
        NavigatorTree navigatorTree = this.getOwningNavigatorTree();
        if (navigatorTree != null) {
            for (Element element : collection) {
                DatabasesFolder databasesFolder = this.getParent(element);
                if (databasesFolder != null) {
                    if (!databasesFolder.remove(element)) continue;
                    NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder, (NavigatorTreeNode)this);
                    NavigatorTreeNode navigatorTreeNode2 = navigatorTree.findTreeNode(element, (NavigatorTreeNode)this);
                    if (navigatorTreeNode2 == null) {
                        navigatorTreeNode2 = navigatorTree.findTreeNode(element, (NavigatorTreeNode)this);
                    }
                    if (navigatorTreeNode2 == null) continue;
                    navigatorTree.removeChildFromNode(navigatorTreeNode, navigatorTreeNode2);
                    continue;
                }
                navigatorTree.removeChildrenFromNode(this, Collections.singletonList(element));
            }
        }
    }

    @Override
    protected void updateImpl(Object object, UpdateMessage updateMessage) {
        String string = null;
        Properties properties = null;
        ArrayList arrayList = new ArrayList();
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_ADDED) {
            List list = updateMessage.getAddObjects();
            for (Object e : list) {
                if (e instanceof IConnectionNode) {
                    IConnectionNode iConnectionNode = (IConnectionNode)e;
                    DatabaseConnections databaseConnections = null;
                    try {
                        databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
                        properties = databaseConnections.getProperties(iConnectionNode.getConnectionName());
                        if (properties != null && properties.get(NAV_FOLDER_PROP) != null) {
                            string = (String)properties.get(NAV_FOLDER_PROP);
                            properties.remove(NAV_FOLDER_PROP);
                            databaseConnections.updateConnection(iConnectionNode.getConnectionName(), iConnectionNode.getConnectionName(), properties);
                            this.addConnectionToFolder(DatabasesFolderCache.createTreePath(string), iConnectionNode);
                            continue;
                        }
                        arrayList.add(e);
                    }
                    catch (ConnectionException connectionException) {
                        connectionException.printStackTrace();
                    }
                    continue;
                }
                arrayList.add(e);
            }
            if (arrayList.size() > 0) {
                list.clear();
                list.addAll(arrayList);
                super.updateImpl(object, updateMessage);
            }
        } else {
            super.updateImpl(object, updateMessage);
        }
    }

    protected final String getDatabaseType(IConnectionNode<?> iConnectionNode) {
        URL uRL = iConnectionNode.getURL();
        return uRL != null ? uRL.getProtocol() : "sqldev.nav";
    }

    @Override
    protected void cleanupOnClose() {
        this.clearRenameListener();
    }

    protected Collection<IConnectionNode<?>> getConnections() {
        ArrayList arrayList = new ArrayList();
        ConnectionFolderOwner connectionFolderOwner = (ConnectionFolderOwner)this.getElement();
        Iterator iterator = connectionFolderOwner.getChildren();
        while (iterator.hasNext()) {
            arrayList.add((IConnectionNode)iterator.next());
        }
        return arrayList;
    }

    private static DatabasesFolder findOrCreateFolder(TreePath treePath, Map<TreePath, DatabasesFolder> map, ChildHandler childHandler, RootHandler rootHandler) {
        DatabasesFolder databasesFolder = map.get(treePath);
        if (databasesFolder == null) {
            databasesFolder = ConnectionFolderOwnerTreeNode.createFolder(treePath.getLastPathComponent().toString());
            map.put(treePath, databasesFolder);
            TreePath treePath2 = treePath.getParentPath();
            DatabasesFolder databasesFolder2 = databasesFolder;
            if (treePath2 == null) {
                rootHandler.addChildToRoot(databasesFolder2);
            } else {
                while (treePath2 != null) {
                    DatabasesFolder databasesFolder3 = databasesFolder2;
                    databasesFolder2 = map.get(treePath2);
                    if (databasesFolder2 != null) {
                        childHandler.addChildToFolder(databasesFolder2, databasesFolder3);
                        break;
                    }
                    databasesFolder2 = ConnectionFolderOwnerTreeNode.createFolder(treePath2.getLastPathComponent().toString());
                    map.put(treePath2, databasesFolder2);
                    databasesFolder2.add((Element)databasesFolder3);
                    if ((treePath2 = treePath2.getParentPath()) != null) continue;
                    rootHandler.addChildToRoot(databasesFolder2);
                }
            }
        }
        return databasesFolder;
    }

    @Override
    protected Iterator<Element> loadChildrenImpl() {
        ArrayList arrayList = new ArrayList();
        HashMap<TreePath, DatabasesFolder> hashMap = new HashMap<TreePath, DatabasesFolder>();
        this.initRenameListener();
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance();
        for (IConnectionNode<?> iConnectionNode : this.getConnections()) {
            String string = iConnectionNode.getQualifiedConnectionName();
            String string2 = this.getConnectionType(iConnectionNode);
            TreePath treePath = databasesFolderCache.getFolder(string2, string);
            if (treePath == null) {
                arrayList.add(iConnectionNode);
                continue;
            }
            DatabasesFolder databasesFolder3 = ConnectionFolderOwnerTreeNode.findOrCreateFolder(treePath, hashMap, (databasesFolder, databasesFolder2) -> databasesFolder.add((Element)databasesFolder2), databasesFolder -> arrayList.add((IConnectionNode<?>)((Object)databasesFolder)));
            databasesFolder3.add(iConnectionNode);
        }
        return arrayList.iterator();
    }

    protected String getConnectionType(IConnectionNode<?> iConnectionNode) {
        URL uRL = iConnectionNode.getURL();
        String string = uRL != null ? uRL.getProtocol() : "unknown";
        return string;
    }

    @Override
    protected Object getKey(Element element) {
        if (element instanceof IConnectionNode) {
            return "Store:" + ((IConnectionNode)element).getQualifiedConnectionName();
        }
        if (element instanceof DatabasesFolder) {
            return "Folder:" + ((DatabasesFolder)element).getName();
        }
        return super.getKey(element);
    }

    void updateFolder(TreePath treePath, TreePath treePath2) {
        DatabasesFolder databasesFolder = this.getFolders().get(treePath);
        if (databasesFolder != null) {
            String string = treePath.getLastPathComponent().toString();
            TreePath treePath3 = treePath.getParentPath();
            String string2 = treePath2.getLastPathComponent().toString();
            TreePath treePath4 = treePath2.getParentPath();
            NavigatorTree navigatorTree = this.getOwningNavigatorTree();
            if (treePath4 != null) {
                DatabasesFolder databasesFolder2;
                DatabasesFolder databasesFolder3 = this.findOrCreateFolder(navigatorTree, treePath4);
                NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)databasesFolder3, (NavigatorTreeNode)this);
                navigatorTree.expand(navigatorTreeNode, false);
                if (treePath3 != null && (databasesFolder2 = this.getFolders().get(treePath3)) != null) {
                    databasesFolder2.remove((Element)databasesFolder);
                }
                databasesFolder3.add((Element)databasesFolder);
                this.updateCache(databasesFolder, treePath2);
                this.reparentNode(navigatorTree, navigatorTreeNode, (Element)databasesFolder);
            } else {
                DatabasesFolder databasesFolder4 = this.getParent((Element)databasesFolder);
                if (databasesFolder4 != null && databasesFolder4.remove((Element)databasesFolder)) {
                    this.updateCache(databasesFolder, treePath2);
                }
                if (this.reparentNode(navigatorTree, this, (Element)databasesFolder) == null) {
                    navigatorTree.addChildToNode((NavigatorTreeNode)this, (Element)databasesFolder);
                }
            }
        }
    }

    private void updateFolderInOtherRoots(TreePath treePath, TreePath treePath2) {
        NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)this.getParent();
        Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = iterator.next();
            if (navigatorTreeNode2 == this || !(navigatorTreeNode2 instanceof ConnectionFolderOwnerTreeNode)) continue;
            ((ConnectionFolderOwnerTreeNode)navigatorTreeNode2).updateFolder(treePath, treePath2);
        }
    }

    private static interface ChildHandler {
        public void addChildToFolder(DatabasesFolder var1, DatabasesFolder var2);
    }

    private static interface RootHandler {
        public void addChildToRoot(DatabasesFolder var1);
    }

    private static interface PathCreationFunction {
        public TreePath createPath(String var1);
    }
}

