/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.utils;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleDriver;

public class ScriptUtils {
    private static final Logger LOGGER = Logger.getLogger(ScriptUtils.class.getName());

    public static String runAsScript(String string, String string2, LogPage logPage) {
        return ScriptUtils.runAsScript(new StringReader(string), string2, logPage, false);
    }

    public static String runAsScript(String string, String string2) {
        return ScriptUtils.runAsScript(new StringReader(string), string2, null, false);
    }

    public static void runAsScript(FileInputStream fileInputStream, String string, ScriptRunnerContext scriptRunnerContext) {
        ScriptUtils.runAsScript(new InputStreamReader(fileInputStream), string, null, false, scriptRunnerContext);
    }

    public static String runAsScript(InputStream inputStream, String string, LogPage logPage) {
        return ScriptUtils.runAsScript(new InputStreamReader(inputStream), string, logPage, false);
    }

    public static String runAsScript(InputStream inputStream, String string) {
        return ScriptUtils.runAsScript(new InputStreamReader(inputStream), string, null, false);
    }

    public static String runAsScript(Reader reader, String string) {
        return ScriptUtils.runAsScript(reader, string, null, false);
    }

    public static String runAsScript(Reader reader, String string, LogPage logPage, Boolean bl) {
        return ScriptUtils.runAsScript(reader, string, logPage, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runAsScript(Reader reader, String string, LogPage logPage, Boolean bl, ScriptRunnerContext scriptRunnerContext) {
        block14: {
            if (string == null) {
                string = ConnectionSelectorUI.getConnection(ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), string, true);
            }
            if (string != null) {
                Connection connection;
                block13: {
                    block12: {
                        if (logPage == null) {
                            logPage = LogManager.getLogManager().getMsgPage();
                        }
                        connection = null;
                        try {
                            connection = ScriptUtils.resolveConnectionName(string);
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof DBException)) break block12;
                            throw (DBException)((Object)exception);
                        }
                    }
                    if (connection != null) break block13;
                    String string2 = null;
                    return string2;
                }
                try {
                    ScriptExecutor scriptExecutor = new ScriptExecutor(reader, connection);
                    ScriptRunnerContext scriptRunnerContext2 = null;
                    scriptRunnerContext2 = scriptRunnerContext != null ? scriptRunnerContext : new ScriptRunnerContext();
                    scriptRunnerContext2.setCurrentConnection(connection);
                    scriptRunnerContext2.setBaseConnection(connection);
                    scriptRunnerContext2.setTopLevel(true);
                    scriptExecutor.setScriptRunnerContext(scriptRunnerContext2);
                    if (!bl.booleanValue()) {
                        PipedInputStream pipedInputStream = new PipedInputStream();
                        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, logPage);
                        outputRedirector.setName("Report output reader");
                        outputRedirector.start();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                        scriptExecutor.setOut(bufferedOutputStream);
                        scriptRunnerContext2.consumerRuning(true);
                        scriptExecutor.run();
                        outputRedirector.stopRun();
                        break block14;
                    }
                    scriptRunnerContext2.consumerRuning(true);
                    scriptExecutor.run();
                }
                catch (DBException dBException) {
                    Logger.getLogger(ScriptUtils.class.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(ScriptUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        return string;
    }

    public static String runSqlReturnResult(String string, Connection connection) {
        try {
            String string2 = ScriptRunnerContext.getOutputEncoding();
            StringReader stringReader = new StringReader(string);
            ScriptExecutor scriptExecutor = new ScriptExecutor((Reader)stringReader, connection);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)true);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            scriptExecutor.setOut(bufferedOutputStream);
            scriptExecutor.run();
            bufferedOutputStream.flush();
            return byteArrayOutputStream.toString(string2);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private static Connection resolveConnectionName(String string) throws Exception {
        return Connections.getInstance().getConnection(string);
    }

    public static void runFileInDialog(File file, Connection connection) {
        final File file2 = file;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setText("");
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;
            ScriptExecutor sr = null;

            @Override
            public void cancel() {
                this.sr.interrupt();
                this._isCanceled = true;
            }

            @Override
            public Object doWork() {
                Object var1_1 = null;
                this.sr = new ScriptExecutor("@" + file2.getAbsolutePath(), connection2);
                basicEditorPane.setEditable(true);
                this.sr.setScriptRunnerContext(new ScriptRunnerContext());
                this.sr.getScriptRunnerContext().setSubstitutionChar('^');
                this.sr.getScriptRunnerContext().setSubstitutionOn(false);
                this.sr.getScriptRunnerContext().setScanOn(false);
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                }
                catch (IOException iOException) {
                    LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
                }
                this.sr.setOut(bufferedOutputStream);
                this.sr.start();
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                outputRedirector.setName("Script output reader");
                outputRedirector.start();
                basicEditorPane.setEditable(false);
                while (this.sr.isAlive()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return var1_1;
            }

            @Override
            public void finish(Object object) {
                file2.deleteOnExit();
                if (this._isCanceled) {
                    try {
                        connection2.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe("Could not rollback");
                    }
                }
            }

            @Override
            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Installing", null, 500, iDelayedProgressRunnable, (Component)basicEditorPane);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    public static void runInDialog(String string, InputStream inputStream, final Connection connection, final boolean bl) {
        final InputStream inputStream2 = inputStream;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setText("");
        RaptorTask<Object> raptorTask = new RaptorTask<Object>(string, true, IRaptorTaskRunMode.MODAL){
            ScriptExecutor sr;
            {
                super(string, bl, iRaptorTaskRunMode);
                this.sr = null;
            }

            public boolean cancel() {
                this.sr.interrupt();
                return true;
            }

            protected Object doWork() throws TaskException {
                Object var1_1 = null;
                this.sr = new ScriptExecutor(inputStream2, connection2);
                basicEditorPane.setEditable(true);
                this.sr.setScriptRunnerContext(new ScriptRunnerContext());
                this.sr.getScriptRunnerContext().setSubstitutionChar('^');
                this.sr.getScriptRunnerContext().setSubstitutionOn(false);
                this.sr.getScriptRunnerContext().setScanOn(false);
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                }
                catch (IOException iOException) {
                    LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
                }
                this.sr.setOut(bufferedOutputStream);
                this.sr.start();
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                outputRedirector.setLogPage(LogManager.getLogManager().getMsgPage());
                outputRedirector.setName("Script output reader");
                outputRedirector.start();
                basicEditorPane.setEditable(false);
                while (this.sr.isAlive()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return var1_1;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                LOGGER.warning(RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                LOGGER.warning(RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                if (bl) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe(sQLException.getLocalizedMessage());
                    }
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public static void showError(BasicEditorPane basicEditorPane) {
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)"Error", (int)2);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)IdeUtil.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("");
            System.err.println("");
            System.err.println("Usage: java oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils username/password@tns @klr.sql define1 define2 define3 ...");
            System.err.println("");
            System.err.println("");
            System.exit(1);
        }
        String string = stringArray[0].substring(0, stringArray[0].indexOf("/"));
        String string2 = stringArray[0].substring(stringArray[0].indexOf("/") + 1, stringArray[0].indexOf("@"));
        String string3 = stringArray[0].substring(stringArray[0].indexOf("@") + 1);
        String string4 = "jdbc:oracle:thin:@" + string3;
        Object object = null;
        object = stringArray[1].indexOf("@") == 0 ? stringArray[1].substring(1) : stringArray[1];
        File file = new File((String)object);
        if (!file.exists() && ((String)object).indexOf(".") == -1) {
            object = (String)object + ".sql";
        }
        if (!file.exists() && ((String)object).indexOf(".") == -1) {
            object = (String)object + ".sql";
        }
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        for (int i = 2; i < stringArray.length; ++i) {
            scriptRunnerContext.getMap().put("" + (i - 1), stringArray[i]);
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string4, string, string2);
        connection.setAutoCommit(false);
        ScriptExecutor scriptExecutor = new ScriptExecutor((InputStream)new FileInputStream((String)object), connection);
        scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
        scriptExecutor.run();
    }
}

