/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.Context;
import oracle.ide.model.Element;

public class RestLoadData {
    public static final String PARSING_SCHEMA = "PARSING_SCHEMA";
    public static final String URL_MAPPING = "URL_MAPPING";
    public static final String PATTERN = "PATTERN";
    public static final String SCHEMA_STATUS = "SCHEMA_STATUS";
    public static final String AUTO_REST_AUTH = "AUTO_REST_AUTH";
    public static final String ORDS_VERSION = "ORDS_VERSION";
    public static final String MODULE_NAME = "MODULE_NAME";
    public static final String URI_PREFIX = "URI_PREFIX";
    public static final String TEMPLATE_ID = "TEMPLATE_ID";
    public static final String URI_TEMPLATE = "URI_TEMPLATE";
    public static final String METHOD = "METHOD";
    public static final String PRIVILEGE_NAME = "PRIVILEGE_NAME";
    public static final String SELECTED_MODULE_NAMES = "SELECTED_MODULE_NAMES";
    public static final String ROLE_NAME = "NAME";
    private static final String ITEMS_PER_PAGE = "ITEMS_PER_PAGE";
    private static final String MODULE_COMMENTS = "MODULE_COMMENTS";
    private static final String ORIGINS_ALLOWED = "ORIGINS_ALLOWED";
    private static final String STATUS = "STATUS";
    private static final String ETAG_TYPE = "ETAG_TYPE";
    private static final String ETAG_QUERY = "ETAG_QUERY";
    private static final String PRIORITY = "PRIORITY";
    private static final String TEMPLATE_COMMENTS = "TEMPLATE_COMMENTS";
    private static final String HANDLER_COMMENTS = "HANDLER_COMMENTS";
    private static final String HANDLER_ITEMS_PER_PAGE = "HANDLER_ITEMS_PER_PAGE";
    private static final String MIMES_ALLOWED = "MIMES_ALLOWED";
    private static final String SOURCE = "SOURCE";
    private static final String SOURCE_TYPE = "SOURCE_TYPE";
    private static final String ACCESS_METHOD = "ACCESS_METHOD";
    private static final String BIND_VARIABLE_NAME = "BIND_VARIABLE_NAME";
    private static final String PARAMETER_COMMENTS = "PARAMETER_COMMENTS";
    private static final String PARAMETER_NAME = "PARAMETER_NAME";
    private static final String PARAM_SOURCE_TYPE = "SOURCE_TYPE";
    private static final String PARAM_TYPE = "PARAM_TYPE";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String LABEL = "LABEL";
    private static final String PATTERNS = "PATTERNS";
    private static final String PRIVILEGE_COMMENTS = "PRIVILEGE_COMMENTS";
    private static final String SELECTED_ROLE_NAMES = "SELECTED_ROLE_NAMES";

    public static RestSchema createRestSchema(DBObject dBObject) {
        return new RestLoadData().createSchema(dBObject, null, true);
    }

    public static RestSchema createRestSchema(NavigatorTreeNode navigatorTreeNode) {
        RestSchema restSchema = null;
        if (navigatorTreeNode.getChildCount() > 0) {
            restSchema = new RestLoadData().getSchema(navigatorTreeNode);
        } else {
            ObjectFolder objectFolder = (ObjectFolder)navigatorTreeNode.getElement();
            restSchema = new RestLoadData().loadSchema(objectFolder);
        }
        return restSchema;
    }

    public static RestModule createRestModuleTemplateHandler(Context context) {
        return new RestLoadData().createModuleTemplateHandler(context, 0L);
    }

    public static RestModule createRestModuleTemplatesHandlers(DBObjectInstance dBObjectInstance) {
        return new RestLoadData().createModuleTemplatesHandlers(dBObjectInstance);
    }

    public static RestModule createRestModuleTemplatesHandlers(DBObject dBObject) {
        return new RestLoadData().createModuleTemplatesHandlers(dBObject);
    }

    public static RestModule createModuleTemplateHandlerExcludeTemplate(Context context, long l) {
        return new RestLoadData().createModuleTemplateHandler(context, l);
    }

    public static RestModule createRestModule(DBObject dBObject) {
        return new RestLoadData().createModule(dBObject, null, true);
    }

    public static List<RestModule> createModules(NavigatorTreeNode navigatorTreeNode, List<String> list) {
        ArrayList<RestModule> arrayList = new ArrayList();
        if (navigatorTreeNode.getChildCount() > 0) {
            arrayList = new RestLoadData().getModules(navigatorTreeNode, list);
        } else {
            ObjectFolder objectFolder = (ObjectFolder)navigatorTreeNode.getElement();
            arrayList = RestLoadData.loadModules(objectFolder, list);
        }
        return arrayList;
    }

    public static RestTemplate createTemplateHandlerExcludMethod(Context context, String string) {
        return new RestLoadData().creatTemplateHandlers(context, string);
    }

    public static RestTemplate createRestTemplate(DBObject dBObject) {
        return new RestLoadData().createTemplate(dBObject);
    }

    public static RestResourceHandler createRestHandler(DBObject dBObject) {
        return new RestLoadData().createHandler(dBObject);
    }

    public static List<RestResourceHandler> createRestHandlers(Context context) {
        return new RestLoadData().createHandlers(context);
    }

    public static List<RestTemplate> createRestTemplatesHandlers(Context context) {
        return new RestLoadData().createTemplatesHandlers(context);
    }

    public static RestPrivilege createRestPrivilege(DBObject dBObject) {
        return new RestLoadData().createPrivilege(dBObject, null, true);
    }

    public static RestPrivilege createRestPrivilege(DBChildInstance dBChildInstance) {
        return new RestLoadData().createPrivilege(null, dBChildInstance, false);
    }

    public static void retreiveRestModuleNamesUriPrefixes(NavigatorTreeNode navigatorTreeNode, List<String> list, List<String> list2, String string) {
        new RestLoadData().retreiveModuleNamesUriPrefixes(navigatorTreeNode, list, list2, string);
    }

    public static void retreiveRestTemplateUris(NavigatorTreeNode navigatorTreeNode, List<String> list, String string) {
        new RestLoadData().retreiveTemplateUris(navigatorTreeNode, list, string);
    }

    private RestSchema getSchema(NavigatorTreeNode navigatorTreeNode) {
        DBObject dBObject;
        NavigatorTreeNode navigatorTreeNode2;
        Element element;
        RestSchema restSchema = null;
        if (navigatorTreeNode != null && navigatorTreeNode.getChildCount() > 0 && (element = (navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getFirstChild()).getElement()) != null && (dBObject = new DBObject(element)) != null) {
            restSchema = this.createSchema(dBObject, null, true);
        }
        return restSchema;
    }

    private RestSchema loadSchema(ObjectFolder objectFolder) {
        RestSchema restSchema = null;
        try {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            List list = dBFolderInstance.listChildren();
            if (list != null && list.size() > 0) {
                DBObjectInstance dBObjectInstance = (DBObjectInstance)list.get(0);
                restSchema = this.createSchema(null, (DBChildInstance)dBObjectInstance, false);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(RestLoadData.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return restSchema;
    }

    private RestSchema createSchema(DBObject dBObject, DBChildInstance dBChildInstance, boolean bl) {
        Map map = null;
        if (bl) {
            if (dBObject == null) {
                return null;
            }
            map = dBObject.getDictionary();
            if (map == null) {
                return null;
            }
        } else if (dBChildInstance == null) {
            return null;
        }
        String string = bl ? (String)map.get(PARSING_SCHEMA) : (String)dBChildInstance.getProperty(PARSING_SCHEMA);
        String string2 = bl ? (String)map.get(URL_MAPPING) : (String)dBChildInstance.getProperty(URL_MAPPING);
        String string3 = bl ? (String)map.get(PATTERN) : (String)dBChildInstance.getProperty(PATTERN);
        String string4 = bl ? (String)map.get(SCHEMA_STATUS) : (String)dBChildInstance.getProperty(SCHEMA_STATUS);
        String string5 = bl ? (String)map.get(AUTO_REST_AUTH) : (String)dBChildInstance.getProperty(AUTO_REST_AUTH);
        String string6 = bl ? (String)map.get(ORDS_VERSION) : (String)dBChildInstance.getProperty(ORDS_VERSION);
        RestSchema restSchema = new RestSchema(string, string2, string3, string4, string5, string6);
        return restSchema;
    }

    private RestModule createModuleTemplateHandler(Context context, long l) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        RestModule restModule = null;
        if (dBObject != null) {
            NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
            if (dBObject.getObjectType().equals("REST_TEMPLATE")) {
                navigatorTreeNode = (NavigatorTreeNode)navigatorTreeNode.getParent();
            }
            if ((restModule = this.createModule(dBObject, null, true)) != null) {
                boolean bl;
                List<RestTemplate> list = null;
                boolean bl2 = bl = navigatorTreeNode.getChildCount() > 0;
                if (bl) {
                    list = this.createTemplatesHandlers(navigatorTreeNode, l);
                } else {
                    DBObjectInstance dBObjectInstance = ((ObjectNode)navigatorTreeNode.getElement()).getNodeInstance();
                    if (dBObjectInstance != null) {
                        list = this.loadTemplatesHandlers(dBObjectInstance, l);
                    }
                }
                restModule.setTemplates(list);
            }
        }
        return restModule;
    }

    private RestModule createModuleTemplatesHandlers(DBObject dBObject) {
        RestModule restModule = null;
        if (dBObject != null) {
            NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(dBObject);
            restModule = this.createModule(dBObject, null, true);
            if (navigatorTreeNode != null) {
                boolean bl;
                List<RestTemplate> list = null;
                boolean bl2 = bl = navigatorTreeNode.getChildCount() > 0;
                if (bl) {
                    list = this.createTemplatesHandlers(navigatorTreeNode, 0L);
                } else {
                    DBObjectInstance dBObjectInstance = ((ObjectNode)navigatorTreeNode.getElement()).getNodeInstance();
                    list = this.loadTemplatesHandlers(dBObjectInstance, 0L);
                }
                restModule.setTemplates(list);
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The moduleNode is null.");
            }
        }
        return restModule;
    }

    private RestModule createModuleTemplatesHandlers(DBObjectInstance dBObjectInstance) {
        List<RestTemplate> list;
        RestModule restModule = null;
        if (dBObjectInstance != null && (restModule = this.createModule(null, (DBChildInstance)dBObjectInstance, false)) != null && (list = this.loadTemplatesHandlers(dBObjectInstance, 0L)) != null && !list.isEmpty()) {
            restModule.setTemplates(list);
        }
        return restModule;
    }

    public static List<RestModule> loadModules(ObjectFolder objectFolder, List<String> list) {
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        boolean bl = list != null && !list.isEmpty();
        try {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            List list2 = dBFolderInstance.listChildren();
            for (DBChildInstance dBChildInstance : list2) {
                RestModule restModule;
                String string = (String)dBChildInstance.getProperty(ROLE_NAME);
                if (string == null) continue;
                DBObjectInstance dBObjectInstance = null;
                if (bl) {
                    if (list.contains(string)) {
                        dBObjectInstance = (DBObjectInstance)dBChildInstance;
                    }
                } else {
                    dBObjectInstance = (DBObjectInstance)dBChildInstance;
                }
                if (dBObjectInstance == null || (restModule = RestLoadData.createRestModuleTemplatesHandlers(dBObjectInstance)) == null) continue;
                arrayList.add(restModule);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(RestLoadData.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return arrayList;
    }

    private List<RestModule> getModules(NavigatorTreeNode navigatorTreeNode, List<String> list) {
        boolean bl;
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        boolean bl2 = bl = list != null && !list.isEmpty();
        if (navigatorTreeNode != null) {
            Enumeration enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                String string;
                DBObject dBObject;
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                Element element = navigatorTreeNode2.getElement();
                if (element == null || (dBObject = new DBObject(element)) == null) continue;
                Map map = dBObject.getDictionary();
                if (map == null) {
                    return null;
                }
                Set set = map.keySet();
                if (set == null || !set.contains(MODULE_NAME) || RestUtils.nullOrEmpty(string = (String)map.get(MODULE_NAME))) continue;
                RestModule restModule = null;
                if (bl) {
                    if (list.contains(string)) {
                        restModule = RestLoadData.createRestModuleTemplatesHandlers(dBObject);
                    }
                } else {
                    restModule = RestLoadData.createRestModuleTemplatesHandlers(dBObject);
                }
                if (restModule == null) continue;
                arrayList.add(restModule);
            }
        }
        return arrayList;
    }

    private List<RestTemplate> loadTemplatesHandlers(DBObjectInstance dBObjectInstance, long l) {
        ArrayList<RestTemplate> arrayList = new ArrayList<RestTemplate>();
        try {
            List list;
            if (dBObjectInstance != null && (list = dBObjectInstance.listChildren("REST_TEMPLATE")) != null && !list.isEmpty()) {
                for (DBChildInstance dBChildInstance : list) {
                    RestTemplate restTemplate;
                    String string = (String)dBChildInstance.getProperty(URI_TEMPLATE);
                    long l2 = -1L;
                    Object object = dBChildInstance.getProperty(TEMPLATE_ID);
                    if (object != null && object instanceof BigDecimal) {
                        l2 = ((BigDecimal)object).longValue();
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot obtain the template id for the resource template");
                    }
                    if (RestUtils.emptyValue(string) || l != 0L && l == l2 || (restTemplate = this.createTemplate(dBChildInstance)) == null) continue;
                    arrayList.add(restTemplate);
                    DBObjectInstance dBObjectInstance2 = (DBObjectInstance)dBChildInstance;
                    List<RestResourceHandler> list2 = this.loadHandlers(dBObjectInstance2);
                    if (list2 == null || list2.isEmpty()) continue;
                    restTemplate.setResourceHandlers(list2);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            return null;
        }
        return arrayList;
    }

    private List<RestResourceHandler> loadHandlers(DBObjectInstance dBObjectInstance) {
        ArrayList<RestResourceHandler> arrayList = new ArrayList<RestResourceHandler>();
        if (dBObjectInstance != null) {
            List list = null;
            try {
                list = dBObjectInstance.listChildren("REST_HANDLER");
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
                return null;
            }
            if (list != null) {
                for (DBChildInstance dBChildInstance : list) {
                    RestResourceHandler restResourceHandler;
                    String string = (String)dBChildInstance.getProperty(METHOD);
                    if (RestUtils.emptyValue(string) || (restResourceHandler = this.createHandler(null, dBChildInstance, false)) == null) continue;
                    arrayList.add(restResourceHandler);
                }
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot get the template's handlers.");
            }
        }
        return arrayList;
    }

    private RestTemplate creatTemplateHandlers(Context context, String string) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        RestTemplate restTemplate = null;
        if (dBObject != null) {
            if (!dBObject.getObjectType().equals("REST_TEMPLATE") && dBObject.getObjectType().equals("REST_HANDLER")) {
                navigatorTreeNode = (NavigatorTreeNode)navigatorTreeNode.getParent();
            }
            restTemplate = this.createTemplate(dBObject);
            Enumeration enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DBObject dBObject2;
                RestResourceHandler restResourceHandler;
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                Element element = navigatorTreeNode2.getElement();
                if (string != null && element.getShortLabel().equals(string) || (restResourceHandler = this.createHandler(dBObject2 = new DBObject(element))) == null) continue;
                restTemplate.addResourceHandler(restResourceHandler.getMethodType(), restResourceHandler);
            }
        }
        return restTemplate;
    }

    private List<RestTemplate> createTemplatesHandlers(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        List<RestTemplate> list = this.createTemplatesHandlers(navigatorTreeNode, 0L);
        return list;
    }

    private List<RestResourceHandler> createHandlers(Context context) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null && navigatorTreeNode.getElement() instanceof ObjectNode) {
            return this.createHandlers(navigatorTreeNode);
        }
        return null;
    }

    private List<RestResourceHandler> createHandlers(NavigatorTreeNode navigatorTreeNode) {
        List<RestResourceHandler> list = new ArrayList<RestResourceHandler>();
        if (navigatorTreeNode != null && navigatorTreeNode.getElement() instanceof ObjectNode) {
            boolean bl;
            boolean bl2 = bl = navigatorTreeNode.getChildCount() > 0;
            if (bl) {
                Enumeration enumeration = navigatorTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                    Element element = navigatorTreeNode2.getElement();
                    DBObject dBObject = new DBObject(element);
                    RestResourceHandler restResourceHandler = this.createHandler(dBObject);
                    if (restResourceHandler == null) continue;
                    list.add(restResourceHandler);
                }
            } else {
                DBObjectInstance dBObjectInstance = ((ObjectNode)navigatorTreeNode.getElement()).getNodeInstance();
                list = this.loadHandlers(dBObjectInstance);
            }
        }
        return list;
    }

    private List<RestTemplate> createTemplatesHandlers(NavigatorTreeNode navigatorTreeNode, long l) {
        ArrayList<RestTemplate> arrayList = new ArrayList<RestTemplate>();
        Enumeration enumeration = navigatorTreeNode.children();
        while (enumeration.hasMoreElements()) {
            RestTemplate restTemplate;
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
            Element element = navigatorTreeNode2.getElement();
            DBObject dBObject = new DBObject(element);
            long l2 = -1L;
            Object v = dBObject.getDictionary().get(TEMPLATE_ID);
            if (v != null && v instanceof BigDecimal) {
                l2 = ((BigDecimal)v).longValue();
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot obtain the template id for the resource template");
            }
            if (l != 0L && l == l2 || (restTemplate = this.createTemplate(dBObject)) == null) continue;
            arrayList.add(restTemplate);
            List<RestResourceHandler> list = this.createHandlers(navigatorTreeNode2);
            if (list == null || list.size() <= 0) continue;
            restTemplate.setResourceHandlers(list);
        }
        return arrayList;
    }

    private void retreiveModuleNamesUriPrefixes(NavigatorTreeNode navigatorTreeNode, List<String> list, List<String> list2, String string) {
        NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
        Enumeration enumeration = navigatorTreeNode2.children();
        while (enumeration.hasMoreElements()) {
            NavigatorTreeNode navigatorTreeNode3 = (NavigatorTreeNode)enumeration.nextElement();
            Element element = navigatorTreeNode3.getElement();
            if (string != null && element.getShortLabel().equals(string)) continue;
            DBObject dBObject = new DBObject(element);
            Map map = dBObject.getDictionary();
            String string2 = null;
            if (map.containsKey(MODULE_NAME) && !RestUtils.nullOrEmpty(string2 = (String)map.get(MODULE_NAME))) {
                list.add(string2);
            }
            if (!map.containsKey(URI_PREFIX) || RestUtils.nullOrEmpty(string2 = (String)map.get(URI_PREFIX))) continue;
            list2.add(string2);
        }
    }

    private void retreiveTemplateUris(NavigatorTreeNode navigatorTreeNode, List<String> list, String string) {
        NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent();
        Enumeration enumeration = navigatorTreeNode2.children();
        while (enumeration.hasMoreElements()) {
            NavigatorTreeNode navigatorTreeNode3 = (NavigatorTreeNode)enumeration.nextElement();
            Element element = navigatorTreeNode3.getElement();
            if (string != null && element.getShortLabel().equals(string)) continue;
            DBObject dBObject = new DBObject(element);
            Map map = dBObject.getDictionary();
            String string2 = null;
            if (!map.containsKey(URI_TEMPLATE) || RestUtils.nullOrEmpty(string2 = (String)map.get(URI_TEMPLATE))) continue;
            list.add(string2);
        }
    }

    private RestModule createModule(DBObject dBObject, DBChildInstance dBChildInstance, boolean bl) {
        Object object;
        Map map = null;
        Set set = null;
        if (bl) {
            if (dBObject == null) {
                return null;
            }
            map = dBObject.getDictionary();
            if (map == null) {
                return null;
            }
            set = map.keySet();
        } else {
            if (dBChildInstance == null) {
                return null;
            }
            set = dBChildInstance.getPropertyKeys();
        }
        RestModule restModule = new RestModule();
        String string = null;
        if (set.contains(MODULE_NAME)) {
            String string2 = string = bl ? (String)map.get(MODULE_NAME) : (String)dBChildInstance.getProperty(MODULE_NAME);
            if (!RestUtils.nullOrEmpty(string)) {
                restModule.setName(string);
            }
        }
        if (set.contains(URI_PREFIX)) {
            String string3 = string = bl ? (String)map.get(URI_PREFIX) : (String)dBChildInstance.getProperty(URI_PREFIX);
            if (!RestUtils.nullOrEmpty(string)) {
                restModule.setURIPrefix(string);
            }
        }
        if (set.contains(ITEMS_PER_PAGE)) {
            Object object2 = object = bl ? map.get(ITEMS_PER_PAGE) : dBChildInstance.getProperty(ITEMS_PER_PAGE);
            if (object != null) {
                long l = 0L;
                if (object instanceof Long) {
                    l = (Long)object;
                } else if (object instanceof BigDecimal) {
                    l = ((BigDecimal)object).longValue();
                }
                restModule.setPaginationSize(l);
            }
        }
        if (set.contains(STATUS)) {
            String string4 = string = bl ? (String)map.get(STATUS) : (String)dBChildInstance.getProperty(STATUS);
            if (!RestUtils.nullOrEmpty(string)) {
                restModule.setPublished(string);
            }
        }
        if (set.contains(ORIGINS_ALLOWED)) {
            String string5 = string = bl ? (String)map.get(ORIGINS_ALLOWED) : (String)dBChildInstance.getProperty(ORIGINS_ALLOWED);
            if (!RestUtils.nullOrEmpty(string)) {
                object = this.createList(string.trim());
                restModule.setOrigins(object);
            }
        }
        if (set.contains(MODULE_COMMENTS)) {
            String string6 = string = bl ? (String)map.get(MODULE_COMMENTS) : (String)dBChildInstance.getProperty(MODULE_COMMENTS);
            if (!RestUtils.nullOrEmpty(string)) {
                restModule.setComments(string);
            }
        }
        return restModule;
    }

    private RestTemplate createTemplate(DBObject dBObject) {
        return this.createTemplate(dBObject, null, true);
    }

    private RestTemplate createTemplate(DBChildInstance dBChildInstance) {
        return this.createTemplate(null, dBChildInstance, false);
    }

    private RestTemplate createTemplate(DBObject dBObject, DBChildInstance dBChildInstance, boolean bl) {
        Map map = null;
        Set set = null;
        if (bl) {
            if (dBObject == null) {
                return null;
            }
            map = dBObject.getDictionary();
            if (map == null) {
                return null;
            }
            set = map.keySet();
        } else {
            if (dBChildInstance == null) {
                return null;
            }
            set = dBChildInstance.getPropertyKeys();
        }
        RestTemplate restTemplate = new RestTemplate();
        String string = null;
        if (set.contains(URI_TEMPLATE)) {
            String string2 = string = bl ? (String)map.get(URI_TEMPLATE) : (String)dBChildInstance.getProperty(URI_TEMPLATE);
            if (!RestUtils.nullOrEmpty(string)) {
                restTemplate.setURIPattern(string);
            }
        }
        if (set.contains(PRIORITY)) {
            Object object;
            Object object2 = object = bl ? map.get(PRIORITY) : dBChildInstance.getProperty(PRIORITY);
            if (object != null) {
                int n = 0;
                if (object instanceof Integer) {
                    n = (Integer)object;
                } else if (object instanceof BigDecimal) {
                    n = ((BigDecimal)object).intValue();
                }
                restTemplate.setPriority(n);
            }
        }
        if (set.contains(ETAG_TYPE)) {
            String string3 = string = bl ? (String)map.get(ETAG_TYPE) : (String)dBChildInstance.getProperty(ETAG_TYPE);
            if (!RestUtils.nullOrEmpty(string)) {
                restTemplate.setEntityTag(string);
            }
        }
        if (set.contains(ETAG_QUERY)) {
            String string4 = string = bl ? (String)map.get(ETAG_QUERY) : (String)dBChildInstance.getProperty(ETAG_QUERY);
            if (!RestUtils.nullOrEmpty(string)) {
                restTemplate.setEntityTagQuery(string);
            }
        }
        if (set.contains(TEMPLATE_COMMENTS)) {
            String string5 = string = bl ? (String)map.get(TEMPLATE_COMMENTS) : (String)dBChildInstance.getProperty(TEMPLATE_COMMENTS);
            if (!RestUtils.nullOrEmpty(string)) {
                restTemplate.setComments(string);
            }
        }
        return restTemplate;
    }

    private RestResourceHandler createHandler(DBObject dBObject) {
        return this.createHandler(dBObject, null, true);
    }

    private RestResourceHandler createHandler(DBObject dBObject, DBChildInstance dBChildInstance, boolean bl) {
        Object object;
        List<RestHandlerParameter> list;
        Map map = null;
        Set set = null;
        if (bl) {
            if (dBObject == null) {
                return null;
            }
            map = dBObject.getDictionary();
            if (map == null) {
                return null;
            }
            set = map.keySet();
        } else {
            if (dBChildInstance == null) {
                return null;
            }
            set = dBChildInstance.getPropertyKeys();
        }
        RestResourceHandler restResourceHandler = new RestResourceHandler();
        String string = null;
        if (set.contains(METHOD)) {
            String string2 = string = bl ? (String)map.get(METHOD) : (String)dBChildInstance.getProperty(METHOD);
            if (!RestUtils.nullOrEmpty(string)) {
                restResourceHandler.setMethodType(string);
            }
        }
        if (set.contains("SOURCE_TYPE")) {
            String string3 = string = bl ? (String)map.get("SOURCE_TYPE") : (String)dBChildInstance.getProperty("SOURCE_TYPE");
            if (!RestUtils.nullOrEmpty(string)) {
                restResourceHandler.setSourceType(string);
            }
        }
        if (set.contains(SOURCE)) {
            list = bl ? (Clob)map.get(SOURCE) : (Clob)dBChildInstance.getProperty(SOURCE);
            try {
                string = list.getSubString(1L, (int)list.length());
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
            }
            if (!RestUtils.nullOrEmpty(string)) {
                restResourceHandler.setSQL(string);
            }
        }
        if (set.contains(HANDLER_ITEMS_PER_PAGE)) {
            Object object2 = list = bl ? map.get(HANDLER_ITEMS_PER_PAGE) : dBChildInstance.getProperty(HANDLER_ITEMS_PER_PAGE);
            if (list != null) {
                long l = 0L;
                if (list instanceof Long) {
                    l = (Long)((Object)list);
                } else if (list instanceof BigDecimal) {
                    l = ((BigDecimal)((Object)list)).longValue();
                }
                restResourceHandler.setPaginationSize(l);
            }
        }
        if (set.contains(MIMES_ALLOWED)) {
            List<RestHandlerParameter> list2 = list = bl ? (String)map.get(MIMES_ALLOWED) : (String)dBChildInstance.getProperty(MIMES_ALLOWED);
            if (!RestUtils.nullOrEmpty((String)((Object)list))) {
                object = this.createList(((String)((Object)list)).trim());
                restResourceHandler.setMimeTypes((List)object);
            }
        }
        if (set.contains(HANDLER_COMMENTS)) {
            String string4 = string = bl ? (String)map.get(HANDLER_COMMENTS) : (String)dBChildInstance.getProperty(HANDLER_COMMENTS);
            if (!RestUtils.nullOrEmpty(string)) {
                restResourceHandler.setComments(string);
            }
        }
        try {
            list = null;
            object = null;
            object = bl ? ((ObjectNode)dBObject.getNode()).getNodeInstance() : (DBObjectInstance)dBChildInstance;
            if (object != null && (list = this.createParameters((DBObjectInstance)object)) != null && !list.isEmpty()) {
                restResourceHandler.setParameters(list);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return restResourceHandler;
    }

    private List<RestHandlerParameter> createParameters(DBObjectInstance dBObjectInstance) {
        try {
            List list;
            if (dBObjectInstance != null && (list = dBObjectInstance.listChildren("REST_PARAMETER")) != null && !list.isEmpty()) {
                ArrayList<RestHandlerParameter> arrayList = new ArrayList<RestHandlerParameter>();
                for (DBChildInstance dBChildInstance : list) {
                    RestHandlerParameter restHandlerParameter = this.createParameter(null, dBChildInstance, false);
                    arrayList.add(restHandlerParameter);
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return null;
    }

    private RestHandlerParameter createParameter(DBObject dBObject, DBChildInstance dBChildInstance, boolean bl) {
        Map map = null;
        Set set = null;
        if (bl) {
            if (dBObject == null) {
                return null;
            }
            map = dBObject.getDictionary();
            if (map == null) {
                return null;
            }
            set = map.keySet();
        } else {
            if (dBChildInstance == null) {
                return null;
            }
            set = dBChildInstance.getPropertyKeys();
        }
        RestHandlerParameter restHandlerParameter = new RestHandlerParameter();
        String string = null;
        if (set.contains(PARAMETER_NAME)) {
            String string2 = string = bl ? (String)map.get(PARAMETER_NAME) : (String)dBChildInstance.getProperty(PARAMETER_NAME);
            if (!RestUtils.nullOrEmpty(string)) {
                restHandlerParameter.setName(string);
            }
        }
        if (set.contains(BIND_VARIABLE_NAME)) {
            String string3 = string = bl ? (String)map.get(BIND_VARIABLE_NAME) : (String)dBChildInstance.getProperty(BIND_VARIABLE_NAME);
            if (!RestUtils.nullOrEmpty(string)) {
                restHandlerParameter.setBindVariable(string);
            }
        }
        if (set.contains(ACCESS_METHOD)) {
            String string4 = string = bl ? (String)map.get(ACCESS_METHOD) : (String)dBChildInstance.getProperty(ACCESS_METHOD);
            if (!RestUtils.nullOrEmpty(string)) {
                restHandlerParameter.setAccessMethod(string);
            }
        }
        if (set.contains("SOURCE_TYPE")) {
            String string5 = string = bl ? (String)map.get("SOURCE_TYPE") : (String)dBChildInstance.getProperty("SOURCE_TYPE");
            if (!RestUtils.nullOrEmpty(string)) {
                restHandlerParameter.setSourceType(string);
            }
        }
        if (set.contains(PARAM_TYPE)) {
            String string6 = string = bl ? (String)map.get(PARAM_TYPE) : (String)dBChildInstance.getProperty(PARAM_TYPE);
            if (!RestUtils.nullOrEmpty(string)) {
                restHandlerParameter.setDataType(string);
            }
        }
        if (set.contains(PARAMETER_COMMENTS)) {
            String string7 = string = bl ? (String)map.get(PARAMETER_COMMENTS) : (String)dBChildInstance.getProperty(PARAMETER_COMMENTS);
            if (!RestUtils.nullOrEmpty(string)) {
                restHandlerParameter.setComments(string);
            }
        }
        return restHandlerParameter;
    }

    private RestPrivilege createPrivilege(DBObject dBObject, DBChildInstance dBChildInstance, boolean bl) {
        List<String> list;
        Map map = null;
        Set set = null;
        if (bl) {
            if (dBObject == null) {
                return null;
            }
            map = dBObject.getDictionary();
            if (map == null) {
                return null;
            }
            set = map.keySet();
        } else {
            if (dBChildInstance == null) {
                return null;
            }
            set = dBChildInstance.getPropertyKeys();
        }
        RestPrivilege restPrivilege = new RestPrivilege();
        String string = null;
        if (set.contains(PRIVILEGE_NAME)) {
            String string2 = string = bl ? (String)map.get(PRIVILEGE_NAME) : (String)dBChildInstance.getProperty(PRIVILEGE_NAME);
            if (!RestUtils.nullOrEmpty(string)) {
                restPrivilege.setName(string);
            }
        }
        if (set.contains(LABEL)) {
            String string3 = string = bl ? (String)map.get(LABEL) : (String)dBChildInstance.getProperty(LABEL);
            if (!RestUtils.nullOrEmpty(string)) {
                restPrivilege.setTitle(string);
            }
        }
        if (set.contains(DESCRIPTION)) {
            String string4 = string = bl ? (String)map.get(DESCRIPTION) : (String)dBChildInstance.getProperty(DESCRIPTION);
            if (!RestUtils.nullOrEmpty(string)) {
                restPrivilege.setDescription(string);
            }
        }
        if (set.contains(SELECTED_ROLE_NAMES)) {
            String string5 = string = bl ? (String)map.get(SELECTED_ROLE_NAMES) : (String)dBChildInstance.getProperty(SELECTED_ROLE_NAMES);
            if (!RestUtils.nullOrEmpty(string)) {
                list = RestLoadData.parseValues(string);
                restPrivilege.setRoles(list);
            }
        }
        if (set.contains(SELECTED_MODULE_NAMES)) {
            String string6 = string = bl ? (String)map.get(SELECTED_MODULE_NAMES) : (String)dBChildInstance.getProperty(SELECTED_MODULE_NAMES);
            if (!RestUtils.nullOrEmpty(string)) {
                list = RestLoadData.parseValues(string);
                restPrivilege.setModules(list);
            }
        }
        if (set.contains(PATTERNS)) {
            String string7 = string = bl ? (String)map.get(PATTERNS) : (String)dBChildInstance.getProperty(PATTERNS);
            if (!RestUtils.nullOrEmpty(string)) {
                list = RestLoadData.parseValues(string);
                restPrivilege.setURIPatterns(list);
            }
        }
        if (set.contains(PRIVILEGE_COMMENTS)) {
            String string8 = string = bl ? (String)map.get(PRIVILEGE_COMMENTS) : (String)dBChildInstance.getProperty(PRIVILEGE_COMMENTS);
            if (!RestUtils.nullOrEmpty(string)) {
                restPrivilege.setComments(string);
            }
        }
        return restPrivilege;
    }

    public static List<String> parseValues(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && (stringArray = string.split("\\|\\^\\|")) != null) {
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private List<String> createList(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split(",")) {
            arrayList.add(string2);
        }
        return arrayList;
    }
}

