/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.NameInUseException;
import oracle.aurora.rdbms.NoSchema;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.ReferencingHandle;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SourceHandle;
import oracle.aurora.rdbms.WouldReplaceException;
import oracle.aurora.util.classfile.Mutable;
import oracle.aurora.util.classfile.Raw;
import oracle.aurora.util.tools.ToolException;
import oracle.sql.CHAR;

public final class ClassHandle
extends ReferencingHandle {
    ClassHandle(String name, Schema schema, long index, byte[] timestamp) {
        super(name, schema, index, timestamp);
    }

    public int type() {
        return 29;
    }

    public SourceHandle derivedFrom() throws ObjectTypeChangedException {
        return this.doDerivedFrom();
    }

    public void setResolver(Resolver newResolver) throws ObjectTypeChangedException {
        this.doSetResolver(newResolver);
    }

    private static native void create(byte[] var0, int var1, String[] var2, int[] var3, boolean var4, boolean var5, boolean var6, boolean var7, HandleHolder var8, String var9) throws NameInUseException, WouldReplaceException, ModifyPermissionException;

    public static ClassHandle create(byte[] classFileImage, Schema schema, Resolver resolver, boolean definersRights, boolean allowReplace, boolean replaceOnlyIfChanged, boolean andResolve) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        if (classFileImage == null) {
            throw new IllegalArgumentException("classFileImage can not be null");
        }
        if (schema == null) {
            schema = Schema.currentSchema();
        }
        if (schema instanceof NoSchema) {
            throw new IllegalArgumentException("Schema instanceof NoSchema");
        }
        if (resolver == null) {
            resolver = Resolver.defaultCreateHandleResolver(schema);
        }
        int id = schema.ownerNumber();
        HandleHolder holder = new HandleHolder();
        try {
            ClassHandle.create(classFileImage, id, resolver.patterns(), resolver.ownerNumbers(), definersRights, allowReplace, replaceOnlyIfChanged, andResolve, holder, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow("ClassHandle.create in schema " + schema.toString());
        }
        ClassHandle h = (ClassHandle)holder.handle;
        if (h == null) {
            h = new ClassHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        h.data = classFileImage;
        return h;
    }

    public static ClassHandle create(byte[] classFileImage, Schema schema, Resolver resolver, boolean definersRights, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return ClassHandle.create(classFileImage, schema, resolver, definersRights, replace, false, false);
    }

    public static ClassHandle intern(HandleHolder holder) {
        Schema schema;
        ClassHandle h = (ClassHandle)holder.handle;
        if (h == null && (schema = Schema.lookupFixed(holder.schemaNumber)) != null) {
            h = new ClassHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        return h;
    }

    public InputStream transformedInputStream() throws IOException {
        return super.inputStream();
    }

    public InputStream untransformedInputStream() throws IOException {
        Mutable m;
        try {
            m = new Mutable(new Raw.Class(super.inputStream()));
        }
        catch (ToolException te) {
            throw new IOException("Mutable creation failed");
        }
        return new ByteArrayInputStream(m.stripAurora());
    }

    private static native boolean lookup_(Class var0, HandleHolder var1);

    private static boolean lookup(Class cl, HandleHolder holder) {
        return ClassHandle.lookup_(cl, holder);
    }

    public static ClassHandle lookup(Class cl) {
        HandleHolder holder = new HandleHolder();
        if (cl == null || !ClassHandle.lookup(cl, holder)) {
            return null;
        }
        return ClassHandle.intern(holder);
    }

    private native Class loadClass(boolean var1, String var2, boolean var3) throws ObjectTypeChangedException, ClassNotFoundException;

    public Class loadClass() throws ClassNotFoundException, ObjectTypeChangedException {
        return this.loadClass(false);
    }

    public Class loadClass(boolean onlyIfAlreadyLoaded) throws ClassNotFoundException, ObjectTypeChangedException {
        Class c = null;
        try {
            c = this.loadClass(onlyIfAlreadyLoaded, null, false);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".loadClass");
        }
        return c;
    }

    public CHAR getNcompSourceNameAsCHAR() {
        return new CHAR(this.getNcompSourceName(), null);
    }

    public CHAR getNcompLibNameAsCHAR() {
        return new CHAR(this.getNcompLibName(), null);
    }

    public CHAR getNcompDllNameAsCHAR() {
        return new CHAR(this.getNcompDllName(), null);
    }

    public CHAR getNcompFunctionNameAsCHAR() {
        return new CHAR(this.getNcompFunctionName(), null);
    }

    public boolean setNcompSourceName(CHAR chr_name) {
        return this.setNcompSourceName(this.getBytes(chr_name));
    }

    public boolean setNcompLibName(CHAR chr_name) {
        return this.setNcompLibName(this.getBytes(chr_name));
    }

    public boolean setNcompFunctionName(CHAR chr_name) {
        return this.setNcompFunctionName(this.getBytes(chr_name));
    }

    private byte[] getBytes(CHAR ch) {
        byte[] bytes = ch.shareBytes();
        if (bytes == null) {
            throw new NullPointerException("byte array in name attribute can not be null");
        }
        return bytes;
    }

    public native boolean getNcompIsEnabled();

    public native boolean getNcompIsAllowed();

    private native byte[] getNcompSourceName();

    private native byte[] getNcompLibName();

    private native byte[] getNcompDllName();

    private native byte[] getNcompFunctionName();

    public native boolean setNcompIsEnabled(boolean var1);

    public native boolean setNcompIsAllowed(boolean var1);

    private native boolean setNcompSourceName(byte[] var1);

    private native boolean setNcompLibName(byte[] var1);

    private native boolean setNcompFunctionName(byte[] var1);
}

