/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.aurora.rdbms.DbmsJava;
import oracle.aurora.rdbms.DefaultResolver;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.OracleClassLoader;
import oracle.aurora.rdbms.ResolverTerm;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.sql.CHAR;

public class Resolver {
    private static DefaultResolver defaultResolver;
    protected ResolverTerm[] terms;

    public Resolver(ResolverTerm[] terms) {
        this.terms = terms;
    }

    public Resolver(String spec) throws InvalidResolverPatternException, SchemaNotFoundException {
        Vector<Schema> parsedSchemas = new Vector<Schema>();
        Vector<String> parsedPatterns = new Vector<String>();
        StringTokenizer theTerms = new StringTokenizer(spec, "(");
        while (theTerms.hasMoreTokens()) {
            Schema schema;
            String aTerm = theTerms.nextToken();
            StringTokenizer termTokens = new StringTokenizer(aTerm = aTerm.replace(')', ' '), " ");
            if (termTokens.countTokens() != 2) {
                throw new InvalidResolverPatternException("Invalid resolver pattern: (" + aTerm + ")");
            }
            parsedPatterns.addElement(termTokens.nextToken());
            String schemaString = termTokens.nextToken();
            if (schemaString.indexOf(34) == -1) {
                if (OracleClassLoader.getSystemClassLoader() != null) {
                    schemaString = schemaString.toUpperCase();
                }
            } else {
                schemaString = schemaString.replace('\"', ' ').trim();
            }
            if ((schema = Schema.lookup(schemaString)) == null) {
                throw new SchemaNotFoundException(schemaString);
            }
            parsedSchemas.addElement(schema);
        }
        Object[] pats = new String[parsedPatterns.size()];
        parsedPatterns.copyInto(pats);
        Object[] schemes = new Schema[parsedSchemas.size()];
        parsedSchemas.copyInto(schemes);
        this.init((String[])pats, (Schema[])schemes);
    }

    Resolver() {
    }

    private void init(String[] patterns, Schema[] schemas) throws SchemaNotFoundException, InvalidResolverPatternException {
        if (patterns.length < schemas.length) {
            throw new InvalidResolverPatternException();
        }
        if (patterns.length > schemas.length) {
            throw new SchemaNotFoundException();
        }
        this.terms = new ResolverTerm[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            this.terms[i] = new ResolverTerm(patterns[i], schemas[i]);
        }
    }

    public Resolver(String[] patterns, Schema[] schemas) throws SchemaNotFoundException, InvalidResolverPatternException {
        this.init(patterns, schemas);
    }

    public Resolver(String[] patterns, CHAR[] schemaNames) throws SchemaNotFoundException, InvalidResolverPatternException {
        Schema[] schemas = new Schema[schemaNames.length];
        for (int i = 0; i < schemas.length; ++i) {
            schemas[i] = Schema.lookup(schemaNames[i]);
        }
        this.init(patterns, schemas);
    }

    public Resolver(String[] patterns, String[] schemaNames) throws SchemaNotFoundException, InvalidResolverPatternException {
        Schema[] schemas = new Schema[schemaNames.length];
        for (int i = 0; i < schemas.length; ++i) {
            schemas[i] = Schema.lookup(schemaNames[i]);
        }
        this.init(patterns, schemas);
    }

    public static Resolver defaultResolver() {
        if (defaultResolver == null) {
            defaultResolver = new DefaultResolver();
        }
        return defaultResolver;
    }

    public int length() {
        return this.terms.length;
    }

    public ResolverTerm term(int index) {
        return this.terms[index];
    }

    String[] patterns() {
        String[] patterns = new String[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            patterns[i] = this.terms[i].pattern();
        }
        return patterns;
    }

    int[] ownerNumbers() {
        int[] ownerNumbers = new int[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            ownerNumbers[i] = this.terms[i].schema().ownerNumber();
        }
        return ownerNumbers;
    }

    public String toString() {
        String result = "Resolver(";
        for (int i = 0; i < this.terms.length; ++i) {
            result = result + "(" + this.terms[i].pattern() + " " + this.terms[i].schema() + ")";
        }
        return result + ")";
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            result ^= this.terms[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        Resolver other;
        boolean result = false;
        if (obj instanceof Resolver && (other = (Resolver)obj).length() == this.length()) {
            result = true;
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.terms[i].equals(other.term(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public Resolver concatenate(Resolver r) {
        ResolverTerm[] newTerms = new ResolverTerm[this.terms.length + r.terms.length];
        System.arraycopy(this.terms, 0, newTerms, 0, this.terms.length);
        System.arraycopy(r.terms, 0, newTerms, this.terms.length, r.terms.length);
        this.terms = newTerms;
        return this;
    }

    static Resolver defaultCreateHandleResolver(Schema schema) {
        String jarname = DbmsJava.jarNameToPrepend();
        ResolverTerm[] terms = new ResolverTerm[jarname == null ? 2 : 3];
        try {
            int idx = 0;
            if (jarname != null) {
                terms[idx++] = new ResolverTerm("///" + jarname + "///" + "*", schema);
            }
            terms[idx++] = new ResolverTerm("*", schema);
            terms[idx] = new ResolverTerm("*", Schema.publicSchema);
        }
        catch (InvalidResolverPatternException e) {
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        return new Resolver(terms);
    }
}

