/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.ide.help.HelpSystem;
import oracle.jdbc.internal.OracleConnection;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.AboutDialog;
import oracle.olapdv.app.AllReportViewer;
import oracle.olapdv.app.AppLog;
import oracle.olapdv.app.DataValidateApp;
import oracle.olapdv.app.DataValidatePanel;
import oracle.olapdv.app.ModelViewer;
import oracle.olapdv.app.TreePanel;
import oracle.olapdv.app.TreeSelection;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.log.ValidateLogger;
import oracle.olapdv.olap.model.AWDO;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.olap.provider.AwProvider;
import oracle.olapdv.olap.provider.reader.AwReader;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.reader.ModelReader;
import oracle.olapdv.util.MiscUtils;
import oracle.olapdv.writer.CreateSchemaObjects;
import oracle.olapdv.writer.ModelWriter;
import oracle.olapdv.writer.ValidationWriter;

public class DataValidateDialog
extends JDialog
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(DataValidateDialog.class.getName());
    private Frame m_parent;
    private DataValidatePanel m_dataValidatePanel;
    private RaptorTask raptorTask;
    private OracleConnection m_conn;
    private String m_owner;
    private String m_awName;
    private String CLOSE_COMMAND = "CLOSE";

    public DataValidateDialog(Frame frame, OracleConnection oracleConnection, String string, String string2) {
        super(frame, OLAPDVArb.format("DATA_VALIDATION_FOR_AW", string2));
        this.m_parent = frame;
        this.m_owner = string;
        this.m_awName = string2;
        this.m_conn = oracleConnection;
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        connectionManager.setClonedConnection((Connection)oracleConnection);
        CreateSchemaObjects createSchemaObjects = new CreateSchemaObjects();
        if (!createSchemaObjects.create()) {
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            validateTopDO.setPermissionError(true);
            JOptionPane.showMessageDialog(frame, OLAPDVArb.getString("MISSING_REQUIRED_DATABASE_PRIVILEGES"), OLAPDVArb.getString("MISSING_PRIVILEGES_TITLE"), 0);
        }
        this.registerKeyboardActions();
        this.setMenuBar();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getRootPane(), "olapdv_start_get_start");
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, this.CLOSE_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void setMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(StringUtils.stripMnemonic((String)OLAPDVArb.getString("FILE_MENU")));
        jMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.getString("FILE_MENU")));
        JMenuItem jMenuItem = new JMenuItem(OLAPDVArb.getString("FILE_MENU_ITEM_CLOSE"));
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(this.CLOSE_COMMAND);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu(StringUtils.stripMnemonic((String)OLAPDVArb.getString("VIEW_MENU")));
        jMenu2.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.getString("VIEW_MENU")));
        JMenuItem jMenuItem2 = new JMenuItem(OLAPDVArb.getString("VIEW_MENU_LOG_ITEM"));
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("LOG");
        jMenu2.add(jMenuItem2);
        JMenu jMenu3 = new JMenu(StringUtils.stripMnemonic((String)OLAPDVArb.getString("HELP_MENU")));
        JMenuItem jMenuItem3 = new JMenuItem(OLAPDVArb.getString("HELP_MENU_TABLE_OF_CONTENTS"));
        jMenuItem3.setActionCommand("DATA_VALIDATION_HELP");
        jMenuItem3.addActionListener(this);
        jMenu3.add(jMenuItem3);
        jMenu3.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.getString("HELP_MENU")));
        JMenuItem jMenuItem4 = new JMenuItem(OLAPDVArb.getString("HELP_MENU_ITEM_ABOUT"));
        jMenuItem4.setActionCommand("ABOUT");
        jMenuItem4.addActionListener(this);
        jMenu3.add(jMenuItem4);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DataValidateDialog.this.closeDown(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(this.CLOSE_COMMAND)) {
            this.closeDown(true);
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("About")) {
            AboutDialog aboutDialog = new AboutDialog(this);
            Rectangle rectangle = MiscUtils.centerWindow(this, 600, 275);
            aboutDialog.setBounds(rectangle);
            aboutDialog.setModal(true);
            aboutDialog.setVisible(true);
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("DATA_VALIDATION_HELP")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.getRootPane());
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("LOG")) {
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(this.m_owner, this.m_awName);
            MiscUtils.showLogInformation(validateModelDO.getName(), this);
        }
    }

    public void closeDown(boolean bl) {
        Object object;
        Object object2;
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        if (bl) {
            try {
                object2 = new ValidationWriter();
                object = validateTopDO.getValidateModelDO(this.m_owner, this.m_awName);
                ((ValidationWriter)object2).writeValidateReport((ValidateModelDO)object, true);
            }
            catch (SQLException sQLException) {
                LOG.log(Level.SEVERE, "On CloseDown, SQL Exception occurred with error code = " + sQLException.getErrorCode(), sQLException);
            }
        }
        object2 = AppLog.getInstance();
        ((AppLog)object2).shutDown();
        object = ValidateLogger.getInstance();
        ((ValidateLogger)object).closeDown();
        validateTopDO.cleanUp();
        this.dispose();
    }

    public boolean isAWNameInTheModelTable(String string, String string2) {
        QueryManager queryManager = new QueryManager();
        boolean bl = queryManager.isModelNameInTable(string, string2);
        return bl;
    }

    public void importAWOnStartUp(RaptorTask raptorTask, String string, String string2) {
        this.raptorTask = raptorTask;
        DoInitializeAndImport doInitializeAndImport = new DoInitializeAndImport(string, string2);
        doInitializeAndImport.run();
    }

    private boolean isRaptorTaskCancelled(RaptorTask raptorTask) {
        boolean bl = false;
        IRaptorTaskStatus iRaptorTaskStatus = raptorTask.getStatus();
        if (!iRaptorTaskStatus.isAlive()) {
            bl = true;
        }
        return bl;
    }

    private void recordLastTimeDimensionsModified(ValidateModelDO validateModelDO) {
        QueryManager queryManager = new QueryManager();
        for (DimensionDO dimensionDO : validateModelDO.getDimensionDOs()) {
            String string = queryManager.getLastTimeDimensionModified(this.m_owner, dimensionDO.getName());
            dimensionDO.setLastTimeDimensionModified(string);
        }
    }

    private void initializeUIPanelInSwingThread(DataValidateApp dataValidateApp) {
        final DataValidateApp dataValidateApp2 = dataValidateApp;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DataValidateDialog.this.m_dataValidatePanel = new DataValidatePanel(DataValidateDialog.this, DataValidateDialog.this.m_parent, dataValidateApp2);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.WARNING, "initializeUIPanelInSwingThread has been interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.log(Level.WARNING, "initializeUIPanelInSwingThread has received an invocationTargetException");
        }
    }

    private void doQuickLaunch(String string) {
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(string, this.m_awName);
        validateModelDO.setLaunchedFromCache(true);
        DataValidateApp dataValidateApp = new DataValidateApp();
        dataValidateApp.setLaunchType(2);
        if (validateTopDO.isValidateModelPresent(string, this.m_awName)) {
            dataValidateApp.setPlugInAWName(this.m_awName);
        }
        this.initializeUIPanelInSwingThread(dataValidateApp);
        dataValidateApp.setDataValidatePanel(this.m_dataValidatePanel);
        TreePanel treePanel = this.m_dataValidatePanel.getTreePanel();
        treePanel.setOwner(string);
        this.m_dataValidatePanel.refreshModelViewerWithValidateTopDO(validateTopDO);
        treePanel.setValidateTopDO(validateTopDO);
        TreeSelection treeSelection = this.m_dataValidatePanel.getTreeSelection();
        treeSelection.setTopValidateModelDO(validateTopDO);
        this.setTitle(OLAPDVArb.format("DATA_VALIDATION_FOR_AW", this.m_awName));
        this.setContentPane(this.m_dataValidatePanel);
        treePanel.setModelName(validateModelDO.getName());
        treePanel.addModelTreeNode(validateModelDO.getName());
    }

    private boolean isCacheValid(String string, String string2) {
        AwReader awReader;
        boolean bl = true;
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(string, string2);
        List<String> list = validateModelDO.getAllDimensionListCache();
        QueryManager queryManager = new QueryManager();
        List<String> list2 = queryManager.getDimensionsInAW(string, string2);
        if (list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                String string3;
                String string4 = list.get(i);
                if (string4.equalsIgnoreCase(string3 = list2.get(i))) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (bl && !(awReader = new AwReader()).isDimensionMetadataCacheCurrent(string, validateModelDO.getDimensionDOs())) {
            bl = false;
        }
        return bl;
    }

    public void refreshModelViewer() {
        ModelViewer modelViewer = this.m_dataValidatePanel.getModelViewer();
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(this.m_owner, this.m_awName);
        modelViewer.refreshModelViewPanel(validateModelDO);
    }

    public void refreshAllReportViewer() {
        AllReportViewer allReportViewer = this.m_dataValidatePanel.getAllReportViewer();
        allReportViewer.refreshAllMessages();
    }

    public void notifyModelPanelReady() {
        this.m_dataValidatePanel.notifyModelPanelReady();
    }

    public DataValidatePanel getDataValidatePanel() {
        return this.m_dataValidatePanel;
    }

    public void requestInitialFocus(final boolean bl) {
        int n = 750;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataValidateDialog.this.m_dataValidatePanel.requestFocus();
                DataValidateDialog.this.m_dataValidatePanel.setNavigatorTreeFocused(bl);
            }
        };
        Timer timer = new Timer(n, actionListener);
        timer.setRepeats(false);
        timer.start();
    }

    public void requestInitialReportPanelRowSelection(final LevelDO levelDO) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataValidateDialog.this.m_dataValidatePanel.setReportPanelRow(levelDO);
            }
        };
        int n = 1000;
        Timer timer = new Timer(n, actionListener);
        timer.setRepeats(false);
        timer.start();
    }

    protected class DoInitializeAndImport {
        private String owner;
        private String awName;

        public DoInitializeAndImport(String string, String string2) {
            this.owner = string;
            this.awName = string2;
        }

        public void run() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DataValidateDialog.this.raptorTask.setMessage(OLAPDVArb.getString("LOADING_OBJECT_MODEL_FROM_VALIDATE_TABLE"));
            int n = 0;
            ModelWriter modelWriter = new ModelWriter();
            modelWriter.deleteObsoleteModelInformationFromMainDVTable(this.awName, false);
            modelWriter.deleteObsoleteModelInformationFromLastRunDVTable(this.awName, false);
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            validateTopDO.setDataValidateDialog(DataValidateDialog.this);
            boolean bl = DataValidateDialog.this.isAWNameInTheModelTable(this.owner, this.awName);
            QueryManager queryManager = null;
            queryManager = new QueryManager();
            List<AWDO> list = queryManager.getAllAWsAvailableToUser();
            validateTopDO = ValidateTopDO.getInstance();
            validateTopDO.setAWDOs(list);
            if (validateTopDO.isValidateModelPresent(this.owner, this.awName) && bl && DataValidateDialog.this.isCacheValid(this.owner, this.awName)) {
                DataValidateDialog.this.doQuickLaunch(this.owner);
                return;
            }
            validateTopDO.deleteModelDO(this.owner, this.awName);
            ValidateModelDO validateModelDO = null;
            if (bl) {
                object4 = new ModelReader();
                ((ModelReader)object4).readValidateTable(this.owner, this.awName);
                object3 = validateTopDO.getValidateModelDO(this.owner, this.awName);
                object2 = ((ValidateModelDO)object3).getModelOwner();
                validateModelDO = validateTopDO.copyValidateDO((String)object2, this.awName, "COPY_OF_" + this.awName);
                validateTopDO.deleteModelDO(this.owner, this.awName);
                modelWriter.deleteModelFromTable(this.owner, this.awName, false);
            }
            object4 = new DataValidateApp();
            ((DataValidateApp)object4).setLaunchType(2);
            if (validateTopDO.isValidateModelPresent(this.owner, this.awName)) {
                ((DataValidateApp)object4).setPlugInAWName(this.awName);
            }
            DataValidateDialog.this.initializeUIPanelInSwingThread((DataValidateApp)object4);
            ((DataValidateApp)object4).setDataValidatePanel(DataValidateDialog.this.m_dataValidatePanel);
            object3 = DataValidateDialog.this.m_dataValidatePanel.getTreePanel();
            ((TreePanel)object3).setOwner(this.owner);
            DataValidateDialog.this.raptorTask.setMessage(OLAPDVArb.getString("READING_ANALYTIC_WORKSPACE_METADATA"));
            object2 = new AwProvider();
            AWDO aWDO = ((AwProvider)object2).getOLAPObjectModel(this.owner, this.awName);
            aWDO.setName(this.awName);
            if (DataValidateDialog.this.isRaptorTaskCancelled(DataValidateDialog.this.raptorTask)) {
                LOG.log(Level.WARNING, OLAPDVArb.format("USER_CANCEL_LAUNCH_LOG_MESSAGE", ++n));
                validateTopDO.deleteModelDO(this.owner, this.awName);
                queryManager.rollback();
                return;
            }
            modelWriter = new ModelWriter(aWDO, DataValidateDialog.this.m_parent);
            DataValidateDialog.this.raptorTask.setMessage(OLAPDVArb.getString("UPDATING_USER_VALIDATION_TABLE"));
            boolean bl2 = modelWriter.writeDimensionsToDataValidationTable(this.owner, false);
            if (DataValidateDialog.this.isRaptorTaskCancelled(DataValidateDialog.this.raptorTask)) {
                LOG.log(Level.WARNING, OLAPDVArb.format("USER_CANCEL_LAUNCH_LOG_MESSAGE", ++n));
                validateTopDO.deleteModelDO(this.owner, this.awName);
                queryManager.rollback();
                return;
            }
            DataValidateDialog.this.raptorTask.setMessage(OLAPDVArb.getString("COMPLETE_LOADING_VALIDATION_OBJ_MODEL"));
            ModelReader modelReader = new ModelReader();
            ValidateModelDO validateModelDO2 = modelReader.populateDataValidationObjectModel((Connection)DataValidateDialog.this.m_conn, this.owner, this.awName);
            if (!bl2) {
                validateModelDO2.resetDepthAfterErrorFromCreateFromAW();
                object = new ModelWriter(validateModelDO2);
                ((ModelWriter)object).writeValidateModelToValidationTable(this.owner, false);
            }
            if (validateModelDO != null) {
                validateTopDO.updateValidateReportFromCopy(validateModelDO2, validateModelDO);
            }
            if (DataValidateDialog.this.isRaptorTaskCancelled(DataValidateDialog.this.raptorTask)) {
                LOG.log(Level.WARNING, OLAPDVArb.format("USER_CANCEL_LAUNCH_LOG_MESSAGE", ++n));
                validateTopDO.deleteModelDO(this.owner, this.awName);
                queryManager.rollback();
                return;
            }
            if (bl) {
                try {
                    object = new ValidationWriter();
                    ((ValidationWriter)object).writeValidateReport(validateModelDO2, false);
                }
                catch (SQLException sQLException) {
                    LOG.log(Level.SEVERE, "In startup run method, SQL Exception occurred with error code = " + sQLException.getErrorCode(), sQLException);
                }
            }
            DataValidateDialog.this.raptorTask.setMessage(OLAPDVArb.getString("DATA_VALIDATION_READY_TO_GO"));
            validateModelDO2.setModelChangesPending(false);
            validateTopDO.setPendingSQLUpdates(false);
            if (DataValidateDialog.this.isRaptorTaskCancelled(DataValidateDialog.this.raptorTask)) {
                LOG.log(Level.WARNING, OLAPDVArb.format("USER_CANCEL_LAUNCH_LOG_MESSAGE", ++n));
                validateTopDO.deleteModelDO(this.owner, this.awName);
                queryManager.rollback();
                return;
            }
            validateTopDO.addNewValidateModel(validateModelDO2);
            DataValidateDialog.this.m_dataValidatePanel.refreshModelViewerWithValidateTopDO(validateTopDO);
            ((TreePanel)object3).setValidateTopDO(validateTopDO);
            object = DataValidateDialog.this.m_dataValidatePanel.getTreeSelection();
            ((TreeSelection)object).setTopValidateModelDO(validateTopDO);
            DataValidateDialog.this.setTitle(OLAPDVArb.format("DATA_VALIDATION_FOR_AW", this.awName));
            DataValidateDialog.this.setContentPane(DataValidateDialog.this.m_dataValidatePanel);
            ((TreePanel)object3).setModelName(validateModelDO2.getName());
            ((TreePanel)object3).addModelTreeNode(validateModelDO2.getName());
            validateModelDO2.setLaunchedFromCache(false);
            DataValidateDialog.this.recordLastTimeDimensionsModified(validateModelDO2);
            List<String> list2 = queryManager.getDimensionsInAW(this.owner, this.awName);
            validateModelDO2.setAllDimensionListCache(list2);
            if (DataValidateDialog.this.isRaptorTaskCancelled(DataValidateDialog.this.raptorTask)) {
                LOG.log(Level.WARNING, OLAPDVArb.format("USER_CANCEL_LAUNCH_LOG_MESSAGE", ++n));
                validateTopDO.deleteModelDO(this.owner, this.awName);
                queryManager.rollback();
                return;
            }
            DataValidateDialog.this.m_dataValidatePanel.refreshModelPanelTopLabel();
        }
    }
}

