/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.query;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.log.LogWriter;
import oracle.olapdv.log.ValidateLogger;
import oracle.olapdv.olap.model.AWDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.query.DrillResultSet;
import oracle.olapdv.query.ValidateQuerySQL;
import oracle.olapdv.util.jdbc.SQLParam;
import oracle.olapdv.util.jdbc.SQLWrapper;

public class QueryManager {
    private static Queries queries;
    private static final String XMLFILE = "olapdvqmqueries.xml";
    private Logger LOG = Logger.getLogger(QueryManager.class.getName());
    protected static final String GET_DIMENSION_COUNT_IN_AW = "get_dimension_count_in_aw";
    protected static final String GET_NUMBER_OF_MODELS = "get_number_of_models";
    protected static final String GET_COUNT_PER_LEVEL = "get_count_per_level";
    protected static final String GET_NULL_COUNT = "get_null_count";
    protected static final String GET_NULL_DESCRIPTION_COUNT = "get_null_description_count";
    protected static final String GET_MEMBERS_WITH_MULTI_DESC_COUNT = "get_members_with_multi_desc_count";
    protected static final String GET_DESC_WITH_MULT_MEMBER_COUNT = "get_desc_with_multi_member_count";
    protected static final String GET_MEMBERS_WITH_MULTI_PARENTS = "get_members_with_multi_parents";
    protected static final String GET_MEMBERS_WITH_MULTI_PARENTS_SNOWFLAKE = "get_members_with_multi_parents_snowflake";
    protected static final String GET_DESC_WITH_MULTI_PARENTS_SNOWFLAKE = "get_desc_with_multi_parents_snowflake";
    protected static final String GET_MEMBERS_AND_DESCRIPTIONS = "get_members_and_descriptions";
    protected static final String GET_MEMBERS_AND_DESCRIPTIONS2 = "get_members_and_descriptions2";
    protected static final String GET_NULL_MEMBERS_SNOWFLAKE = "get_null_members_snowflake";
    protected static final String GET_MEMBERS_WITH_NULL_DESC = "get_members_with_null_desc";
    protected static final String GET_MEMBERS_WITH_MULTI_DESC = "get_members_with_multi_desc";
    protected static final String GET_MEMBERS_WITH_MULTI_DESC2 = "get_members_with_multi_desc2";
    protected static final String GET_DESC_WITH_MULTI_MEMBERS = "get_desc_with_multi_members";
    protected static final String GET_DESC_WITH_MULTI_MEMBERS2 = "get_desc_with_multi_members2";
    protected static final String GET_DESC_WITH_MULTI_MEMBERS3 = "get_desc_with_multi_members3";
    protected static final String GET_DESC_WITH_MULTI_MEMBERS4 = "get_desc_with_multi_members4";
    protected static final String GET_DESC_WITH_MULTI_MEMBERS5 = "get_desc_with_multi_members5";
    protected static final String GET_MEMBER_WITH_MULTI_PARENT = "get_member_with_multi_parent";
    protected static final String GET_MEMBER_WITH_MULTI_PARENT_SNOWFLAKE = "get_member_with_multi_parent_snowflake";
    protected static final String GET_DESC_WITH_MULTI_PARENT_DESC = "get_desc_with_multi_parent_desc";
    protected static final String GET_DESC_WITH_MULTI_PARENT_DESC_SNOWFLAKE = "get_desc_with_multi_parent_desc_snowflake";
    protected static final String ALTER_TABLE_MODIFY_VARCHAR2 = "alter_table_modify_varchar2";
    protected static final String ALTER_TABLE_MODIFY_NVARCHAR2 = "alter_table_modify_nvarchar2";
    protected static final String CORRECT_ROWS_WITH_NULL_MEMBERS = "correct_rows_with_null_members";
    protected static final String CORRECT_ROWS_WITH_NULL_MEMBERS_TO_CHAR = "correct_rows_with_null_members_to_char";
    protected static final String CORRECT_ROWS_WITH_NULL_MEMBERS_NUMBER = "correct_rows_with_null_members_number";
    protected static final String CORRECT_ROWS_WITH_NULL_MEMBERS_DESC = "correct_rows_with_null_members_desc";
    protected static final String CORRECT_MEMBERS_WITH_MULTI_DESC = "correct_members_with_multi_desc";
    protected static final String CORRECT_BY_MEMBERS_MEMBERS_WITH_MULTI_DESC = "correct_by_members_members_with_multi_desc";
    protected static final String CORRECT_BY_MEMBERS_MEMBERS_WITH_MULTI_DESC2 = "correct_by_members_members_with_multi_desc2";
    protected static final String CORRECT_DESCRIPTIONS_WITH_MULTI_MEMBERS1 = "correct_descriptions_with_multi_members1";
    protected static final String CORRECT_DESCRIPTIONS_WITH_MULTI_MEMBERS2 = "correct_descriptions_with_multi_members2";
    protected static final String CORRECT_BY_MEMBERS_DESC_WITH_MULTI_DESC_SNOWFLAKE = "correct_by_members_desc_with_multi_desc_snowflake";
    protected static final String CORRECT_BY_CONCATFIX_DESC_WITH_MULTI_MEMBERS = "correct_by_concatfix_desc_with_multi_members";
    protected static final String CORRECT_BY_CONCATFIX_DESC_WITH_MULTI_MEMBERS_SNOWFLAKE = "correct_by_concatfix_desc_with_multi_members_snowflake";
    protected static final String CORRECT_BY_MOST_COMMONFIX_DESC_WITH_MULTI_MEMBERS = "correct_by_most_commonfix_desc_with_multi_members";
    protected static final String CORRECT_MEMBERS_WITH_MULTI_PARENTS = "correct_members_with_multi_parents";
    protected static final String CORRECT_MEMBERS_WITH_MULTI_PARENTS_SNOWFLAKE = "correct_members_with_multi_parents_snowflake";
    protected static final String CORRECT_BY_CONCATFIX_MEMBERS_WITH_MULTI_PARENTS = "correct_by_concatfix_members_with_multi_parents";
    protected static final String CORRECT_BY_CONCATFIX_MEMBERS_WITH_MULTI_PARENTS_SNOWFLAKE = "correct_by_concatfix_members_with_multi_parents_snowflake";
    protected static final String CORRECT_MULTI_PARENT_DESC = "correct_multi_parent_desc";
    protected static final String CORRECT_MULTI_DESC_PARENT_DESC_SNOWFLAKE = "correct_multi_desc_parent_desc_snowflake";
    private static final String FIND_ALTER_TABLE_COLUMN_SIZE = "find_alter_table_column_size";
    private static final String FIND_ALTER_TABLE_COLUMN_SIZE_SNOWFLAKE = "find_alter_table_column_size_snowflake";
    private static final String FIND_MAX_LENGTH = "find_max_length";
    private static final String GET_AWS_AVAILABLE_TO_USER = "get_aws_available_to_user";
    private static final String GET_ALL_AWS_FOR_USER = "get_all_aws_for_user";
    private static final String GET_CURRENT_USER = "get_current_user";
    private static final String FIND_MAX_ROW = "find_max_row";
    private static final String IS_OWNER_VALID = "is_owner_valid";
    private static final String IS_TABLE_NAME_VALID = "is_table_name_valid";
    private static final String IS_COLUMN_NAME_VALID = "is_column_name_valid";
    private static final String GET_SERVER_DATE_TIME = "get_server_date_time";
    private static final String GET_LAST_TIME_TABLE_UPDATED = "get_last_time_table_updated";
    private static final String GET_LAST_DDL_TIME_DIMENSION_MODIFIED = "get_last_ddl_time_dimension_modified";
    private static final String GET_ALL_DIMENSIONS_IN_ANALYTIC_WORKSPACE = "get_all_dimensions_in_the_analytic_workspace";
    public static final int COLUMN_MEMBER = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int DESCRIPTION_APPEND_MEMBER = 3;

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), (String)XMLFILE);
                JavaXMLBind.BindToJavaStr((String)string3, (String)string2, (Object)this);
            }
            catch (Exception exception) {
                this.LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        QueryManager.queries = queries;
    }

    public static String getLoggedInUser(Connection connection) throws SQLException {
        String string = null;
        String string2 = "SELECT USER FROM DUAL";
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            string = dBUtil.executeReturnOneCol(string2);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return string;
    }

    public boolean areThereAnyDimensions(String string, String string2) {
        Connection connection = null;
        boolean bl = false;
        String string3 = this.getQuery(GET_DIMENSION_COUNT_IN_AW);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method areThereAnyDimensions, SQL Exception occurred.", sQLException);
        }
        int n = 0;
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string);
            hashMap.put("AW_NAME", string2);
            String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
            n = Integer.valueOf(string4);
            if (n > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method areThereAnyDimensions, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public boolean isModelNameInTable(String string, String string2) {
        Connection connection = null;
        boolean bl = false;
        String string3 = this.getQuery(GET_NUMBER_OF_MODELS);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method isModelNameInTable, SQL Exception occurred.", sQLException);
        }
        int n = 0;
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("MODEL_OWNER", string);
            hashMap.put("MODEL_NAME", string2);
            String string4 = dBUtil.executeReturnOneCol(string3, hashMap);
            n = Integer.valueOf(string4);
            if (n > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method isModelNameInTable, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public int countMembers(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        String string = this.getQuery(GET_COUNT_PER_LEVEL);
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        if (string4 == null || string4.length() == 0) {
            return 1;
        }
        if (string3 == null || string3.length() == 0) {
            return 1;
        }
        string = String.format(string, string4, string2, string3);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string5 = dBUtil.executeReturnOneCol(string);
            n = Integer.valueOf(string5);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countDescriptions(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getLongDescriptionColumnName();
        if (string3 == null || string3.length() == 0) {
            return 1;
        }
        if (string2 == null || string2.length() == 0) {
            return 1;
        }
        String string4 = this.getQuery(GET_COUNT_PER_LEVEL);
        string4 = String.format(string4, string3, string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string5 = dBUtil.executeReturnOneCol(string4);
            n = Integer.valueOf(string5);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countNonUniqueMembersAcrossLevels(LevelDO levelDO) throws SQLException {
        LevelDO levelDO2;
        Connection connection = null;
        Object var8_3 = null;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getColumnDataType();
        if (string3 == null || string3.length() == 0) {
            return 0;
        }
        ArrayList<LevelDO> arrayList = levelDO.getHierarchyDO().getLevelDOs();
        if (arrayList.size() < 2) {
            return 0;
        }
        if (arrayList.size() < 3 && (levelDO2 = arrayList.get(0)).getValidState() == LevelDO.ValidStates.VALID_WARNING) {
            return 0;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT COUNT(*) MEMBERCOUNT FROM ");
        stringBuffer.append("( SELECT DISTINCT " + string3);
        stringBuffer.append(" FROM " + string + "." + string2);
        if (!(string4 == null || string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR") || string4.startsWith("CHAR") || string4.startsWith("NCHAR"))) {
            string3 = this.wrapToChar(string3);
        }
        stringBuffer.append(" WHERE " + string3 + " IN (");
        boolean bl = true;
        for (LevelDO object3 : arrayList) {
            if (object3 == levelDO || object3.getValidState() == LevelDO.ValidStates.VALID_WARNING) continue;
            levelMapDO = object3.getLevelMapDO();
            String string5 = levelMapDO.getTableName();
            Object object = levelMapDO.getColumnName();
            string4 = levelMapDO.getColumnDataType();
            if (!(string4 == null || string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR") || string4.startsWith("CHAR") || string4.startsWith("NCHAR"))) {
                object = this.wrapToChar((String)object);
            }
            if (!bl) {
                stringBuffer.append(" UNION ");
            }
            stringBuffer.append("SELECT DISTINCT " + (String)object + " FROM ");
            stringBuffer.append(string + "." + (String)string5);
            bl = false;
        }
        stringBuffer.append("))");
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            List list = dBUtil.executeReturnList(stringBuffer.toString(), null);
            for (Object object : list) {
                BigDecimal bigDecimal = (BigDecimal)object.get("MEMBERCOUNT");
                n = bigDecimal.intValue();
            }
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    private String wrapToChar(String string) {
        return "TO_CHAR(" + string + ")";
    }

    public int countNullMembers(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        if (string3 == null || string3.length() == 0) {
            return 0;
        }
        String string4 = String.format(this.getQuery(GET_NULL_COUNT), string, string2, string3);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string5 = dBUtil.executeReturnOneCol(string4);
            n = Integer.valueOf(string5);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countNullDescriptions(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        if (string4 == null || string4.length() == 0) {
            return 0;
        }
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        String string5 = String.format(this.getQuery(GET_NULL_DESCRIPTION_COUNT), string3, string4, string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string6 = dBUtil.executeReturnOneCol(string5);
            n = Integer.valueOf(string6);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countMembersWithMultipleDescriptions(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        if (string4 == null || string4.length() == 0) {
            return 0;
        }
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        String string5 = String.format(this.getQuery(GET_MEMBERS_WITH_MULTI_DESC_COUNT), string3, string4, string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string6 = dBUtil.executeReturnOneCol(string5);
            n = Integer.valueOf(string6);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countDescriptionsAssignedToMultipleMembers(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        String string5 = String.format(this.getQuery(GET_DESC_WITH_MULT_MEMBER_COUNT), string4, string3, string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string6 = dBUtil.executeReturnOneCol(string5);
            n = Integer.valueOf(string6);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countMembersWithMultipleParents(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        String string = null;
        Object var10_4 = null;
        LevelDO levelDO2 = null;
        boolean bl = false;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getParentColumnName();
        levelDO2 = levelDO.getParentLevelDO();
        if (levelDO2 == null) {
            return 0;
        }
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string6 = levelMapDO2.getColumnName();
        String string7 = levelMapDO2.getTableName();
        if (string3 == null || string3.length() == 0) {
            return 0;
        }
        if (string7 != null && !string3.equalsIgnoreCase(string7)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery(GET_MEMBERS_WITH_MULTI_PARENTS), string4, string6, string2, string3) : String.format(this.getQuery(GET_MEMBERS_WITH_MULTI_PARENTS_SNOWFLAKE), string4, string6, string2, string3, string7, string5);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string8 = dBUtil.executeReturnOneCol(string);
            n = Integer.valueOf(string8);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public int countDescriptionsWithMultipleParentDescriptions(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        boolean bl = false;
        int n = 0;
        connection = ConnectionManager.getInstance().getMainConnection();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getLongDescriptionColumnName();
        String string4 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        if (levelDO2 == null) {
            return 0;
        }
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string5 = levelMapDO2.getTableName();
        String string6 = levelMapDO2.getColumnName();
        String string7 = levelMapDO2.getLongDescriptionColumnName();
        if (string3 == null || string3.length() == 0) {
            return 0;
        }
        if (string7 == null || string7.length() == 0) {
            return 0;
        }
        if (string2 == null || string2.length() == 0) {
            return 0;
        }
        if (string5 != null && !string2.equalsIgnoreCase(string5)) {
            bl = true;
        }
        String string8 = !bl ? String.format(this.getQuery(GET_MEMBERS_WITH_MULTI_PARENTS), string3, string7, string, string2) : String.format(this.getQuery(GET_DESC_WITH_MULTI_PARENTS_SNOWFLAKE), string3, string7, string, string2, string5, string4, string6);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string9 = dBUtil.executeReturnOneCol(string8);
            n = Integer.valueOf(string9);
        }
        catch (Exception exception) {
            exception.fillInStackTrace();
            throw exception;
        }
        return n;
    }

    public Object[][] getDistinctMembersAndDescriptions(LevelDO levelDO) throws SQLException {
        String string;
        Connection connection = null;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        DrillResultSet drillResultSet = new DrillResultSet(2);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getDistinctMembersAndDescriptions, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        if (string4 != null && string4.equalsIgnoreCase(string5)) {
            bl = true;
            string = String.format(this.getQuery(GET_MEMBERS_AND_DESCRIPTIONS), string4, string2, string3);
        } else {
            string = String.format(this.getQuery(GET_MEMBERS_AND_DESCRIPTIONS2), string4, string5, string2, string3);
        }
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block10: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ArrayList arrayList = new ArrayList();
                    resultSet = dBUtil.executeQuery(string, arrayList);
                    if (resultSet == null) break block10;
                    resultSet.setFetchSize(1000);
                    while (resultSet.next()) {
                        objectArray[0] = resultSet.getString(1);
                        objectArray[1] = !bl ? resultSet.getString(2) : resultSet.getString(1);
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getMembersNotUniqueAcrossLevels(LevelDO levelDO) throws SQLException {
        Object object;
        Object object2;
        Connection connection = null;
        Object[] objectArray = new Object[2];
        DrillResultSet drillResultSet = new DrillResultSet(2);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getMembersNotUniqueAcrossLevels, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        String string5 = levelMapDO.getColumnDataType();
        ArrayList<LevelDO> arrayList = levelDO.getHierarchyDO().getLevelDOs();
        if (arrayList.size() < 2) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (LevelDO levelDO2 : arrayList) {
            if (levelDO2 == levelDO) continue;
            string3 = levelMapDO.getColumnName();
            if (!(string5.startsWith("VARCHAR") || string5.startsWith("NVARCHAR") || string5.startsWith("CHAR"))) {
                string3 = this.wrapToChar(string3);
            }
            stringBuffer.append("SELECT DISTINCT " + string3);
            stringBuffer.append(", " + string4);
            stringBuffer.append(" FROM " + string + "." + string2);
            stringBuffer.append(" WHERE " + string3 + " IN (");
            object2 = levelDO2.getLevelMapDO();
            String string6 = ((LevelMapDO)object2).getTableName();
            object = ((LevelMapDO)object2).getColumnName();
            String string7 = ((LevelMapDO)object2).getColumnDataType();
            if (!(string7.startsWith("VARCHAR") || string7.startsWith("NVARCHAR") || string7.startsWith("CHAR"))) {
                object = this.wrapToChar((String)object);
            }
            stringBuffer.append("SELECT DISTINCT " + (String)object + " FROM ");
            stringBuffer.append(string + "." + string6 + ")");
            stringBuffer.append(" UNION ");
        }
        Object object3 = stringBuffer.toString();
        int n = ((String)object3).length();
        object3 = ((String)object3).substring(0, n - 6);
        if (Connections.getInstance().lock(connection)) {
            block12: {
                object2 = null;
                try {
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    ArrayList arrayList2 = new ArrayList();
                    object2 = object.executeQuery((String)object3, arrayList2);
                    if (object2 == null) break block12;
                    object2.setFetchSize(1000);
                    while (object2.next()) {
                        objectArray[0] = object2.getString(1);
                        objectArray[1] = object2.getString(2);
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object2);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)object2);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getNullMemberRows(LevelDO levelDO) throws SQLException {
        StringBuffer stringBuffer;
        Connection connection = null;
        String string = null;
        boolean bl = false;
        Object[] objectArray = new Object[4];
        DrillResultSet drillResultSet = new DrillResultSet(4);
        boolean bl2 = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getNullMemberRows, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getParentColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string7 = levelMapDO2.getColumnName();
        String string8 = levelMapDO2.getLongDescriptionColumnName();
        String string9 = levelMapDO2.getTableName();
        if (string3 != null && string9 != null && !string3.equalsIgnoreCase(string9)) {
            bl = true;
        }
        ArrayList<String> arrayList = null;
        if (!bl) {
            arrayList = levelDO.getAncestorKeyAndDescriptionColumns();
            objectArray = new Object[arrayList.size() + 1];
            drillResultSet = new DrillResultSet(arrayList.size() + 1);
            boolean bl3 = true;
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT DISTINCT ");
            for (String string10 : arrayList) {
                if (bl3) {
                    stringBuffer.append(string10);
                    bl3 = false;
                    continue;
                }
                stringBuffer.append(", " + string10);
            }
            stringBuffer.append(String.format(" FROM %1$s.%2$s WHERE %3$s IS NULL AND ROWNUM < 25000 ORDER BY %4$s, %5$s", string2, string3, string4, string7, string6));
            string = stringBuffer.toString();
        } else {
            string = String.format(this.getQuery(GET_NULL_MEMBERS_SNOWFLAKE), string6, string7, string8, string2, string3, string9, string5, string4);
        }
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block16: {
                resultSet = null;
                try {
                    stringBuffer = DBUtil.getInstance((Connection)connection);
                    stringBuffer.setRaiseError(true);
                    ArrayList arrayList2 = new ArrayList();
                    resultSet = stringBuffer.executeQuery(string, arrayList2);
                    if (resultSet == null) break block16;
                    resultSet.setFetchSize(1000);
                    while (resultSet.next()) {
                        if (bl) {
                            objectArray[0] = "(null)";
                            objectArray[1] = resultSet.getString(1);
                            objectArray[2] = resultSet.getString(2);
                            objectArray[3] = resultSet.getString(3);
                        } else {
                            objectArray[0] = "(null)";
                            int n = 1;
                            for (String string11 : arrayList) {
                                objectArray[n] = resultSet.getString(n);
                                ++n;
                            }
                        }
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getMembersWithNullDescriptions(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        Object[] objectArray = new Object[2];
        DrillResultSet drillResultSet = new DrillResultSet(2);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getMembersWithNullDescriptions, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        String string5 = String.format(this.getQuery(GET_MEMBERS_WITH_NULL_DESC), string3, string4, string, string2);
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block8: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ArrayList arrayList = new ArrayList();
                    resultSet = dBUtil.executeQuery(string5, arrayList);
                    if (resultSet == null) break block8;
                    resultSet.setFetchSize(1000);
                    while (resultSet.next()) {
                        objectArray[0] = resultSet.getString(1);
                        objectArray[1] = "(null)";
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getMembersWithMultipleDescriptions(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        Object[] objectArray = new Object[4];
        DrillResultSet drillResultSet = new DrillResultSet(4);
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getMembersWithMultipleDescriptions, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        String string5 = string3 != null && string3.equalsIgnoreCase(string4) ? String.format(this.getQuery(GET_MEMBERS_WITH_MULTI_DESC), string3, string4, string, string2) : String.format(this.getQuery(GET_MEMBERS_WITH_MULTI_DESC2), string3, string4, string, string2);
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block8: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ArrayList arrayList = new ArrayList();
                    resultSet = dBUtil.executeQuery(string5, arrayList);
                    if (resultSet == null) break block8;
                    resultSet.setFetchSize(1000);
                    while (resultSet.next()) {
                        objectArray[0] = resultSet.getString(1);
                        objectArray[1] = resultSet.getString(2);
                        objectArray[2] = resultSet.getString(3);
                        objectArray[3] = resultSet.getString(4);
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getDescriptionsAssignedToMultipleMembers(LevelDO levelDO) throws SQLException {
        Object object;
        Connection connection = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object[] objectArray = new Object[5];
        DrillResultSet drillResultSet = new DrillResultSet(5);
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getDescriptionsAssignedToMultipleMembers, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string4 = levelMapDO.getOwner();
        String string5 = levelMapDO.getTableName();
        String string6 = levelMapDO.getColumnName();
        String string7 = levelMapDO.getLongDescriptionColumnName();
        String string8 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        String string9 = null;
        if (levelDO2 != null) {
            object = levelDO2.getLevelMapDO();
            string2 = ((LevelMapDO)object).getTableName();
            string9 = ((LevelMapDO)object).getLongDescriptionColumnName();
            string3 = ((LevelMapDO)object).getColumnName();
        }
        string = string6 != null && string6.equalsIgnoreCase(string7) ? (string9 != null ? String.format(this.getQuery(GET_DESC_WITH_MULTI_MEMBERS), string7, string6, string9, string4, string5) : String.format(this.getQuery(GET_DESC_WITH_MULTI_MEMBERS2), string7, string6, string4, string5)) : (string9 != null ? (string2 != null && !string5.equalsIgnoreCase(string2) ? String.format(this.getQuery(GET_DESC_WITH_MULTI_MEMBERS3), string7, string6, string9, string4, string5, string2, string8, string3) : String.format(this.getQuery(GET_DESC_WITH_MULTI_MEMBERS4), string7, string6, string9, string4, string5)) : String.format(this.getQuery(GET_DESC_WITH_MULTI_MEMBERS5), string7, string6, string4, string5));
        if (Connections.getInstance().lock(connection)) {
            object = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ArrayList arrayList = new ArrayList();
                object = dBUtil.executeQuery(string, arrayList);
                if (object != null) {
                    object.setFetchSize(1000);
                    while (object.next()) {
                        objectArray[0] = object.getString(1);
                        objectArray[1] = object.getString(2);
                        objectArray[2] = object.getString(3);
                        objectArray[3] = object.getString(4);
                        objectArray[4] = object.getString(5);
                        drillResultSet.addRow(objectArray);
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2) throws SQLException {
        Connection connection = null;
        boolean bl = false;
        Object[] objectArray = new Object[6];
        DrillResultSet drillResultSet = new DrillResultSet(6);
        boolean bl2 = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getMembersWithMultipleParents, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getParentColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string6 = levelMapDO2.getTableName();
        String string7 = levelMapDO2.getColumnName();
        String string8 = levelMapDO2.getLongDescriptionColumnName();
        if (string6 != null && !string2.equalsIgnoreCase(string6)) {
            bl = true;
        }
        String string9 = !bl ? String.format(this.getQuery(GET_MEMBER_WITH_MULTI_PARENT), string3, string7, string5, string8, string, string2) : String.format(this.getQuery(GET_MEMBER_WITH_MULTI_PARENT_SNOWFLAKE), string3, string4, string5, string8, string, string2, string6, string7);
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block9: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ArrayList arrayList = new ArrayList();
                    resultSet = dBUtil.executeQuery(string9, arrayList);
                    if (resultSet == null) break block9;
                    resultSet.setFetchSize(1000);
                    while (resultSet.next()) {
                        objectArray[0] = resultSet.getString(1);
                        objectArray[1] = resultSet.getString(2);
                        objectArray[2] = resultSet.getString(3);
                        objectArray[3] = resultSet.getString(4);
                        objectArray[4] = resultSet.getString(5);
                        objectArray[5] = resultSet.getString(6);
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object[][] getDescriptionsWithMultipleParentDescs(LevelDO levelDO, LevelDO levelDO2) throws SQLException {
        Connection connection = null;
        String string = null;
        boolean bl = false;
        Object[] objectArray = new Object[6];
        DrillResultSet drillResultSet = new DrillResultSet(6);
        boolean bl2 = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getDescriptionsWithMultipleParentDescs, SQL Exception occurred.", sQLException);
        }
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getParentColumnName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        if (string7 != null && !string3.equalsIgnoreCase(string7)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery(GET_DESC_WITH_MULTI_PARENT_DESC), string6, string9, string5, string8, string2, string3) : String.format(this.getQuery(GET_DESC_WITH_MULTI_PARENT_DESC_SNOWFLAKE), string6, string9, string5, string8, string2, string3, string7, string4);
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block9: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ArrayList arrayList = new ArrayList();
                    resultSet = dBUtil.executeQuery(string, arrayList);
                    if (resultSet == null) break block9;
                    resultSet.setFetchSize(1000);
                    while (resultSet.next()) {
                        objectArray[0] = resultSet.getString(1);
                        objectArray[1] = resultSet.getString(2);
                        objectArray[2] = resultSet.getString(3);
                        objectArray[3] = resultSet.getString(4);
                        objectArray[4] = resultSet.getString(5);
                        objectArray[5] = resultSet.getString(6);
                        drillResultSet.addRow(objectArray);
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return drillResultSet.getObjectData();
    }

    public Object correctMembersWithNullDescriptions(LevelDO levelDO, String string, String string2, boolean bl) throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        String string3 = null;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctMembersWithNullDescriptions, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string4 = levelMapDO.getOwner();
        String string5 = levelMapDO.getTableName();
        String string6 = levelMapDO.getColumnName();
        String string7 = levelMapDO.getLongDescriptionColumnName();
        String string8 = levelMapDO.getColumnDataType();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO.getModelName());
        String string9 = validateQuerySQL.getSQLTextForAppendFixForMembersWithNullDescriptions(levelDO, string, string2);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Members With Null Descriptions for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        int n = this.findMaxLengthOfRowForColumn(levelDO, string6) + string.length() + string2.length();
        int n2 = levelMapDO.getDescColumnDataTypeLength();
        if (n2 < n) {
            String string10 = levelMapDO.getLongDescDataType();
            if (string10.startsWith("VARCHAR")) {
                if (n > 4000) {
                    n = 4000;
                }
                string3 = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2), string4, string5, string7, n);
            } else if (string10.startsWith("NVARCHAR")) {
                if (n > 2000) {
                    n = 2000;
                }
                string3 = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2), string4, string5, string7, n);
            }
        }
        if (string3 != null) {
            logWriter.write(" ");
            logWriter.write("REM Alter Table Needed for Description column " + string5 + "." + string7);
            logWriter.write(string3 + ";");
            logWriter.write(" ");
        }
        logWriter.write(string9 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        boolean bl2 = !string8.startsWith("VARCHAR") && !string8.startsWith("NVARCHAR") && !string8.startsWith("CHAR");
        Object object2 = String.format("UPDATE %1$s.%2$s SET %3$s = ", string4, string5, string7);
        object2 = bl2 ? (String)object2 + String.format("'%1$s' || TO_CHAR(%2$s) || '%3$s' WHERE %4$s IS NULL", string, string6, string2, string7) : (String)object2 + String.format("'%1$s' || %2$s || '%3$s' WHERE %4$s IS NULL", string, string6, string2, string7);
        try {
            try {
                if (string3 != null) {
                    sQLParam = SQLWrapper.execute(connection, string3);
                    if (sQLParam != null) {
                        sQLParam.closeResultSet();
                    }
                    levelMapDO.setDescColumnDataTypeLength(n);
                }
            }
            catch (SQLException sQLException) {
                this.LOG.log(Level.SEVERE, "In method correctMembersWithNullDescriptions, SQL Exception occurred.", sQLException);
            }
            sQLParam = SQLWrapper.execute(connection, (String)object2);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctRowsWithNullMembers(LevelDO levelDO) throws SQLException {
        int n;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        LevelMapDO levelMapDO;
        String string9;
        LogWriter logWriter;
        Object object;
        boolean bl;
        SQLParam sQLParam;
        String string10;
        Connection connection;
        block44: {
            connection = null;
            string10 = null;
            sQLParam = null;
            bl = false;
            object = null;
            try {
                connection = ConnectionManager.getInstance().getClonedConnection();
            }
            catch (SQLException sQLException) {
                this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembers, SQL Exception occurred.", sQLException);
            }
            ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
            ValidateLogger validateLogger = ValidateLogger.getInstance();
            logWriter = validateLogger.getLogWriter(levelDO.getModelName());
            string9 = validateQuerySQL.getSQLTextForNullMembers(levelDO);
            levelMapDO = levelDO.getLevelMapDO();
            string8 = levelMapDO.getOwner();
            string7 = levelMapDO.getTableName();
            string6 = levelMapDO.getColumnName();
            string5 = levelMapDO.getParentColumnName();
            string4 = levelMapDO.getColumnDataType();
            LevelDO levelDO2 = levelDO.getParentLevelDO();
            LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
            String string11 = levelMapDO2.getTableName();
            string3 = levelMapDO2.getColumnName();
            string2 = levelMapDO2.getColumnDataType();
            if (string11 != null && !string7.equalsIgnoreCase(string11)) {
                bl = true;
            }
            string = null;
            n = 0;
            if (!bl) {
                if (string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR")) {
                    try {
                        int n2 = levelMapDO.getColumnDataTypeLength();
                        int n3 = this.findMaxLengthOfRowForColumn(levelDO, string3);
                        if (n2 >= n3 + levelDO.getName().length()) break block44;
                        n = n3 + levelDO.getName().length() + 10;
                        if (string4.startsWith("VARCHAR")) {
                            if (n > 4000) {
                                n = 4000;
                            }
                            string = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2), string8, string7, string6, n);
                            break block44;
                        }
                        if (n > 2000) {
                            n = 2000;
                        }
                        string = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2), string8, string7, string6, n);
                    }
                    catch (SQLException sQLException) {
                        this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembers, SQL Exception occurred.", sQLException);
                    }
                }
            } else if (string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR")) {
                try {
                    int n4 = levelMapDO.getColumnDataTypeLength();
                    int n5 = this.findMaxLengthOfRowForColumn(levelDO, string5);
                    if (n4 < n5 + levelDO.getName().length()) {
                        n = n5 + levelDO.getName().length() + 10;
                        if (string4.startsWith("VARCHAR")) {
                            if (n > 4000) {
                                n = 4000;
                            }
                            string = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2), string8, string7, string6, n);
                        } else {
                            if (n > 2000) {
                                n = 2000;
                            }
                            string = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2), string8, string7, string6, n);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembers, SQL Exception occurred.", sQLException);
                }
            }
        }
        if (string != null) {
            try {
                if (string != null) {
                    sQLParam = SQLWrapper.execute(connection, string);
                    if (sQLParam != null) {
                        sQLParam.closeResultSet();
                    }
                    levelMapDO.setColumnDataTypeLength(n);
                }
            }
            catch (SQLException sQLException) {
                this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembers, SQL Exception occurred.", sQLException);
            }
        }
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Null Member Rows for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        if (string != null) {
            logWriter.write(" ");
            logWriter.write("REM Alter Table Needed");
            logWriter.write(string + ";");
            logWriter.write(" ");
        }
        logWriter.write(string9 + ";");
        if (!bl) {
            if ((string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR")) && (string2.startsWith("VARCHAR") || string2.startsWith("NVARCHAR"))) {
                string10 = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS), string8, string7, string6, levelDO.getName(), string3);
            } else if ((string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR")) && string2.startsWith("NUMBER")) {
                string10 = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS_TO_CHAR), string8, string7, string6, levelDO.getName(), string3);
            } else if (string4.startsWith("NUMBER")) {
                string10 = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS_NUMBER), string8, string7, string6, string3);
            }
        } else if ((string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR")) && (string2.startsWith("VARCHAR") || string2.startsWith("NVARCHAR"))) {
            string10 = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS), string8, string7, string6, levelDO.getName(), string5);
        } else if ((string4.startsWith("VARCHAR") || string4.startsWith("NVARCHAR")) && string2.startsWith("NUMBER")) {
            string10 = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS_TO_CHAR), string8, string7, string6, levelDO.getName(), string5);
        } else if (string4.startsWith("NUMBER")) {
            string10 = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS_NUMBER), string8, string7, string6, string5);
        }
        if (string10 != null) {
            try {
                sQLParam = SQLWrapper.execute(connection, string10);
                object = sQLParam.getValue();
            }
            catch (SQLException sQLException) {
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (sQLParam != null) {
                    sQLParam.closeResultSet();
                }
            }
        }
        return object;
    }

    public Object correctRowsWithNullMembersByDescription(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        String string = null;
        SQLParam sQLParam = null;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembersByDescription, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO.getModelName());
        String string2 = validateQuerySQL.getSQLTextForNullMembersByDescription(levelDO);
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        int n = levelMapDO.getColumnDataTypeLength();
        String string7 = levelMapDO.getColumnDataType();
        int n2 = 0;
        try {
            n2 = this.findMaxLengthForDescription(levelDO);
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembersByDescription, SQL Exception occurred.", sQLException);
        }
        String string8 = null;
        if (n < n2 && (string7.startsWith("VARCHAR") || string7.startsWith("NVARCHAR2"))) {
            if (string7.startsWith("VARCHAR")) {
                string8 = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2), string3, string4, string5, n2);
            } else if (string7.startsWith("NVARCHAR")) {
                string8 = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2), string3, string4, string5, n2);
            }
            try {
                if (string8 != null) {
                    sQLParam = SQLWrapper.execute(connection, string8);
                    if (sQLParam != null) {
                        sQLParam.closeResultSet();
                    }
                    levelMapDO.setColumnDataTypeLength(n2);
                }
            }
            catch (SQLException sQLException) {
                this.LOG.log(Level.SEVERE, "In method correctRowsWithNullMembersByDescription, SQL Exception occurred.", sQLException);
            }
        }
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Null Member Rows for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        if (string8 != null) {
            logWriter.write(" ");
            logWriter.write("REM Alter Table Needed");
            logWriter.write(string8 + ";");
            logWriter.write(" ");
        }
        logWriter.write(string2 + ";");
        string = String.format(this.getQuery(CORRECT_ROWS_WITH_NULL_MEMBERS_DESC), string3, string4, string5, string6);
        try {
            sQLParam = SQLWrapper.execute(connection, string);
            object = sQLParam.getValue();
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
        return object;
    }

    public Object correctMembersWithMultipleDescriptions(LevelDO levelDO, boolean bl) throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctMembersWithMultipleDescriptions, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getColumnName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO.getModelName());
        String string5 = validateQuerySQL.getSQLTextForMembersWithMultipleDescriptions(levelDO);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Members With Multiple Descriptions for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        logWriter.write(string5 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        try {
            String string6 = String.format(this.getQuery(CORRECT_MEMBERS_WITH_MULTI_DESC), string, string2, string3, string4);
            sQLParam = SQLWrapper.execute(connection, string6);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctByMemberFixMembersWithMultipleDescriptions(LevelDO levelDO, String string, String string2, boolean bl) throws SQLException {
        Connection connection = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = levelMapDO.getColumnDataType();
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByMemberFixMembersWithMultipleDescriptions, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO.getModelName());
        String string8 = validateQuerySQL.getSQLTextForMemberFixForMembersWithMultipleDescriptions(levelDO, string, string2);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Members With Multiple Descriptions for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        logWriter.write(string8 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        String string9 = string7.startsWith("VARCHAR") || string7.startsWith("NVARCHAR") || string7.startsWith("CHAR") ? String.format(this.getQuery(CORRECT_BY_MEMBERS_MEMBERS_WITH_MULTI_DESC), string3, string4, string6, string2, string5, string) : String.format(this.getQuery(CORRECT_BY_MEMBERS_MEMBERS_WITH_MULTI_DESC2), string3, string4, string6, string2, string5, string);
        try {
            sQLParam = SQLWrapper.execute(connection, string9);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctDescriptionsWithMultipleMembers(LevelDO levelDO, String string, int n, boolean bl) throws SQLException {
        Object object;
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getColumnDataType();
        String string7 = levelMapDO.getLongDescDataType();
        boolean bl2 = !string6.startsWith("VARCHAR") && !string6.startsWith("NVARCHAR") && !string6.startsWith("CHAR");
        Object object2 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctDescriptionsWithMultipleMembers, SQL Exception occurred.", sQLException);
        }
        String string8 = null;
        int n2 = 0;
        int n3 = levelMapDO.getDescColumnDataTypeLength();
        if (n3 < n + string.length()) {
            object = levelMapDO.getLongDescriptionColumnName();
            n2 = n + string.length() + 10;
            if (string7.startsWith("VARCHAR")) {
                if (n2 > 4000) {
                    n2 = 4000;
                }
                string8 = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2), string2, string3, string5, n2) + "\r\n";
            } else if (string6.startsWith("NVARCHAR")) {
                if (n2 > 2000) {
                    n2 = 2000;
                }
                string8 = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2), string2, string3, string5, n2) + "\r\n";
            }
        }
        object = ValidateLogger.getInstance();
        LogWriter logWriter = ((ValidateLogger)object).getLogWriter(levelDO.getModelName());
        String string9 = validateQuerySQL.getSQLTextForDescriptionsWithMultipleMembers(levelDO, string);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Descriptions With Multiple Members for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        if (string8 != null) {
            logWriter.write(string8 + ";");
        }
        logWriter.write(string9 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        String string10 = bl2 ? String.format(this.getQuery(CORRECT_DESCRIPTIONS_WITH_MULTI_MEMBERS1), string5, string, string4, string2, string3) : String.format(this.getQuery(CORRECT_DESCRIPTIONS_WITH_MULTI_MEMBERS2), string5, string, string4, string2, string3);
        try {
            if (string8 != null) {
                sQLParam = SQLWrapper.execute(connection, string8);
                if (sQLParam != null) {
                    sQLParam.closeResultSet();
                }
                levelMapDO.setDescColumnDataTypeLength(n2);
            }
            sQLParam = SQLWrapper.execute(connection, string10);
            object2 = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object2;
    }

    public Object correctByConcatFixDescriptionsWithMultipleMembers(LevelDO levelDO, String string, int n, boolean bl) throws SQLException {
        Object object;
        Object object2;
        Connection connection = null;
        String string2 = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        String string7 = levelMapDO.getParentColumnName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string8 = levelMapDO2.getTableName();
        String string9 = levelMapDO2.getColumnName();
        String string10 = levelMapDO2.getLongDescriptionColumnName();
        Object object3 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByConcatFixDescriptionsWithMultipleMembers, SQL Exception occurred.", sQLException);
        }
        String string11 = null;
        int n2 = 0;
        int n3 = levelMapDO.getDescColumnDataTypeLength();
        if (n3 < n + string.length()) {
            object2 = levelMapDO.getLongDescriptionColumnName();
            n2 = n + string.length() + 10;
            object = levelMapDO.getLongDescDataType();
            if (((String)object).startsWith("VARCHAR")) {
                if (n2 > 4000) {
                    n2 = 4000;
                }
                string11 = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2), string3, string4, object2, n2) + "\r\n";
            } else if (((String)object).startsWith("NVARCHAR")) {
                if (n2 > 2000) {
                    n2 = 2000;
                }
                string11 = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2), string3, string4, object2, n2) + "\r\n";
            }
        }
        object2 = ValidateLogger.getInstance();
        object = ((ValidateLogger)object2).getLogWriter(levelDO.getModelName());
        String string12 = validateQuerySQL.getSQLTextForConcatFixForDescriptionsWithMultipleMembers(levelDO, string);
        ((LogWriter)object).write(" ");
        ((LogWriter)object).write("REM **** SQL To Fix Descriptions With Multiple Members for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        if (string11 != null) {
            ((LogWriter)object).write(string11 + ";");
        }
        ((LogWriter)object).write(string12 + ";");
        if (bl) {
            ((LogWriter)object).write("commit;");
            ((LogWriter)object).write(" ");
        }
        string2 = string4.equalsIgnoreCase(string8) ? String.format(this.getQuery(CORRECT_BY_CONCATFIX_DESC_WITH_MULTI_MEMBERS), string3, string4, string6, string, string10, string5) : String.format(this.getQuery(CORRECT_BY_CONCATFIX_DESC_WITH_MULTI_MEMBERS_SNOWFLAKE), string3, string4, string6, string, string10, string8, string7, string9, string5);
        try {
            if (string11 != null) {
                sQLParam = SQLWrapper.execute(connection, string11);
                if (sQLParam != null) {
                    sQLParam.closeResultSet();
                }
                levelMapDO.setDescColumnDataTypeLength(n2);
            }
            sQLParam = SQLWrapper.execute(connection, string2);
            object3 = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object3;
    }

    public Object correctByMostCommonFixDescriptionsWithMultipleMembers(LevelDO levelDO, boolean bl) throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByMostCommonFixDescriptionsWithMultipleMembers, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO.getModelName());
        String string = validateQuerySQL.getSQLTextForMostCommonFixForDescriptionsWithMultipleMembers(levelDO);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Descriptions With Multiple Members for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        logWriter.write(string + ";");
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = String.format(this.getQuery(CORRECT_BY_MOST_COMMONFIX_DESC_WITH_MULTI_MEMBERS), string2, string3, string5, string4);
        try {
            sQLParam = SQLWrapper.execute(connection, string6);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2, boolean bl) throws SQLException {
        Connection connection = null;
        String string = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        boolean bl2 = false;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctMembersWithMultipleParents, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO2.getModelName());
        String string2 = validateQuerySQL.getSQLTextForMembersWithMultipleParents(levelDO, levelDO2);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Members With Multiple Parents for Level " + levelDO2.getName() + " in " + levelDO2.getOwningDimensionName() + "." + levelDO2.getOwningHierarchyName());
        logWriter.write(string2 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getParentColumnName();
        String string7 = levelMapDO.getLongDescriptionColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string8 = levelMapDO2.getTableName();
        String string9 = levelMapDO2.getColumnName();
        String string10 = levelMapDO2.getLongDescriptionColumnName();
        try {
            if (string8 != null && !string4.equalsIgnoreCase(string8)) {
                bl2 = true;
            }
            string = !bl2 ? String.format(this.getQuery(CORRECT_MEMBERS_WITH_MULTI_PARENTS), string3, string4, string5, string9, string10) : String.format(this.getQuery(CORRECT_MEMBERS_WITH_MULTI_PARENTS_SNOWFLAKE), string3, string4, string5, string6, string10, string8, string9);
            sQLParam = SQLWrapper.execute(connection, string);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctByMemberFixMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2, String string, String string2, String string3, boolean bl) throws SQLException {
        Object object;
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        boolean bl2 = false;
        Object object2 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByMemberFixMembersWithMultipleParents, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO2.getModelName());
        String string4 = validateQuerySQL.getSQLTextForMemberFixForMembersWithMultipleParents(levelDO, levelDO2, string, string2, string3);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Members With Multiple Parents for Level " + levelDO2.getName() + " in " + levelDO2.getOwningDimensionName() + "." + levelDO2.getOwningHierarchyName());
        logWriter.write(string4 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getParentColumnName();
        String string7 = levelMapDO.getOwner();
        String string8 = levelMapDO.getTableName();
        String string9 = " ";
        String string10 = levelMapDO.getColumnDataType();
        if (string10.startsWith("VARCHAR") || string10.startsWith("NVARCHAR") || string10.startsWith("CHAR")) {
            string9 = "'";
        }
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string11 = levelMapDO2.getTableName();
        string10 = levelMapDO2.getColumnDataType();
        String string12 = " ";
        if (string10.startsWith("VARCHAR") || string10.startsWith("NVARCHAR") || string10.startsWith("CHAR")) {
            string12 = "'";
        }
        levelMapDO2 = levelDO.getLevelMapDO();
        String string13 = levelMapDO2.getColumnName();
        String string14 = levelMapDO2.getLongDescriptionColumnName();
        if (string11 != null && !string8.equalsIgnoreCase(string11)) {
            bl2 = true;
        }
        if (!bl2) {
            object = string12.equalsIgnoreCase("'") ? String.format("UPDATE %1$s.%2$s SET %3$s = '%4$s',%n%5$s = '%6$s' WHERE ", string7, string8, string13, string2, string14, string3) : String.format("UPDATE %1$s.%2$s SET %3$s = %4$s,%n%5$s = '%6$s' WHERE ", string7, string8, string13, string2, string14, string3);
            object = string9.equalsIgnoreCase("'") ? (String)object + String.format("%1$s  = '%2$s'", string5, string) : (String)object + String.format("%1$s  = %2$s", string5, string);
        } else {
            object = string12.equalsIgnoreCase("'") ? String.format("UPDATE %1$s.%2$s SET %3$s = '%4$s'%n WHERE ", string7, string8, string6, string2) : String.format("UPDATE %1$s.%2$s SET %3$s = %4$s%n WHERE ", string7, string8, string6, string2);
            object = string9.equalsIgnoreCase("'") ? (String)object + String.format("%1$s = '%2$s'", string5, string) : (String)object + String.format("%1$s = %2$s", string5, string);
        }
        try {
            sQLParam = SQLWrapper.execute(connection, (String)object);
            object2 = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object2;
    }

    public Object correctByConcatFixMembersWithMultipleParents(LevelDO levelDO, LevelDO levelDO2, String string, int n, boolean bl) throws SQLException {
        Object object;
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        boolean bl2 = false;
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string2 = levelMapDO.getColumnName();
        String string3 = levelMapDO.getParentColumnName();
        String string4 = levelMapDO.getOwner();
        String string5 = levelMapDO.getTableName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string6 = levelMapDO2.getColumnName();
        String string7 = levelMapDO2.getTableName();
        if (string == null || string.length() == 0) {
            string = " ";
        }
        String string8 = null;
        int n2 = 0;
        int n3 = 0;
        if ((levelMapDO.getColumnDataType().startsWith("VARCHAR") || levelMapDO.getColumnDataType().startsWith("NVARCHAR")) && (n2 = levelMapDO.getColumnDataTypeLength()) < n + string.length()) {
            object = levelMapDO.getColumnName();
            n3 = n + string.length() + 10;
            if (levelMapDO.getColumnDataType().startsWith("VARCHAR")) {
                if (n3 > 4000) {
                    n3 = 4000;
                }
                string8 = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2) + "%n", string4, string5, object, n3);
            } else {
                if (n3 > 2000) {
                    n3 = 2000;
                }
                string8 = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2) + "%n", string4, string5, object, n3);
            }
        }
        object = ValidateLogger.getInstance();
        LogWriter logWriter = ((ValidateLogger)object).getLogWriter(levelDO2.getModelName());
        String string9 = validateQuerySQL.getSQLTextForConcatFixForMembersWithMultipleParents(levelDO, levelDO2, string);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Members With Multiple Parents for Level " + levelDO2.getName() + " in " + levelDO2.getOwningDimensionName() + "." + levelDO2.getOwningHierarchyName());
        if (string8 != null) {
            logWriter.write(string8 + ";");
        }
        logWriter.write(string9 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        Object object2 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByConcatFixMembersWithMultipleParents, SQL Exception occurred.", sQLException);
        }
        if (string7 != null && !string5.equalsIgnoreCase(string7)) {
            bl2 = true;
        }
        String string10 = !bl2 ? String.format(this.getQuery(CORRECT_BY_CONCATFIX_MEMBERS_WITH_MULTI_PARENTS), string4, string5, string2, string, string6) : String.format(this.getQuery(CORRECT_BY_CONCATFIX_MEMBERS_WITH_MULTI_PARENTS_SNOWFLAKE), string4, string5, string2, string, string3, string6, string7);
        try {
            if (string8 != null) {
                sQLParam = SQLWrapper.execute(connection, string8);
                if (sQLParam != null) {
                    sQLParam.closeResultSet();
                }
                levelMapDO.setColumnDataTypeLength(n3);
            }
            sQLParam = SQLWrapper.execute(connection, string10);
            object2 = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object2;
    }

    public Object correctMultipleParentDescription(LevelDO levelDO, LevelDO levelDO2, boolean bl) throws SQLException {
        String string;
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        boolean bl2 = false;
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctMultipleParentDescription, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO2.getModelName());
        String string2 = validateQuerySQL.getSQLTextForDescriptionsWithMultipleParentDescriptions(levelDO, levelDO2);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Descriptions With Multiple Parent Descriptions for Level " + levelDO2.getName() + " in " + levelDO2.getOwningDimensionName() + "." + levelDO2.getOwningHierarchyName());
        logWriter.write(string2 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getColumnName();
        String string6 = levelMapDO.getLongDescriptionColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string7 = levelMapDO2.getColumnName();
        String string8 = levelMapDO2.getLongDescriptionColumnName();
        String string9 = levelMapDO2.getTableName();
        if (string9 != null && !string4.equalsIgnoreCase(string9)) {
            bl2 = true;
        }
        if (bl2) {
            String string10 = levelMapDO.getParentColumnName();
            string = String.format(this.getQuery(CORRECT_MULTI_DESC_PARENT_DESC_SNOWFLAKE), string3, string4, string9, string6, string8, string5, string10, string7);
        } else {
            string = String.format(this.getQuery(CORRECT_MULTI_PARENT_DESC), string3, string4, string6, string8);
        }
        try {
            sQLParam = SQLWrapper.execute(connection, string);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctByMemberFixForDescriptionsWithMultipleParentDescriptions(LevelDO levelDO, LevelDO levelDO2, String string, String string2, boolean bl) throws SQLException {
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        boolean bl2 = false;
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO2.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        String string6 = levelMapDO.getParentColumnName();
        LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
        String string7 = levelMapDO2.getTableName();
        String string8 = levelMapDO2.getColumnName();
        String string9 = levelMapDO2.getLongDescriptionColumnName();
        if (string7 != null && !string4.equalsIgnoreCase(string7)) {
            bl2 = true;
        }
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(levelDO2.getModelName());
        String string10 = validateQuerySQL.getSQLTextForMemberFixForDescriptionsWithMultipleParentDescriptions(levelDO, levelDO2, string, string2);
        logWriter.write(" ");
        logWriter.write("REM **** SQL To Fix Descriptions With Multiple Parent Descriptions for Level " + levelDO2.getName() + " in " + levelDO2.getOwningDimensionName() + "." + levelDO2.getOwningHierarchyName());
        logWriter.write(string10 + ";");
        if (bl) {
            logWriter.write("commit;");
            logWriter.write(" ");
        }
        Object object = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByMemberFixForDescriptionsWithMultipleParentDescriptions, SQL Exception occurred.", sQLException);
        }
        String string11 = !bl2 ? String.format(this.getQuery(CORRECT_BY_MEMBERS_MEMBERS_WITH_MULTI_DESC), string3, string4, string9, string, string5, string2) : String.format(this.getQuery(CORRECT_BY_MEMBERS_DESC_WITH_MULTI_DESC_SNOWFLAKE), string3, string4, string7, string6, string8, string9, string, string5, string2);
        try {
            sQLParam = SQLWrapper.execute(connection, string11);
            object = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object;
    }

    public Object correctByConcatFixForDescriptionsWithMultipleParentDescriptions(LevelDO levelDO, String string, int n, boolean bl) throws SQLException {
        Object object;
        Object object2;
        Connection connection = null;
        SQLParam sQLParam = null;
        SQLParam sQLParam2 = null;
        Object object3 = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method correctByConcatFixForDescriptionsWithMultipleParentDescriptions, SQL Exception occurred.", sQLException);
        }
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getLongDescriptionColumnName();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = levelDO2.getLevelMapDO();
        String string5 = levelMapDO2.getLongDescriptionColumnName();
        if (string == null || string.length() == 0) {
            string = " ";
        }
        String string6 = null;
        int n2 = 0;
        int n3 = levelMapDO.getDescColumnDataTypeLength();
        if (n3 < n + string.length()) {
            object2 = levelMapDO.getLongDescriptionColumnName();
            n2 = n + string.length() + 10;
            object = levelMapDO.getLongDescDataType();
            if (((String)object).startsWith("VARCHAR")) {
                if (n2 > 4000) {
                    n2 = 4000;
                }
                string6 = String.format(this.getQuery(ALTER_TABLE_MODIFY_VARCHAR2) + "%n", string3, string4, object2, n2);
            } else if (((String)object).startsWith("NVARCHAR")) {
                if (n2 > 2000) {
                    n2 = 2000;
                }
                string6 = String.format(this.getQuery(ALTER_TABLE_MODIFY_NVARCHAR2) + "%n", string3, string4, object2, n2);
            }
        }
        object2 = ValidateLogger.getInstance();
        object = ((ValidateLogger)object2).getLogWriter(levelDO.getModelName());
        String string7 = validateQuerySQL.getSQLTextForConcatFixForDescriptionsWithMultipleParentDescriptions(levelDO, string);
        ((LogWriter)object).write(" ");
        ((LogWriter)object).write("REM **** SQL To Fix Descriptions With Multiple Parent Descriptions for Level " + levelDO.getName() + " in " + levelDO.getOwningDimensionName() + "." + levelDO.getOwningHierarchyName());
        if (string6 != null) {
            ((LogWriter)object).write(string6 + ";");
        }
        ((LogWriter)object).write(string7 + ";");
        if (bl) {
            ((LogWriter)object).write("commit;");
            ((LogWriter)object).write(" ");
        }
        String string8 = String.format(this.getQuery(CORRECT_BY_CONCATFIX_MEMBERS_WITH_MULTI_PARENTS), string3, string4, string2, string, string5);
        try {
            if (string6 != null) {
                sQLParam = SQLWrapper.execute(connection, string6);
                if (sQLParam != null) {
                    sQLParam.closeResultSet();
                }
                levelMapDO.setDescColumnDataTypeLength(n2);
            }
            sQLParam = SQLWrapper.execute(connection, string8);
            object3 = sQLParam.getValue();
            if (bl) {
                sQLParam2 = SQLWrapper.execute(connection, "commit");
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
            if (sQLParam2 != null) {
                sQLParam2.closeResultSet();
            }
        }
        return object3;
    }

    public int findAlterTableColumnSizeForConcatFix(LevelDO levelDO, int n) throws SQLException {
        Connection connection = null;
        int n2 = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string5 = levelMapDO.getOwner();
        String string6 = levelMapDO.getTableName();
        String string7 = levelMapDO.getParentColumnName();
        if (n == 1) {
            string2 = levelMapDO.getColumnName();
        } else if (n == 2) {
            string2 = levelMapDO.getLongDescriptionColumnName();
        } else if (n == 3) {
            string2 = levelMapDO.getLongDescriptionColumnName();
        }
        LevelDO levelDO2 = levelDO.getParentLevelDO();
        LevelMapDO levelMapDO2 = null;
        if (levelDO2 != null) {
            levelMapDO2 = levelDO2.getLevelMapDO();
            string4 = levelMapDO2.getColumnName();
        }
        String string8 = null;
        if (n == 1) {
            string3 = levelMapDO2.getColumnName();
            string8 = levelMapDO2.getTableName();
        } else if (n == 2) {
            string3 = levelMapDO2.getLongDescriptionColumnName();
            string8 = levelMapDO2.getTableName();
        } else if (n == 3) {
            string3 = levelMapDO.getColumnName();
            string8 = levelMapDO.getTableName();
        }
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method findAlterTableColumnSizeForConcatFix, SQL Exception occurred.", sQLException);
        }
        if (string8 != null && !string6.equalsIgnoreCase(string8)) {
            bl = true;
        }
        string = !bl ? String.format(this.getQuery(FIND_ALTER_TABLE_COLUMN_SIZE), string2, string3, string5, string6) : String.format(this.getQuery(FIND_ALTER_TABLE_COLUMN_SIZE_SNOWFLAKE), string2, string3, string5, string6, string8, string7, string4);
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet;
            block19: {
                resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    ArrayList arrayList = new ArrayList();
                    resultSet = dBUtil.executeQuery(string, arrayList);
                    if (resultSet == null || !resultSet.next()) break block19;
                    n2 = resultSet.getInt("MAXVALUE");
                }
                catch (Exception exception) {
                    try {
                        this.LOG.log(Level.SEVERE, "In method findAlterTableColumnSizeForConcatFix, SQL Exception occurred.", exception);
                        throw exception;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return n2;
    }

    public int findMaxLengthForDescription(LevelDO levelDO) throws SQLException {
        Connection connection = null;
        int n = 0;
        String string = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getLongDescriptionColumnName();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method findMaxLengthForDescription, SQL Exception occurred.", sQLException);
        }
        string = String.format(this.getQuery(FIND_MAX_LENGTH), string4, string2, string3);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string5 = dBUtil.executeReturnOneCol(string);
            n = string5 != null ? Integer.valueOf(string5) : 100;
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method findMaxLengthForDescription, SQL Exception occurred.", exception);
            throw exception;
        }
        return n;
    }

    public int findMaxLengthOfRowForColumn(LevelDO levelDO, String string) throws SQLException {
        Connection connection = null;
        int n = 0;
        String string2 = null;
        LevelMapDO levelMapDO = levelDO.getLevelMapDO();
        String string3 = levelMapDO.getOwner();
        String string4 = levelMapDO.getTableName();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method findMaxLengthOfRowForColumn, SQL Exception occurred.", sQLException);
        }
        string2 = String.format(this.getQuery(FIND_MAX_LENGTH), string, string3, string4);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string5 = dBUtil.executeReturnOneCol(string2);
            n = string5 != null ? Integer.valueOf(string5) : 100;
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method findMaxLengthOfRowForColumn, SQL Exception occurred.", exception);
            throw exception;
        }
        return n;
    }

    public ArrayList<String> getAWsAvailableToUser() throws SQLException {
        Connection connection = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getQuery(GET_AWS_AVAILABLE_TO_USER);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getAWsAvailableToUser, SQL Exception occurred.", sQLException);
        }
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            List list = dBUtil.executeReturnList(string, null);
            for (Map map : list) {
                String string2 = (String)map.get("OWNER");
                String string3 = (String)map.get("AW");
                if (string2.equalsIgnoreCase("SYS")) continue;
                arrayList.add(string2 + "." + string3);
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method getAWsAvailableToUser, SQL Exception occurred.", exception);
            throw exception;
        }
        return arrayList;
    }

    public List<AWDO> getAllAWsAvailableToUser() {
        Connection connection = null;
        ArrayList<AWDO> arrayList = new ArrayList<AWDO>();
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getAllAWsAvailableToUser, SQL Exception occurred.", sQLException);
        }
        String string = this.getQuery(GET_ALL_AWS_FOR_USER);
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap hashMap = new HashMap();
        List list = dBUtil.executeReturnList(string, hashMap);
        for (Map map : list) {
            String string2 = (String)map.get("OWNER");
            String string3 = (String)map.get("AW");
            AWDO aWDO = new AWDO(string2, string3);
            arrayList.add(aWDO);
        }
        return arrayList;
    }

    public List<String> getDimensionsInAW(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getDimensionsInAW, SQL Exception occurred.", sQLException);
        }
        String string3 = this.getQuery(GET_ALL_DIMENSIONS_IN_ANALYTIC_WORKSPACE);
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        dBUtil.setRaiseError(true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("AW_NAME", string2);
        List list = dBUtil.executeReturnList(string3, hashMap);
        for (Map map : list) {
            String string4 = (String)map.get("DIMENSION_NAME");
            arrayList.add(string4);
        }
        return arrayList;
    }

    public String getCurrentUser() throws SQLException {
        Connection connection = null;
        String string = null;
        String string2 = this.getQuery(GET_CURRENT_USER);
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getCurrentUser, SQL Exception occurred.", sQLException);
        }
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            string = dBUtil.executeReturnOneCol(string2);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method getCurrentUser, SQL Exception occurred.", exception);
            throw exception;
        }
        return string;
    }

    public int findMaxRowValueInTable(String string, String string2, String string3) {
        Connection connection = null;
        int n = 0;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method findMaxRowValueInTable, SQL Exception occurred.", sQLException);
        }
        String string4 = String.format(this.getQuery(FIND_MAX_ROW), string3, string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string5 = dBUtil.executeReturnOneCol(string4);
            if (string5 != null) {
                n = Integer.valueOf(string5);
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method findMaxRowValueInTable, SQL Exception occurred.", exception);
        }
        return n;
    }

    public boolean isOwnerValid(String string) {
        Connection connection = null;
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method isOwnerValid, SQL Exception occurred.", sQLException);
        }
        String string2 = this.getQuery(IS_OWNER_VALID);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string.toUpperCase());
            List list = dBUtil.executeReturnList(string2, hashMap);
            if (!list.isEmpty()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method isOwnerValid, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public boolean isTableNameValid(String string, String string2) {
        Connection connection = null;
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method isTableNameValid, SQL Exception occurred.", sQLException);
        }
        String string3 = this.getQuery(IS_TABLE_NAME_VALID);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string.toUpperCase());
            hashMap.put("TABLE_NAME", string2.toUpperCase());
            List list = dBUtil.executeReturnList(string3, hashMap);
            if (!list.isEmpty()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method isTableNameValid, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public boolean isColumnNameValid(String string, String string2, String string3) {
        Connection connection = null;
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        boolean bl = false;
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method isColumnNameValid, SQL Exception occurred.", sQLException);
        }
        String string4 = this.getQuery(IS_COLUMN_NAME_VALID);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string.toUpperCase());
            hashMap.put("TABLE_NAME", string2.toUpperCase());
            hashMap.put("COLUMN_NAME", string3.toUpperCase());
            List list = dBUtil.executeReturnList(string4, hashMap);
            if (!list.isEmpty()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method isColumnNameValid, SQL Exception occurred.", exception);
        }
        return bl;
    }

    public String getLastTimeTableUpdated(String string, String string2) {
        String string3 = null;
        Connection connection = null;
        connection = ConnectionManager.getInstance().getMainConnection();
        String string4 = String.format(this.getQuery(GET_LAST_TIME_TABLE_UPDATED), string, string2);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            string3 = dBUtil.executeReturnOneCol(string4);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method getLastTimeTableUpdated, SQL Exception occurred.", exception);
        }
        return string3;
    }

    public String getLastTimeDimensionModified(String string, String string2) {
        String string3 = null;
        Connection connection = null;
        connection = ConnectionManager.getInstance().getMainConnection();
        String string4 = this.getQuery(GET_LAST_DDL_TIME_DIMENSION_MODIFIED);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string.toUpperCase());
            hashMap.put("OBJECT_NAME", string2.toUpperCase());
            string3 = dBUtil.executeReturnOneCol(string4, hashMap);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method getLastTimeDimensionModified, SQL Exception occurred.", exception);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Connection connection = null;
        SQLParam sQLParam = null;
        String string = "commit";
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
            this.getCurrentServerDateTime();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method commit, SQL Exception occurred.", sQLException);
        }
        try {
            sQLParam = SQLWrapper.execute(connection, string);
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method commit, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Connection connection = null;
        SQLParam sQLParam = null;
        String string = "rollback";
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
            this.getCurrentServerDateTime();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method rollback, SQL Exception occurred.", sQLException);
        }
        try {
            sQLParam = SQLWrapper.execute(connection, string);
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method rollback, SQL Exception occurred.", sQLException);
        }
        finally {
            if (sQLParam != null) {
                sQLParam.closeResultSet();
            }
        }
    }

    public String getCurrentServerDateTime() {
        Connection connection = null;
        String string = this.getQuery(GET_SERVER_DATE_TIME);
        String string2 = "";
        try {
            connection = ConnectionManager.getInstance().getClonedConnection();
        }
        catch (SQLException sQLException) {
            this.LOG.log(Level.SEVERE, "In method getCurrentServerDateTime, SQL Exception occurred.", sQLException);
        }
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            string2 = dBUtil.executeReturnOneCol(string);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, "In method getCurrentServerDateTime, Exception occurred.", exception);
        }
        return string2;
    }
}

