/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.IOException;
import oracle.security.spnego.SPNEGO;
import oracle.security.spnego.SPNEGOException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HttpSPNEGO
extends SPNEGO {
    private static final String HTTP_SPNEGO_INITIATE = "Negotiate";
    private static final String HTTP_SPNEGO_PREFIX = "NEGOTIATE ";
    private static final String HTTP_NTLM_PREFIX = "NTLM ";

    public String initiate() {
        super.start();
        this.setTransport(1);
        return HTTP_SPNEGO_INITIATE;
    }

    public int decodeRequest(String hdr) throws SPNEGOException {
        if (hdr == null) {
            throw new SPNEGOException("Input parameter is null");
        }
        if (hdr.toUpperCase().startsWith(HTTP_SPNEGO_PREFIX)) {
            try {
                String encgss = hdr.substring(HTTP_SPNEGO_PREFIX.length());
                BASE64Decoder b64Decoder = new BASE64Decoder();
                byte[] gss = b64Decoder.decodeBuffer(encgss);
                return super.decodeReq(gss);
            }
            catch (IOException e) {
                throw new SPNEGOException(e);
            }
        }
        if (hdr.toUpperCase().startsWith(HTTP_NTLM_PREFIX)) {
            return 2;
        }
        throw new SPNEGOException("Invalid HTTP SPNEGO Header");
    }

    public String encodeResponse(int status, byte[] token, byte[] mic) throws SPNEGOException {
        BASE64Encoder b64Encoder = new BASE64Encoder();
        byte[] response = super.encodeRes(status, "1.2.840.113554.1.2.2", token, mic);
        return "Negotiate " + b64Encoder.encodeBuffer(response);
    }

    public String encodeResponse(int status, String mech, byte[] token, byte[] mic) throws SPNEGOException {
        BASE64Encoder b64Encoder = new BASE64Encoder();
        byte[] response = super.encodeRes(status, mech, token, mic);
        return "Negotiate " + b64Encoder.encodeBuffer(response);
    }
}

