/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.spnego;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import oracle.security.spnego.ASNException;
import oracle.security.spnego.ASNReader;
import oracle.security.spnego.Any;
import oracle.security.spnego.CompoundType;
import oracle.security.spnego.IIterativeType;
import oracle.security.spnego.IType;
import oracle.security.spnego.Tag;
import oracle.security.spnego.Type;

public abstract class Set
extends CompoundType {
    public Set(Tag tag) {
        super("", tag);
    }

    public Set(String name, Tag tag) {
        super(name, tag);
    }

    public Set(String name, Tag tag, Object value) {
        super(name, tag);
        if (value != null) {
            if (value instanceof ArrayList) {
                this.value(value);
            } else {
                throw new ClassCastException();
            }
        }
    }

    @Override
    public void decode(ASNReader is) throws IOException {
        Type t;
        ListIterator it;
        int found;
        this.reset();
        is.mark(Integer.MAX_VALUE);
        ASNReader local = is.decodeStructure(this);
        if (local == null) {
            is.reset();
            throw new ASNException(1, "Decoding SET");
        }
        block3: do {
            it = this.iterator();
            found = 0;
            while (it.hasNext()) {
                t = (Type)it.next();
                if (!t.isBlank()) continue;
                try {
                    local.mark(Integer.MAX_VALUE);
                    t.decode(local);
                    ++found;
                }
                catch (EOFException x) {
                    break block3;
                }
                catch (ASNException x) {
                    if (x.getCurrentIndex() != 1 || t.isOptional()) continue;
                    local.reset();
                }
            }
        } while (found != 0);
        it = this.iterator();
        while (it.hasNext()) {
            t = (Type)it.next();
            if (!t.isBlank() || t.isOptional()) continue;
            throw new ASNException(1, "Decoding SET");
        }
    }

    @Override
    public void reset() {
        ListIterator it = this.iterator();
        while (it.hasNext()) {
            ((IType)it.next()).reset();
        }
    }

    @Override
    public Object value() {
        return this.cloneComponents();
    }

    @Override
    public void value(Object value) {
        this.reset();
        if (value instanceof IType) {
            value = ((IType)value).value();
        }
        Iterator src = value instanceof ArrayList ? ((ArrayList)value).iterator() : ((ArrayList)((Any)value).value()).iterator();
        ListIterator dst = this.iterator();
        while (src.hasNext() && dst.hasNext()) {
            IType ts = (IType)src.next();
            IType td = (IType)dst.next();
            if (ts instanceof IIterativeType) {
                td.value(ts);
                continue;
            }
            td.value(ts.value());
        }
    }

    @Override
    public boolean isBlank() {
        boolean result = true;
        ListIterator it = this.iterator();
        while (it.hasNext()) {
            IType t = (IType)it.next();
            if (t.isBlank()) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public ListIterator iterator() {
        return this.components.listIterator();
    }

    @Override
    protected void initInternal() {
        super.initInternal();
        this.value = null;
    }

    public String toString() {
        String cn = this.getClass().getName();
        String ls = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(ls);
        sb.append("-- Begin ").append(cn).append(" (SET)").append(ls);
        int i = 1;
        ListIterator it = this.iterator();
        while (it.hasNext()) {
            IType t = (IType)it.next();
            sb.append("--   field #").append(i++).append(" (").append(t.getClass().getName()).append("): ").append(String.valueOf(t)).append(ls);
        }
        sb.append("-- End ").append(cn).append(" (SET)");
        return sb.toString();
    }
}

