/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.TextItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;

public class TextInsightData
implements XMLInsightData {
    private Object _defaultData = null;
    private XMLCompletionInsightProvider _insight;
    private ReadOnlyListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_VALUE_DESCRIPTOR"));

    public TextInsightData(XMLCompletionInsightProvider insight, InsightLocation insightLocation) {
        this._insight = insight;
        this._insightLocation = insightLocation;
        this._fillDataList();
        this._updateDataImpl();
    }

    public ListModel getListModel() {
        return this._buildListModel();
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        ListDataItem selectedItem = (ListDataItem)selectedObject;
        String selectedName = selectedItem.getName();
        if (selectedName == null) {
            return false;
        }
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        editorPane.beginEdit(EDIT_DESCRIPTOR);
        TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
        TextLocator textLocator = textInfo.getLocator();
        int startOffset = textLocator.getStartOffset();
        int endOffset = this._guessTextEndOffset((ReadTextBuffer)textBuffer, textLocator);
        try {
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, selectedName, null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editorPane.endEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        textBuffer.writeLock(false);
        try {
            ListDataItem item;
            int i;
            int listSize;
            TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
            TextLocator textLocator = textInfo.getLocator();
            int startOffset = textLocator.getStartOffset();
            int endOffset = this._guessTextEndOffset((ReadTextBuffer)textBuffer, textLocator);
            String userPrefix = "";
            if (endOffset > startOffset) {
                userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
            }
            int startIndex = listSize = this._insightDataList != null ? this._insightDataList.length : 0;
            int endIndex = listSize;
            for (i = 0; i < listSize; ++i) {
                item = this._insightDataList[i];
                String itemName = item.getName();
                if (!itemName.startsWith(userPrefix)) continue;
                startIndex = i;
                break;
            }
            for (i = startIndex; i < listSize; ++i) {
                item = this._insightDataList[i];
                String endItemName = item.getName();
                if (endItemName.startsWith(userPrefix)) continue;
                endIndex = i;
                break;
            }
            if (startIndex == listSize) {
                return;
            }
            ListDataItem firstItem = this._insightDataList[startIndex];
            String commonPrefix = firstItem.getName();
            if (endIndex - startIndex > 1) {
                for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
                    ListDataItem nextItem = this._insightDataList[i2];
                    commonPrefix = InsightUtils.getCommonPrefix(commonPrefix, nextItem.getName());
                }
            }
            if (!commonPrefix.startsWith(userPrefix)) {
                System.err.println("userPrefix: " + userPrefix);
                System.err.println("commonPrefix: " + commonPrefix);
                throw new IllegalStateException("Common text/prefix error");
            }
            editorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                if (endOffset > startOffset) {
                    document.remove(startOffset, endOffset - startOffset);
                }
                document.insertString(startOffset, commonPrefix, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in partial completion: " + e);
                e.printStackTrace();
            }
            finally {
                editorPane.endEdit();
            }
        }
        finally {
            textBuffer.writeUnlock();
        }
    }

    @Override
    public void updateData() {
        this._updateDataImpl();
    }

    public void updateInsightLocation(InsightLocation newLocation) {
        int newStart;
        TextInfo currentInfo = this._insightLocation.getCurrentTextInfo();
        int currentStart = currentInfo.getLocator().getStartOffset();
        TextInfo newInfo = newLocation.getCurrentTextInfo();
        if (newInfo != null && (newStart = newInfo.getLocator().getStartOffset()) == currentStart) {
            this._insightLocation = newLocation;
        }
    }

    private ReadOnlyListModel _buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ReadOnlyListModel((Object[])this._insightDataList);
        }
        return this._listModel;
    }

    private void _updateDataImpl() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        TextInfo textInfo = this._insightLocation.getCurrentTextInfo();
        TextLocator textLocator = textInfo.getLocator();
        int startOffset = textLocator.getStartOffset();
        int endOffset = this._guessTextEndOffset((ReadTextBuffer)textBuffer, textLocator);
        if (caretOffset < startOffset || caretOffset > endOffset) {
            this._clearData();
            return;
        }
        String userPrefix = "";
        if (caretOffset > startOffset) {
            if (caretOffset < endOffset) {
                endOffset = caretOffset;
            }
            userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
        }
        this._setDefault(userPrefix);
        this._fillMatchingData(userPrefix);
    }

    private int _guessTextEndOffset(ReadTextBuffer textBuffer, TextLocator textLocator) {
        int endOffset = textLocator.getEndOffset();
        int guessOffset = textLocator.getStartOffset();
        boolean done = false;
        if (guessOffset >= 0) {
            while (guessOffset < endOffset && !done) {
                char currentChar = textBuffer.getChar(guessOffset);
                switch (currentChar) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        done = true;
                        break;
                    }
                }
                if (done) continue;
                ++guessOffset;
            }
        }
        return guessOffset;
    }

    private void _clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void _fillDataList() {
        TreeSet listData = new TreeSet();
        List declarations = this._insightLocation.getElementDeclarations();
        if (declarations.size() > 0) {
            SimpleType simpleType;
            int lastIndex = declarations.size() - 1;
            ElementDef parentElementDef = InsightUtils.getElementDef(this._insight.getGrammarResolver(), this._insight.getGrammarProvider(), declarations, lastIndex);
            if (parentElementDef != null && TypeUtils.isSimpleTypeOrComplexTextOnlyElement((GrammarComponent)parentElementDef) && (simpleType = TypeUtils.getSimpleTypeAncestor((Type)parentElementDef.getType())) != null) {
                this._addSimpleTypeValues(listData, simpleType);
            }
        }
        this._insightDataList = new ListDataItem[listData.size()];
        listData.toArray(this._insightDataList);
    }

    private void _addSimpleTypeValues(TreeSet listData, SimpleType simpleType) {
        Set enumValues = AttributeValueUtils.getAttributeValues((SimpleType)simpleType);
        for (String value : enumValues) {
            TextItem valueItem = new TextItem(value);
            listData.add(valueItem);
        }
    }

    private void _fillMatchingData(String userPrefix) {
        this._matchingDataList = SortedInsightInputFilter.INSTANCE.getMatchingData(this._insightDataList, userPrefix);
    }

    private void _setDefault(String userPrefix) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int listSize = this._insightDataList.length;
        int prefixLength = userPrefix.length();
        String lowerCasePrefix = userPrefix.toLowerCase();
        for (int j = prefixLength; j > 0; --j) {
            String shortenedPrefix = userPrefix.substring(0, j);
            BaseItem lowerCaseMatch = null;
            for (int i = 0; i < listSize; ++i) {
                BaseItem item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (itemName.startsWith(shortenedPrefix)) {
                    this._defaultData = item;
                    return;
                }
                if (lowerCaseMatch != null || !itemName.toLowerCase().startsWith(lowerCasePrefix)) continue;
                lowerCaseMatch = item;
            }
            if (lowerCaseMatch == null) continue;
            this._defaultData = lowerCaseMatch;
            return;
        }
    }
}

