/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;

public class UnmodifiableMappingArrayWrapper<E, R>
implements List<R> {
    private final Function<E, R> mapper;
    private final E[] values;
    private int offset;
    private int length;

    public UnmodifiableMappingArrayWrapper(E[] values, Function<E, R> mapper) {
        this.mapper = mapper;
        this.values = values;
        this.offset = 0;
        this.length = values.length;
    }

    public UnmodifiableMappingArrayWrapper(E[] values, int from, int to, Function<E, R> mapper) {
        if (from > values.length) {
            throw new IndexOutOfBoundsException();
        }
        if (to > values.length) {
            throw new IndexOutOfBoundsException();
        }
        if (from > to) {
            throw new IndexOutOfBoundsException("from > to");
        }
        this.mapper = mapper;
        this.values = values;
        this.offset = from;
        this.length = to - from;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object e) {
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            if (!Objects.equals(e, this.mapper.apply(this.values[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<R> iterator() {
        return new Iterator<R>(){
            private int next;
            {
                this.next = UnmodifiableMappingArrayWrapper.this.offset;
            }

            @Override
            public boolean hasNext() {
                return this.next < UnmodifiableMappingArrayWrapper.this.offset + UnmodifiableMappingArrayWrapper.this.length;
            }

            @Override
            public R next() {
                if (this.next >= UnmodifiableMappingArrayWrapper.this.offset + UnmodifiableMappingArrayWrapper.this.length) {
                    throw new NoSuchElementException();
                }
                return UnmodifiableMappingArrayWrapper.this.mapper.apply(UnmodifiableMappingArrayWrapper.this.values[this.next++]);
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            array[i] = this.mapper.apply(this.values[this.offset + i]);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.length);
        }
        for (int i = 0; i < this.length; ++i) {
            array[i] = this.mapper.apply(this.values[this.offset + i]);
        }
        if (array.length > this.length) {
            array[this.length] = null;
        }
        return array;
    }

    @Override
    public boolean add(R e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends R> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends R> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public R get(int index) {
        return this.mapper.apply(this.values[this.offset + index]);
    }

    @Override
    public R set(int index, R element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, R element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public R remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object e) {
        for (int i = this.offset; i < this.length; ++i) {
            if (!Objects.equals(e, this.mapper.apply(this.values[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object e) {
        for (int i = this.length - 1; i >= this.offset; --i) {
            if (!Objects.equals(e, this.mapper.apply(this.values[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<R> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<R> listIterator(final int index) {
        return new ListIterator<R>(){
            private int next;
            {
                this.next = UnmodifiableMappingArrayWrapper.this.offset + index;
            }

            @Override
            public boolean hasNext() {
                return this.next < UnmodifiableMappingArrayWrapper.this.offset + UnmodifiableMappingArrayWrapper.this.length;
            }

            @Override
            public R next() {
                if (this.next >= UnmodifiableMappingArrayWrapper.this.offset + UnmodifiableMappingArrayWrapper.this.length) {
                    throw new NoSuchElementException();
                }
                return UnmodifiableMappingArrayWrapper.this.mapper.apply(UnmodifiableMappingArrayWrapper.this.values[this.next++]);
            }

            @Override
            public boolean hasPrevious() {
                return this.next > UnmodifiableMappingArrayWrapper.this.offset;
            }

            @Override
            public R previous() {
                if (this.next == UnmodifiableMappingArrayWrapper.this.offset) {
                    throw new NoSuchElementException();
                }
                return UnmodifiableMappingArrayWrapper.this.mapper.apply(UnmodifiableMappingArrayWrapper.this.values[--this.next]);
            }

            @Override
            public int nextIndex() {
                return this.next - UnmodifiableMappingArrayWrapper.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.next - UnmodifiableMappingArrayWrapper.this.offset - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(R e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(R e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<R> subList(int from, int to) {
        return new UnmodifiableMappingArrayWrapper<E, R>(this.values, this.offset + from, this.offset + to, this.mapper);
    }
}

