/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.TypeName;

public final class FieldName
extends MemberName {
    private final String fieldName;

    FieldName(TypeName parent, String fieldName) {
        super(parent);
        this.fieldName = fieldName;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.FIELD;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public boolean isVariableArity() {
        return false;
    }

    @Override
    public boolean isFixedArity() {
        return true;
    }

    @Override
    public TypeName[] getParameters() {
        return TypeName.EMPTY_ARRAY;
    }

    @Override
    public String getSimpleName() {
        return this.fieldName;
    }

    @Override
    public String getSourceName() {
        return this.fieldName;
    }

    @Override
    public StringBuilder appendSourceName(StringBuilder builder) {
        return builder.append(this.fieldName);
    }

    @Override
    public String getQualifiedSourceName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedNamePrefixLength() + this.fieldName.length());
        return this.getType().appendQualifiedSourceNamePrefix(builder).append(this.fieldName).toString();
    }

    @Override
    public void writeSourceName(Writer writer) throws IOException {
        writer.write(this.fieldName);
    }

    @Override
    public String getBinaryName() {
        return this.fieldName;
    }

    @Override
    public StringBuilder appendBinaryName(StringBuilder builder) {
        return builder.append(this.fieldName);
    }

    @Override
    public void writeBinaryName(Writer writer) throws IOException {
        writer.write(this.fieldName);
    }

    @Override
    public String getQualifiedBinaryName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedNamePrefixLength() + this.fieldName.length());
        return this.getType().appendQualifiedBinaryNamePrefix(builder).append(this.fieldName).toString();
    }

    @Override
    public String getHybridName() {
        return this.fieldName;
    }

    @Override
    public StringBuilder appendHybridName(StringBuilder builder) {
        return builder.append(this.fieldName);
    }

    @Override
    public String getQualifiedHybridName() {
        StringBuilder builder = new StringBuilder(this.getType().getQualifiedHybridNamePrefixLength() + this.fieldName.length());
        return this.getType().appendQualifiedHybridNamePrefix(builder).append(this.fieldName).toString();
    }

    @Override
    public void writeHybridName(Writer writer) throws IOException {
        writer.write(this.fieldName);
    }

    @Override
    public int compareToUnqualified(MemberName that) {
        switch (that.getKind()) {
            case CONSTRUCTOR: {
                return 1;
            }
            case METHOD: {
                int comparison = this.fieldName.compareTo(that.getSimpleName());
                return comparison != 0 ? comparison : -1;
            }
            case FIELD: {
                return this.fieldName.compareTo(((FieldName)that).fieldName);
            }
        }
        throw new IllegalStateException("unexpected kind " + (Object)((Object)that.getKind()));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FieldName)) {
            return false;
        }
        FieldName that = (FieldName)object;
        return this.fieldName.equals(that.fieldName) && this.getParent().equals(that.getParent());
    }

    @Override
    public int hashCode() {
        return this.getParent().hashCode() * 31 + this.fieldName.hashCode();
    }
}

