/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v11.ac;

import oracle.security.xmlsec.liberty.v11.LibertyInitializer;
import oracle.security.xmlsec.liberty.v11.ac.ACElement;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextException;
import oracle.security.xmlsec.liberty.v11.ac.AuthenticationContextStatement;
import oracle.security.xmlsec.liberty.v11.ac.LibertyUtils;
import oracle.security.xmlsec.liberty.v11.ac.PhysicalVerification;
import oracle.security.xmlsec.liberty.v11.ac.WrittenConsent;
import oracle.security.xmlsec.saml.SAMLInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Identification
extends ACElement {
    private String[] ns = new String[]{"http://projectliberty.org/schemas/authctx/2002/05", "http://projectliberty.org/schemas/authctx/2002/05"};
    private String[] localNames = new String[]{"PhysicalVerification", "WrittenConsent"};
    public static final String ANONYMITY = "anonymity";
    public static final String VERINYMITY = "verinymity";
    public static final String PSEUDONYMITY = "pseudonymity";

    public Identification(Element element, AuthenticationContextStatement acs) {
        super(element, acs);
    }

    public Identification(Element element, String systemId, AuthenticationContextStatement acs) {
        super(element, systemId, acs);
    }

    public Identification(Document owner, AuthenticationContextStatement acs) {
        super(owner, "http://projectliberty.org/schemas/authctx/2002/05", "Identification", acs);
    }

    public Identification(Document owner, AuthenticationContextStatement acs, String nym) throws AuthenticationContextException {
        this(owner, acs);
        this.setNym(nym);
    }

    public void setPhysicalVerification(PhysicalVerification pv) throws AuthenticationContextException {
        LibertyUtils.setChildACElement(this, pv, this.ns, this.localNames);
    }

    public PhysicalVerification getPhysicalVerification() {
        return (PhysicalVerification)LibertyUtils.getChildACElement(this, "PhysicalVerification", this.authenticationContextClass);
    }

    public void setWrittenConsent(WrittenConsent wc) throws AuthenticationContextException {
        LibertyUtils.setChildACElement(this, wc, this.ns, this.localNames);
    }

    public WrittenConsent getWrittenConsent() {
        return (WrittenConsent)LibertyUtils.getChildACElement(this, "WrittenConsent", this.authenticationContextClass);
    }

    public void setNym(String nym) throws AuthenticationContextException {
        this.authenticationContextClass.validateAttributeValue(nym, "nym", "http://projectliberty.org/schemas/authctx/2002/05", this);
        this.setAttribute("nym", nym);
    }

    public String getNym() {
        if (this.hasAttribute("nym")) {
            return this.getAttribute("nym");
        }
        return null;
    }

    static {
        SAMLInitializer.initialize();
        LibertyInitializer.initialize();
    }
}

