/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12CapturerImpl;

public class Teradata12CaptureObjectsOnlineCapturer
extends AbstractOnlineCapturer {
    public static final String TERADATA_LANGUAGE_ID = "TERADATALANG";
    protected String m_modelName = null;
    protected CaptureQueries m_captureQueries = null;
    protected Teradata12CapturerImpl m_teradataCaptureObjectsOnlineCapturer;

    public Teradata12CaptureObjectsOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
        this.m_teradataCaptureObjectsOnlineCapturer = new Teradata12CapturerImpl(migrationStorer, connection);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                String string;
                DatabaseMetaData databaseMetaData = this.m_sourceConnection.getMetaData();
                try {
                    ResultSet resultSet = this.m_sourceConnection.createStatement().executeQuery("select database");
                    resultSet.next();
                    string = resultSet.getString(1);
                }
                catch (Throwable throwable) {
                    string = databaseMetaData.getUserName();
                }
                this.m_modelName = string.equals(databaseMetaData.getUserName()) ? "\\\\" + databaseMetaData.getUserName() + " (" + databaseMetaData.getDatabaseProductName() + ")" : "\\\\" + databaseMetaData.getUserName() + "\\" + string + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                throw new CaptureException((Throwable)sQLException);
            }
        }
        return this.m_modelName;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_teradataCaptureObjectsOnlineCapturer.captureObjects(string, captureContext, migrationObjectFilter);
    }

    public CaptureQueries getCaptureQueries() {
        if (this.m_captureQueries == null) {
            this.m_captureQueries = new Teradata12CaptureQueries();
        }
        return this.m_captureQueries;
    }
}

