/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.util.EventObject;
import oracle.bali.jle.LayoutItem;

public class BoundsToolEvent
extends EventObject {
    public static final int ITEM_MOVING = 1;
    public static final int ITEM_MOVED = 2;
    public static final int ITEM_RESIZING = 3;
    public static final int ITEM_RESIZED = 4;
    public static final int ITEM_MOVE_POSITIONING = 5;
    public static final int ITEM_RESIZE_POSITIONING = 6;
    private LayoutItem _item;
    private int _id;
    private double _dx;
    private double _dy;

    public BoundsToolEvent(Object source, int id, LayoutItem item) {
        this(source, id, item, Double.NaN, Double.NaN);
    }

    public BoundsToolEvent(Object source, int id, LayoutItem item, double dx, double dy) {
        super(source);
        this._id = id;
        this._item = item;
        this._dx = dx;
        this._dy = dy;
    }

    public int getId() {
        return this._id;
    }

    public LayoutItem getItem() {
        return this._item;
    }

    public double getDeltaX() {
        return this._dx;
    }

    public double getDeltaY() {
        return this._dy;
    }

    @Override
    public String toString() {
        String type = null;
        switch (this._id) {
            case 3: {
                type = "ITEM_RESIZING";
                break;
            }
            case 4: {
                type = "ITEM_RESIZED";
                break;
            }
            case 1: {
                type = "ITEM_MOVING";
                break;
            }
            case 2: {
                type = "ITEM_MOVED";
                break;
            }
            case 5: {
                type = "ITEM_MOVE_POSITIONING";
                break;
            }
            case 6: {
                type = "ITEM_RESIZE_POSITIONING";
            }
        }
        return this.getClass().getName() + ": " + type + " on " + this._item + ", dx=" + this._dx + ", dy=" + this._dy;
    }
}

