/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.ClipboardTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class ClipboardUndo
extends LocalizedEdit {
    private LayoutItem[] _items;
    private boolean _isCut;
    private ClipboardTool _tool;

    public ClipboardUndo(LayoutItem[] items, boolean isCut, ClipboardTool tool) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        this._items = items;
        this._isCut = isCut;
        this._tool = tool;
    }

    @Override
    public void undo() {
        super.undo();
        if (this._isCut) {
            this._tool.processPaste();
        } else {
            this._tool.processCut(this._items);
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (!this._isCut) {
            this._tool.processPaste();
        } else {
            this._tool.processCut(this._items);
        }
    }

    @Override
    public void die() {
        super.die();
        this._items = null;
    }

    @Override
    public String getBaseKey() {
        return this._isCut ? "CUT" : "PASTE";
    }

    public LayoutItem[] getItems() {
        LayoutItem[] items = new LayoutItem[this._items.length];
        System.arraycopy(this._items, 0, items, 0, this._items.length);
        return items;
    }

    public boolean isCut() {
        return this._isCut;
    }
}

