/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.jdbc;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCursor;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSet;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoResultSetMetaData;
import org.bson.types.ObjectId;

public class MongoResultSetMetaData
extends AMongoResultSetMetaData {
    Object _seed = null;
    MongoResultSet.RESULTSETTYPE _resultSetType = MongoResultSet.RESULTSETTYPE.doc;
    ArrayList<String> _colNames = null;
    ArrayList<Integer> _colTypes = null;

    public MongoResultSetMetaData(Object object, MongoResultSet.RESULTSETTYPE rESULTSETTYPE) {
        this._seed = object;
        this._resultSetType = rESULTSETTYPE;
        this.init();
    }

    private void init() {
        this._colNames = new ArrayList();
        this._colTypes = new ArrayList();
        if (this._seed instanceof Double) {
            this._colNames.add("value");
            this._colTypes.add(8);
        } else if (this._seed instanceof Set) {
            this._colNames.add("value");
            this._colTypes.add(12);
        } else if (!(this._seed instanceof DBCursor || this._seed instanceof BasicDBList || this._seed instanceof BasicDBObject || this._seed instanceof CommandResult || this._seed instanceof List || this._seed == null)) {
            this._colNames.add("json");
            this._colTypes.add(2005);
        } else if (this.getResultSetType() == MongoResultSet.RESULTSETTYPE.doc) {
            this._colNames.add("_id");
            this._colNames.add("json");
            this._colTypes.add(12);
            this._colTypes.add(2005);
        } else if (this.getResultSetType() == MongoResultSet.RESULTSETTYPE.table) {
            this.getTableColumnNamesAndTypes();
        }
    }

    private void getTableColumnNamesAndTypes() {
        if (this._seed instanceof BasicDBObject) {
            Set set = ((BasicDBObject)this._seed).keySet();
            this._colNames.addAll(set);
            for (String string : set) {
                Object object = ((BasicDBObject)this._seed).get(string);
                if (object instanceof Boolean) {
                    this._colTypes.add(16);
                    continue;
                }
                if (object instanceof Date) {
                    this._colTypes.add(91);
                    continue;
                }
                if (object instanceof Double) {
                    this._colTypes.add(8);
                    continue;
                }
                if (object instanceof Integer) {
                    this._colTypes.add(4);
                    continue;
                }
                if (object instanceof Long) {
                    this._colTypes.add(4);
                    continue;
                }
                if (object instanceof ObjectId) {
                    this._colTypes.add(12);
                    continue;
                }
                if (object instanceof String) {
                    this._colTypes.add(12);
                    continue;
                }
                if (object instanceof BasicDBObject) {
                    this._colTypes.add(2005);
                    continue;
                }
                this._colTypes.add(12);
            }
        } else if (this._seed instanceof String) {
            this._colNames.add("VALUE");
            this._colTypes.add(12);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._colNames.size();
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this._colNames.get(n - 1);
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        int n2 = n - 1;
        return this._colTypes.get(n2);
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        int n2 = n - 1;
        switch (this._colTypes.get(n2)) {
            case 12: {
                return "VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 8: {
                return "DOUBLE";
            }
        }
        return "VARCHAR";
    }

    private MongoResultSet.RESULTSETTYPE getResultSetType() {
        return this._resultSetType;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.getColumnName(n).equals("_id")) {
            return 24;
        }
        return 0;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return 0;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 0;
    }
}

