/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.jdbc;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import oracle.dbtools.thirdparty.mongodb.jdbc.Criteria;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoConnection;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSet;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSetEmpty;
import oracle.dbtools.thirdparty.mongodb.jdbc.NoSQL;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoResultSet;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoStatement;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;

public class MongoStatement
extends AMongoStatement {
    private MongoConnection _conn = null;
    private int _fetchSize = 10;
    private ResultSet _rs = null;

    public MongoStatement(MongoConnection mongoConnection) {
        this._conn = mongoConnection;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this._rs = this.executeQuery(string);
        return true;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        AMongoResultSet aMongoResultSet = null;
        NoSQL noSQL = new NoSQL(string);
        if (noSQL.getTask() == NoSQL.Task.GETCOLLECTIONNAMES) {
            MongoCursor mongoCursor = this._conn.getMongoDB().listCollectionNames().iterator();
            aMongoResultSet = new MongoResultSet(mongoCursor, noSQL.getResultSetType(), this);
        } else if (noSQL.getTask() == NoSQL.Task.FIND) {
            Object object;
            MongoCollection mongoCollection = this._conn.getMongoDB().getCollection(noSQL.getCollection());
            mongoCollection.find().batchSize(this.getFetchSize());
            MongoCursor mongoCursor = null;
            int n = noSQL.getLimit();
            if (noSQL.hasCriteria()) {
                object = noSQL.getCriteria();
                if (n == -1) {
                    FindIterable findIterable = mongoCollection.find((Bson)((BasicDBObject)((Criteria)object).getQuery()).toBsonDocument(Document.class, CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()})));
                    mongoCursor = findIterable.iterator();
                } else {
                    FindIterable findIterable = mongoCollection.find((Bson)((BasicDBObject)((Criteria)object).getQuery()).toBsonDocument(Document.class, CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()}))).limit(n);
                    mongoCursor = findIterable.iterator();
                }
            } else if (n == -1) {
                mongoCursor = mongoCollection.find().iterator();
            } else if (n == -2) {
                mongoCursor = null;
                aMongoResultSet = new MongoResultSetEmpty();
            } else {
                mongoCursor = mongoCollection.find().limit(n).iterator();
            }
            if (mongoCursor != null) {
                if (noSQL.getResultSetType() == MongoResultSet.RESULTSETTYPE.doc) {
                    object = StreamSupport.stream(mongoCollection.find().spliterator(), false).map(Document::toJson).collect(Collectors.joining(", ", "[", "]"));
                    aMongoResultSet = new MongoResultSet(object, noSQL.getResultSetType(), this);
                } else {
                    aMongoResultSet = new MongoResultSet(mongoCursor, noSQL.getResultSetType(), this);
                }
            }
        } else if (noSQL.getTask() == NoSQL.Task.EVAL) {
            Object var4_6 = null;
            aMongoResultSet = new MongoResultSet(var4_6, noSQL.getResultSetType(), this);
        } else if (noSQL.getTask() == NoSQL.Task.STATS) {
            Document document = null;
            String[] stringArray = noSQL.getStmt().split("(?<!system)\\.(?!(users)|(version))");
            if (stringArray.length >= 3) {
                document = this._conn.getMongoDB().runCommand((Bson)new Document("collStats", (Object)stringArray[1]));
            }
            aMongoResultSet = new MongoResultSet(document, noSQL.getResultSetType(), this);
        } else if (noSQL.getTask() == NoSQL.Task.COMMAND) {
            Object var4_8 = null;
            aMongoResultSet = new MongoResultSet(var4_8, noSQL.getResultSetType(), this);
        }
        return aMongoResultSet;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this._fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._rs;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }
}

