/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.ScrollableResultSetIterator;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.CachedDynamicProfile;
import sqlj.runtime.profile.ref.CachedDynamicProfileWrapper;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.CachedStatementWrapper;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.ExecuteEventListener;
import sqlj.runtime.profile.ref.RTCallableStatement;
import sqlj.runtime.profile.ref.RTStatementWrapper;
import sqlj.runtime.ref.ResultSetIterImpl;
import sqlj.runtime.ref.ScrollableResultSetIterImpl;

public class UntypedSelectProfile
extends CachedDynamicProfileWrapper {
    public UntypedSelectProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    public UntypedSelectProfile(CachedDynamicProfile cachedDynamicProfile) {
        super(cachedDynamicProfile);
    }

    public CachedStatement getCachedStatement(int n) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        if (entryInfo.getRole() == 19) {
            if (entryInfo.getStatementType() != 4) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entryInfo.getSQLString());
            }
            if (entryInfo.getExecuteType() != 8) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
            }
            return new UntypedSelectCachedStatement(super.getCachedStatement(n), entryInfo);
        }
        return super.getCachedStatement(n);
    }

    public CachedStatement getCachedStatement(int n, BatchContext batchContext) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        if (entryInfo.getRole() == 19) {
            if (entryInfo.getStatementType() != 4) {
                ProfileRefErrors.raise_EXPECTED_CALLABLE_STATEMENT(entryInfo.getSQLString());
            }
            if (entryInfo.getExecuteType() != 8) {
                ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
            }
            return new UntypedSelectCachedStatement(super.getCachedStatement(n, batchContext), entryInfo);
        }
        return super.getCachedStatement(n, batchContext);
    }

    public class UntypedSelectCachedStatement
    extends CachedStatementWrapper {
        private EntryInfo m_entry;

        UntypedSelectCachedStatement(CachedStatement cachedStatement, EntryInfo entryInfo) {
            super(cachedStatement);
            this.m_entry = entryInfo;
        }

        public RTStatement getStatement(ExecuteEventListener executeEventListener) throws SQLException {
            RTCallableStatement rTCallableStatement = (RTCallableStatement)super.getStatement(executeEventListener);
            if (rTCallableStatement != null) {
                rTCallableStatement = new UntypedSelectStatement(rTCallableStatement, this.m_entry);
            }
            return rTCallableStatement;
        }

        public RTStatement getStatement(ExecuteEventListener executeEventListener, BatchContext batchContext) throws SQLException {
            RTCallableStatement rTCallableStatement = (RTCallableStatement)super.getStatement(executeEventListener, batchContext);
            if (rTCallableStatement != null) {
                rTCallableStatement = new UntypedSelectStatement(rTCallableStatement, this.m_entry);
            }
            return rTCallableStatement;
        }
    }

    public static class UntypedSelectStatement
    extends RTStatementWrapper
    implements RTCallableStatement {
        private RTResultSet m_rs = null;
        private int m_resultParam;
        private RTCallableStatement m_cstmt;

        public UntypedSelectStatement(RTCallableStatement rTCallableStatement, EntryInfo entryInfo) {
            super(rTCallableStatement);
            this.m_resultParam = entryInfo.getParamCount();
            this.m_cstmt = rTCallableStatement;
        }

        public void registerOutParameter(int n, int n2) throws SQLException {
            if (n != this.m_resultParam) {
                this.m_cstmt.registerOutParameter(n, n2);
            }
        }

        public Object getObject(int n, Class clazz) throws SQLException {
            if (n == this.m_resultParam) {
                if (clazz.getName().equals("sqlj.runtime.ResultSetIterator")) {
                    return UntypedSelectStatement.newUntypedIterator(this.getQueryResult());
                }
                return UntypedSelectStatement.newScrollableUntypedIterator(this.getQueryResult());
            }
            return super.getObject(n, clazz);
        }

        private RTResultSet getQueryResult() throws SQLException {
            if (this.m_rs == null) {
                ProfileRefErrors.raise_UNEXPECTED_CALL("getQueryResult");
            }
            return this.m_rs;
        }

        public int executeUpdate() throws SQLException {
            this.m_rs = this.stmt.executeRTQuery();
            return -1;
        }

        public static ResultSetIterator newUntypedIterator(RTResultSet rTResultSet) throws SQLException {
            return new ResultSetIterImpl(rTResultSet);
        }

        public static ScrollableResultSetIterator newScrollableUntypedIterator(RTResultSet rTResultSet) throws SQLException {
            String string = rTResultSet.getJDBCResultSet().getClass().getName();
            if (string.startsWith("oracle.jdbc.")) {
                return new ScrollableResultSetIterImpl(rTResultSet.getJDBCResultSet(), rTResultSet);
            }
            return new ScrollableResultSetIterImpl(rTResultSet);
        }
    }
}

