/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.marshal.xml.ClassLoaderHelper;
import oracle.ide.marshal.xml.HashMapProxy;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter2;
import oracle.ide.util.StringComparator;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Map2Dom
implements ToDomConverter2 {
    private static final boolean HASH_MAP_PROXY_ENABLED = Boolean.getBoolean("use.HashMapProxy");
    static final String KEY_TAG = "Key";
    static final String VALUE_TAG = "Value";
    private static final Class _stringClass = String.class;
    private static final Class _mapClass = Map.class;
    private static final Class _hashMapClass = HashMap.class;
    private static final Class _hashMapProxyClass = HashMapProxy.class;
    private final Comparator _stringComparator = new StringComparator();

    Map2Dom() {
    }

    @Override
    public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        return this.toElement(wrapper, element, type, o2d, this.getClass().getClassLoader());
    }

    @Override
    public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d, ClassLoader classLoader) {
        if (!_mapClass.isAssignableFrom(type)) {
            return false;
        }
        Map map = (Map)wrapper.getObject();
        Object[] keyArray = map.keySet().toArray();
        Arrays.sort(keyArray, this._stringComparator);
        Iterator<Object> iter = Arrays.asList(keyArray).iterator();
        boolean useHashMapProxy = HASH_MAP_PROXY_ENABLED && type == _hashMapProxyClass;
        String namespaceURI = element.getNamespaceURI();
        while (iter.hasNext()) {
            Object key = iter.next();
            Element keyElement = o2d.toElement(key, KEY_TAG, _stringClass, namespaceURI);
            Document ownerDocument = element.getOwnerDocument();
            Element valueElement = this.getValueElement(useHashMapProxy, o2d, ownerDocument, map, key, namespaceURI);
            Element itemElement = ownerDocument.createElementNS(namespaceURI, "Item");
            itemElement.appendChild(keyElement);
            itemElement.appendChild(valueElement);
            element.appendChild(itemElement);
        }
        return true;
    }

    @Override
    public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
        return this.toObject(wrapper, element, type, o2d, this.getClass().getClassLoader());
    }

    @Override
    public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d, ClassLoader loader) {
        if (!_mapClass.isAssignableFrom(type)) {
            return false;
        }
        boolean useHashMapProxy = HASH_MAP_PROXY_ENABLED && type == _hashMapClass;
        try {
            NodeList children = element.getChildNodes();
            int numItems = children.getLength();
            Map map = useHashMapProxy ? new HashMapProxy(o2d) : (Map)type.newInstance();
            for (int i = 0; i < numItems; ++i) {
                int j;
                Node childNode = children.item(i);
                if (childNode.getNodeType() != 1) continue;
                Element itemElement = (Element)childNode;
                NodeList itemKeyValuePair = itemElement.getChildNodes();
                int numChildren = itemKeyValuePair.getLength();
                Element keyElement = null;
                for (j = 0; j < numChildren; ++j) {
                    Node itemChildNode = itemKeyValuePair.item(j);
                    if (itemChildNode.getNodeType() != 1) continue;
                    keyElement = (Element)itemChildNode;
                    ++j;
                    break;
                }
                Element valueElement = null;
                while (j < numChildren) {
                    Node itemChildNode = itemKeyValuePair.item(j);
                    if (itemChildNode.getNodeType() == 1) {
                        valueElement = (Element)itemChildNode;
                        break;
                    }
                    ++j;
                }
                Object keyObject = Map2Dom.toObject(o2d, keyElement);
                Object valueObject = this.getValueObject(useHashMapProxy, o2d, valueElement, loader);
                map.put(keyObject, valueObject);
                ClassLoaderHelper.populateClassLoaders(keyObject, valueObject);
            }
            wrapper.setObject(map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            wrapper.setObject(null);
            return true;
        }
    }

    static Object toObject(Object2Dom o2d, Element elem) {
        return Map2Dom.toObject(o2d, elem, Map2Dom.class.getClassLoader());
    }

    static Object toObject(Object2Dom o2d, Element elem, ClassLoader loader) {
        return o2d.toObject(elem, _stringClass, loader);
    }

    private Object getValueObject(boolean useHashMapProxy, Object2Dom o2d, Element valueElement, ClassLoader loader) {
        if (valueElement != null) {
            String classAttr = o2d.getClassAttr(valueElement);
            if (!useHashMapProxy || classAttr == null || classAttr.startsWith("java.lang")) {
                return Map2Dom.toObject(o2d, valueElement, loader);
            }
        }
        return valueElement;
    }

    private Element getValueElement(boolean useHashMapProxy, Object2Dom o2d, Document ownerDocument, Map map, Object key, String namespaceURI) {
        Object valueObject;
        if (useHashMapProxy) {
            HashMapProxy proxy = (HashMapProxy)map;
            valueObject = proxy.superGet(key);
        } else {
            valueObject = map.get(key);
        }
        if (valueObject instanceof DocumentFragment) {
            return (Element)((DocumentFragment)valueObject).getFirstChild();
        }
        if (valueObject instanceof XMLElement) {
            return (Element)ownerDocument.importNode((Node)((XMLElement)valueObject), true);
        }
        return o2d.toElement(valueObject, VALUE_TAG, _stringClass, namespaceURI);
    }
}

