/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import oracle.charts.types.TaskDesc;
import oracle.charts.types.TaskLink;
import oracle.viz.util.Tree;

public class GanttTaskTree
extends Tree {
    private Hashtable taskTable = null;
    private LinkedList linkTable = null;

    public GanttTaskTree() {
        this.taskTable = new Hashtable();
        this.linkTable = new LinkedList();
    }

    public GanttTaskTree(int indexCapacity) {
        this.taskTable = new Hashtable(indexCapacity);
        this.linkTable = new LinkedList();
    }

    public GanttTaskTree(Collection c) {
        this(c.size());
        this.internalList = Collections.synchronizedList(new LinkedList());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Tree.Node n = new Tree.Node(iter.next());
            this.internalList.add(n);
            this.addNotify(n);
        }
    }

    public GanttTaskTree(Object[] array) {
        this(array.length);
        this.internalList = Collections.synchronizedList(new LinkedList());
        int i = 0;
        while (i < array.length) {
            Tree.Node n = new Tree.Node(array[i]);
            this.internalList.add(n);
            this.addNotify(n);
            ++i;
        }
    }

    public TaskDesc getTaskDesc(long ID) {
        return (TaskDesc)this.getNode((long)ID).item;
    }

    public void setDependency(TaskLink link) {
        this.linkTable.add(link);
    }

    public void setDependencies(TaskLink[] links) {
        int i = 0;
        while (i < links.length) {
            this.linkTable.add(links[i]);
            ++i;
        }
    }

    public ListIterator getDependencies() {
        return this.linkTable.listIterator();
    }

    protected Tree.Node getNode(long ID) {
        return (Tree.Node)this.taskTable.get(new Long(ID));
    }

    protected void addNotify(Tree.Node n) {
        Long key = new Long(((TaskDesc)n.item).getID());
        this.taskTable.put(key, n);
    }

    protected void removeNotify(Object o) {
        this.taskTable.remove(new Long(((TaskDesc)o).getID()));
    }
}

