/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.util.Date;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.samlp.ResponseType;
import oracle.security.xmlsec.samlp.Status;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LibResponseMessage
extends ResponseType {
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 2;

    protected LibResponseMessage(Element element) throws DOMException {
        super(element);
    }

    protected LibResponseMessage(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected LibResponseMessage(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.setVersion(1, 2);
    }

    protected LibResponseMessage(Document owner, String nsURI, String localName, String responseID, Date issueInstant) throws DOMException {
        this(owner, nsURI, localName);
        this.setResponseID(responseID);
        this.setIssueInstant(issueInstant);
    }

    public static LibResponseMessage getInstance(Element element) throws DOMException {
        return (LibResponseMessage)XMLUtils.getInstance((Element)element, null, (String)"urn:liberty:iff:2003-08");
    }

    public void setProviderID(String providerID) {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "ProviderID", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), providerID, true);
    }

    public String getProviderID() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "ProviderID");
    }

    public void setStatus(Status status) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)status, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public Status getStatus() {
        return (Status)LibertyUtils.getChildElement((XMLElement)this, "urn:oasis:names:tc:SAML:1.0:protocol", "Status");
    }

    public void setRelayState(String value) {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "RelayState", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), value, true);
    }

    public String getRelayState() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "RelayState");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        String id = this.getID();
        if (id == null || id.length() == 0) {
            return super.addSignature(signatureMethod, c14nMethod, digestMethod);
        }
        this.clearSignature();
        return LibDSigUtils.addSignature((XMLElement)this, id, signatureMethod, c14nMethod, digestMethod, this.getNSURIsPrecedeDSig(), this.getLocalNamesPrecedeDSig());
    }

    protected String getID() {
        return this.getResponseID();
    }

    protected abstract String[] getChildElementsNSURIs();

    protected abstract String[] getChildElementsLocalNames();

    protected int getChildElementPosition(String nsURI, String localName) throws DOMException {
        String[] localNames = this.getChildElementsLocalNames();
        String[] nsURIs = this.getChildElementsNSURIs();
        int pos = 0;
        while (!localName.equals(localNames[pos]) || !nsURI.equals(nsURIs[pos])) {
            if (pos >= localNames.length) {
                throw new DOMException(9, "The element with the local name " + localName + "in the namespace " + nsURI + "is not a valid child element specified in the schema for this element");
            }
            ++pos;
        }
        return pos;
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

