/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12.metadata;

import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Organization
extends XMLElement {
    private static final String[] nsURIs = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08"};
    private static final String[] localNames = new String[]{"OrganizationName", "OrganizationDisplayName", "OrganizationURL"};

    public Organization(Element element) throws DOMException {
        super(element);
    }

    public Organization(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Organization(Document owner) throws DOMException {
        super(owner, "urn:liberty:metadata:2003-08", "Organization");
    }

    public Organization(Document owner, String orgName, String orgDisplayName, String orgURL) throws DOMException {
        this(owner);
        this.setOrganizationName(orgName);
        this.setOrganizationDisplayName(orgDisplayName);
        this.setOrganizationURL(orgURL);
    }

    public void setOrganizationName(String orgName) throws DOMException {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "OrganizationName", nsURIs, localNames, orgName, true);
    }

    public String getOrganizationName() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "OrganizationName");
    }

    public void setOrganizationDisplayName(String orgDisplayName) throws DOMException {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "OrganizationDisplayName", nsURIs, localNames, orgDisplayName, true);
    }

    public String getOrganizationDisplayName() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "OrganizationDisplayName");
    }

    public void setOrganizationURL(String orgURL) throws DOMException {
        LibertyUtils.insertChildElementWithText(this, "urn:liberty:metadata:2003-08", "OrganizationURL", nsURIs, localNames, orgURL, true);
    }

    public String getOrganizationURL() {
        return LibertyUtils.collectTextFromChild(this, "urn:liberty:metadata:2003-08", "OrganizationURL");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

