/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MSAccessCapture;
import oracle.dbtools.migration.workbench.plugin.MSAccessCaptureSelectionPanel;
import oracle.dbtools.migration.workbench.plugin.MSAccessMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MSAccessPlugin;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;

public class MSAccessCaptureDialog {
    private JEWTDialog _jewtDialog;
    private static final long serialVersionUID = 5025669709731183466L;
    private MSAccessCaptureSelectionPanel _panel = new MSAccessCaptureSelectionPanel();
    private JButton m_okButton;
    private String _errMsg;

    public MSAccessCaptureDialog() {
        this._jewtDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._panel, null, (String)MSAccessMigrationAddinArb.getString("ACCESS_CAPTURE_DIALOG_TITLE"), (int)2);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_accessCapture_html");
        this.m_okButton = new JButton(MSAccessMigrationAddinArb.getString("CAPTURE_DIALOG_LBL_OK_BUTTON"));
        this._jewtDialog.addCustomButton((Component)this.m_okButton);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = MSAccessCaptureDialog.this._panel.getFileName();
                    if (string != null) {
                        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
                        if (persistenceManager == null) {
                            MSAccessCaptureDialog.this._jewtDialog.closeDialog(true);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString((String)"MSG_CANNOT_CAPTURE"), (String)MigrationAddinArb.getString((String)"TITLE_CANNOT_CAPTURE"), (String)"help_must_connect_before_capture");
                            return;
                        }
                        if (!MSAccessCaptureDialog.this.validateXML(string)) {
                            MSAccessCaptureDialog.this._jewtDialog.closeDialog(true);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MSAccessCaptureDialog.this._errMsg, (String)MigrationAddinArb.getString((String)"TITLE_CANNOT_CAPTURE"), null);
                        } else {
                            MSAccessCapture mSAccessCapture = new MSAccessCapture(string, (MigrationStorer)new BasicMigrationStorer(MigrationAddin.getPersistenceManager()));
                            MSAccessCaptureDialog.this._jewtDialog.closeDialog(true);
                            mSAccessCapture.start(true);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
        this._jewtDialog.setSize(500, 200);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._jewtDialog);
    }

    public void setVisible(boolean bl) {
        this._jewtDialog.setVisible(bl);
    }

    private boolean validateXML(String string) {
        if (!string.endsWith("xml")) {
            this._errMsg = MSAccessMigrationAddinArb.getString("NOT_A_VALID_XML");
            return false;
        }
        DOMParser dOMParser = new DOMParser();
        try {
            InputStream inputStream = MSAccessPlugin.class.getResourceAsStream("schema.dtd");
            dOMParser.parseDTD(inputStream, "DATABASES");
            DTD dTD = dOMParser.getDoctype();
            dOMParser.setValidationMode(2);
            dOMParser.showWarnings(true);
            dOMParser.setDoctype(dTD);
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            dOMParser.parse((InputStream)fileInputStream);
        }
        catch (Exception exception) {
            this._errMsg = MSAccessMigrationAddinArb.getString("DOCUMENT_NOT_GENERATED_FROM_TOOL");
            return false;
        }
        return true;
    }
}

