/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.category;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.category.CategoryDefinition;
import oracle.bali.xml.model.category.IllegalCategoryException;
import oracle.bali.xml.model.category.MutableCategoryDefinition;

public class CategoryDefinitionFactory {
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.model.category");

    public static MutableCategoryDefinition createMutableCategoryDefinition(String identifier) throws IllegalCategoryException {
        if (identifier == null) {
            throw new IllegalCategoryException("The category identifier cannot be null.");
        }
        return new MutableCategoryDefinition(identifier);
    }

    public static CategoryDefinition createCategoryDefinition(StructuredMetadataBean category) throws IllegalCategoryException {
        if (category == null || !XmlMetadataConstants.CATEGORY.equals((Object)category.getName())) {
            throw new IllegalCategoryException("Unexpected StructuredMetadataBean passed to createCategoryDefinition: " + category);
        }
        String identifier = category.getProperty(XmlMetadataConstants.ID_ATTR);
        MutableCategoryDefinition result = CategoryDefinitionFactory.createMutableCategoryDefinition(identifier);
        List children = category.getChildren();
        for (StructuredMetadataBean child : children) {
            String childValue;
            QualifiedName childName = child.getName();
            if (XmlMetadataConstants.GLOBAL_DISPLAY_NAME.equals((Object)childName)) {
                childValue = child.getValue();
                if (childValue == null) continue;
                result.setDisplayName(childValue);
                continue;
            }
            if (XmlMetadataConstants.PREFERRED_PAGE_RANK.equals((Object)childName)) {
                childValue = child.getValue();
                if (childValue == null) continue;
                result.setPreferredPageRank(childValue);
                continue;
            }
            if (XmlMetadataConstants.OPEN_BY_DEFAULT.equals((Object)childName)) {
                childValue = child.getValue();
                if (childValue == null) continue;
                result.setOpenByDefault(childValue);
                continue;
            }
            if (XmlMetadataConstants.GLOBAL_DESCRIPTION.equals((Object)childName)) {
                childValue = child.getValue();
                if (childValue == null) continue;
                result.setDescription(childValue);
                continue;
            }
            if (XmlMetadataConstants.DISPLAY_ORDER.equals((Object)childName)) {
                childValue = child.getValue();
                if (childValue == null) continue;
                result.setDisplayOrder(childValue);
                continue;
            }
            if (XmlMetadataConstants.SMALL_ICON.equals((Object)childName) || !XmlMetadataConstants.CATEGORY.equals((Object)childName)) continue;
            try {
                CategoryDefinition subCategory = CategoryDefinitionFactory.createCategoryDefinition(child);
                if (subCategory == null) continue;
                result.addSubCategoryDefinition(subCategory);
            }
            catch (IllegalCategoryException e) {
                _LOGGER.log(Level.WARNING, "Invalid sub-category definition encountered (and ignored)", e);
            }
            catch (RuntimeException rE) {
                _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing sub-category definitions", rE);
            }
        }
        return result;
    }

    public static List<CategoryDefinition> createCategoryDefinitions(StructuredMetadataBean categoryDefinitions) {
        if (categoryDefinitions == null || !XmlMetadataConstants.CATEGORY_DEFINITIONS.equals((Object)categoryDefinitions.getName())) {
            return Collections.emptyList();
        }
        ArrayList<CategoryDefinition> resultList = new ArrayList<CategoryDefinition>();
        List categoryList = categoryDefinitions.getChildren();
        for (StructuredMetadataBean category : categoryList) {
            try {
                CategoryDefinition result = CategoryDefinitionFactory.createCategoryDefinition(category);
                resultList.add(result);
            }
            catch (IllegalCategoryException e) {
                _LOGGER.log(Level.WARNING, "Invalid category definition encountered (and ignored)", e);
            }
            catch (RuntimeException rE) {
                _LOGGER.log(Level.SEVERE, "Unexpected exception encountered while processing category definitions", rE);
            }
        }
        return resultList;
    }

    public static List<CategoryDefinition> createCategoryDefinitions(List<StructuredMetadataBean> categoryDefinitionsList) {
        ArrayList<CategoryDefinition> resultList = new ArrayList<CategoryDefinition>();
        for (StructuredMetadataBean categoryDefinitions : categoryDefinitionsList) {
            List<CategoryDefinition> partialList = CategoryDefinitionFactory.createCategoryDefinitions(categoryDefinitions);
            resultList.addAll(partialList);
        }
        return resultList;
    }

    private CategoryDefinitionFactory() {
    }
}

